/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.searchEverywhere.providers.runConfigurations;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.actions.ChooseRunConfigurationPopup;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.platform.searchEverywhere.SeItemPresentation;
import com.intellij.platform.searchEverywhere.SeSimpleItemPresentation;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/searchEverywhere/providers/runConfigurations/SeRunConfigurationsPresentationProvider;", "", "<init>", "()V", "getPresentation", "Lcom/intellij/platform/searchEverywhere/SeItemPresentation;", "item", "Lcom/intellij/execution/actions/ChooseRunConfigurationPopup$ItemWrapper;", "extendedDescription", "", "intellij.platform.searchEverywhere"})
@ApiStatus.Internal
public final class SeRunConfigurationsPresentationProvider {
    @NotNull
    public static final SeRunConfigurationsPresentationProvider INSTANCE = new SeRunConfigurationsPresentationProvider();

    private SeRunConfigurationsPresentationProvider() {
    }

    @NotNull
    public final SeItemPresentation getPresentation(@NotNull ChooseRunConfigurationPopup.ItemWrapper<?> item, @Nullable String extendedDescription) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Executor debugExecutor = ExecutorRegistry.getInstance().getExecutorById("Debug");
        Executor runExecutor = DefaultRunExecutor.getRunExecutorInstance();
        KeyStroke enterStroke = KeyStroke.getKeyStroke(10, 0);
        KeyStroke shiftEnterStroke = KeyStroke.getKeyStroke(10, 64);
        StringBuilder descriptionText = new StringBuilder();
        if (debugExecutor != null) {
            descriptionText.append(debugExecutor.getActionName());
            descriptionText.append("(" + KeymapUtil.getKeystrokeText((KeyStroke)enterStroke) + ")");
            if (runExecutor != null) {
                descriptionText.append(" / " + runExecutor.getActionName());
                descriptionText.append("(" + KeymapUtil.getKeystrokeText((KeyStroke)shiftEnterStroke) + ")");
            }
        } else if (runExecutor != null) {
            descriptionText.append(runExecutor.getActionName());
            descriptionText.append("(" + KeymapUtil.getKeystrokeText((KeyStroke)enterStroke) + ")");
        }
        Icon icon = item.getIcon();
        return new SeSimpleItemPresentation((IconId)(icon != null ? IconIdKt.rpcId((Icon)icon) : null), item.getText(), descriptionText.toString(), extendedDescription);
    }
}

