/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.RecurrenceRuleFreq;
import circlet.common.calendar.RelativeDate;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.Weekday;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0019\u0010\u0004\u001a\u00020\u00032\n\u0010\u0005\u001a\u00060\u0007j\u0002`\u0006H&\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\t\u001a\u00060\u0007j\u0002`\u0006H&\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH&J\b\u0010\u000e\u001a\u00020\u000fH&J\b\u0010\u0010\u001a\u00020\u0011H&J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0000H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lcirclet/common/calendar/EventCounter;", "", "toNextEvent", "", "toNextEventAfterDate", "targetDate", "Lcirclet/platform/api/ADate;", "Lcirclet/platform/api/KotlinXDate;", "(Lcirclet/platform/api/KotlinXDate;)V", "getCurrentDate", "()Lcirclet/platform/api/KotlinXDate;", "getWeekdays", "", "Lcirclet/platform/api/Weekday;", "getFrequency", "Lcirclet/common/calendar/RecurrenceRuleFreq;", "getRelativity", "Lcirclet/common/calendar/RelativeDate;", "haveCommonWeekdays", "", "event", "getFrequencyOrder", "", "spaceport-common"})
public interface EventCounter {
    public void toNextEvent();

    public void toNextEventAfterDate(@NotNull KotlinXDate var1);

    @NotNull
    public KotlinXDate getCurrentDate();

    @NotNull
    public List<Weekday> getWeekdays();

    @NotNull
    public RecurrenceRuleFreq getFrequency();

    @NotNull
    public RelativeDate getRelativity();

    public boolean haveCommonWeekdays(@NotNull EventCounter var1);

    public int getFrequencyOrder();

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean haveCommonWeekdays(@NotNull EventCounter $this, @NotNull EventCounter event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return CollectionsKt.any((Iterable)CollectionsKt.intersect((Iterable)$this.getWeekdays(), (Iterable)event.getWeekdays()));
        }

        public static int getFrequencyOrder(@NotNull EventCounter $this) {
            int n;
            RecurrenceRuleFreq recurrenceRuleFreq = $this.getFrequency();
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Daily) {
                n = 0;
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Weekly) {
                n = 1;
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
                n = 2;
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
                n = 3;
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
                n = 4;
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
                n = 5;
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Yearly) {
                n = 6;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return n;
        }
    }
}

