/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.metrics.product.app;

import circlet.platform.metrics.EventBuilder;
import circlet.platform.metrics.Severity;
import circlet.platform.metrics.product.Metrics;
import circlet.platform.metrics.product.MetricsEvent;
import circlet.platform.metrics.product.MetricsEventBuilder;
import circlet.platform.metrics.product.MetricsEventPayload;
import circlet.platform.metrics.product.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import libraries.basics.Sync;
import libraries.coroutines.extra.Lifetime;
import libraries.klogging.BaseLogger;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggerExJvmKt;
import libraries.klogging.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.JVMDateTimeServiceKt;
import runtime.TimeService;
import runtime.routing.ActionCookies;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000  2\u00020\u0001:\u0002 !B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JD\u0010\u0011\u001a\u00020\u0010\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u0002H\u00122#\u0010\u0015\u001a\u001f\u0012\u0004\u0012\u0002H\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\u0017\u0012\u0004\u0012\u00020\u00100\u0016\u00a2\u0006\u0002\b\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J$\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcirclet/platform/metrics/product/app/MetricsComponent;", "Lcirclet/platform/metrics/product/Metrics;", "timeService", "Lruntime/TimeService;", "<init>", "(Lruntime/TimeService;)V", "session", "Lcirclet/platform/metrics/product/Session;", "getSession", "()Lcirclet/platform/metrics/product/Session;", "buffer", "Lkotlin/collections/ArrayDeque;", "Lcirclet/platform/metrics/product/MetricsEventPayload;", "subscribers", "", "Lkotlin/Function1;", "", "event", "T", "Lcirclet/platform/metrics/product/MetricsEvent;", "schema", "body", "Lkotlin/Function2;", "Lcirclet/platform/metrics/product/MetricsEventBuilder;", "Lkotlin/ExtensionFunctionType;", "(Lcirclet/platform/metrics/product/MetricsEvent;Lkotlin/jvm/functions/Function2;)V", "subscribe", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "subscriber", "notifySubscribers", "doNotifySubscribers", "Companion", "EventAttributesBuilder", "platform-product-metrics-app"})
@SourceDebugExtension(value={"SMAP\nMetricsComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsComponent.kt\ncirclet/platform/metrics/product/app/MetricsComponent\n+ 2 Sync.kt\nlibraries/basics/Sync\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KLoggerEx.kt\nlibraries/klogging/KLoggerExKt\n+ 5 KLoggerExJvm.kt\nlibraries/klogging/KLoggerExJvmKt\n*L\n1#1,86:1\n4#2:87\n4#2:88\n1863#3:89\n1755#3,3:104\n1864#3:117\n17#4:90\n105#4,9:91\n114#4,3:101\n117#4,4:107\n18#4,6:111\n7#5:100\n*S KotlinDebug\n*F\n+ 1 MetricsComponent.kt\ncirclet/platform/metrics/product/app/MetricsComponent\n*L\n58#1:87\n65#1:88\n79#1:89\n80#1:104,3\n79#1:117\n80#1:90\n80#1:91,9\n80#1:101,3\n80#1:107,4\n80#1:111,6\n80#1:100\n*E\n"})
public final class MetricsComponent
implements Metrics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TimeService timeService;
    @NotNull
    private final Session session;
    @NotNull
    private final ArrayDeque<MetricsEventPayload> buffer;
    @NotNull
    private final List<Function1<MetricsEventPayload, Unit>> subscribers;

    public MetricsComponent(@NotNull TimeService timeService) {
        Intrinsics.checkNotNullParameter((Object)timeService, (String)"timeService");
        this.timeService = timeService;
        this.session = new Session();
        this.buffer = new ArrayDeque();
        this.subscribers = new ArrayList();
    }

    public /* synthetic */ MetricsComponent(TimeService timeService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            timeService = JVMDateTimeServiceKt.getDefaultTimeService();
        }
        this(timeService);
    }

    @Override
    @NotNull
    public Session getSession() {
        return this.session;
    }

    @Override
    public <T extends MetricsEvent> void event(@NotNull T schema, @NotNull Function2<? super T, ? super MetricsEventBuilder<T>, Unit> body) {
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        MetricsEventPayload event = new MetricsEventBuilder<T>(schema).event(this.timeService.now(), (arg_0, arg_1) -> MetricsComponent.event$lambda$1(this, body, arg_0, arg_1));
        this.notifySubscribers(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(@NotNull Lifetime lifetime, @NotNull Function1<? super MetricsEventPayload, Unit> subscriber) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(subscriber, (String)"subscriber");
        Sync sync2 = Sync.INSTANCE;
        List<Function1<MetricsEventPayload, Unit>> lock$iv = this.subscribers;
        boolean $i$f$exec = false;
        List<Function1<MetricsEventPayload, Unit>> list2 = lock$iv;
        synchronized (list2) {
            boolean bl = false;
            ((Collection)this.subscribers).add(subscriber);
            lifetime.add((Function)((Function0)() -> MetricsComponent.subscribe$lambda$3$lambda$2(this, subscriber)));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifySubscribers(MetricsEventPayload event) {
        Sync sync2 = Sync.INSTANCE;
        List<Function1<MetricsEventPayload, Unit>> lock$iv = this.subscribers;
        boolean $i$f$exec = false;
        List<Function1<MetricsEventPayload, Unit>> list2 = lock$iv;
        synchronized (list2) {
            boolean bl = false;
            if (this.subscribers.isEmpty()) {
                ((Collection)this.buffer).add(event);
            } else {
                while (!((Collection)this.buffer).isEmpty()) {
                    this.doNotifySubscribers((MetricsEventPayload)this.buffer.removeFirst());
                }
                this.doNotifySubscribers(event);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doNotifySubscribers(MetricsEventPayload event) {
        Iterable $this$forEach$iv = this.subscribers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Unit unit;
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            KLogger $this$catch$iv = Companion.getLogger();
            boolean $i$f$catch = false;
            KLogger $this$internalCatch_u24default$iv$iv = $this$catch$iv;
            List except$iv$iv = CollectionsKt.emptyList();
            boolean $i$f$internalCatch = false;
            try {
                boolean bl2 = false;
                it.invoke((Object)event);
                unit = Unit.INSTANCE;
            }
            catch (Throwable th$iv$iv) {
                void th$iv;
                boolean bl3;
                block10: {
                    boolean $i$f$isCancellationException = false;
                    if (th$iv$iv instanceof InterruptedException || th$iv$iv instanceof CancellationException) {
                        throw th$iv$iv;
                    }
                    Iterable $this$any$iv$iv$iv = except$iv$iv;
                    boolean $i$f$any = false;
                    if ($this$any$iv$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv$iv$iv : $this$any$iv$iv$iv) {
                            KClass it$iv$iv = (KClass)element$iv$iv$iv;
                            boolean bl4 = false;
                            if (!it$iv$iv.isInstance((Object)th$iv$iv)) continue;
                            bl3 = true;
                            break block10;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    throw th$iv$iv;
                }
                Throwable throwable = th$iv$iv;
                KLogger $this$catch_u24lambda_u240$iv = $this$internalCatch_u24default$iv$iv;
                boolean bl5 = false;
                if (KLoggerExJvmKt.isShutdownInProgress()) {
                    BaseLogger.DefaultImpls.warn$default($this$catch_u24lambda_u240$iv, (Throwable)th$iv, null, 2, null);
                } else {
                    BaseLogger.DefaultImpls.error$default($this$catch_u24lambda_u240$iv, (Throwable)th$iv, null, 2, null);
                }
                unit = null;
            }
        }
    }

    private static final Unit event$lambda$1(MetricsComponent this$0, Function2 $body, MetricsEvent $this$event, MetricsEventBuilder event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$body, (String)"$body");
        Intrinsics.checkNotNullParameter((Object)$this$event, (String)"$this$event");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.set($this$event.getSessionId(), this$0.getSession().currentSessionId());
        String string = ActionCookies.INSTANCE.currentUid();
        if (string != null) {
            String it = string;
            boolean bl = false;
            event.set($this$event.getActionCookie(), it);
        }
        $body.invoke((Object)$this$event, (Object)event);
        return Unit.INSTANCE;
    }

    private static final Unit subscribe$lambda$3$lambda$2(MetricsComponent this$0, Function1 $subscriber) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$subscriber, (String)"$subscriber");
        ((Collection)this$0.subscribers).remove($subscriber);
        return Unit.INSTANCE;
    }

    public MetricsComponent() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcirclet/platform/metrics/product/app/MetricsComponent$Companion;", "Llibraries/klogging/KLogging;", "<init>", "()V", "platform-product-metrics-app"})
    public static final class Companion
    extends KLogging {
        private Companion() {
            super(null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0005H\u0014J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J*\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcirclet/platform/metrics/product/app/MetricsComponent$EventAttributesBuilder;", "Lcirclet/platform/metrics/EventBuilder;", "attributes", "", "", "", "<init>", "(Ljava/util/Map;)V", "getAttributes", "()Ljava/util/Map;", "prop", "", "key", "value", "count", "increment", "", "severity", "Lcirclet/platform/metrics/Severity;", "gauge", "histogram", "buckets", "", "platform-product-metrics-app"})
    private static final class EventAttributesBuilder
    extends EventBuilder {
        @NotNull
        private final Map<String, Object> attributes;

        public EventAttributesBuilder(@NotNull Map<String, Object> attributes) {
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.attributes = attributes;
        }

        @NotNull
        public final Map<String, Object> getAttributes() {
            return this.attributes;
        }

        @Override
        protected void prop(@NotNull String key, @NotNull Object value2) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            this.attributes.put(key, value2);
        }

        @Override
        public void count(@NotNull String key, long increment, @NotNull Severity severity) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            Long l = increment;
            this.attributes.put(key, l);
        }

        @Override
        public void gauge(@NotNull String key, long value2, @NotNull Severity severity) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            Long l = value2;
            this.attributes.put(key, l);
        }

        @Override
        public void histogram(@NotNull String key, long value2, @NotNull Severity severity, @Nullable double[] buckets) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            Long l = value2;
            this.attributes.put(key, l);
        }
    }
}

