/*
 * Decompiled with CFR 0.152.
 */
package libraries.basics;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Llibraries/basics/SecretsReplacer;", "", "secrets", "", "", "<init>", "(Ljava/util/Set;)V", "getSecrets", "()Ljava/util/Set;", "replacementPattern", "Ljava/util/regex/Pattern;", "replaceSecrets", "text", "Companion", "libraries-basics"})
@SourceDebugExtension(value={"SMAP\nSecretsReplacer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecretsReplacer.kt\nlibraries/basics/SecretsReplacer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,70:1\n1863#2:71\n1863#2,2:74\n1864#2:76\n1019#2,2:77\n1088#3,2:72\n*S KotlinDebug\n*F\n+ 1 SecretsReplacer.kt\nlibraries/basics/SecretsReplacer\n*L\n19#1:71\n37#1:74,2\n19#1:76\n54#1:77,2\n24#1:72,2\n*E\n"})
public class SecretsReplacer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> secrets;
    @NotNull
    private final Pattern replacementPattern;
    @NotNull
    private static final Pattern doNotMatchPattern;

    public SecretsReplacer(@NotNull Set<String> secrets) {
        Pattern pattern;
        Intrinsics.checkNotNullParameter(secrets, (String)"secrets");
        this.secrets = secrets;
        List processedSecrets = new ArrayList();
        Iterable $this$forEach$iv = this.secrets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List lines;
            boolean bl;
            String trimmed;
            String secret;
            block7: {
                secret = (String)element$iv;
                boolean bl2 = false;
                trimmed = ((Object)StringsKt.trim((CharSequence)secret)).toString();
                if (trimmed.length() <= 2) continue;
                CharSequence $this$any$iv = secret;
                boolean $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv2;
                    char it = element$iv2 = $this$any$iv.charAt(i);
                    boolean bl3 = false;
                    if (!(it != '*')) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            if (!bl) continue;
            processedSecrets.add(secret);
            if (trimmed.length() != secret.length()) {
                processedSecrets.add(trimmed);
            }
            if ((lines = StringsKt.lines((CharSequence)secret)).size() <= 1) continue;
            Iterable $this$forEach$iv2 = lines;
            boolean $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                String it = (String)element$iv3;
                boolean bl4 = false;
                String trimmedLine = ((Object)StringsKt.trim((CharSequence)it)).toString();
                if (trimmedLine.length() < 8) continue;
                processedSecrets.add(trimmedLine);
            }
        }
        if (processedSecrets.isEmpty()) {
            pattern = doNotMatchPattern;
        } else {
            List $this$sortByDescending$iv = processedSecrets;
            boolean $i$f$sortByDescending = false;
            if ($this$sortByDescending$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        String it = (String)b;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.length());
                        it = (String)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.length()));
                    }
                });
            }
            String pattern2 = CollectionsKt.joinToString$default((Iterable)processedSecrets, (CharSequence)"|", null, null, (int)0, null, SecretsReplacer::_init_$lambda$4, (int)30, null);
            Pattern pattern3 = Pattern.compile(pattern2);
            Intrinsics.checkNotNull((Object)pattern3);
            pattern = pattern3;
        }
        this.replacementPattern = pattern;
    }

    @NotNull
    public final Set<String> getSecrets() {
        return this.secrets;
    }

    @NotNull
    public String replaceSecrets(@NotNull String text2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (Intrinsics.areEqual((Object)this.replacementPattern, (Object)doNotMatchPattern)) {
            string = text2;
        } else {
            String string2 = this.replacementPattern.matcher(text2).replaceAll("*******");
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"replaceAll(...)");
        }
        return string;
    }

    private static final CharSequence _init_$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = Pattern.quote(it);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"quote(...)");
        return "(" + StringsKt.replace$default((String)string, (String)"%%", (String)"\\E%{1,2}\\Q", (boolean)false, (int)4, null) + ")";
    }

    static {
        Pattern pattern = Pattern.compile("");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        doNotMatchPattern = pattern;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llibraries/basics/SecretsReplacer$Companion;", "", "<init>", "()V", "doNotMatchPattern", "Ljava/util/regex/Pattern;", "libraries-basics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

