/*
 * Decompiled with CFR 0.152.
 */
package runtime.routing;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import libraries.collections.Stack;
import libraries.io.random.UID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.routing.ActionCookie;
import runtime.routing.ActionCookiesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\b\u0010\n\u001a\u0004\u0018\u00010\u0006J\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0006\u0010\r\u001a\u00020\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lruntime/routing/ActionCookies;", "", "<init>", "()V", "cookies", "Llibraries/collections/Stack;", "Lruntime/routing/ActionCookie;", "setCookie", "", "item", "current", "currentUid", "", "clearLast", "platform-runtime"})
public final class ActionCookies {
    @NotNull
    public static final ActionCookies INSTANCE = new ActionCookies();
    @NotNull
    private static final Stack<ActionCookie> cookies = new Stack();

    private ActionCookies() {
    }

    public final void setCookie(@NotNull ActionCookie item2) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        ActionCookie actionCookie = item2;
        if (actionCookie instanceof ActionCookie.Descriptor) {
            while (!cookies.isEmpty()) {
                if (Stack.peek$default(cookies, 0, 1, null) instanceof ActionCookie.Descriptor) {
                    cookies.pop();
                    break;
                }
                if (!(Stack.peek$default(cookies, 0, 1, null) instanceof ActionCookie.Dialog)) continue;
                cookies.pop();
            }
            cookies.push(item2);
        } else if (actionCookie instanceof ActionCookie.Dialog) {
            cookies.push(item2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ActionCookiesKt.access$getLog$p().debug("Action cookie: " + item2);
    }

    @Nullable
    public final ActionCookie current() {
        return !cookies.isEmpty() ? (ActionCookie)Stack.peek$default(cookies, 0, 1, null) : null;
    }

    @Nullable
    public final String currentUid() {
        UID uid;
        ActionCookie cookie = this.current();
        UID uID = uid = cookie instanceof ActionCookie.Descriptor ? ((ActionCookie.Descriptor)cookie).getUid() : (cookie instanceof ActionCookie.Dialog ? ((ActionCookie.Dialog)cookie).getUid() : null);
        return uID != null ? uID.toString() : null;
    }

    public final void clearLast() {
        cookies.pop();
    }
}

