/*
 * Decompiled with CFR 0.152.
 */
package libraries.io.content;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import libraries.io.HexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\tJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Llibraries/io/content/Digest;", "", "algorithm", "", "value", "", "<init>", "(Ljava/lang/String;[B)V", "hex", "(Ljava/lang/String;Ljava/lang/String;)V", "getAlgorithm", "()Ljava/lang/String;", "getValue", "()[B", "equals", "", "other", "hashCode", "", "toString", "component1", "component2", "copy", "libraries-io"})
public final class Digest {
    @NotNull
    private final String algorithm;
    @NotNull
    private final byte[] value;

    public Digest(@NotNull String algorithm, @NotNull byte[] value2) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.algorithm = algorithm;
        this.value = value2;
    }

    @NotNull
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final byte[] getValue() {
        return this.value;
    }

    public Digest(@NotNull String algorithm, @NotNull String hex) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        this(algorithm, HexKt.decodeHexString(hex));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type libraries.io.content.Digest");
        Digest cfr_ignored_0 = (Digest)other;
        if (!Intrinsics.areEqual((Object)this.algorithm, (Object)((Digest)other).algorithm)) {
            return false;
        }
        return Arrays.equals(this.value, ((Digest)other).value);
    }

    public int hashCode() {
        int result2 = this.algorithm.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.value);
        return result2;
    }

    @NotNull
    public String toString() {
        return "(" + this.algorithm + "=" + HexKt.toHexString(this.value) + ")";
    }

    @NotNull
    public final String component1() {
        return this.algorithm;
    }

    @NotNull
    public final byte[] component2() {
        return this.value;
    }

    @NotNull
    public final Digest copy(@NotNull String algorithm, @NotNull byte[] value2) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return new Digest(algorithm, value2);
    }

    public static /* synthetic */ Digest copy$default(Digest digest, String string, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            string = digest.algorithm;
        }
        if ((n & 2) != 0) {
            byArray = digest.value;
        }
        return digest.copy(string, byArray);
    }
}

