/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spaceport.gateway.rd;

import circlet.rd.api.IdeType;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.spaceport.gateway.rd.ExternalIde;
import com.intellij.spaceport.gateway.rd.IdeProduct;
import com.intellij.spaceport.gateway.rd.IntelliJPlatformProductMeta;
import com.intellij.spaceport.gateway.rd.SpaceIdeTypeMappingKt;
import com.jetbrains.gateway.ssh.IntelliJPlatformProduct;
import icons.GatewayCoreIcons;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.stringUtils.UnicodeUtilKt;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/intellij/spaceport/gateway/rd/SpaceIdeTypeMapping;", "", "<init>", "()V", "mapping", "", "", "Lcom/jetbrains/gateway/ssh/IntelliJPlatformProduct;", "externalIdeMapping", "Lcom/intellij/spaceport/gateway/rd/IdeProduct;", "appProductCode", "getAppProductCode", "()Ljava/lang/String;", "getPlatformProduct", "Lcom/intellij/spaceport/gateway/rd/IntelliJPlatformProductMeta;", "ideType", "Lcirclet/rd/api/IdeType;", "getIdeProduct", "isTypeOfRunningApplication", "", "Companion", "intellij.spaceport.gateway"})
@SourceDebugExtension(value={"SMAP\nSpaceIdeTypeMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceIdeTypeMapping.kt\ncom/intellij/spaceport/gateway/rd/SpaceIdeTypeMapping\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,92:1\n1#2:93\n434#3:94\n507#3,5:95\n*S KotlinDebug\n*F\n+ 1 SpaceIdeTypeMapping.kt\ncom/intellij/spaceport/gateway/rd/SpaceIdeTypeMapping\n*L\n70#1:94\n70#1:95,5\n*E\n"})
public final class SpaceIdeTypeMapping {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, IntelliJPlatformProduct> mapping;
    @NotNull
    private final Map<String, IdeProduct> externalIdeMapping;

    public SpaceIdeTypeMapping() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"CLion", (Object)IntelliJPlatformProduct.CLION), TuplesKt.to((Object)"GoLand", (Object)IntelliJPlatformProduct.GOIDE), TuplesKt.to((Object)"Idea", (Object)IntelliJPlatformProduct.IDEA), TuplesKt.to((Object)"PhpStorm", (Object)IntelliJPlatformProduct.PHPSTORM), TuplesKt.to((Object)"PyCharm", (Object)IntelliJPlatformProduct.PYCHARM), TuplesKt.to((Object)"RubyMine", (Object)IntelliJPlatformProduct.RUBYMINE), TuplesKt.to((Object)"WebStorm", (Object)IntelliJPlatformProduct.WEBSTORM), TuplesKt.to((Object)"Rider", (Object)IntelliJPlatformProduct.RIDER), TuplesKt.to((Object)"RustRover", (Object)IntelliJPlatformProduct.RUSTROVER)};
        this.mapping = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"vs-code", (Object)new IdeProduct(ExternalIde.VS_CODE.getId(), ExternalIde.VS_CODE.getIdeName(), ExternalIde.VS_CODE.getIcon(), true)), TuplesKt.to((Object)"cursor", (Object)new IdeProduct(ExternalIde.VS_CODE.getId(), ExternalIde.CURSOR.getIdeName(), ExternalIde.CURSOR.getIcon(), true))};
        this.externalIdeMapping = MapsKt.mapOf((Pair[])pairArray);
    }

    private final String getAppProductCode() {
        String string = ApplicationInfo.getInstance().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IntelliJPlatformProductMeta getPlatformProduct(@NotNull IdeType ideType) {
        IntelliJPlatformProductMeta intelliJPlatformProductMeta;
        Intrinsics.checkNotNullParameter((Object)ideType, (String)"ideType");
        IntelliJPlatformProduct intelliJPlatformProduct = this.mapping.get(ideType.getId());
        if (intelliJPlatformProduct != null) {
            IntelliJPlatformProduct it = intelliJPlatformProduct;
            boolean bl = false;
            intelliJPlatformProductMeta = new IntelliJPlatformProductMeta(it);
        } else {
            void $this$filterTo$iv$iv;
            String $this$filter$iv = ideType.getId();
            boolean $i$f$filter = false;
            CharSequence bl = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                if (!(UnicodeUtilKt.isUpperCase((char)it) || Character.isTitleCase(it))) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string = StringsKt.take((String)((StringBuilder)destination$iv$iv).toString(), (int)2);
            String string2 = ideType.getNames().getBackendShortName();
            Icon icon = GatewayCoreIcons.Icons.JetBrainsClient;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"JetBrainsClient");
            String string3 = ideType.getId();
            boolean bl3 = true;
            Icon icon2 = icon;
            String string4 = string2;
            String string5 = string;
            intelliJPlatformProductMeta = new IntelliJPlatformProductMeta(string5, string4, icon2, bl3, string3);
        }
        return intelliJPlatformProductMeta;
    }

    @NotNull
    public final IdeProduct getIdeProduct(@NotNull IdeType ideType) {
        Intrinsics.checkNotNullParameter((Object)ideType, (String)"ideType");
        Map<String, IdeProduct> map2 = this.externalIdeMapping;
        IdeProduct ideProduct = map2.get(ideType.getId());
        if (ideProduct == null) {
            boolean bl = false;
            ideProduct = SpaceIdeTypeMappingKt.access$toIdeProduct(this.getPlatformProduct(ideType));
        }
        return ideProduct;
    }

    public final boolean isTypeOfRunningApplication(@NotNull IdeType ideType) {
        Intrinsics.checkNotNullParameter((Object)ideType, (String)"ideType");
        IntelliJPlatformProductMeta intelliJPlatformProductMeta = this.getPlatformProduct(ideType);
        return Intrinsics.areEqual((Object)(intelliJPlatformProductMeta != null ? intelliJPlatformProductMeta.getProductCode() : null), (Object)this.getAppProductCode());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/spaceport/gateway/rd/SpaceIdeTypeMapping$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/spaceport/gateway/rd/SpaceIdeTypeMapping;", "getInstance", "()Lcom/intellij/spaceport/gateway/rd/SpaceIdeTypeMapping;", "getIdeProduct", "Lcom/intellij/spaceport/gateway/rd/IdeProduct;", "ideType", "Lcirclet/rd/api/IdeType;", "getPlatformProduct", "Lcom/intellij/spaceport/gateway/rd/IntelliJPlatformProductMeta;", "isTypeOfRunningApplication", "", "intellij.spaceport.gateway"})
    @SourceDebugExtension(value={"SMAP\nSpaceIdeTypeMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceIdeTypeMapping.kt\ncom/intellij/spaceport/gateway/rd/SpaceIdeTypeMapping$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,92:1\n40#2,3:93\n*S KotlinDebug\n*F\n+ 1 SpaceIdeTypeMapping.kt\ncom/intellij/spaceport/gateway/rd/SpaceIdeTypeMapping$Companion\n*L\n84#1:93,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final SpaceIdeTypeMapping getInstance() {
            boolean $i$f$service = false;
            Class<SpaceIdeTypeMapping> serviceClass$iv = SpaceIdeTypeMapping.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (SpaceIdeTypeMapping)object;
        }

        @Nullable
        public final IdeProduct getIdeProduct(@NotNull IdeType ideType) {
            Intrinsics.checkNotNullParameter((Object)ideType, (String)"ideType");
            return this.getInstance().getIdeProduct(ideType);
        }

        @NotNull
        public final IntelliJPlatformProductMeta getPlatformProduct(@NotNull IdeType ideType) {
            Intrinsics.checkNotNullParameter((Object)ideType, (String)"ideType");
            return this.getInstance().getPlatformProduct(ideType);
        }

        public final boolean isTypeOfRunningApplication(@NotNull IdeType ideType) {
            Intrinsics.checkNotNullParameter((Object)ideType, (String)"ideType");
            return this.getInstance().isTypeOfRunningApplication(ideType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

