/*
 * Decompiled with CFR 0.152.
 */
package circlet.rd.api;

import circlet.common.HelpKt;
import circlet.rd.api.RdSshConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001e"}, d2={"Lcirclet/rd/api/WorkspaceSshConnectionParams;", "", "host", "", "internalConnection", "Lcirclet/rd/api/RdSshConnection;", "proxyJump", "<init>", "(Ljava/lang/String;Lcirclet/rd/api/RdSshConnection;Lcirclet/rd/api/RdSshConnection;)V", "getHost", "()Ljava/lang/String;", "getInternalConnection", "()Lcirclet/rd/api/RdSshConnection;", "getProxyJump", "configFileHostEntry", "sshConnectionString", "sshShortConnectionString", "sshForwardPortString", "vsCodeConnectionHelpUrl", "serverVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "rd-api"})
public final class WorkspaceSshConnectionParams {
    @NotNull
    private final String host;
    @NotNull
    private final RdSshConnection internalConnection;
    @NotNull
    private final RdSshConnection proxyJump;

    public WorkspaceSshConnectionParams(@NotNull String host, @NotNull RdSshConnection internalConnection, @NotNull RdSshConnection proxyJump) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)internalConnection, (String)"internalConnection");
        Intrinsics.checkNotNullParameter((Object)proxyJump, (String)"proxyJump");
        this.host = host;
        this.internalConnection = internalConnection;
        this.proxyJump = proxyJump;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @NotNull
    public final RdSshConnection getInternalConnection() {
        return this.internalConnection;
    }

    @NotNull
    public final RdSshConnection getProxyJump() {
        return this.proxyJump;
    }

    @NotNull
    public final String configFileHostEntry() {
        return StringsKt.trimIndent((String)("\n            Host " + this.host + "\n                IdentityFile ~/.ssh/id_rsa # adjust the path to the private key as needed\n                ProxyJump " + this.proxyJump.getUser() + "@" + this.proxyJump.getHost() + ":" + this.proxyJump.getPort() + "\n                HostName " + this.internalConnection.getHost() + "\n                Port " + this.internalConnection.getPort() + "\n                User " + this.internalConnection.getUser() + "\n                ForwardAgent yes\n                HostKeyAlias " + this.host + "\n                StrictHostKeyChecking accept-new\n        "));
    }

    @NotNull
    public final String sshConnectionString() {
        return "ssh -J " + this.proxyJump.getUser() + "@" + this.proxyJump.getHost() + ":" + this.proxyJump.getPort() + " -o ForwardAgent=yes -o HostKeyAlias=" + this.host + " -p " + this.internalConnection.getPort() + " " + this.internalConnection.getUser() + "@" + this.internalConnection.getHost();
    }

    @NotNull
    public final String sshShortConnectionString() {
        return "ssh " + this.host;
    }

    @NotNull
    public final String sshForwardPortString() {
        return "ssh -L <local_port>:127.0.0.1:<dev_env_port> -N " + this.host;
    }

    @NotNull
    public final String vsCodeConnectionHelpUrl(@NotNull String serverVersion) {
        Intrinsics.checkNotNullParameter((Object)serverVersion, (String)"serverVersion");
        return HelpKt.spaceportHelpUrl("open-code-in-dev-environment.html#visual_studio_code", HelpKt.toAppVersion(serverVersion));
    }

    @NotNull
    public final String component1() {
        return this.host;
    }

    @NotNull
    public final RdSshConnection component2() {
        return this.internalConnection;
    }

    @NotNull
    public final RdSshConnection component3() {
        return this.proxyJump;
    }

    @NotNull
    public final WorkspaceSshConnectionParams copy(@NotNull String host, @NotNull RdSshConnection internalConnection, @NotNull RdSshConnection proxyJump) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)internalConnection, (String)"internalConnection");
        Intrinsics.checkNotNullParameter((Object)proxyJump, (String)"proxyJump");
        return new WorkspaceSshConnectionParams(host, internalConnection, proxyJump);
    }

    public static /* synthetic */ WorkspaceSshConnectionParams copy$default(WorkspaceSshConnectionParams workspaceSshConnectionParams, String string, RdSshConnection rdSshConnection, RdSshConnection rdSshConnection2, int n, Object object) {
        if ((n & 1) != 0) {
            string = workspaceSshConnectionParams.host;
        }
        if ((n & 2) != 0) {
            rdSshConnection = workspaceSshConnectionParams.internalConnection;
        }
        if ((n & 4) != 0) {
            rdSshConnection2 = workspaceSshConnectionParams.proxyJump;
        }
        return workspaceSshConnectionParams.copy(string, rdSshConnection, rdSshConnection2);
    }

    @NotNull
    public String toString() {
        return "WorkspaceSshConnectionParams(host=" + this.host + ", internalConnection=" + this.internalConnection + ", proxyJump=" + this.proxyJump + ")";
    }

    public int hashCode() {
        int result2 = this.host.hashCode();
        result2 = result2 * 31 + this.internalConnection.hashCode();
        result2 = result2 * 31 + this.proxyJump.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WorkspaceSshConnectionParams)) {
            return false;
        }
        WorkspaceSshConnectionParams workspaceSshConnectionParams = (WorkspaceSshConnectionParams)other;
        if (!Intrinsics.areEqual((Object)this.host, (Object)workspaceSshConnectionParams.host)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.internalConnection, (Object)workspaceSshConnectionParams.internalConnection)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.proxyJump, (Object)workspaceSshConnectionParams.proxyJump);
    }
}

