/*
 * Decompiled with CFR 0.152.
 */
package circlet.todo;

import circlet.client.api.TodoAnchor;
import circlet.client.api.TodoItemRecord;
import circlet.platform.api.Ref;
import circlet.platform.client.RefResolveKt;
import circlet.todo.TodoItemCategory;
import circlet.todo.TodoTreeItemInterface;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.MutableProperty;
import runtime.reactive.PropertyKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0015\u001a\u00020\u0004H\u0016J\u0011\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00c6\u0003J\u0011\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\nH\u00c6\u0003JA\u0010\u001d\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u001c\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014\u00a8\u0006%"}, d2={"Lcirclet/todo/TodoTreeItem;", "Lcirclet/todo/TodoTreeItemInterface;", "ref", "Lcirclet/platform/api/Ref;", "Lcirclet/client/api/TodoItemRecord;", "anchor", "Lcirclet/client/api/TodoAnchor;", "category", "Lcirclet/todo/TodoItemCategory;", "optimistic", "Lruntime/reactive/MutableProperty;", "<init>", "(Lcirclet/platform/api/Ref;Lcirclet/client/api/TodoAnchor;Lcirclet/todo/TodoItemCategory;Lruntime/reactive/MutableProperty;)V", "getRef", "()Lcirclet/platform/api/Ref;", "getAnchor", "()Lcirclet/client/api/TodoAnchor;", "getCategory", "()Lcirclet/todo/TodoItemCategory;", "getOptimistic", "()Lruntime/reactive/MutableProperty;", "resolve", "unfurlExpanded", "", "getUnfurlExpanded", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "", "spaceport-app-state"})
public final class TodoTreeItem
implements TodoTreeItemInterface {
    @Nullable
    private final Ref<TodoItemRecord> ref;
    @NotNull
    private final TodoAnchor anchor;
    @NotNull
    private final TodoItemCategory category;
    @Nullable
    private final MutableProperty<TodoItemRecord> optimistic;
    @NotNull
    private final MutableProperty<Boolean> unfurlExpanded;

    public TodoTreeItem(@Nullable Ref<TodoItemRecord> ref2, @NotNull TodoAnchor anchor, @NotNull TodoItemCategory category, @Nullable MutableProperty<TodoItemRecord> optimistic) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        this.ref = ref2;
        this.anchor = anchor;
        this.category = category;
        this.optimistic = optimistic;
        this.unfurlExpanded = PropertyKt.mutableProperty(false);
    }

    @Override
    @Nullable
    public Ref<TodoItemRecord> getRef() {
        return this.ref;
    }

    @Override
    @NotNull
    public TodoAnchor getAnchor() {
        return this.anchor;
    }

    @Override
    @NotNull
    public TodoItemCategory getCategory() {
        return this.category;
    }

    @Override
    @Nullable
    public MutableProperty<TodoItemRecord> getOptimistic() {
        return this.optimistic;
    }

    @Override
    @NotNull
    public TodoItemRecord resolve() {
        Ref<TodoItemRecord> ref2 = this.getRef();
        if (ref2 == null || (ref2 = RefResolveKt.resolve(ref2)) == null) {
            MutableProperty<TodoItemRecord> mutableProperty = this.getOptimistic();
            if (mutableProperty != null) {
                ref2 = mutableProperty.getValue();
            } else {
                throw new IllegalStateException("null".toString());
            }
        }
        return ref2;
    }

    @NotNull
    public final MutableProperty<Boolean> getUnfurlExpanded() {
        return this.unfurlExpanded;
    }

    @Nullable
    public final Ref<TodoItemRecord> component1() {
        return this.ref;
    }

    @NotNull
    public final TodoAnchor component2() {
        return this.anchor;
    }

    @NotNull
    public final TodoItemCategory component3() {
        return this.category;
    }

    @Nullable
    public final MutableProperty<TodoItemRecord> component4() {
        return this.optimistic;
    }

    @NotNull
    public final TodoTreeItem copy(@Nullable Ref<TodoItemRecord> ref2, @NotNull TodoAnchor anchor, @NotNull TodoItemCategory category, @Nullable MutableProperty<TodoItemRecord> optimistic) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        return new TodoTreeItem(ref2, anchor, category, optimistic);
    }

    public static /* synthetic */ TodoTreeItem copy$default(TodoTreeItem todoTreeItem, Ref ref2, TodoAnchor todoAnchor, TodoItemCategory todoItemCategory, MutableProperty mutableProperty, int n, Object object) {
        if ((n & 1) != 0) {
            ref2 = todoTreeItem.ref;
        }
        if ((n & 2) != 0) {
            todoAnchor = todoTreeItem.anchor;
        }
        if ((n & 4) != 0) {
            todoItemCategory = todoTreeItem.category;
        }
        if ((n & 8) != 0) {
            mutableProperty = todoTreeItem.optimistic;
        }
        return todoTreeItem.copy(ref2, todoAnchor, todoItemCategory, mutableProperty);
    }

    @NotNull
    public String toString() {
        return "TodoTreeItem(ref=" + this.ref + ", anchor=" + this.anchor + ", category=" + this.category + ", optimistic=" + this.optimistic + ")";
    }

    public int hashCode() {
        int result2 = this.ref == null ? 0 : this.ref.hashCode();
        result2 = result2 * 31 + this.anchor.hashCode();
        result2 = result2 * 31 + this.category.hashCode();
        result2 = result2 * 31 + (this.optimistic == null ? 0 : this.optimistic.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TodoTreeItem)) {
            return false;
        }
        TodoTreeItem todoTreeItem = (TodoTreeItem)other;
        if (!Intrinsics.areEqual(this.ref, todoTreeItem.ref)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.anchor, (Object)todoTreeItem.anchor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.category, (Object)todoTreeItem.category)) {
            return false;
        }
        return Intrinsics.areEqual(this.optimistic, todoTreeItem.optimistic);
    }
}

