/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import java.lang.reflect.Method;

public abstract class TestDiscoveryListener {
    public abstract String getFrameworkId();

    public void testStarted(String className, String methodName) {
        try {
            Object data = this.getData();
            Method testStarted = data.getClass().getMethod("testDiscoveryStarted", String.class, String.class);
            testStarted.invoke(data, className, methodName);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void testFinished(String className, String methodName, boolean succeed) {
        if (succeed) {
            try {
                Object data = this.getData();
                Method testEnded = data.getClass().getMethod("testDiscoveryEnded", String.class, String.class);
                testEnded.invoke(data, className, methodName);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected Object getData() throws Exception {
        return Class.forName("com.intellij.rt.coverage.data.TestDiscoveryProjectData").getMethod("getProjectData", new Class[0]).invoke(null, new Object[0]);
    }

    public void testRunStarted(String name) {
    }

    public void testRunFinished(String name) {
    }
}

