/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JCefVersionDetails {
    private static final Pattern PATTERN = Pattern.compile("#.#.#-g([0-9a-f]{7})-chromium-#.#.#.#-api-#.#".replaceAll("\\.", "\\\\.").replaceAll("#", "(\\\\d+)"));
    public final CefVersion cefVersion;
    public final ChromiumVersion chromiumVersion;
    public final ApiVersion apiVersion;
    private final String stringValue;

    JCefVersionDetails(String stringValue) throws VersionUnavailableException {
        this.stringValue = stringValue;
        Matcher matcher = PATTERN.matcher(stringValue);
        if (!matcher.matches()) {
            throw new VersionUnavailableException("JCEF version has wrong format: " + stringValue);
        }
        try {
            this.cefVersion = new CefVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), matcher.group(4));
            this.chromiumVersion = new ChromiumVersion(Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)), Integer.parseInt(matcher.group(7)), Integer.parseInt(matcher.group(8)));
            this.apiVersion = new ApiVersion(Integer.parseInt(matcher.group(9)), Integer.parseInt(matcher.group(10)));
        }
        catch (Exception e) {
            throw new VersionUnavailableException("Unable to parse JCEF version: " + stringValue, e);
        }
    }

    public String toString() {
        return this.stringValue;
    }

    public static final class VersionUnavailableException
    extends Exception {
        VersionUnavailableException(String message, Throwable cause) {
            super(message, cause);
        }

        VersionUnavailableException(String message) {
            super(message);
        }
    }

    public static final class CefVersion {
        public final int major;
        public final int api;
        public final int patch;
        public final String commitHash;

        CefVersion(int major, int api, int patch, String commitHash) {
            this.major = major;
            this.api = api;
            this.patch = patch;
            this.commitHash = commitHash;
        }
    }

    public static final class ChromiumVersion {
        public final int major;
        public final int minor;
        public final int build;
        public final int patch;

        ChromiumVersion(int major, int minor, int build, int patch) {
            this.major = major;
            this.minor = minor;
            this.build = build;
            this.patch = patch;
        }
    }

    public static final class ApiVersion {
        public final int major;
        public final int minor;

        ApiVersion(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public boolean isCompatible(int targetMajor, int targetMinor) {
            return this.major == targetMajor && this.minor >= targetMinor;
        }
    }
}

