/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spaceport.gateway.rd.list;

import circlet.platform.client.ApiService;
import circlet.rd.api.Rd_Workspace;
import circlet.rd.api.impl.RdTroubleshootServiceProxyKt;
import circlet.rd.api.spaceport.RdReportEndpoint;
import circlet.workspaces.Workspace;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.logsUploader.LogPacker;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.spaceport.gateway.messages.SpaceportGatewayBundle;
import com.intellij.spaceport.gateway.rd.SpaceIdeTypeMapping;
import com.intellij.spaceport.gateway.rd.list.SpaceGatewayReport;
import com.intellij.spaceport.utils.SpaceUrls;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.Compressor;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.NetUtils;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.gateway.ssh.util.RemotePathsKt;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.future.FutureKt;
import libraries.coroutines.extra.CoroutineBuildersExtKt;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.Lifetimed;
import libraries.klogging.BaseLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.Property;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005\u0012\n\u0010\b\u001a\u00060\tj\u0002`\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\n \u001e*\u0004\u0018\u00010\u00100\u00102\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/spaceport/gateway/rd/list/SpaceGatewayReport;", "", "lt", "Llibraries/coroutines/extra/Lifetime;", "devEnv", "Lruntime/reactive/Property;", "Lcirclet/rd/api/Rd_Workspace;", "Lcom/intellij/spaceport/gateway/DevEnv;", "space", "Lcirclet/workspaces/Workspace;", "Lcom/intellij/spaceport/gateway/Space;", "parent", "Ljavax/swing/JComponent;", "<init>", "(Llibraries/coroutines/extra/Lifetime;Lruntime/reactive/Property;Lcirclet/workspaces/Workspace;Ljavax/swing/JComponent;)V", "getTimestamp", "", "report", "", "launchBrowser", "timestamp", "reportId", "showErrorDialog", "createFallbackFile", "Ljava/nio/file/Path;", "name", "content", "createLogsArchive", "Ljava/io/File;", "uploadGwLogs", "kotlin.jvm.PlatformType", "archive", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "youtrackUrl", "summary", "description", "intellij.spaceport.gateway"})
@SourceDebugExtension(value={"SMAP\nSpaceGatewayReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceGatewayReport.kt\ncom/intellij/spaceport/gateway/rd/list/SpaceGatewayReport\n+ 2 KLoggers.kt\nlibraries/klogging/KLoggersKt\n*L\n1#1,211:1\n16#2:212\n*S KotlinDebug\n*F\n+ 1 SpaceGatewayReport.kt\ncom/intellij/spaceport/gateway/rd/list/SpaceGatewayReport\n*L\n131#1:212\n*E\n"})
public final class SpaceGatewayReport {
    @NotNull
    private final Lifetime lt;
    @NotNull
    private final Property<Rd_Workspace> devEnv;
    @NotNull
    private final Workspace space;
    @NotNull
    private final JComponent parent;

    public SpaceGatewayReport(@NotNull Lifetime lt, @NotNull Property<Rd_Workspace> devEnv2, @NotNull Workspace space2, @NotNull JComponent parent) {
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        Intrinsics.checkNotNullParameter(devEnv2, (String)"devEnv");
        Intrinsics.checkNotNullParameter((Object)space2, (String)"space");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.lt = lt;
        this.devEnv = devEnv2;
        this.space = space2;
        this.parent = parent;
    }

    private final String getTimestamp() {
        String timezone = System.getProperty("user.timezone");
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone(timezone));
        String string = df.format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public final void report() {
        String timestamp = this.getTimestamp();
        JComponent jComponent = this.parent;
        String string = SpaceportGatewayBundle.INSTANCE.message("rd.list.report.uploading", new Object[0]) + "...";
        new Task.Modal(this, timestamp, jComponent, string){
            final /* synthetic */ SpaceGatewayReport this$0;
            final /* synthetic */ String $timestamp;
            {
                this.this$0 = $receiver;
                this.$timestamp = $timestamp;
                super(null, $super_call_param$1, $super_call_param$2, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(false);
                File file = null;
                try {
                    file = SpaceGatewayReport.access$createLogsArchive(this.this$0);
                    indicator.setFraction(0.25);
                    indicator.checkCanceled();
                    String reportId = SpaceGatewayReport.access$uploadGwLogs(this.this$0, file, indicator);
                    Intrinsics.checkNotNull((Object)reportId);
                    SpaceGatewayReport.access$launchBrowser(this.this$0, this.$timestamp, reportId);
                }
                catch (Throwable e) {
                    report.1 $this$logger$iv = this;
                    boolean $i$f$logger = false;
                    BaseLogger.DefaultImpls.info$default((BaseLogger)((BaseLogger)KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(report.1.class))), (Throwable)e, null, (int)2, null);
                    if (!indicator.isCanceled()) {
                        SpaceGatewayReport.access$showErrorDialog(this.this$0);
                    }
                }
                finally {
                    File file2 = file;
                    if (file2 != null) {
                        file2.delete();
                    }
                }
            }
        }.queue();
    }

    private final void launchBrowser(String timestamp, String reportId) {
        String clientLogsUrl = SpaceUrls.INSTANCE.rdClientTroubleshootLogs(this.space.getServer(), reportId, ((Rd_Workspace)this.devEnv.getValue()).getId());
        String hostLogsUrl = SpaceUrls.INSTANCE.rdHostTroubleshootLogs(this.space.getServer(), reportId, ((Rd_Workspace)this.devEnv.getValue()).getId());
        String ideLogsUrl = SpaceUrls.INSTANCE.rdIdeLogs(this.space.getServer(), ((Rd_Workspace)this.devEnv.getValue()).getId());
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        String description = StringsKt.trimIndent((String)("\n      Date and time: " + timestamp + "\n      CodeCanvas stack url: " + this.space.getServer() + "\n      Dev environment: " + this.space.getServer() + "/all-ns/rd/environment/" + ((Rd_Workspace)this.devEnv.getValue()).getId() + " \n      Client details: " + ((Rd_Workspace)this.devEnv.getValue()).getIdeVersionDetails().getDisplayName() + "\n      Client build: " + ((Rd_Workspace)this.devEnv.getValue()).getIdeVersionDetails().getBuild() + "\n      Gateway build: " + appInfo.getFullVersion() + "\n      Client and Gateway logs: " + clientLogsUrl + "\n      Dev environment host logs: " + hostLogsUrl + "\n      IDE back-end logs: " + ideLogsUrl + "\n    "));
        String summary = "Report for dev environment: " + ((Rd_Workspace)this.devEnv.getValue()).getId();
        BrowserUtil.browse((String)this.youtrackUrl(summary, description));
    }

    private final void showErrorDialog() {
        CoroutineBuildersExtKt.launch$default((Lifetimed)((Lifetimed)this.lt), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SpaceGatewayReport this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = com.intellij.openapi.progress.CoroutinesKt.blockingContext(() -> showErrorDialog.1.invokeSuspend$lambda$0(this.this$0), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(SpaceGatewayReport this$0) {
                MessagesService messagesService = MessagesService.Companion.getInstance();
                JComponent jComponent = SpaceGatewayReport.access$getParent$p(this$0);
                Icon icon = UIUtil.getErrorIcon();
                String string = SpaceportGatewayBundle.INSTANCE.message("rd.list.report.error.title", new Object[0]);
                String string2 = SpaceportGatewayBundle.INSTANCE.message("rd.list.report.error.message", new Object[0]);
                String[] stringArray = new String[]{SpaceportGatewayBundle.INSTANCE.message("rd.list.report.error.close", new Object[0])};
                String[] stringArray2 = stringArray;
                MessagesService.showMessageDialog$default((MessagesService)messagesService, null, (Component)jComponent, (String)string2, (String)string, (String[])stringArray2, (int)0, (int)0, (Icon)icon, null, (boolean)true, null, (int)96, null);
                return Unit.INSTANCE;
            }
        }), (int)6, null);
    }

    private final Path createFallbackFile(String name, String content) {
        Path path = Files.createTempFile(name, ".txt", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
        Path fallbackFile = path;
        try {
            String string = content;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            Files.write(fallbackFile, byArray, new OpenOption[0]);
        }
        catch (Throwable e) {
            SpaceGatewayReport $this$logger$iv = this;
            boolean $i$f$logger = false;
            BaseLogger.DefaultImpls.info$default((BaseLogger)((BaseLogger)KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(SpaceGatewayReport.class))), (Throwable)e, null, (int)2, null);
        }
        return fallbackFile;
    }

    private final File createLogsArchive() {
        Object t = FutureKt.asCompletableFuture((Deferred)CoroutineBuildersExtKt.async$default((Lifetimed)((Lifetimed)this.lt), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super File>, Object>(this, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SpaceGatewayReport this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var16_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        buildNumber = ((Rd_Workspace)SpaceGatewayReport.access$getDevEnv$p(this.this$0).getValue()).getIdeVersionDetails().getBuild();
                        try {
                            v0 = SpaceIdeTypeMapping.Companion.getPlatformProduct(((Rd_Workspace)SpaceGatewayReport.access$getDevEnv$p(this.this$0).getValue()).getIdeType());
                            productCode = v0 != null ? v0.getProductCode() : null;
                            v1 = productCode;
                            Intrinsics.checkNotNull((Object)v1);
                            v2 = BuildNumber.fromStringWithProductCode((String)buildNumber, (String)v1);
                            Intrinsics.checkNotNull((Object)v2);
                            pathString = RemotePathsKt.getDefaultClientLogPath((BuildNumber)v2);
                            productCode = new File(pathString).toPath();
                        }
                        catch (Throwable e) {
                            $this$logger$iv = $this$async;
                            $i$f$logger = false;
                            BaseLogger.DefaultImpls.info$default((BaseLogger)((BaseLogger)KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(CoroutineScope.class))), (Throwable)e, null, (int)2, null);
                            productCode = SpaceGatewayReport.access$createFallbackFile(this.this$0, "JetBrainsClient" + buildNumber, e.toString());
                        }
                        clientLogsPath = productCode;
                        this.L$0 = $this$async;
                        this.L$1 = buildNumber;
                        this.L$2 = clientLogsPath;
                        this.label = 1;
                        v3 = LogPacker.packLogs(null, (Continuation)((Continuation)this));
                        ** if (v3 != var16_3) goto lbl33
lbl32:
                        // 1 sources

                        return var16_3;
lbl33:
                        // 1 sources

                        ** GOTO lbl41
                    }
                    case 1: {
                        clientLogsPath = (Path)this.L$2;
                        buildNumber = (String)this.L$1;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl41:
                            // 2 sources

                            e = (Path)v3;
                        }
                        catch (Throwable e) {
                            $this$logger$iv = $this$async;
                            $i$f$logger = false;
                            BaseLogger.DefaultImpls.info$default((BaseLogger)((BaseLogger)KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(CoroutineScope.class))), (Throwable)e, null, (int)2, null);
                            v4 = ApplicationNamesInfo.getInstance().getProductName();
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getProductName(...)");
                            v5 = v4.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"toLowerCase(...)");
                            e = SpaceGatewayReport.access$createFallbackFile(this.this$0, v5, e.toString());
                        }
                        gwLogsPath = e;
                        fileName = StringsKt.replace$default((String)("client_" + buildNumber + "_" + ((Rd_Workspace)SpaceGatewayReport.access$getDevEnv$p(this.this$0).getValue()).getId() + "_logs"), (String)".", (String)"_", (boolean)false, (int)4, null);
                        logsFile = Files.createTempFile(fileName, ".tar.gz", new FileAttribute[0]).toFile();
                        var8_12 = (Closeable)new Compressor.Tar(logsFile, Compressor.Tar.Compression.GZIP);
                        var9_15 = null;
                        try {
                            output = (Compressor.Tar)var8_12;
                            $i$a$-use-SpaceGatewayReport$createLogsArchive$1$1 = false;
                            output.addDirectory("JetBrainsClient" + buildNumber, (Path)clientLogsPath);
                            v6 = new OpenOption[]{};
                            v7 = Files.newInputStream(gwLogsPath, Arrays.copyOf(v6, v6.length));
                            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"newInputStream(...)");
                            var12_20 = new BufferedInputStream(v7);
                            var13_21 = null;
                            try {
                                inputStream = (BufferedInputStream)var12_20;
                                $i$a$-use-SpaceGatewayReport$createLogsArchive$1$1$1 = false;
                                output.addFile(PathsKt.getName((Path)gwLogsPath), ByteStreamsKt.readBytes((InputStream)inputStream));
                                var14_22 = Unit.INSTANCE;
                            }
                            catch (Throwable var15_24) {
                                var13_21 = var15_24;
                                throw var15_24;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)var12_20, (Throwable)var13_21);
                            }
                            var10_16 = Unit.INSTANCE;
                        }
                        catch (Throwable var11_18) {
                            var9_15 = var11_18;
                            throw var11_18;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var8_12, (Throwable)var9_15);
                        }
                        return logsFile;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super File> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)6, null)).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (File)t;
    }

    private final String uploadGwLogs(File archive, ProgressIndicator progress) {
        return (String)FutureKt.asCompletableFuture((Deferred)CoroutineBuildersExtKt.async$default((Lifetimed)((Lifetimed)this.lt), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this, archive, progress, null){
            int label;
            final /* synthetic */ SpaceGatewayReport this$0;
            final /* synthetic */ File $archive;
            final /* synthetic */ ProgressIndicator $progress;
            {
                this.this$0 = $receiver;
                this.$archive = $archive;
                this.$progress = $progress;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = RdTroubleshootServiceProxyKt.rdTroubleshootService((ApiService)SpaceGatewayReport.access$getSpace$p(this.this$0).getClient().getApi()).initReport(((Rd_Workspace)SpaceGatewayReport.access$getDevEnv$p(this.this$0).getValue()).getId(), (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        uploadEndpoint = (RdReportEndpoint)v0;
                        HttpRequests.put((String)uploadEndpoint.getUploadUrl(), (String)"application/octet-stream").productNameAsUserAgent().tuner((HttpRequests.ConnectionTuner)LambdaMetafactory.metafactory(null, null, null, (Ljava/net/URLConnection;)V, invokeSuspend$lambda$0(circlet.rd.api.spaceport.RdReportEndpoint java.net.URLConnection ), (Ljava/net/URLConnection;)V)((RdReportEndpoint)uploadEndpoint)).connect((HttpRequests.RequestProcessor)LambdaMetafactory.metafactory(null, null, null, (Lcom/intellij/util/io/HttpRequests$Request;)Ljava/lang/Object;, invokeSuspend$lambda$1(java.io.File com.intellij.openapi.progress.ProgressIndicator com.intellij.util.io.HttpRequests$Request ), (Lcom/intellij/util/io/HttpRequests$Request;)Ljava/lang/Long;)((File)this.$archive, (ProgressIndicator)this.$progress));
                        return uploadEndpoint.getReportId();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(RdReportEndpoint $uploadEndpoint, URLConnection it) {
                Iterable $this$forEach$iv = $uploadEndpoint.getHeaders();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    String name = (String)pair.component1();
                    String value = (String)pair.component2();
                    it.addRequestProperty(name, value);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final Long invokeSuspend$lambda$1(File $archive, ProgressIndicator $progress, HttpRequests.Request it) {
                Long l;
                URLConnection uRLConnection = it.getConnection();
                Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                HttpURLConnection http = (HttpURLConnection)uRLConnection;
                http.setFixedLengthStreamingMode($archive.length());
                Closeable closeable = http.getOutputStream();
                Throwable throwable = null;
                try {
                    long l2;
                    OutputStream outputStream = (OutputStream)closeable;
                    boolean bl = false;
                    Closeable closeable2 = new FileInputStream($archive);
                    int n = 65536;
                    closeable2 = closeable2 instanceof BufferedInputStream ? (BufferedInputStream)closeable2 : new BufferedInputStream((InputStream)closeable2, n);
                    Throwable throwable2 = null;
                    try {
                        BufferedInputStream inputStream = (BufferedInputStream)closeable2;
                        boolean bl2 = false;
                        l2 = NetUtils.copyStreamContent((ProgressIndicator)$progress, (InputStream)inputStream, (OutputStream)outputStream, (long)$archive.length());
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    l = l2;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return l;
            }
        }), (int)6, null)).get();
    }

    private final String youtrackUrl(String summary, String description) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"project", (Object)"RDO"), TuplesKt.to((Object)"description", (Object)description), TuplesKt.to((Object)"summary", (Object)summary)};
        Url url = Urls.newFromEncoded((String)"https://youtrack.jetbrains.com/newIssue").addParameters(MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"addParameters(...)");
        Url url2 = url;
        String additionalParams = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object)"Type+Report"), (CharSequence)"", null, null, (int)0, null, SpaceGatewayReport::youtrackUrl$lambda$0, (int)30, null);
        return url2.toExternalForm() + additionalParams;
    }

    private static final CharSequence youtrackUrl$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "&c=" + it;
    }

    public static final /* synthetic */ File access$createLogsArchive(SpaceGatewayReport $this) {
        return $this.createLogsArchive();
    }

    public static final /* synthetic */ String access$uploadGwLogs(SpaceGatewayReport $this, File archive, ProgressIndicator progress) {
        return $this.uploadGwLogs(archive, progress);
    }

    public static final /* synthetic */ void access$launchBrowser(SpaceGatewayReport $this, String timestamp, String reportId) {
        $this.launchBrowser(timestamp, reportId);
    }

    public static final /* synthetic */ void access$showErrorDialog(SpaceGatewayReport $this) {
        $this.showErrorDialog();
    }

    public static final /* synthetic */ JComponent access$getParent$p(SpaceGatewayReport $this) {
        return $this.parent;
    }

    public static final /* synthetic */ Property access$getDevEnv$p(SpaceGatewayReport $this) {
        return $this.devEnv;
    }

    public static final /* synthetic */ Path access$createFallbackFile(SpaceGatewayReport $this, String name, String content) {
        return $this.createFallbackFile(name, content);
    }

    public static final /* synthetic */ Workspace access$getSpace$p(SpaceGatewayReport $this) {
        return $this.space;
    }
}

