/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.platform.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/platform/execution/dashboard/RunDashboardTypePanel;", "Lcom/intellij/ui/components/panels/NonOpaquePanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "value", "Lcom/intellij/execution/configurations/ConfigurationType;", "type", "getType", "()Lcom/intellij/execution/configurations/ConfigurationType;", "setType", "(Lcom/intellij/execution/configurations/ConfigurationType;)V", "nodeStateChanging", "", "checkBox", "Ljavax/swing/JCheckBox;", "applyLink", "Ljavax/swing/JEditorPane;", "hasFolders", "root", "Lcom/intellij/ui/CheckedTreeNode;", "tree", "Lcom/intellij/ui/CheckboxTree;", "treeExpander", "Lcom/intellij/ide/DefaultTreeExpander;", "updateTree", "", "hasTypeWithOppositeExclusion", "selectedTypeId", "", "getTreeExpander", "Lcom/intellij/ide/TreeExpander;", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.platform.execution.dashboard"})
@SourceDebugExtension(value={"SMAP\nRunDashboardTypePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunDashboardTypePanel.kt\ncom/intellij/platform/execution/dashboard/RunDashboardTypePanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,221:1\n1011#2,2:222\n1869#2,2:224\n1869#2,2:226\n1761#2,3:228\n*S KotlinDebug\n*F\n+ 1 RunDashboardTypePanel.kt\ncom/intellij/platform/execution/dashboard/RunDashboardTypePanel\n*L\n196#1:222,2\n197#1:224,2\n198#1:226,2\n210#1:228,3\n*E\n"})
public final class RunDashboardTypePanel
extends NonOpaquePanel
implements UiDataProvider {
    @NotNull
    private final Project project;
    @Nullable
    private ConfigurationType type;
    private boolean nodeStateChanging;
    private JCheckBox checkBox;
    private JEditorPane applyLink;
    private boolean hasFolders;
    @NotNull
    private final CheckedTreeNode root;
    @NotNull
    private final CheckboxTree tree;
    @NotNull
    private final DefaultTreeExpander treeExpander;

    public RunDashboardTypePanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((LayoutManager)new BorderLayout());
        this.project = project;
        this.root = new CheckedTreeNode((Object)"TypeRoot");
        this.tree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(this){
            final /* synthetic */ RunDashboardTypePanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void customizeRenderer(JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super.customizeRenderer(tree2, value, selected, expanded, leaf, row, hasFocus);
                if (value instanceof CheckedTreeNode) {
                    Object userObject = ((CheckedTreeNode)value).getUserObject();
                    if (userObject instanceof RunnerAndConfigurationSettings) {
                        ColoredTreeCellRenderer renderer = this.getTextRenderer();
                        ConfigurationType configurationType = this.this$0.getType();
                        renderer.setIcon(configurationType != null ? configurationType.getIcon() : null);
                        renderer.append(((RunnerAndConfigurationSettings)userObject).getName());
                    } else if (userObject instanceof String) {
                        ColoredTreeCellRenderer renderer = this.getTextRenderer();
                        renderer.setIcon(AllIcons.Nodes.Folder);
                        renderer.append((String)userObject);
                    }
                }
            }
        }, this.root);
        this.treeExpander = new DefaultTreeExpander((JTree)this.tree);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this.project);
        Topic topic = RunManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new RunManagerListener(){
            private boolean updateInProgress;

            public void runConfigurationAdded(RunnerAndConfigurationSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                if (!this.updateInProgress) {
                    this.updateTree(this.getType());
                }
            }

            public void runConfigurationRemoved(RunnerAndConfigurationSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                if (!this.updateInProgress) {
                    this.updateTree(this.getType());
                }
            }

            public void beginUpdate() {
                this.updateInProgress = true;
            }

            public void endUpdate() {
                this.updateInProgress = false;
                this.updateTree(this.getType());
            }
        });
        this.tree.addCheckboxTreeListener(new CheckboxTreeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void nodeStateChanged(CheckedTreeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Object object = node.getUserObject();
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = object instanceof RunnerAndConfigurationSettings ? (RunnerAndConfigurationSettings)object : null;
                if (runnerAndConfigurationSettings == null) {
                    return;
                }
                RunnerAndConfigurationSettings settings = runnerAndConfigurationSettings;
                if (node.getUserObject() instanceof RunnerAndConfigurationSettings) {
                    try {
                        nodeStateChanging = true;
                        if (node.isChecked()) {
                            RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)project);
                            Intrinsics.checkNotNull((Object)runDashboardManager, (String)"null cannot be cast to non-null type com.intellij.platform.execution.dashboard.RunDashboardManagerImpl");
                            ((RunDashboardManagerImpl)runDashboardManager).restoreConfigurations((Collection)new SmartList((Object)settings.getConfiguration()));
                        } else {
                            RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)project);
                            Intrinsics.checkNotNull((Object)runDashboardManager, (String)"null cannot be cast to non-null type com.intellij.platform.execution.dashboard.RunDashboardManagerImpl");
                            ((RunDashboardManagerImpl)runDashboardManager).hideConfigurations((Collection)new SmartList((Object)settings.getConfiguration()));
                        }
                    }
                    finally {
                        nodeStateChanging = false;
                    }
                }
            }
        });
        DialogPanel typePanel = BuilderKt.panel(arg_0 -> RunDashboardTypePanel._init_$lambda$0(this, arg_0));
        typePanel.setBorder((Border)JBUI.Borders.empty((int)1, (int)10));
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)this.tree), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        JScrollPane scrollPane = jScrollPane;
        NonOpaquePanel wrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        wrapper.add((Component)typePanel, (Object)"East");
        wrapper.add((Component)scrollPane, (Object)"Center");
        this.add((Component)wrapper, "Center");
        RunDashboardManagerImpl.setupToolbar((JPanel)((Object)this), (JComponent)wrapper, this.project);
    }

    @Nullable
    public final ConfigurationType getType() {
        return this.type;
    }

    public final void setType(@Nullable ConfigurationType value) {
        this.type = value;
        if (this.nodeStateChanging) {
            return;
        }
        if (value != null) {
            JCheckBox jCheckBox = this.checkBox;
            if (jCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"checkBox");
                jCheckBox = null;
            }
            RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)this.project);
            Intrinsics.checkNotNull((Object)runDashboardManager, (String)"null cannot be cast to non-null type com.intellij.platform.execution.dashboard.RunDashboardManagerImpl");
            jCheckBox.setSelected(!((RunDashboardManagerImpl)runDashboardManager).isNewExcluded(value.getId()));
            JEditorPane jEditorPane = this.applyLink;
            if (jEditorPane == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"applyLink");
                jEditorPane = null;
            }
            String string = value.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            jEditorPane.setEnabled(this.hasTypeWithOppositeExclusion(string));
        }
        this.updateTree(value);
    }

    private final void updateTree(ConfigurationType type) {
        MutableTreeNode p0;
        Iterable $this$forEach$iv;
        if (type == null) {
            this.hasFolders = false;
            this.root.removeAllChildren();
            TreeModel treeModel = this.tree.getModel();
            Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
            ((DefaultTreeModel)treeModel).setRoot((TreeNode)this.root);
            return;
        }
        ArrayList<CheckedTreeNode> children = new ArrayList<CheckedTreeNode>();
        Map map = FactoryMap.create(arg_0 -> RunDashboardTypePanel.updateTree$lambda$1(RunDashboardTypePanel::updateTree$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"create(...)");
        Map folders = map;
        List settingsList = RunManager.Companion.getInstance(this.project).getConfigurationSettingsList(type);
        RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)this.project);
        for (RunnerAndConfigurationSettings settings : settingsList) {
            String folderName;
            CheckedTreeNode node = new CheckedTreeNode((Object)settings);
            if (!runDashboardManager.isShowInDashboard(settings.getConfiguration())) {
                node.setChecked(false);
            }
            if ((folderName = settings.getFolderName()) != null) {
                Object v = folders.get(folderName);
                Intrinsics.checkNotNull(v);
                ((CheckedTreeNode)v).add((MutableTreeNode)node);
                continue;
            }
            children.add(node);
        }
        this.root.removeAllChildren();
        ArrayList folderNodes = new ArrayList(folders.values());
        Iterable $this$sortBy$iv = folderNodes;
        boolean $i$f$sortBy22 = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CheckedTreeNode it = (CheckedTreeNode)a;
                    boolean bl = false;
                    Object object = it.getUserObject();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                    it = (CheckedTreeNode)b;
                    Comparable comparable = (Comparable)((Object)((String)object));
                    bl = false;
                    Object object2 = it.getUserObject();
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)((String)object2))));
                }
            });
        }
        $this$sortBy$iv = folderNodes;
        CheckedTreeNode $i$f$sortBy22 = this.root;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (MutableTreeNode)element$iv;
            boolean bl = false;
            $i$f$sortBy22.add(p0);
        }
        $this$forEach$iv = children;
        $i$f$sortBy22 = this.root;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (MutableTreeNode)element$iv;
            boolean bl = false;
            $i$f$sortBy22.add(p0);
        }
        TreeModel treeModel = this.tree.getModel();
        Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
        ((DefaultTreeModel)treeModel).setRoot((TreeNode)this.root);
        this.hasFolders = !((Collection)folderNodes).isEmpty();
        Iterator iterator = folderNodes.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            CheckedTreeNode folderNode = (CheckedTreeNode)iterator2.next();
            this.tree.expandPath(new TreePath(folderNode.getPath()));
        }
    }

    private final boolean hasTypeWithOppositeExclusion(String selectedTypeId) {
        boolean bl;
        block3: {
            RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)this.project);
            Intrinsics.checkNotNull((Object)runDashboardManager, (String)"null cannot be cast to non-null type com.intellij.platform.execution.dashboard.RunDashboardManagerImpl");
            RunDashboardManagerImpl runDashboardManager2 = (RunDashboardManagerImpl)runDashboardManager;
            boolean newExcluded = runDashboardManager2.isNewExcluded(selectedTypeId);
            Set<String> set = runDashboardManager2.getTypes();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getTypes(...)");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String typeId = (String)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)typeId, (Object)selectedTypeId) && runDashboardManager2.isNewExcluded(typeId) != newExcluded)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public final TreeExpander getTreeExpander() {
        return this.hasFolders ? (TreeExpander)this.treeExpander : null;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = PlatformDataKeys.TREE_EXPANDER_HIDE_ACTIONS_IF_NO_EXPANDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"TREE_EXPANDER_HIDE_ACTIONS_IF_NO_EXPANDER");
        sink.set(dataKey, (Object)true);
        DataKey dataKey2 = PlatformDataKeys.TREE_EXPANDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"TREE_EXPANDER");
        sink.set(dataKey2, (Object)this.getTreeExpander());
    }

    private static final Unit _init_$lambda$0(RunDashboardTypePanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> RunDashboardTypePanel.lambda$0$0(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0(RunDashboardTypePanel this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ExecutionBundle.message((String)"run.dashboard.show.new.configurations", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell it = cell = Cell.comment$default((Cell)$this$row.checkBox(string).applyToComponent(arg_0 -> RunDashboardTypePanel.lambda$0$0$0(this$0, arg_0)), (String)ExecutionBundle.message((String)"run.dashboard.apply.to.all.types", (Object[])new Object[0]), (int)0, arg_0 -> RunDashboardTypePanel.lambda$0$0$1(this$0, arg_0), (int)2, null);
        boolean bl = false;
        JEditorPane jEditorPane = it.getComment();
        Intrinsics.checkNotNull((Object)jEditorPane);
        this$0.applyLink = jEditorPane;
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0$0(RunDashboardTypePanel this$0, JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        this$0.checkBox = (JCheckBox)$this$applyToComponent;
        $this$applyToComponent.addActionListener(arg_0 -> RunDashboardTypePanel.lambda$0$0$0$0(this$0, $this$applyToComponent, arg_0));
        return Unit.INSTANCE;
    }

    private static final void lambda$0$0$0$0(RunDashboardTypePanel this$0, JBCheckBox $this_applyToComponent, ActionEvent actionEvent) {
        ConfigurationType type = this$0.type;
        if (type != null) {
            RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)this$0.project);
            Intrinsics.checkNotNull((Object)runDashboardManager, (String)"null cannot be cast to non-null type com.intellij.platform.execution.dashboard.RunDashboardManagerImpl");
            ((RunDashboardManagerImpl)runDashboardManager).setNewExcluded(type.getId(), !$this_applyToComponent.isSelected());
            JEditorPane jEditorPane = this$0.applyLink;
            if (jEditorPane == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"applyLink");
                jEditorPane = null;
            }
            String string = type.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            jEditorPane.setEnabled(this$0.hasTypeWithOppositeExclusion(string));
        }
    }

    private static final void lambda$0$0$1(RunDashboardTypePanel this$0, HyperlinkEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)this$0.project);
        Intrinsics.checkNotNull((Object)runDashboardManager, (String)"null cannot be cast to non-null type com.intellij.platform.execution.dashboard.RunDashboardManagerImpl");
        RunDashboardManagerImpl manager = (RunDashboardManagerImpl)runDashboardManager;
        JCheckBox jCheckBox = this$0.checkBox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"checkBox");
            jCheckBox = null;
        }
        boolean isChecked = jCheckBox.isSelected();
        for (String typeId : manager.getTypes()) {
            RunDashboardManager runDashboardManager2 = RunDashboardManager.getInstance((Project)this$0.project);
            Intrinsics.checkNotNull((Object)runDashboardManager2, (String)"null cannot be cast to non-null type com.intellij.platform.execution.dashboard.RunDashboardManagerImpl");
            ((RunDashboardManagerImpl)runDashboardManager2).setNewExcluded(typeId, !isChecked);
        }
        ConfigurationType type = this$0.type;
        if (type != null) {
            JEditorPane jEditorPane = this$0.applyLink;
            if (jEditorPane == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"applyLink");
                jEditorPane = null;
            }
            String string = type.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            jEditorPane.setEnabled(this$0.hasTypeWithOppositeExclusion(string));
        }
    }

    private static final CheckedTreeNode updateTree$lambda$0(String it) {
        return new CheckedTreeNode((Object)it);
    }

    private static final CheckedTreeNode updateTree$lambda$1(Function1 $tmp0, Object p0) {
        return (CheckedTreeNode)$tmp0.invoke(p0);
    }
}

