/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.ui.BaseChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\r2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\rH\u0016JF\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\r0\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\r2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DirectoryChangesGroupingPolicy;", "Lcom/intellij/openapi/vcs/changes/ui/BaseChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/tree/DefaultTreeModel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getModel", "()Ljavax/swing/tree/DefaultTreeModel;", "getParentNodeFor", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "nodePath", "Lcom/intellij/openapi/vcs/changes/ui/StaticFilePath;", "node", "subtreeRoot", "getParentNodeRecursive", "pathBuilder", "Ljava/util/function/Function;", "grandParent", "cachingRoot", "Factory", "intellij.platform.vcs.impl.shared"})
@ApiStatus.Internal
public final class DirectoryChangesGroupingPolicy
extends BaseChangesGroupingPolicy {
    @NotNull
    private final Project project;
    @NotNull
    private final DefaultTreeModel model;

    public DirectoryChangesGroupingPolicy(@NotNull Project project, @NotNull DefaultTreeModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.project = project;
        this.model = model;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DefaultTreeModel getModel() {
        return this.model;
    }

    @Override
    @NotNull
    public ChangesBrowserNode<?> getParentNodeFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode<?> node, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        Intrinsics.checkNotNullParameter((Object)nodePath, (String)"nodePath");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter(subtreeRoot, (String)"subtreeRoot");
        ChangesGroupingPolicy changesGroupingPolicy = this.getNextPolicy();
        ChangesBrowserNode<?> nextPolicyGroup = changesGroupingPolicy != null ? changesGroupingPolicy.getParentNodeFor(nodePath, node, subtreeRoot) : null;
        ChangesBrowserNode<?> changesBrowserNode = nextPolicyGroup;
        if (changesBrowserNode == null) {
            changesBrowserNode = subtreeRoot;
        }
        ChangesBrowserNode<?> grandParent = changesBrowserNode;
        ChangesBrowserNode<?> cachingRoot = BaseChangesGroupingPolicy.Companion.getCachingRoot(grandParent, subtreeRoot);
        Object object = TreeModelBuilder.PATH_NODE_BUILDER.getRequired((UserDataHolder)subtreeRoot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRequired(...)");
        Function pathBuilder = (Function)object;
        return this.getParentNodeRecursive(nodePath, pathBuilder, grandParent, cachingRoot);
    }

    private final ChangesBrowserNode<?> getParentNodeRecursive(StaticFilePath nodePath, Function<StaticFilePath, ChangesBrowserNode<?>> pathBuilder, ChangesBrowserNode<?> grandParent, ChangesBrowserNode<?> cachingRoot) {
        ChangesBrowserNode cachedParent = null;
        List nodes = new ArrayList();
        StaticFilePath parentPath = nodePath;
        while (parentPath.getParent() != null && (cachedParent = (ChangesBrowserNode)((Map)TreeModelBuilder.DIRECTORY_CACHE.getValue((UserDataHolder)cachingRoot)).get(parentPath.getKey())) == null) {
            ChangesBrowserNode<?> pathNode = pathBuilder.apply(parentPath);
            if (pathNode == null) continue;
            pathNode.markAsHelperNode();
            Object object = TreeModelBuilder.DIRECTORY_CACHE.getValue((UserDataHolder)cachingRoot);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            Map map2 = (Map)object;
            String string = parentPath.getKey();
            ChangesBrowserNode<?> changesBrowserNode = pathNode;
            map2.put(string, changesBrowserNode);
            nodes.add(pathNode);
        }
        ChangesBrowserNode changesBrowserNode = cachedParent;
        if (changesBrowserNode == null) {
            changesBrowserNode = grandParent;
        }
        ChangesBrowserNode node = changesBrowserNode;
        for (ChangesBrowserNode nextNode : CollectionsKt.asReversedMutable((List)nodes)) {
            this.model.insertNodeInto(nextNode, node, node.getChildCount());
            node = nextNode;
        }
        return node;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DirectoryChangesGroupingPolicy$Factory;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "<init>", "()V", "createGroupingPolicy", "Lcom/intellij/openapi/vcs/changes/ui/DirectoryChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "intellij.platform.vcs.impl.shared"})
    public static final class Factory
    extends ChangesGroupingPolicyFactory {
        @Override
        @NotNull
        public DirectoryChangesGroupingPolicy createGroupingPolicy(@NotNull Project project, @NotNull DefaultTreeModel model) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return new DirectoryChangesGroupingPolicy(project, model);
        }
    }
}

