/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInsight.intention.EventTrackingIntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNamedElementWithCustomPresentation;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.statistics.SpellcheckerActionStatistics;
import com.intellij.spellchecker.statistics.SpellcheckerRateTracker;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import icons.SpellcheckerIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameTo
extends PsiUpdateModCommandQuickFix
implements Iconable,
EventTrackingIntentionAction {
    private final String typo;
    private final TextRange range;
    private final SmartPsiElementPointer<PsiElement> pointer;
    private final SpellcheckerRateTracker tracker;
    private final List<String> suggestions = new ArrayList<String>();

    public RenameTo(String typo, TextRange range, PsiElement psi, SpellcheckerRateTracker tracker) {
        this.typo = typo;
        this.range = range;
        this.pointer = SmartPointerManager.getInstance((Project)psi.getProject()).createSmartPsiElementPointer(psi, psi.getContainingFile());
        this.tracker = tracker;
    }

    @NotNull
    public String getFamilyName() {
        String string = RenameTo.getFixName();
        if (string == null) {
            RenameTo.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement psiElement, @NotNull ModPsiUpdater updater) {
        Pair<PsiNamedElement, String> name;
        if (project == null) {
            RenameTo.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            RenameTo.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            RenameTo.$$$reportNull$$$0(3);
        }
        if ((name = RenameTo.getPresentationName(psiElement)) == null) {
            return;
        }
        this.generateSuggestions((String)name.second, psiElement);
        updater.rename((PsiNamedElement)name.first, psiElement, this.suggestions);
        if (!IntentionPreviewUtils.isIntentionPreviewActive()) {
            SpellcheckerActionStatistics.renameToPerformed(this.tracker, this.suggestions.size());
        }
    }

    public void suggestionShown(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            RenameTo.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            RenameTo.$$$reportNull$$$0(5);
        }
        if (psiFile == null) {
            RenameTo.$$$reportNull$$$0(6);
        }
        if (this.tracker.markShown()) {
            SpellcheckerActionStatistics.suggestionShown(this.tracker);
        }
    }

    @Nls
    public static String getFixName() {
        return SpellCheckerBundle.message("rename.to", new Object[0]);
    }

    public Icon getIcon(int flags) {
        return SpellcheckerIcons.Spellcheck;
    }

    @Nullable
    private static Pair<PsiNamedElement, String> getPresentationName(PsiElement element) {
        String name;
        PsiNamedElement namedElement = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiNamedElement.class});
        if (namedElement == null) {
            return null;
        }
        if (namedElement instanceof PsiNamedElementWithCustomPresentation) {
            PsiNamedElementWithCustomPresentation custom = (PsiNamedElementWithCustomPresentation)namedElement;
            v0 = custom.getPresentationName();
        } else {
            v0 = name = namedElement.getName();
        }
        if (name == null) {
            return null;
        }
        return new Pair((Object)namedElement, (Object)name);
    }

    private void generateSuggestions(String name, PsiElement element) {
        if (this.suggestions.isEmpty()) {
            TextRange range = this.range.shiftLeft(element.getText().indexOf(name));
            SpellCheckerManager.getInstance(this.pointer.getProject()).getSuggestions(this.typo).stream().map(suggestion -> range.replace(name, suggestion)).filter(suggestion -> RenameUtil.isValidName((Project)element.getProject(), (PsiElement)element, (String)suggestion)).forEach(this.suggestions::add);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/quickfixes/RenameTo";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/quickfixes/RenameTo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "suggestionShown";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

