/*
 * Decompiled with CFR 0.152.
 */
package runtime.container;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.container.ChildFirstURLClassLoader;
import runtime.container.PluginDescriptor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00062\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR4\u0010\u000f\u001a&\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\n0\n \u0011*\u0012\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\n0\n\u0018\u00010\u00120\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lruntime/container/ChildFirstURLClassLoader;", "Ljava/net/URLClassLoader;", "name", "", "urls", "", "Ljava/net/URL;", "plugin", "Lruntime/container/PluginDescriptor;", "parent", "Ljava/lang/ClassLoader;", "<init>", "(Ljava/lang/String;[Ljava/net/URL;Lruntime/container/PluginDescriptor;Ljava/lang/ClassLoader;)V", "getPlugin", "()Lruntime/container/PluginDescriptor;", "myExtraParents", "", "kotlin.jvm.PlatformType", "", "Ljava/util/Set;", "title", "getResource", "loadClass", "Ljava/lang/Class;", "resolve", "", "getPermissions", "Ljava/security/PermissionCollection;", "codesource", "Ljava/security/CodeSource;", "toString", "Companion", "platform-runtime"})
public final class ChildFirstURLClassLoader
extends URLClassLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginDescriptor plugin;
    private final Set<ClassLoader> myExtraParents;
    @NotNull
    private final String title;
    @NotNull
    private static final PermissionCollection allPermissions = new PermissionCollection(){
        private final long serialVersionUID;
        private Permission allPermission;
        {
            this.serialVersionUID = 482874725021998286L;
            this.allPermission = new AllPermission();
        }

        public final Permission getAllPermission() {
            return this.allPermission;
        }

        public final void setAllPermission(Permission permission) {
            Intrinsics.checkNotNullParameter((Object)permission, (String)"<set-?>");
            this.allPermission = permission;
        }

        public void add(Permission permission) {
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        }

        public boolean implies(Permission permission) {
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
            return true;
        }

        public Enumeration<Permission> elements() {
            return new Enumeration<Permission>(this){
                private int cur;
                final /* synthetic */ Companion.allPermissions.1 this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean hasMoreElements() {
                    return this.cur < 1;
                }

                public Permission nextElement() {
                    if (this.cur == 0) {
                        this.cur = 1;
                        return this.this$0.getAllPermission();
                    }
                    throw new NoSuchElementException();
                }
            };
        }
    };
    @NotNull
    private static final ClassLoader ourSystemClassloader;

    public ChildFirstURLClassLoader(@NotNull String name, @NotNull URL[] urls, @NotNull PluginDescriptor plugin, @NotNull ClassLoader parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(urls, parent);
        this.plugin = plugin;
        this.myExtraParents = Collections.newSetFromMap(new IdentityHashMap());
        this.title = name;
    }

    @NotNull
    public final PluginDescriptor getPlugin() {
        return this.plugin;
    }

    @Override
    @Nullable
    public URL getResource(@Nullable String name) {
        ClassLoader parent;
        URL resource = this.findResource(name);
        if (resource != null) {
            return resource;
        }
        if (name != null && StringsKt.startsWith$default((String)name, (String)"/", (boolean)false, (int)2, null)) {
            String string = name.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            resource = this.findResource(string);
            if (resource != null) {
                return resource;
            }
        }
        if ((parent = this.getParent()) != null && (resource = parent.getResource(name)) != null) {
            return resource;
        }
        for (ClassLoader extraParent : this.myExtraParents) {
            resource = extraParent.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    @Nullable
    public synchronized Class<?> loadClass(@NotNull String name, boolean resolve2) throws ClassNotFoundException {
        ClassLoader parent;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Class<?> clazz = null;
        try {
            clazz = ourSystemClassloader.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = this.findLoadedClass(name);
        }
        if (clazz == null) {
            try {
                clazz = this.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null && (parent = this.getParent()) != null) {
            try {
                clazz = parent.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            for (ClassLoader extraParent : this.myExtraParents) {
                try {
                    clazz = extraParent.loadClass(name);
                    if (clazz == null) continue;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        if (clazz == null) {
            clazz = ClassLoader.getSystemClassLoader().loadClass(name);
        }
        if (resolve2) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    @NotNull
    public PermissionCollection getPermissions(@NotNull CodeSource codesource) {
        Intrinsics.checkNotNullParameter((Object)codesource, (String)"codesource");
        return allPermissions;
    }

    @NotNull
    public String toString() {
        return "ChildFirstURLClassLoader{" + this.title + "}";
    }

    static {
        if (allPermissions.elements() == null) {
            throw new IllegalStateException();
        }
        ourSystemClassloader = new URLClassLoader(new URL[0], null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lruntime/container/ChildFirstURLClassLoader$Companion;", "", "<init>", "()V", "allPermissions", "Ljava/security/PermissionCollection;", "ourSystemClassloader", "Ljava/lang/ClassLoader;", "getOurSystemClassloader", "()Ljava/lang/ClassLoader;", "platform-runtime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClassLoader getOurSystemClassloader() {
            return ourSystemClassloader;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

