/*
 * Decompiled with CFR 0.152.
 */
package runtime.text;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import runtime.text.ReplacementBuilder;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\u001a\u0084\u0001\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u001d\u0010\u0006\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0002\b\t2\u0006\u0010\n\u001a\u0002H\u00022\u001d\u0010\u000b\u001a\u0019\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\u0002\b\t2\u001d\u0010\r\u001a\u0019\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\u000e\u001a{\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u00030\u00102\u0006\u0010\n\u001a\u0002H\u00022\u001d\u0010\u000b\u001a\u0019\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\u0002\b\t2\u001d\u0010\r\u001a\u0019\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\u0002\b\tH\u0002\u00a2\u0006\u0002\u0010\u0011\u001a)\u0010\u0000\u001a\u00020\u0005*\u00020\u00052\u001d\u0010\n\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0002\b\t\u001a;\u0010\u0000\u001a\u00020\u0005*\u00020\u00052*\u0010\u000f\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00130\u0012\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0013\u00a2\u0006\u0002\u0010\u0014\u001a\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0017"}, d2={"formatTemplate", "", "TBuilder", "TReplacement", "template", "", "replacementBuilder", "Lkotlin/Function1;", "Lruntime/text/ReplacementBuilder;", "Lkotlin/ExtensionFunctionType;", "builder", "addReplacement", "Lkotlin/Function2;", "addPart", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "replacements", "", "(Ljava/lang/String;Ljava/util/Map;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "", "Lkotlin/Pair;", "(Ljava/lang/String;[Lkotlin/Pair;)Ljava/lang/String;", "getTemplateParts", "", "platform-runtime"})
public final class StringTemplateKt {
    public static final <TBuilder, TReplacement> void formatTemplate(@NotNull String template, @NotNull Function1<? super ReplacementBuilder<TReplacement>, Unit> replacementBuilder, TBuilder builder, @NotNull Function2<? super TBuilder, ? super TReplacement, Unit> addReplacement, @NotNull Function2<? super TBuilder, ? super String, Unit> addPart) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter(replacementBuilder, (String)"replacementBuilder");
        Intrinsics.checkNotNullParameter(addReplacement, (String)"addReplacement");
        Intrinsics.checkNotNullParameter(addPart, (String)"addPart");
        ReplacementBuilder replacementBuilder2 = new ReplacementBuilder();
        replacementBuilder.invoke(replacementBuilder2);
        StringTemplateKt.formatTemplate(template, replacementBuilder2.getReplacements(), builder, addReplacement, addPart);
    }

    private static final <TBuilder, TReplacement> void formatTemplate(String template, Map<String, ? extends TReplacement> replacements, TBuilder builder, Function2<? super TBuilder, ? super TReplacement, Unit> addReplacement, Function2<? super TBuilder, ? super String, Unit> addPart) {
        List<String> parts = StringTemplateKt.getTemplateParts(template);
        for (String part : parts) {
            if (StringsKt.startsWith$default((String)part, (String)"{", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)part, (String)"}", (boolean)false, (int)2, null)) {
                String key = StringsKt.dropLast((String)StringsKt.drop((String)part, (int)1), (int)1);
                TReplacement replacement = replacements.get(key);
                if (replacement != null) {
                    addReplacement.invoke(builder, replacement);
                    continue;
                }
                addPart.invoke(builder, (Object)part);
                continue;
            }
            addPart.invoke(builder, (Object)part);
        }
    }

    @NotNull
    public static final String formatTemplate(@NotNull String $this$formatTemplate, @NotNull Function1<? super ReplacementBuilder<String>, Unit> builder) {
        Intrinsics.checkNotNullParameter((Object)$this$formatTemplate, (String)"<this>");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        StringBuilder resultBuilder = new StringBuilder();
        StringTemplateKt.formatTemplate($this$formatTemplate, builder, resultBuilder, StringTemplateKt::formatTemplate$lambda$0, StringTemplateKt::formatTemplate$lambda$1);
        String string = resultBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String formatTemplate(@NotNull String $this$formatTemplate, Pair<String, String> ... replacements) {
        Intrinsics.checkNotNullParameter((Object)$this$formatTemplate, (String)"<this>");
        Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
        StringBuilder resultBuilder = new StringBuilder();
        StringTemplateKt.formatTemplate($this$formatTemplate, MapsKt.toMap(replacements), resultBuilder, StringTemplateKt::formatTemplate$lambda$2, StringTemplateKt::formatTemplate$lambda$3);
        String string = resultBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final List<String> getTemplateParts(String template) {
        List parts = new ArrayList();
        StringBuilder currentPartBuilder = new StringBuilder();
        int n = template.length();
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder;
            char c = template.charAt(i);
            char c2 = c;
            if (c2 == '{') {
                String string = currentPartBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                parts.add(string);
                StringsKt.clear((StringBuilder)currentPartBuilder);
                stringBuilder = currentPartBuilder.append(c);
                continue;
            }
            if (c2 == '}') {
                currentPartBuilder.append(c);
                String string = currentPartBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                parts.add(string);
                stringBuilder = StringsKt.clear((StringBuilder)currentPartBuilder);
                continue;
            }
            stringBuilder = currentPartBuilder.append(c);
        }
        if (((CharSequence)currentPartBuilder).length() > 0) {
            String string = currentPartBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            parts.add(string);
        }
        return parts;
    }

    private static final Unit formatTemplate$lambda$0(StringBuilder $this$formatTemplate, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$formatTemplate, (String)"$this$formatTemplate");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$formatTemplate.append(it);
        return Unit.INSTANCE;
    }

    private static final Unit formatTemplate$lambda$1(StringBuilder $this$formatTemplate, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$formatTemplate, (String)"$this$formatTemplate");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$formatTemplate.append(it);
        return Unit.INSTANCE;
    }

    private static final Unit formatTemplate$lambda$2(StringBuilder $this$formatTemplate, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$formatTemplate, (String)"$this$formatTemplate");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$formatTemplate.append(it);
        return Unit.INSTANCE;
    }

    private static final Unit formatTemplate$lambda$3(StringBuilder $this$formatTemplate, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$formatTemplate, (String)"$this$formatTemplate");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$formatTemplate.append(it);
        return Unit.INSTANCE;
    }
}

