/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.vcs.log.data.RefreshRequest;
import com.intellij.vcs.log.data.VcsLogRefresherImpl;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\u001a-\u0010\n\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\u000b0\u000fH\u0082\b\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\u00110\u0012H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\u0013"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "smallDataPackCommitsCount", "", "getSmallDataPackCommitsCount", "()I", "isSmallDataPackEnabled", "", "()Z", "receiveAll", "", "T", "Lkotlinx/coroutines/channels/Channel;", "consumer", "Lkotlin/Function1;", "fold", "Lcom/intellij/vcs/log/data/RefreshRequest;", "", "intellij.platform.vcs.log.impl"})
public final class VcsLogRefresherImplKt {
    @NotNull
    private static final Logger LOG;

    private static final int getSmallDataPackCommitsCount() {
        return Registry.Companion.intValue("vcs.log.small.data.pack.commits.count");
    }

    private static final boolean isSmallDataPackEnabled() {
        return VcsLogRefresherImplKt.getSmallDataPackCommitsCount() > 0 && !ApplicationManager.getApplication().isUnitTestMode();
    }

    private static final <T> void receiveAll(Channel<T> $this$receiveAll, Function1<? super T, Unit> consumer) {
        boolean $i$f$receiveAll = false;
        Object nextItem = null;
        do {
            if ((nextItem = ChannelResult.getOrNull-impl((Object)$this$receiveAll.tryReceive-PtdJZtk())) == null) continue;
            consumer.invoke(nextItem);
        } while (nextItem != null);
    }

    private static final RefreshRequest fold(List<? extends RefreshRequest> $this$fold) {
        Set roots = new LinkedHashSet();
        boolean optimize = false;
        List<? extends RefreshRequest> list = $this$fold;
        for (RefreshRequest refreshRequest : list) {
            RefreshRequest refreshRequest2 = refreshRequest;
            if (refreshRequest2 instanceof RefreshRequest.RefreshRoots) {
                roots.addAll((Collection)((RefreshRequest.RefreshRoots)refreshRequest).getRootsToRefresh());
                optimize = optimize || ((RefreshRequest.RefreshRoots)refreshRequest).getOptimize();
                continue;
            }
            if (Intrinsics.areEqual((Object)refreshRequest2, (Object)RefreshRequest.ReloadAll.INSTANCE)) {
                return RefreshRequest.ReloadAll.INSTANCE;
            }
            throw new NoWhenBranchMatchedException();
        }
        return new RefreshRequest.RefreshRoots(roots, optimize);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ boolean access$isSmallDataPackEnabled() {
        return VcsLogRefresherImplKt.isSmallDataPackEnabled();
    }

    public static final /* synthetic */ int access$getSmallDataPackCommitsCount() {
        return VcsLogRefresherImplKt.getSmallDataPackCommitsCount();
    }

    public static final /* synthetic */ RefreshRequest access$fold(List $receiver) {
        return VcsLogRefresherImplKt.fold($receiver);
    }

    static {
        Logger logger = Logger.getInstance(VcsLogRefresherImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

