/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.PhmVcsLogStorageBackend;
import com.intellij.vcs.log.data.index.VcsLogStorageBackend;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.impl.VcsRefImpl;
import com.intellij.vcs.log.util.StorageId;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class VcsLogStorageImpl
implements Disposable,
VcsLogStorage {
    @NotNull
    private static final Logger LOG = Logger.getInstance(VcsLogStorage.class);
    @NotNull
    @NonNls
    private static final String HASHES_STORAGE = "hashes";
    @NotNull
    @NonNls
    private static final String REFS_STORAGE = "refs";
    @NotNull
    @NonNls
    private static final String STORAGE = "storage";
    @NotNull
    private static final String STORAGE_CLOSED_MESSAGE = "Storage is closed";
    public static final int VERSION = 8;
    public static final int NO_INDEX = -1;
    private static final int REFS_VERSION = 2;
    @NotNull
    private final StorageId.Directory myHashesStorageId;
    @NotNull
    private final StorageId.Directory myRefsStorageId;
    @Nullable
    private MyPersistentBTreeEnumerator myCommitIdEnumerator;
    @Nullable
    private PersistentEnumerator<VcsRef> myRefsEnumerator;
    @NotNull
    private final VcsLogErrorHandler myErrorHandler;
    private volatile boolean myDisposed;

    private VcsLogStorageImpl(@NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull StorageId.Directory hashesStorageId, @NotNull StorageId.Directory refsStorageId, @NotNull VcsLogErrorHandler errorHandler, @NotNull Disposable parent) throws IOException {
        if (logProviders == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(0);
        }
        if (hashesStorageId == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(1);
        }
        if (refsStorageId == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(2);
        }
        if (errorHandler == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(4);
        }
        this.myDisposed = false;
        this.myErrorHandler = errorHandler;
        Disposer.register((Disposable)parent, (Disposable)this);
        try {
            PersistentEnumerator refsEnumerator;
            MyPersistentBTreeEnumerator commitIdEnumerator;
            StorageLockContext storageLockContext = new StorageLockContext();
            List<VirtualFile> roots = logProviders.keySet().stream().sorted(Comparator.comparing(VirtualFile::getPath)).toList();
            MyCommitIdKeyDescriptor commitIdKeyDescriptor = new MyCommitIdKeyDescriptor(roots);
            this.myHashesStorageId = hashesStorageId;
            this.myCommitIdEnumerator = commitIdEnumerator = new MyPersistentBTreeEnumerator(this.myHashesStorageId, commitIdKeyDescriptor, storageLockContext);
            Disposer.register((Disposable)this, () -> {
                try {
                    commitIdEnumerator.close();
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            });
            VcsRefKeyDescriptor refsKeyDescriptor = new VcsRefKeyDescriptor(logProviders, commitIdKeyDescriptor);
            this.myRefsStorageId = refsStorageId;
            this.myRefsEnumerator = refsEnumerator = new PersistentEnumerator(this.myRefsStorageId.getStorageFile(STORAGE), (KeyDescriptor)refsKeyDescriptor, AbstractStorage.PAGE_SIZE, storageLockContext, this.myRefsStorageId.getVersion());
            Disposer.register((Disposable)this, () -> {
                try {
                    refsEnumerator.close();
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            });
            Disposer.register((Disposable)this, () -> {
                this.myDisposed = true;
            });
        }
        catch (Throwable t) {
            this.myDisposed = true;
            Disposer.dispose((Disposable)this);
            throw t;
        }
    }

    @Nullable
    private CommitId doGetCommitId(int index) throws IOException {
        if (this.myCommitIdEnumerator == null) {
            throw new IllegalStateException(STORAGE_CLOSED_MESSAGE);
        }
        return (CommitId)this.myCommitIdEnumerator.valueOf(index);
    }

    private int getOrPut(@NotNull Hash hash, @NotNull VirtualFile root) throws IOException {
        if (hash == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(5);
        }
        if (root == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(6);
        }
        if (this.myCommitIdEnumerator == null) {
            throw new IllegalStateException(STORAGE_CLOSED_MESSAGE);
        }
        return this.myCommitIdEnumerator.enumerate(new CommitId(hash, root));
    }

    @Override
    public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(7);
        }
        if (root == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(8);
        }
        this.checkDisposed();
        try {
            return this.getOrPut(hash, root);
        }
        catch (IOException e) {
            this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Storage, e);
            return -1;
        }
    }

    @Override
    @Nullable
    public CommitId getCommitId(int commitIndex) {
        this.checkDisposed();
        try {
            CommitId commitId = this.doGetCommitId(commitIndex);
            if (commitId == null) {
                this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Storage, new RuntimeException("Unknown commit index: " + commitIndex));
            }
            return commitId;
        }
        catch (IOException e) {
            this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Storage, e);
            return null;
        }
    }

    @Override
    public boolean containsCommit(@NotNull CommitId id) {
        if (id == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(9);
        }
        this.checkDisposed();
        if (this.myCommitIdEnumerator == null) {
            throw new IllegalStateException(STORAGE_CLOSED_MESSAGE);
        }
        try {
            return this.myCommitIdEnumerator.contains(id);
        }
        catch (IOException e) {
            this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Storage, e);
            return false;
        }
    }

    @Override
    public void iterateCommits(final @NotNull Predicate<? super CommitId> consumer) {
        if (consumer == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(10);
        }
        this.checkDisposed();
        if (this.myCommitIdEnumerator == null) {
            throw new IllegalStateException(STORAGE_CLOSED_MESSAGE);
        }
        try {
            this.myCommitIdEnumerator.iterateData((Processor)new CommonProcessors.FindProcessor<CommitId>(this){

                protected boolean accept(CommitId commitId) {
                    return !consumer.test(commitId);
                }
            });
        }
        catch (IOException e) {
            this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Storage, e);
        }
    }

    @Override
    public int getRefIndex(@NotNull VcsRef ref) {
        if (ref == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(11);
        }
        this.checkDisposed();
        if (this.myRefsEnumerator == null) {
            throw new IllegalStateException(STORAGE_CLOSED_MESSAGE);
        }
        try {
            return this.myRefsEnumerator.enumerate((Object)ref);
        }
        catch (IOException e) {
            this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Storage, e);
            return -1;
        }
    }

    @Override
    @Nullable
    public VcsRef getVcsRef(int refIndex) {
        this.checkDisposed();
        if (this.myRefsEnumerator == null) {
            throw new IllegalStateException(STORAGE_CLOSED_MESSAGE);
        }
        try {
            return (VcsRef)this.myRefsEnumerator.valueOf(refIndex);
        }
        catch (IOException e) {
            this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Storage, e);
            return null;
        }
    }

    @Override
    public void flush() {
        this.checkDisposed();
        if (this.myCommitIdEnumerator == null) {
            throw new IllegalStateException(STORAGE_CLOSED_MESSAGE);
        }
        this.myCommitIdEnumerator.force();
        if (this.myRefsEnumerator == null) {
            throw new IllegalStateException(STORAGE_CLOSED_MESSAGE);
        }
        this.myRefsEnumerator.force();
    }

    @NotNull
    public StorageId getHashesStorageId() {
        StorageId.Directory directory = this.myHashesStorageId;
        if (directory == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(12);
        }
        return directory;
    }

    @NotNull
    public StorageId getRefsStorageId() {
        StorageId.Directory directory = this.myRefsStorageId;
        if (directory == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(13);
        }
        return directory;
    }

    private void checkDisposed() {
        if (this.myDisposed) {
            throw new ProcessCanceledException();
        }
    }

    @ApiStatus.Internal
    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void dispose() {
        this.myCommitIdEnumerator = null;
        this.myRefsEnumerator = null;
    }

    public static @NotNull Pair<VcsLogStorage, @Nullable VcsLogStorageBackend> createStorageAndIndexBackend(@NotNull Project project, @NotNull String logId, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull Set<VirtualFile> indexingRoots, @NotNull VcsLogErrorHandler errorHandler, @NotNull Disposable parent) throws IOException {
        if (project == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(14);
        }
        if (logId == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(15);
        }
        if (logProviders == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(16);
        }
        if (indexingRoots == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(17);
        }
        if (errorHandler == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(18);
        }
        if (parent == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(19);
        }
        StorageId.Directory hashesStorageId = new StorageId.Directory(project.getName(), HASHES_STORAGE, logId, 8);
        StorageId.Directory refsStorageId = new StorageId.Directory(project.getName(), REFS_STORAGE, logId, 10);
        StorageId.Directory indexStorageId = PhmVcsLogStorageBackend.getIndexStorageId(project, logId);
        List<StorageId.Directory> storageIds = List.of(hashesStorageId, refsStorageId, indexStorageId);
        Pair pair = (Pair)IOUtil.openCleanOrResetBroken(() -> {
            VcsLogStorageImpl storage = new VcsLogStorageImpl(logProviders, hashesStorageId, refsStorageId, errorHandler, parent);
            if (indexingRoots.isEmpty()) {
                return new Pair((Object)storage, null);
            }
            try {
                PhmVcsLogStorageBackend indexBackend = PhmVcsLogStorageBackend.create(project, storage, indexStorageId, indexingRoots, errorHandler, parent);
                return new Pair((Object)storage, (Object)indexBackend);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error("Could not create index storage backend", e);
                return new Pair((Object)storage, null);
            }
        }, () -> VcsLogStorageImpl.cleanupStorageFiles(storageIds));
        if (pair == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(20);
        }
        return pair;
    }

    @RequiresBackgroundThread
    static void cleanupStorageFiles(@NotNull Collection<? extends StorageId> storageIds) {
        if (storageIds == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(21);
        }
        ThreadingAssertions.assertBackgroundThread();
        for (StorageId storageId : storageIds) {
            try {
                boolean deleted = storageId.cleanupAllStorageFiles();
                if (deleted) {
                    LOG.info("Deleted storage files in " + String.valueOf(storageId.getStoragePath()));
                    continue;
                }
                LOG.error("Could not clean up storage files in " + String.valueOf(storageId.getStoragePath()));
            }
            catch (Exception e) {
                LOG.error("Could not clean up storage files in " + String.valueOf(storageId.getStoragePath()), (Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashesStorageId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refsStorageId";
                break;
            }
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/VcsLogStorageImpl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexingRoots";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/VcsLogStorageImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getHashesStorageId";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefsStorageId";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createStorageAndIndexBackend";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrPut";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCommitIndex";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsCommit";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "iterateCommits";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRefIndex";
                break;
            }
            case 12: 
            case 13: 
            case 20: {
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createStorageAndIndexBackend";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "cleanupStorageFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13, 20 -> new IllegalStateException(string);
        };
    }

    private static class MyCommitIdKeyDescriptor
    implements KeyDescriptor<CommitId> {
        @NotNull
        private final List<? extends VirtualFile> myRoots;
        @NotNull
        private final Object2IntMap<VirtualFile> myRootsReversed;

        MyCommitIdKeyDescriptor(@NotNull List<? extends VirtualFile> roots) {
            if (roots == null) {
                MyCommitIdKeyDescriptor.$$$reportNull$$$0(0);
            }
            this.myRoots = roots;
            this.myRootsReversed = new Object2IntOpenHashMap();
            for (int i = 0; i < roots.size(); ++i) {
                this.myRootsReversed.put((Object)roots.get(i), i);
            }
        }

        public void save(@NotNull DataOutput out, CommitId value) throws IOException {
            if (out == null) {
                MyCommitIdKeyDescriptor.$$$reportNull$$$0(1);
            }
            ((HashImpl)value.getHash()).write(out);
            out.writeInt(this.myRootsReversed.getInt((Object)value.getRoot()));
        }

        public CommitId read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MyCommitIdKeyDescriptor.$$$reportNull$$$0(2);
            }
            Hash hash = HashImpl.read(in);
            VirtualFile root = this.myRoots.get(in.readInt());
            if (root == null) {
                return null;
            }
            return new CommitId(hash, root);
        }

        public int getHashCode(CommitId value) {
            int result = value.getHash().hashCode();
            result = 31 * result + this.myRootsReversed.getInt((Object)value);
            return result;
        }

        public boolean isEqual(@Nullable CommitId val1, @Nullable CommitId val2) {
            if (val1 == val2) {
                return true;
            }
            if (val1 == null || val2 == null) {
                return false;
            }
            return val1.getHash().equals((Object)val2.getHash()) && this.myRootsReversed.getInt((Object)val1.getRoot()) == this.myRootsReversed.getInt((Object)val2.getRoot());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/VcsLogStorageImpl$MyCommitIdKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyPersistentBTreeEnumerator
    extends PersistentBTreeEnumerator<CommitId> {
        MyPersistentBTreeEnumerator(@NotNull StorageId.Directory storageId, @NotNull KeyDescriptor<CommitId> commitIdKeyDescriptor, @Nullable StorageLockContext storageLockContext) throws IOException {
            if (storageId == null) {
                MyPersistentBTreeEnumerator.$$$reportNull$$$0(0);
            }
            if (commitIdKeyDescriptor == null) {
                MyPersistentBTreeEnumerator.$$$reportNull$$$0(1);
            }
            super(storageId.getStorageFile(VcsLogStorageImpl.STORAGE), commitIdKeyDescriptor, AbstractStorage.PAGE_SIZE, storageLockContext, storageId.getVersion());
        }

        public boolean contains(@NotNull CommitId id) throws IOException {
            if (id == null) {
                MyPersistentBTreeEnumerator.$$$reportNull$$$0(2);
            }
            return this.tryEnumerate(id) != 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storageId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitIdKeyDescriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/VcsLogStorageImpl$MyPersistentBTreeEnumerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VcsRefKeyDescriptor
    implements KeyDescriptor<VcsRef> {
        @NotNull
        private final Map<VirtualFile, VcsLogProvider> myLogProviders;
        @NotNull
        private final KeyDescriptor<CommitId> myCommitIdKeyDescriptor;

        VcsRefKeyDescriptor(@NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull KeyDescriptor<CommitId> commitIdKeyDescriptor) {
            if (logProviders == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(0);
            }
            if (commitIdKeyDescriptor == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(1);
            }
            this.myLogProviders = logProviders;
            this.myCommitIdKeyDescriptor = commitIdKeyDescriptor;
        }

        public int getHashCode(@NotNull VcsRef value) {
            if (value == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(2);
            }
            return value.hashCode();
        }

        public boolean isEqual(@Nullable VcsRef val1, @Nullable VcsRef val2) {
            return Objects.equals(val1, val2);
        }

        public void save(@NotNull DataOutput out, @NotNull VcsRef value) throws IOException {
            if (out == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(3);
            }
            if (value == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(4);
            }
            this.myCommitIdKeyDescriptor.save(out, (Object)new CommitId(value.getCommitHash(), value.getRoot()));
            IOUtil.writeUTF((DataOutput)out, (String)value.getName());
            this.myLogProviders.get(value.getRoot()).getReferenceManager().serialize(out, value.getType());
        }

        public VcsRef read(@NotNull DataInput in) throws IOException {
            CommitId commitId;
            if (in == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(5);
            }
            if ((commitId = (CommitId)this.myCommitIdKeyDescriptor.read(in)) == null) {
                throw new IOException("Can not read commit id for reference");
            }
            String name = IOUtil.readUTF((DataInput)in);
            VcsRefType type = this.myLogProviders.get(commitId.getRoot()).getReferenceManager().deserialize(in);
            return new VcsRefImpl(commitId.getHash(), name, type, commitId.getRoot());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logProviders";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitIdKeyDescriptor";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/VcsLogStorageImpl$VcsRefKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHashCode";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

