/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.PostponableLogRefresherKt;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001bB\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000bJ\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0015H\u0007J\b\u0010\u0019\u001a\u00020\u0015H\u0007J\b\u0010\u001a\u001a\u00020\u000eH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/vcs/log/impl/PostponableLogRefresher;", "", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "<init>", "(Lcom/intellij/vcs/log/data/VcsLogData;)V", "rootsToRefresh", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "refreshers", "", "", "Lcom/intellij/vcs/log/impl/PostponableLogRefresher$Refresher;", "registerRefresher", "", "disposable", "Lcom/intellij/openapi/Disposable;", "id", "refresher", "refresherActivated", "firstTime", "", "refresh", "root", "postponed", "hasPostponedRoots", "refreshPostponedRoots", "Refresher", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
public final class PostponableLogRefresher {
    @NotNull
    private final VcsLogData logData;
    @NotNull
    private final Set<VirtualFile> rootsToRefresh;
    @NotNull
    private final Map<String, Refresher> refreshers;

    public PostponableLogRefresher(@NotNull VcsLogData logData) {
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        this.logData = logData;
        this.rootsToRefresh = new LinkedHashSet();
        this.refreshers = new LinkedHashMap();
        this.logData.addDataPackChangeListener(arg_0 -> PostponableLogRefresher._init_$lambda$0(this, arg_0));
    }

    public final void registerRefresher(@NotNull Disposable disposable, @NotNull String id, @NotNull Refresher refresher) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)refresher, (String)"refresher");
        if (!(this.refreshers.putIfAbsent(id, refresher) == null)) {
            boolean bl = false;
            String string = "Refresher with id " + id + " is already registered";
            throw new IllegalArgumentException(string.toString());
        }
        this.refresherActivated(refresher, true);
        Disposer.register((Disposable)disposable, () -> PostponableLogRefresher.registerRefresher$lambda$1(this, id));
    }

    public final void refresherActivated(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Refresher refresher = this.refreshers.get(id);
        if (refresher != null) {
            this.refresherActivated(refresher, false);
        }
    }

    private final void refresherActivated(Refresher refresher, boolean firstTime) {
        this.logData.initialize();
        if (!this.rootsToRefresh.isEmpty()) {
            this.refreshPostponedRoots();
        } else {
            refresher.validate(firstTime);
        }
    }

    @RequiresEdt
    public final void refresh(@NotNull VirtualFile root, boolean postponed) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (postponed) {
            PostponableLogRefresherKt.access$getLOG$p().debug("Postponed refresh for " + root);
            this.rootsToRefresh.add(root);
        } else {
            this.logData.refresh(SetsKt.setOf((Object)root), true);
        }
    }

    @RequiresEdt
    public final boolean hasPostponedRoots() {
        return !this.rootsToRefresh.isEmpty();
    }

    @RequiresEdt
    public final void refreshPostponedRoots() {
        Set toRefresh = CollectionsKt.toSet((Iterable)this.rootsToRefresh);
        this.rootsToRefresh.removeAll(toRefresh);
        VcsLogData.refresh$default(this.logData, toRefresh, false, 2, null);
    }

    private static final void _init_$lambda$0(PostponableLogRefresher this$0, DataPack dataPack) {
        Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
        for (Refresher refresher : this$0.refreshers.values()) {
            refresher.setDataPack(dataPack);
        }
    }

    private static final void registerRefresher$lambda$1(PostponableLogRefresher this$0, String $id) {
        this$0.refreshers.remove($id);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/log/impl/PostponableLogRefresher$Refresher;", "", "setDataPack", "", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "validate", "refresh", "", "intellij.platform.vcs.log.impl"})
    public static interface Refresher {
        public void setDataPack(@NotNull DataPack var1);

        public void validate(boolean var1);
    }
}

