/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.StatusText;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.ui.frame.ParentTag;
import com.intellij.vcs.log.ui.frame.VcsLogAsyncChangesTreeModel;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J(\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!\u00a8\u0006\""}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogChangesTreeComponents;", "", "<init>", "()V", "getTag", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "model", "Lcom/intellij/vcs/log/ui/frame/VcsLogAsyncChangesTreeModel;", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/AsyncChangesTree;", "getText", "", "Lorg/jetbrains/annotations/Nls;", "commitId", "Lcom/intellij/vcs/log/CommitId;", "getText$intellij_platform_vcs_log_impl", "getSelectedVcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "selectedData", "Lcom/intellij/openapi/vcs/changes/ui/VcsTreeModelData;", "updateStatusText", "emptyText", "Lcom/intellij/util/ui/StatusText;", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVcsLogChangesTreeComponents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogChangesTreeComponents.kt\ncom/intellij/vcs/log/ui/frame/VcsLogChangesTreeComponents\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n19#2:116\n19#2:119\n295#3,2:117\n*S KotlinDebug\n*F\n+ 1 VcsLogChangesTreeComponents.kt\ncom/intellij/vcs/log/ui/frame/VcsLogChangesTreeComponents\n*L\n32#1:116\n39#1:119\n33#1:117,2\n*E\n"})
public final class VcsLogChangesTreeComponents {
    @NotNull
    public static final VcsLogChangesTreeComponents INSTANCE = new VcsLogChangesTreeComponents();

    private VcsLogChangesTreeComponents() {
    }

    @Nullable
    public final ChangesBrowserNode.Tag getTag(@NotNull VcsLogAsyncChangesTreeModel model, @NotNull Change change) {
        Map.Entry entry;
        Object v3;
        block4: {
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            VcsLogAsyncChangesTreeModel.ChangesState $this$asSafely$iv = model.getChangesState();
            boolean $i$f$asSafely = false;
            VcsLogAsyncChangesTreeModel.ChangesState changesState = $this$asSafely$iv;
            if (!(changesState instanceof VcsLogAsyncChangesTreeModel.ChangesState.Changes)) {
                changesState = null;
            }
            VcsLogAsyncChangesTreeModel.ChangesState.Changes changes = (VcsLogAsyncChangesTreeModel.ChangesState.Changes)changesState;
            Map map = changes != null ? changes.getChangesToParents() : null;
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            Map changesToParents = map;
            Iterable $this$firstOrNull$iv = changesToParents.entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!((Set)it.getValue()).contains(change)) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        if ((entry = (Map.Entry)v3) == null || (entry = (CommitId)entry.getKey()) == null) {
            return null;
        }
        Map.Entry parentId = entry;
        Hash hash = parentId.getHash();
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
        return (ChangesBrowserNode.Tag)new ParentTag(hash, this.getText$intellij_platform_vcs_log_impl(model, (CommitId)parentId));
    }

    public final void uiDataSnapshot(@NotNull DataSink sink, @NotNull VcsLogAsyncChangesTreeModel model, @NotNull AsyncChangesTree tree) {
        Set set;
        Object object;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        sink.set(VcsLogAsyncChangesTreeModel.HAS_AFFECTED_FILES, (Object)(model.getAffectedPaths() != null ? 1 : 0));
        VcsLogAsyncChangesTreeModel.ChangesState $this$asSafely$iv = model.getChangesState();
        boolean $i$f$asSafely = false;
        VcsLogAsyncChangesTreeModel.ChangesState changesState = $this$asSafely$iv;
        if (!(changesState instanceof VcsLogAsyncChangesTreeModel.ChangesState.Changes)) {
            changesState = null;
        }
        if (((object = (VcsLogAsyncChangesTreeModel.ChangesState.Changes)changesState) != null && (object = ((VcsLogAsyncChangesTreeModel.ChangesState.Changes)object).getRoots()) != null ? CollectionsKt.toSet((Iterable)((Iterable)object)) : (set = null)) == null) {
            set = SetsKt.emptySet();
        }
        Set roots = set;
        VcsTreeModelData vcsTreeModelData = VcsTreeModelData.selected((JTree)((JTree)tree));
        Intrinsics.checkNotNullExpressionValue((Object)vcsTreeModelData, (String)"selected(...)");
        VcsTreeModelData selectedData = vcsTreeModelData;
        DataKey dataKey = VcsDataKeys.VCS;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"VCS");
        sink.lazy(dataKey, () -> VcsLogChangesTreeComponents.uiDataSnapshot$lambda$0(tree, roots, selectedData));
    }

    @NotNull
    public final String getText$intellij_platform_vcs_log_impl(@NotNull VcsLogAsyncChangesTreeModel model, @NotNull CommitId commitId) {
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)commitId, (String)"commitId");
        Object[] objectArray = new Object[]{commitId.getHash().toShortString()};
        String string = VcsLogBundle.message("vcs.log.changes.changes.to.parent.node", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object text = string;
        VcsShortCommitDetails detail2 = model.getCommitDetails(commitId);
        if (!(detail2 instanceof LoadingDetails) || detail2 instanceof IndexedDetails) {
            text = (String)text + " " + StringUtil.shortenTextWithEllipsis((String)detail2.getSubject(), (int)50, (int)0);
        }
        return text;
    }

    private final AbstractVcs getSelectedVcs(Project project, Set<? extends VirtualFile> roots, VcsTreeModelData selectedData) {
        AbstractVcs rootsVcs = (AbstractVcs)JBIterable.from((Iterable)roots).filterMap(arg_0 -> VcsLogChangesTreeComponents.getSelectedVcs$lambda$1(arg_0 -> VcsLogChangesTreeComponents.getSelectedVcs$lambda$0(project, arg_0), arg_0)).unique().single();
        if (rootsVcs != null) {
            return rootsVcs;
        }
        AbstractVcs selectionVcs = (AbstractVcs)selectedData.iterateUserObjects(Change.class).map(arg_0 -> VcsLogChangesTreeComponents.getSelectedVcs$lambda$3(VcsLogChangesTreeComponents::getSelectedVcs$lambda$2, arg_0)).filterMap(arg_0 -> VcsLogChangesTreeComponents.getSelectedVcs$lambda$5(arg_0 -> VcsLogChangesTreeComponents.getSelectedVcs$lambda$4(project, arg_0), arg_0)).unique().single();
        return selectionVcs;
    }

    public final void updateStatusText(@NotNull VcsLogAsyncChangesTreeModel model, @NotNull StatusText emptyText) {
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)emptyText, (String)"emptyText");
        VcsLogAsyncChangesTreeModel.ChangesState changesState = model.getChangesState();
        if (changesState instanceof VcsLogAsyncChangesTreeModel.ChangesState.Empty) {
            if (((VcsLogAsyncChangesTreeModel.ChangesState.Empty)changesState).getResetText()) {
                emptyText.setText("");
            }
        } else if (changesState instanceof VcsLogAsyncChangesTreeModel.ChangesState.Error) {
            emptyText.setText(VcsLogBundle.message("vcs.log.error.loading.changes.status", new Object[0]));
        } else if (changesState instanceof VcsLogAsyncChangesTreeModel.ChangesState.ManyChanges) {
            Object[] objectArray = new Object[]{((VcsLogAsyncChangesTreeModel.ChangesState.ManyChanges)changesState).getSize(), ((VcsLogAsyncChangesTreeModel.ChangesState.ManyChanges)changesState).getMaxSize()};
            emptyText.setText(VcsLogBundle.message("vcs.log.changes.too.many.status", objectArray));
            StatusText statusText2 = emptyText.appendSecondaryText(VcsLogBundle.message("vcs.log.changes.too.many.show.anyway.status.action", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> VcsLogChangesTreeComponents.updateStatusText$lambda$0(changesState, arg_0));
            Intrinsics.checkNotNull((Object)statusText2);
        } else if (changesState instanceof VcsLogAsyncChangesTreeModel.ChangesState.Changes) {
            if (((VcsLogAsyncChangesTreeModel.ChangesState.Changes)changesState).getRoots().isEmpty()) {
                emptyText.setText(VcsLogBundle.message("vcs.log.changes.select.commits.to.view.changes.status", new Object[0]));
            } else if (!((VcsLogAsyncChangesTreeModel.ChangesState.Changes)changesState).getChangesToParents().isEmpty()) {
                StatusText statusText3 = emptyText.setText(VcsLogBundle.message("vcs.log.changes.no.merge.conflicts.status", new Object[0])).appendSecondaryText(VcsLogBundle.message("vcs.log.changes.show.changes.to.parents.status.action", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> VcsLogChangesTreeComponents.updateStatusText$lambda$1(model, arg_0));
                Intrinsics.checkNotNull((Object)statusText3);
            } else if (model.isShowOnlyAffectedChanges() && model.getAffectedPaths() != null) {
                StatusText statusText4 = emptyText.setText(VcsLogBundle.message("vcs.log.changes.no.changes.that.affect.selected.paths.status", new Object[0])).appendSecondaryText(VcsLogBundle.message("vcs.log.changes.show.all.paths.status.action", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> VcsLogChangesTreeComponents.updateStatusText$lambda$2(model, arg_0));
                Intrinsics.checkNotNull((Object)statusText4);
            } else {
                emptyText.setText("");
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final VcsKey uiDataSnapshot$lambda$0(AsyncChangesTree $tree, Set $roots, VcsTreeModelData $selectedData) {
        Project project = $tree.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AbstractVcs abstractVcs = INSTANCE.getSelectedVcs(project, $roots, $selectedData);
        return abstractVcs != null ? abstractVcs.getKeyInstanceMethod() : null;
    }

    private static final AbstractVcs getSelectedVcs$lambda$0(Project $project, VirtualFile root) {
        return ProjectLevelVcsManager.getInstance((Project)$project).getVcsFor(root);
    }

    private static final AbstractVcs getSelectedVcs$lambda$1(Function1 $tmp0, Object p0) {
        return (AbstractVcs)$tmp0.invoke(p0);
    }

    private static final FilePath getSelectedVcs$lambda$2(Change change) {
        return ChangesUtil.getFilePath((Change)change);
    }

    private static final FilePath getSelectedVcs$lambda$3(Function1 $tmp0, Object p0) {
        return (FilePath)$tmp0.invoke(p0);
    }

    private static final AbstractVcs getSelectedVcs$lambda$4(Project $project, FilePath root) {
        return ProjectLevelVcsManager.getInstance((Project)$project).getVcsFor(root);
    }

    private static final AbstractVcs getSelectedVcs$lambda$5(Function1 $tmp0, Object p0) {
        return (AbstractVcs)$tmp0.invoke(p0);
    }

    private static final void updateStatusText$lambda$0(VcsLogAsyncChangesTreeModel.ChangesState $changesState, ActionEvent it) {
        ((VcsLogAsyncChangesTreeModel.ChangesState.ManyChanges)$changesState).getShowAnyway().invoke();
    }

    private static final void updateStatusText$lambda$1(VcsLogAsyncChangesTreeModel $model, ActionEvent it) {
        $model.setShowChangesFromParents(true);
    }

    private static final void updateStatusText$lambda$2(VcsLogAsyncChangesTreeModel $model, ActionEvent it) {
        $model.setShowOnlyAffectedChanges(false);
    }
}

