/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import org.junit.Assert;

public final class FindManagerTestUtils {
    public static void runFindInCommentsAndLiterals(FindManager findManager, FindModel findModel, String text2, String ext) {
        findModel.setSearchContext(FindModel.SearchContext.IN_STRING_LITERALS);
        FindManagerTestUtils.runFindForwardAndBackward(findManager, findModel, text2, ext);
        findModel.setSearchContext(FindModel.SearchContext.IN_COMMENTS);
        FindManagerTestUtils.runFindForwardAndBackward(findManager, findModel, text2, ext);
    }

    public static void runFindForwardAndBackward(FindManager findManager, FindModel findModel, String text2, String ext) {
        findModel.setForward(true);
        LightVirtualFile file = new LightVirtualFile("A." + ext, (CharSequence)text2);
        FindResult findResult = findManager.findString((CharSequence)text2, 0, findModel, (VirtualFile)file);
        Assert.assertTrue((boolean)findResult.isStringFound());
        int previousOffset = findResult.getStartOffset();
        findResult = findManager.findString((CharSequence)text2, findResult.getEndOffset(), findModel, (VirtualFile)file);
        Assert.assertTrue((boolean)findResult.isStringFound());
        Assert.assertTrue((findResult.getStartOffset() > previousOffset ? 1 : 0) != 0);
        previousOffset = findResult.getStartOffset();
        findResult = findManager.findString((CharSequence)text2, findResult.getEndOffset(), findModel, (VirtualFile)file);
        Assert.assertTrue((boolean)findResult.isStringFound());
        Assert.assertTrue((findResult.getStartOffset() > previousOffset ? 1 : 0) != 0);
        findModel.setForward(false);
        findResult = findManager.findString((CharSequence)text2, text2.length(), findModel, (VirtualFile)file);
        Assert.assertTrue((boolean)findResult.isStringFound());
        previousOffset = findResult.getStartOffset();
        findResult = findManager.findString((CharSequence)text2, previousOffset, findModel, (VirtualFile)file);
        Assert.assertTrue((boolean)findResult.isStringFound());
        Assert.assertTrue((previousOffset > findResult.getStartOffset() ? 1 : 0) != 0);
        previousOffset = findResult.getStartOffset();
        findResult = findManager.findString((CharSequence)text2, previousOffset, findModel, (VirtualFile)file);
        Assert.assertTrue((boolean)findResult.isStringFound());
        Assert.assertTrue((previousOffset > findResult.getStartOffset() ? 1 : 0) != 0);
    }

    public static FindModel configureFindModel(String stringToFind) {
        FindModel findModel = new FindModel();
        findModel.setStringToFind(stringToFind);
        findModel.setWholeWordsOnly(false);
        findModel.setFromCursor(false);
        findModel.setGlobal(true);
        findModel.setMultipleFiles(false);
        findModel.setProjectScope(true);
        return findModel;
    }
}

