/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.TokenWrapper;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.RestartableLexer;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LexerTestCase
extends UsefulTestCase {
    protected void doTest(@NotNull String text2) {
        if (text2 == null) {
            LexerTestCase.$$$reportNull$$$0(0);
        }
        this.doTest(text2, null);
    }

    protected void doTest(@NotNull String text2, @Nullable String expected) {
        if (text2 == null) {
            LexerTestCase.$$$reportNull$$$0(1);
        }
        this.doTest(text2, expected, this.createLexer());
    }

    protected void doTest(@NotNull String text2, @Nullable String expected, @NotNull Lexer lexer) {
        if (text2 == null) {
            LexerTestCase.$$$reportNull$$$0(2);
        }
        if (lexer == null) {
            LexerTestCase.$$$reportNull$$$0(3);
        }
        String result = this.printTokens(lexer, text2, 0);
        if (expected != null) {
            LexerTestCase.assertSameLines(expected, result);
        } else {
            LexerTestCase.assertSameLinesWithFile(this.getPathToTestDataFile(this.getExpectedFileExtension()), result);
        }
    }

    protected String printTokens(@NotNull Lexer lexer, @NotNull CharSequence text2, int start) {
        if (lexer == null) {
            LexerTestCase.$$$reportNull$$$0(4);
        }
        if (text2 == null) {
            LexerTestCase.$$$reportNull$$$0(5);
        }
        return LexerTestCase.printTokens(text2, start, lexer);
    }

    @NotNull
    protected String getPathToTestDataFile(@NotNull String extension) {
        if (extension == null) {
            LexerTestCase.$$$reportNull$$$0(6);
        }
        String string = IdeaTestExecutionPolicy.getHomePathWithPolicy() + "/" + this.getDirPath() + "/" + this.getTestName(true) + extension;
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    protected String getExpectedFileExtension() {
        return ".txt";
    }

    protected void checkZeroState(@NotNull String text2, TokenSet tokenTypes) {
        IElementType type;
        if (text2 == null) {
            LexerTestCase.$$$reportNull$$$0(8);
        }
        Lexer lexer = this.createLexer();
        lexer.start((CharSequence)text2);
        while ((type = lexer.getTokenType()) != null) {
            if (tokenTypes.contains(type) && lexer.getState() != 0) {
                LexerTestCase.fail((String)("Non-zero lexer state on token \"" + lexer.getTokenText() + "\" (" + String.valueOf(type) + ") at " + lexer.getTokenStart()));
            }
            lexer.advance();
        }
    }

    protected String printTokens(@NotNull String text2, int start) {
        if (text2 == null) {
            LexerTestCase.$$$reportNull$$$0(9);
        }
        return LexerTestCase.printTokens(text2, start, this.createLexer());
    }

    protected void checkCorrectRestart(@NotNull String text2) {
        IElementType type;
        if (text2 == null) {
            LexerTestCase.$$$reportNull$$$0(10);
        }
        Lexer mainLexer = this.createLexer();
        List<Trinity<IElementType, Integer, Integer>> allTokens = LexerTestCase.tokenize(text2, 0, 0, mainLexer);
        Lexer auxLexer = this.createLexer();
        auxLexer.start((CharSequence)text2);
        int index = 0;
        while ((type = auxLexer.getTokenType()) != null) {
            int state = auxLexer.getState();
            if (state == 0 || auxLexer instanceof RestartableLexer && ((RestartableLexer)auxLexer).isRestartableState(state)) {
                int tokenStart = auxLexer.getTokenStart();
                List<Trinity<IElementType, Integer, Integer>> expectedTokens = allTokens.subList(index, allTokens.size());
                List<Trinity<IElementType, Integer, Integer>> restartedTokens = LexerTestCase.tokenize(text2, tokenStart, state, mainLexer);
                LexerTestCase.assertEquals((String)("Restarting impossible from offset " + tokenStart + " - " + auxLexer.getTokenText() + "\nAll tokens <type, offset, lexer state>: " + String.valueOf(allTokens) + "\n"), (String)expectedTokens.stream().map(Objects::toString).collect(Collectors.joining("\n")), (String)restartedTokens.stream().map(Objects::toString).collect(Collectors.joining("\n")));
            }
            ++index;
            auxLexer.advance();
        }
    }

    @NotNull
    private static List<Trinity<IElementType, Integer, Integer>> tokenize(@NotNull String text2, int start, int state, @NotNull Lexer lexer) {
        if (text2 == null) {
            LexerTestCase.$$$reportNull$$$0(11);
        }
        if (lexer == null) {
            LexerTestCase.$$$reportNull$$$0(12);
        }
        ArrayList<Trinity<IElementType, Integer, Integer>> allTokens = new ArrayList<Trinity<IElementType, Integer, Integer>>();
        try {
            lexer.start((CharSequence)text2, start, text2.length(), state);
        }
        catch (Throwable t) {
            LOG.error("Restarting impossible from offset " + start, t);
            throw new RuntimeException(t);
        }
        while (lexer.getTokenType() != null) {
            allTokens.add((Trinity<IElementType, Integer, Integer>)Trinity.create((Object)lexer.getTokenType(), (Object)lexer.getTokenStart(), (Object)lexer.getState()));
            lexer.advance();
        }
        ArrayList<Trinity<IElementType, Integer, Integer>> arrayList = allTokens;
        if (arrayList == null) {
            LexerTestCase.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    public static String printTokens(@NotNull CharSequence text2, int start, @NotNull Lexer lexer) {
        IElementType tokenType;
        if (text2 == null) {
            LexerTestCase.$$$reportNull$$$0(14);
        }
        if (lexer == null) {
            LexerTestCase.$$$reportNull$$$0(15);
        }
        lexer.start(text2, start, text2.length());
        StringBuilder result = new StringBuilder();
        while ((tokenType = lexer.getTokenType()) != null) {
            result.append(LexerTestCase.printSingleToken(text2, tokenType, lexer.getTokenStart(), lexer.getTokenEnd()));
            lexer.advance();
        }
        return result.toString();
    }

    @NotNull
    public static String printTokens(@NotNull HighlighterIterator iterator) {
        if (iterator == null) {
            LexerTestCase.$$$reportNull$$$0(16);
        }
        CharSequence text2 = iterator.getDocument().getCharsSequence();
        StringBuilder result = new StringBuilder();
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            result.append(LexerTestCase.printSingleToken(text2, tokenType, iterator.getStart(), iterator.getEnd()));
            iterator.advance();
        }
        String string = result.toString();
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static String printSingleToken(@NotNull CharSequence fileText, @NotNull IElementType tokenType, int start, int end) {
        if (fileText == null) {
            LexerTestCase.$$$reportNull$$$0(18);
        }
        if (tokenType == null) {
            LexerTestCase.$$$reportNull$$$0(19);
        }
        return String.valueOf(tokenType) + " ('" + LexerTestCase.getTokenText(tokenType, fileText, start, end) + "')\n";
    }

    protected void doFileTest(@NotNull String fileExt) {
        if (fileExt == null) {
            LexerTestCase.$$$reportNull$$$0(20);
        }
        this.doTest(this.loadTestDataFile("." + fileExt));
    }

    @NotNull
    protected String loadTestDataFile(String fileExt) {
        String fileName = this.getPathToTestDataFile(fileExt);
        String text2 = "";
        try {
            String fileText = FileUtil.loadFile((File)new File(fileName));
            text2 = StringUtil.convertLineSeparators((String)(this.shouldTrim() ? fileText.trim() : fileText));
        }
        catch (IOException e) {
            LexerTestCase.fail((String)("can't load file " + fileName + ": " + e.getMessage()));
        }
        String string = text2;
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(21);
        }
        return string;
    }

    protected boolean shouldTrim() {
        return true;
    }

    @NotNull
    private static String getTokenText(IElementType tokenType, CharSequence sequence, int start, int end) {
        String string = tokenType instanceof TokenWrapper ? ((TokenWrapper)tokenType).getText() : StringUtil.replace((String)sequence.subSequence(start, end).toString(), (String)"\n", (String)"\\n");
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    protected abstract Lexer createLexer();

    @NotNull
    protected abstract String getDirPath();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 13, 17, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 7: 
            case 13: 
            case 17: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LexerTestCase";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LexerTestCase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToTestDataFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "printTokens";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTestDataFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTest";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "printTokens";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPathToTestDataFile";
                break;
            }
            case 7: 
            case 13: 
            case 17: 
            case 21: 
            case 22: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkZeroState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkCorrectRestart";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "printSingleToken";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doFileTest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 13, 17, 21, 22 -> new IllegalStateException(string);
        };
    }
}

