/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.ide.IdeEventQueue;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.internal.DumpLookupElementWeights;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PerformWithDocumentsCommitted;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ActionProcessor;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.JList;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.junit.Assert;

public class EditorTestFixture {
    @NotNull
    private static final Logger LOG = Logger.getInstance(EditorTestFixture.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final VirtualFile myVirtualFile;
    private boolean myEmptyLookup;

    public EditorTestFixture(@NotNull Project project, @NotNull Editor editor2, @NotNull VirtualFile file) {
        if (project == null) {
            EditorTestFixture.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            EditorTestFixture.$$$reportNull$$$0(1);
        }
        if (file == null) {
            EditorTestFixture.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myEditor = editor2;
        this.myVirtualFile = file;
    }

    public void type(char c) {
        if (ProgressIndicatorUtils.isWriteActionRunningOrPending((ApplicationEx)ApplicationManagerEx.getApplicationEx())) {
            LOG.warn("type() must not be in WA");
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            int keyCode = KeyEvent.getExtendedKeyCodeForChar(c);
            KeyEvent keyEvent = new KeyEvent(this.getEditor().getContentComponent(), 401, -1L, 0, keyCode, c);
            if (!Character.isLetterOrDigit(keyEvent.getKeyChar()) || ClientProperty.get((Component)this.getEditor().getContentComponent(), (Key)ActionUtil.ALLOW_PlAIN_LETTER_SHORTCUTS) == Boolean.TRUE) {
                KeyboardShortcut shortcut = c == '\r' ? (KeyboardShortcut)Objects.requireNonNull(KeymapUtil.getPrimaryShortcut((String)"EditorCompleteStatement")) : new KeyboardShortcut(KeyStroke.getKeyStroke(keyCode, 0), null);
                IdeKeyEventDispatcher keyEventDispatcher = IdeEventQueue.getInstance().getKeyEventDispatcher();
                keyEventDispatcher.updateCurrentContext((Component)this.getEditor().getContentComponent(), (Shortcut)shortcut);
                keyEventDispatcher.getContext().setProject(this.myProject);
                keyEventDispatcher.getContext().setDataContext(this.getEditorDataContext());
                keyEventDispatcher.getContext().setShortcut((Shortcut)shortcut);
                try {
                    if (keyEventDispatcher.processAction((InputEvent)keyEvent, new ActionProcessor(this){

                        public void performAction(@NotNull InputEvent inputEvent, @NotNull AnAction action, @NotNull AnActionEvent event) {
                            if (inputEvent == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (action == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (event == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            super.performAction(inputEvent, action, event);
                            LOG.info("type(): performing action '" + event.getActionManager().getId(action) + "'");
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "inputEvent";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "action";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "event";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/testFramework/fixtures/EditorTestFixture$1";
                            objectArray[2] = "performAction";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    })) {
                        return;
                    }
                }
                finally {
                    keyEventDispatcher.getContext().clear();
                }
            }
            ActionManagerEx.getInstanceEx().fireBeforeEditorTyping(c, this.getEditorDataContext());
            TypedAction.getInstance().actionPerformed(this.myEditor, c, this.getEditorDataContext());
            ActionManagerEx.getInstanceEx().fireAfterEditorTyping(c, this.getEditorDataContext());
        });
    }

    public void type(@NotNull String s) {
        if (s == null) {
            EditorTestFixture.$$$reportNull$$$0(3);
        }
        for (int i = 0; i < s.length(); ++i) {
            this.type(s.charAt(i));
        }
    }

    public boolean performEditorAction(@NotNull String actionId) {
        if (actionId == null) {
            EditorTestFixture.$$$reportNull$$$0(4);
        }
        return this.performEditorAction(actionId, null);
    }

    public boolean performEditorAction(@NotNull String actionId, @Nullable AnActionEvent actionEvent) {
        if (actionId == null) {
            EditorTestFixture.$$$reportNull$$$0(5);
        }
        ActionManagerEx managerEx = ActionManagerEx.getInstanceEx();
        AnAction action = managerEx.getAction(actionId);
        AnActionEvent event = actionEvent != null ? actionEvent : new AnActionEvent(null, this.getEditorDataContext(), "unknown", new Presentation(), (ActionManager)managerEx, 0);
        PerformWithDocumentsCommitted.commitDocumentsIfNeeded((AnAction)action, (AnActionEvent)event);
        ActionUtil.updateAction((AnAction)action, (AnActionEvent)event);
        if (event.getPresentation().isEnabled()) {
            ActionUtil.performAction((AnAction)action, (AnActionEvent)event);
            LOG.info("performEditorAction(): performing action '" + event.getActionManager().getId(action) + "'");
            return true;
        }
        return false;
    }

    @NotNull
    private DataContext getEditorDataContext() {
        DataContext dataContext = EditorUtil.getEditorDataContext((Editor)this.myEditor);
        if (dataContext == null) {
            EditorTestFixture.$$$reportNull$$$0(6);
        }
        return dataContext;
    }

    public PsiFile getFile() {
        return (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.myProject).findFile(this.myVirtualFile));
    }

    @NotNull
    public @Unmodifiable List<HighlightInfo> doHighlighting() {
        List<HighlightInfo> list = this.doHighlighting(false, false);
        if (list == null) {
            EditorTestFixture.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<HighlightInfo> doHighlighting(boolean myAllowDirt, boolean readEditorMarkupModel) {
        EdtTestUtil.runInEdtAndWait(() -> PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments());
        PsiFile file = this.getFile();
        Editor editor2 = this.myEditor;
        if (editor2 instanceof EditorWindow) {
            editor2 = ((EditorWindow)editor2).getDelegate();
            file = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
        }
        Assert.assertNotNull((Object)file);
        List<HighlightInfo> list = CodeInsightTestFixtureImpl.instantiateAndRun(file, editor2, ArrayUtilRt.EMPTY_INT_ARRAY, myAllowDirt, readEditorMarkupModel);
        if (list == null) {
            EditorTestFixture.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    protected Editor getCompletionEditor() {
        Editor editor2 = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)this.myEditor, (PsiFile)this.getFile());
        if (editor2 == null) {
            EditorTestFixture.$$$reportNull$$$0(9);
        }
        return editor2;
    }

    public LookupImpl getLookup() {
        return (LookupImpl)LookupManager.getActiveLookup((Editor)this.myEditor);
    }

    public LookupElement[] complete(@NotNull CompletionType type) {
        if (type == null) {
            EditorTestFixture.$$$reportNull$$$0(10);
        }
        return this.complete(type, 1);
    }

    public LookupElement[] completeBasic() {
        return this.complete(CompletionType.BASIC);
    }

    public LookupElement[] complete(@NotNull CompletionType type, int invocationCount) {
        if (type == null) {
            EditorTestFixture.$$$reportNull$$$0(11);
        }
        this.myEmptyLookup = false;
        ApplicationManager.getApplication().invokeAndWait(() -> CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            CodeCompletionHandlerBase handler = new CodeCompletionHandlerBase(type){

                protected void completionFinished(@NotNull CompletionProgressIndicator indicator, boolean hasModifiers) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    EditorTestFixture.this.myEmptyLookup = indicator.getLookup().getItems().isEmpty();
                    super.completionFinished(indicator, hasModifiers);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/testFramework/fixtures/EditorTestFixture$2", "completionFinished"));
                }
            };
            Editor editor2 = this.getCompletionEditor();
            Assert.assertNotNull((Object)editor2);
            handler.invokeCompletion(this.myProject, editor2, invocationCount);
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        }, null, null, this.myEditor.getDocument()));
        return this.getLookupElements();
    }

    public LookupElement @Nullable [] getLookupElements() {
        LookupImpl lookup = this.getLookup();
        if (lookup == null) {
            return this.myEmptyLookup ? LookupElement.EMPTY_ARRAY : null;
        }
        List list = lookup.getItems();
        return list.toArray(LookupElement.EMPTY_ARRAY);
    }

    public @Unmodifiable List<String> getLookupElementStrings() {
        Object[] elements = this.getLookupElements();
        if (elements == null) {
            return null;
        }
        return ContainerUtil.map((Object[])elements, LookupElement::getLookupString);
    }

    @NotNull
    public final List<LookupElement> completeBasicAllCarets(@Nullable Character charToTypeIfOnlyOneOrNoCompletion, @Nullable Character charToTypeIfMultipleCompletions) {
        CaretModel caretModel = this.myEditor.getCaretModel();
        List carets = caretModel.getAllCarets();
        ArrayList<Integer> originalOffsets = new ArrayList<Integer>(carets.size());
        for (Caret caret : carets) {
            originalOffsets.add(caret.getOffset());
        }
        caretModel.removeSecondaryCarets();
        Collections.reverse(originalOffsets);
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        Iterator iterator = originalOffsets.iterator();
        while (iterator.hasNext()) {
            int originalOffset = (Integer)iterator.next();
            caretModel.moveToOffset(originalOffset);
            LookupElement[] lookupElements = this.completeBasic();
            if ((lookupElements == null || lookupElements.length == 0) && charToTypeIfOnlyOneOrNoCompletion != null) {
                this.type(charToTypeIfOnlyOneOrNoCompletion.charValue());
            } else if (lookupElements != null && lookupElements.length > 0 && charToTypeIfMultipleCompletions != null) {
                this.type(charToTypeIfMultipleCompletions.charValue());
            }
            if (lookupElements == null) continue;
            result.addAll(Arrays.asList(lookupElements));
        }
        ArrayList<LookupElement> arrayList = result;
        if (arrayList == null) {
            EditorTestFixture.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    public void assertPreferredCompletionItems(int selected, String ... expected) {
        if (expected == null) {
            EditorTestFixture.$$$reportNull$$$0(13);
        }
        LookupImpl lookup = this.getLookup();
        Assert.assertNotNull((String)"No lookup is shown", (Object)lookup);
        JList list = lookup.getList();
        List<String> strings = this.getLookupElementStrings();
        Assert.assertNotNull(strings);
        List actual = ContainerUtil.getFirstItems(strings, (int)expected.length);
        if (!actual.equals(Arrays.asList(expected))) {
            UsefulTestCase.assertOrderedEquals(DumpLookupElementWeights.getLookupElementWeights((LookupImpl)lookup, (boolean)false), expected);
        }
        if (selected != list.getSelectedIndex()) {
            DumpLookupElementWeights.getLookupElementWeights((LookupImpl)lookup, (boolean)false).forEach(System.out::println);
        }
        Assert.assertEquals((long)selected, (long)list.getSelectedIndex());
    }

    public void finishLookup(char completionChar) {
        Runnable command = () -> {
            LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)this.myEditor);
            Assert.assertNotNull((Object)lookup);
            lookup.finishLookup(completionChar);
        };
        CommandProcessor.getInstance().executeCommand(this.myProject, command, null, null, this.myEditor.getDocument());
    }

    public PsiElement getElementAtCaret() {
        int findTargetFlags;
        Editor editor2 = this.getCompletionEditor();
        PsiElement element = TargetElementUtil.findTargetElement((Editor)editor2, (int)(findTargetFlags = 3));
        if (element == null && editor2 instanceof EditorWindow) {
            element = TargetElementUtil.findTargetElement((Editor)((EditorWindow)editor2).getDelegate(), (int)findTargetFlags);
        }
        if (element == null) {
            PsiFile psiFile = this.getFile();
            int offset = this.myEditor.getCaretModel().getOffset();
            int expectedCaretOffset = editor2 instanceof EditorEx ? ((EditorEx)editor2).getExpectedCaretOffset() : offset;
            Assert.fail((String)("element not found in file " + String.valueOf(psiFile) + "(" + String.valueOf(psiFile.getClass()) + ", " + String.valueOf(psiFile.getViewProvider()) + ", " + String.valueOf(editor2.getProject()) + ") at caret position offset " + offset + (String)(offset == expectedCaretOffset ? "" : ", expected caret offset: " + expectedCaretOffset) + ", psi structure:\n" + DebugUtil.psiToString((PsiElement)psiFile, (boolean)true, (boolean)true) + ", elementAt(" + offset + ")=" + String.valueOf(psiFile.findElementAt(offset)) + ", editor=" + String.valueOf(editor2) + ", adjusted offset=" + TargetElementUtilBase.adjustOffset((PsiFile)psiFile, (Document)editor2.getDocument(), (int)offset) + ", TargetElementUtilBase.findTargetElement(editor, flags, offset)=" + String.valueOf(TargetElementUtilBase.findTargetElement((Editor)editor2, (int)findTargetFlags, (int)offset))));
        }
        return element;
    }

    public <T extends PsiElement> T findElementByText(@NotNull String text2, @NotNull Class<T> elementClass) {
        if (text2 == null) {
            EditorTestFixture.$$$reportNull$$$0(14);
        }
        if (elementClass == null) {
            EditorTestFixture.$$$reportNull$$$0(15);
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.getFile());
        Assert.assertNotNull((Object)document);
        int pos = document.getText().indexOf(text2);
        Assert.assertTrue((String)text2, (pos >= 0 ? 1 : 0) != 0);
        return (T)PsiTreeUtil.getParentOfType((PsiElement)this.getFile().findElementAt(pos), elementClass);
    }

    @NotNull
    public List<IntentionAction> getAllQuickFixes() {
        List<HighlightInfo> infos = this.doHighlighting();
        ArrayList<IntentionAction> actions = new ArrayList<IntentionAction>();
        for (HighlightInfo info : infos) {
            info.findRegisteredQuickFix((descriptor, range) -> {
                actions.add(descriptor.getAction());
                return null;
            });
        }
        ArrayList<IntentionAction> arrayList = actions;
        if (arrayList == null) {
            EditorTestFixture.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    public @Unmodifiable List<Crumb> getBreadcrumbsAtCaret() {
        FileBreadcrumbsCollector breadcrumbsCollector = FileBreadcrumbsCollector.findBreadcrumbsCollector((Project)this.myProject, (VirtualFile)this.myVirtualFile);
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)breadcrumbsCollector.computeCrumbs(this.myVirtualFile, this.myEditor.getDocument(), this.myEditor.getCaretModel().getOffset(), Boolean.valueOf(true)));
        if (arrayList == null) {
            EditorTestFixture.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor2 = this.myEditor;
        if (editor2 == null) {
            EditorTestFixture.$$$reportNull$$$0(18);
        }
        return editor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 12, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/EditorTestFixture";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/EditorTestFixture";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorDataContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doHighlighting";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionEditor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "completeBasicAllCarets";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllQuickFixes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreadcrumbsAtCaret";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performEditorAction";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "complete";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "assertPreferredCompletionItems";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findElementByText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 12, 16, 17, 18 -> new IllegalStateException(string);
        };
    }
}

