/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.intention.impl.QuickEditAction;
import com.intellij.codeInsight.intention.impl.QuickEditHandler;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.EditorTestFixture;
import com.intellij.testFramework.fixtures.InjectionAssertionData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0018\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00150\u00140\u0013J\u001f\u0010\u0016\u001a\u00020\u000f2\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0018\"\u00020\u0011\u00a2\u0006\u0002\u0010\u0019J\u001c\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013J\u001f\u0010\u001c\u001a\u00020\u000f2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u0018\"\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ\u001f\u0010 \u001a\u00020\u000f2\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u0018\"\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010\"\u001a\u00020#J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010&\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u00061"}, d2={"Lcom/intellij/testFramework/fixtures/InjectionTestFixture;", "", "javaFixture", "Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;", "<init>", "(Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;)V", "injectedLanguageManager", "Lcom/intellij/lang/injection/InjectedLanguageManager;", "getInjectedLanguageManager", "()Lcom/intellij/lang/injection/InjectedLanguageManager;", "injectedElement", "Lcom/intellij/psi/PsiElement;", "getInjectedElement", "()Lcom/intellij/psi/PsiElement;", "assertInjectedLangAtCaret", "", "lang", "", "getAllInjections", "", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiFile;", "assertInjectedContent", "expectedInjectFileTexts", "", "([Ljava/lang/String;)V", "message", "expectedFilesTexts", "assertInjected", "expectedInjections", "Lcom/intellij/testFramework/fixtures/InjectionAssertionData;", "([Lcom/intellij/testFramework/fixtures/InjectionAssertionData;)V", "assertNotInjected", "notExpectedInjections", "openInFragmentEditor", "Lcom/intellij/testFramework/fixtures/EditorTestFixture;", "quickEditHandler", "Lcom/intellij/codeInsight/intention/impl/QuickEditHandler;", "topLevelFile", "getTopLevelFile", "()Lcom/intellij/psi/PsiFile;", "topLevelCaretPosition", "", "getTopLevelCaretPosition", "()I", "topLevelEditor", "Lcom/intellij/openapi/editor/Editor;", "getTopLevelEditor", "()Lcom/intellij/openapi/editor/Editor;", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nInjectionTestFixture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InjectionTestFixture.kt\ncom/intellij/testFramework/fixtures/InjectionTestFixture\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1634#2,3:175\n1563#2:178\n1#3:179\n*S KotlinDebug\n*F\n+ 1 InjectionTestFixture.kt\ncom/intellij/testFramework/fixtures/InjectionTestFixture\n*L\n61#1:175,3\n61#1:178\n*E\n"})
public final class InjectionTestFixture {
    @NotNull
    private final CodeInsightTestFixture javaFixture;

    public InjectionTestFixture(@NotNull CodeInsightTestFixture javaFixture) {
        Intrinsics.checkNotNullParameter((Object)javaFixture, (String)"javaFixture");
        this.javaFixture = javaFixture;
    }

    @NotNull
    public final InjectedLanguageManager getInjectedLanguageManager() {
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)this.javaFixture.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)injectedLanguageManager, (String)"getInstance(...)");
        return injectedLanguageManager;
    }

    @Nullable
    public final PsiElement getInjectedElement() {
        PsiFile psiFile = this.getTopLevelFile();
        if (psiFile == null) {
            return null;
        }
        return this.getInjectedLanguageManager().findInjectedElementAt(psiFile, this.getTopLevelCaretPosition());
    }

    public final void assertInjectedLangAtCaret(@Nullable String lang) {
        PsiElement injectedElement = this.getInjectedElement();
        if (lang != null) {
            TestCase.assertNotNull((String)("injection of '" + lang + "' expected"), (Object)injectedElement);
            PsiElement psiElement = injectedElement;
            Intrinsics.checkNotNull((Object)psiElement);
            TestCase.assertEquals((String)lang, (String)psiElement.getLanguage().getID());
        } else {
            TestCase.assertNull((Object)injectedElement);
        }
    }

    @NotNull
    public final List<Pair<PsiElement, PsiFile>> getAllInjections() {
        List injected = new ArrayList();
        Class[] classArray = new Class[]{PsiLanguageInjectionHost.class};
        Collection collection = PsiTreeUtil.collectElementsOfType((PsiElement)((PsiElement)this.getTopLevelFile()), (Class[])classArray);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"collectElementsOfType(...)");
        Collection hosts = collection;
        for (PsiLanguageInjectionHost host : hosts) {
            this.getInjectedLanguageManager().enumerate((PsiElement)host, (arg_0, arg_1) -> InjectionTestFixture.getAllInjections$lambda$0(injected, host, arg_0, arg_1));
        }
        return injected;
    }

    public final void assertInjectedContent(String ... expectedInjectFileTexts) {
        Intrinsics.checkNotNullParameter((Object)expectedInjectFileTexts, (String)"expectedInjectFileTexts");
        this.assertInjectedContent("injected content expected", ArraysKt.toList((Object[])expectedInjectFileTexts));
    }

    /*
     * WARNING - void declaration
     */
    public final void assertInjectedContent(@NotNull String message, @NotNull List<String> expectedFilesTexts) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        void destination$iv;
        Iterable $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(expectedFilesTexts, (String)"expectedFilesTexts");
        Iterable iterable = this.getAllInjections();
        Collection collection2 = new HashSet();
        String string = message;
        boolean $i$f$mapTo22 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Pair pair = (Pair)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add((PsiFile)it.getSecond());
        }
        $this$mapTo$iv = (Iterable)destination$iv;
        boolean $i$f$map = false;
        void $i$f$mapTo22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiFile psiFile = (PsiFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getText());
        }
        UsefulTestCase.assertSameElements(string, (List)destination$iv$iv, (Collection)expectedFilesTexts);
    }

    public final void assertInjected(InjectionAssertionData ... expectedInjections) {
        Intrinsics.checkNotNullParameter((Object)expectedInjections, (String)"expectedInjections");
        ActionsKt.runReadAction(() -> InjectionTestFixture.assertInjected$lambda$0(expectedInjections, this));
    }

    public final void assertNotInjected(InjectionAssertionData ... notExpectedInjections) {
        Intrinsics.checkNotNullParameter((Object)notExpectedInjections, (String)"notExpectedInjections");
        ActionsKt.runReadAction(() -> InjectionTestFixture.assertNotInjected$lambda$0(notExpectedInjections, this));
    }

    @NotNull
    public final EditorTestFixture openInFragmentEditor() {
        QuickEditHandler quickEditHandler = new QuickEditAction().invokeImpl(this.javaFixture.getProject(), this.getTopLevelEditor(), this.getTopLevelFile());
        Intrinsics.checkNotNull((Object)quickEditHandler);
        return this.openInFragmentEditor(quickEditHandler);
    }

    @NotNull
    public final EditorTestFixture openInFragmentEditor(@NotNull QuickEditHandler quickEditHandler) {
        Editor fragmentEditor;
        Intrinsics.checkNotNullParameter((Object)quickEditHandler, (String)"quickEditHandler");
        PsiFile injectedFile = quickEditHandler.getNewFile();
        Project project = this.javaFixture.getProject();
        PsiElement psiElement = this.getInjectedElement();
        Object object = psiElement != null ? psiElement.getContainingFile() : null;
        Intrinsics.checkNotNull((Object)object);
        DocumentWindow documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)((PsiElement)object));
        int offset = this.getTopLevelEditor().getCaretModel().getOffset();
        int unEscapedOffset = InjectedLanguageUtil.hostToInjectedUnescaped((DocumentWindow)documentWindow, (int)offset);
        Intrinsics.checkNotNull((Object)project);
        FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.Companion.getInstanceEx(project);
        VirtualFile virtualFile = injectedFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Editor editor2 = fragmentEditor = fileEditorManagerEx.openTextEditor(new OpenFileDescriptor(project, virtualFile, unEscapedOffset), true);
        Intrinsics.checkNotNull((Object)editor2);
        return new EditorTestFixture(project, editor2, injectedFile.getVirtualFile());
    }

    @NotNull
    public final PsiFile getTopLevelFile() {
        PsiFile psiFile = this.javaFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile it = psiFile;
        boolean bl = false;
        PsiFile psiFile2 = this.getInjectedLanguageManager().getTopLevelFile((PsiElement)it);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"let(...)");
        return psiFile2;
    }

    public final int getTopLevelCaretPosition() {
        return this.getTopLevelEditor().getCaretModel().getOffset();
    }

    @NotNull
    public final Editor getTopLevelEditor() {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.javaFixture.getProject());
        PsiFile psiFile = this.getTopLevelFile();
        Intrinsics.checkNotNull((Object)psiFile);
        FileEditor fileEditor = fileEditorManager.getSelectedEditor(psiFile.getVirtualFile());
        Intrinsics.checkNotNull((Object)fileEditor, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
        Editor editor2 = ((TextEditor)fileEditor).getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        return editor2;
    }

    private static final void getAllInjections$lambda$0(List $injected, PsiLanguageInjectionHost $host, PsiFile injectedPsi, List list) {
        Intrinsics.checkNotNullParameter((Object)injectedPsi, (String)"injectedPsi");
        Intrinsics.checkNotNullParameter((Object)list, (String)"<unused var>");
        $injected.add(TuplesKt.to((Object)$host, (Object)injectedPsi));
    }

    private static final Unit assertInjected$lambda$0(InjectionAssertionData[] $expectedInjections, InjectionTestFixture this$0) {
        LinkedList expected = (LinkedList)ArraysKt.toCollection((Object[])$expectedInjections, (Collection)new LinkedList());
        LinkedList foundInjections = (LinkedList)CollectionsKt.toCollection((Iterable)this$0.getAllInjections(), (Collection)new LinkedList());
        while (!((Collection)expected).isEmpty()) {
            Pair pair;
            Object v0;
            String injectedLanguage;
            String text2;
            block3: {
                InjectionAssertionData injectionAssertionData = (InjectionAssertionData)expected.pop();
                text2 = injectionAssertionData.component1();
                injectedLanguage = injectionAssertionData.component2();
                Iterable iterable = foundInjections;
                for (Object t : iterable) {
                    Pair pair2 = (Pair)t;
                    boolean bl = false;
                    PsiElement psi = (PsiElement)pair2.component1();
                    PsiFile file = (PsiFile)pair2.component2();
                    if (!(Intrinsics.areEqual((Object)psi.getText(), (Object)text2) && Intrinsics.areEqual((Object)file.getLanguage().getID(), (Object)injectedLanguage))) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            if ((pair = (Pair)v0) == null) {
                Assert.fail((String)("no injection '" + text2 + "' -> '" + injectedLanguage + "' were found, remains: " + CollectionsKt.joinToString$default((Iterable)foundInjections, null, null, null, (int)0, null, InjectionTestFixture::assertInjected$lambda$0$1, (int)31, null) + "   "));
                pair = Unit.INSTANCE;
            }
            Pair found = pair;
            TypeIntrinsics.asMutableCollection((Object)foundInjections).remove(found);
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence assertInjected$lambda$0$1(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        PsiElement psi = (PsiElement)pair.component1();
        PsiFile file = (PsiFile)pair.component2();
        return "'" + psi.getText() + "' -> '" + file.getLanguage() + "'";
    }

    private static final Unit assertNotInjected$lambda$0(InjectionAssertionData[] $notExpectedInjections, InjectionTestFixture this$0) {
        LinkedList notExpected = (LinkedList)ArraysKt.toCollection((Object[])$notExpectedInjections, (Collection)new LinkedList());
        LinkedList foundInjections = (LinkedList)CollectionsKt.toCollection((Iterable)this$0.getAllInjections(), (Collection)new LinkedList());
        while (!((Collection)notExpected).isEmpty()) {
            Pair matchingInjection;
            Object v0;
            String injectedLanguage;
            String text2;
            block2: {
                InjectionAssertionData injectionAssertionData = (InjectionAssertionData)notExpected.pop();
                text2 = injectionAssertionData.component1();
                injectedLanguage = injectionAssertionData.component2();
                Iterable iterable = foundInjections;
                for (Object t : iterable) {
                    Pair pair = (Pair)t;
                    boolean bl = false;
                    PsiElement psi = (PsiElement)pair.component1();
                    PsiFile psiFile = (PsiFile)pair.component2();
                    if (!(Intrinsics.areEqual((Object)psi.getText(), (Object)text2) && Intrinsics.areEqual((Object)psiFile.getLanguage().getID(), (Object)injectedLanguage))) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            if ((matchingInjection = (Pair)v0) == null) continue;
            Assert.fail((String)("not expected injection '" + text2 + "' -> '" + injectedLanguage + "' is found"));
        }
        return Unit.INSTANCE;
    }
}

