/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests.bazel;

import com.intellij.tests.bazel.TestData;
import com.intellij.tests.bazel.TestSuiteXmlRenderer;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class BazelJUnitOutputListener
implements TestExecutionListener,
Closeable {
    public static final Logger LOG = Logger.getLogger(BazelJUnitOutputListener.class.getName());
    private final XMLStreamWriter xml;
    private static final Set<String> SegmentClassTypes = Set.of("class", "nested-class");
    private final Object resultsLock = new Object();
    private final Map<UniqueId, TestData> results = new ConcurrentHashMap<UniqueId, TestData>();
    private TestPlan testPlan;
    private final AtomicBoolean hasClosed = new AtomicBoolean();
    private final AtomicBoolean wasInterrupted = new AtomicBoolean();

    public BazelJUnitOutputListener(Path xmlOut) {
        try {
            Files.createDirectories(xmlOut.getParent(), new FileAttribute[0]);
            this.xml = XMLOutputFactory.newFactory().createXMLStreamWriter(new LazyFileWriter(xmlOut));
            this.xml.writeStartDocument("UTF-8", "1.0");
        }
        catch (IOException | XMLStreamException e) {
            throw new IllegalStateException("Unable to create output file", e);
        }
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = testPlan;
        try {
            this.xml.writeStartElement("testsuites");
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        if (this.testPlan == null) {
            throw new IllegalStateException("Test plan is not currently executing");
        }
        try {
            this.xml.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        this.testPlan = null;
    }

    private Map<TestData, List<TestData>> matchTestCasesToSuites_locked(List<TestData> testCases, boolean includeIncompleteTests) {
        HashMap<TestData, List<TestData>> knownSuites = new HashMap<TestData, List<TestData>>();
        for (TestData testCase : testCases) {
            if (!testCase.getId().isTest() || !includeIncompleteTests && testCase.getDuration() == null) continue;
            Optional<TestData> parent = testCase.getId().getParentIdObject().map(this.results::get);
            List segments = testCase.getId().getUniqueIdObject().getSegments();
            for (int i = segments.size() - 2; i >= 0 && !SegmentClassTypes.contains(((UniqueId.Segment)segments.get(i)).getType()) && !parent.isEmpty(); --i) {
                parent = parent.get().getId().getParentIdObject().map(this.results::get);
            }
            knownSuites.computeIfAbsent(parent.orElse(testCase), id -> new ArrayList()).add(testCase);
        }
        return knownSuites;
    }

    private List<TestData> findTestCases_locked(String engineId) {
        return this.results.values().stream().filter(result -> !this.testPlan.getRoots().contains(result.getId())).filter(result -> {
            if (engineId == null) return true;
            if (result.getId().getUniqueIdObject().getEngineId().map(engineId::equals).orElse(false) == false) return false;
            return true;
        }).collect(Collectors.toList());
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        this.getResult(testIdentifier).setDynamic(true);
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.getResult(testIdentifier).mark(TestExecutionResult.aborted(null)).skipReason(reason);
        this.outputIfTestRootIsComplete(testIdentifier);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        this.getResult(testIdentifier).started();
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        this.getResult(testIdentifier).mark(testExecutionResult);
        this.outputIfTestRootIsComplete(testIdentifier);
    }

    private void outputIfTestRootIsComplete(TestIdentifier testIdentifier) {
        if (!this.testPlan.getRoots().contains(testIdentifier)) {
            return;
        }
        this.output(false, testIdentifier.getUniqueIdObject().getEngineId().orElse(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void output(boolean includeIncompleteTests, String engineId) {
        Object object = this.resultsLock;
        synchronized (object) {
            List<TestData> testCases = this.findTestCases_locked(engineId);
            Map<TestData, List<TestData>> testSuites = this.matchTestCasesToSuites_locked(testCases, includeIncompleteTests);
            try {
                for (Map.Entry<TestData, List<TestData>> suiteAndTests : testSuites.entrySet()) {
                    TestData suite = suiteAndTests.getKey();
                    List<TestData> tests = suiteAndTests.getValue();
                    if (suite.getResult() != null && suite.getResult().getStatus() != TestExecutionResult.Status.SUCCESSFUL) {
                        this.getTestsFromSuite(suite.getId()).forEach(testIdentifier -> {
                            TestData test = this.results.get(testIdentifier.getUniqueIdObject());
                            if (test == null) {
                                test = this.getResult((TestIdentifier)testIdentifier);
                                tests.add(test);
                            }
                            test.mark(suite.getResult()).skipReason(suite.getSkipReason());
                        });
                    }
                    new TestSuiteXmlRenderer(this.testPlan).toXml(this.xml, suite, tests);
                }
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
            Stream.concat(testCases.stream(), testSuites.keySet().stream()).forEach(data -> this.results.remove(data.getId().getUniqueIdObject()));
        }
    }

    private List<TestIdentifier> getTestsFromSuite(TestIdentifier suiteIdentifier) {
        return this.testPlan.getChildren(suiteIdentifier).stream().flatMap(testIdentifier -> {
            if (testIdentifier.isContainer()) {
                return this.getTestsFromSuite((TestIdentifier)testIdentifier).stream();
            }
            return Stream.of(testIdentifier);
        }).collect(Collectors.toList());
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        this.getResult(testIdentifier).addReportEntry(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestData getResult(TestIdentifier id) {
        Object object = this.resultsLock;
        synchronized (object) {
            return this.results.computeIfAbsent(id.getUniqueIdObject(), ignored -> new TestData(id));
        }
    }

    public void closeForInterrupt() {
        this.wasInterrupted.set(true);
        this.close();
    }

    @Override
    public void close() {
        if (this.hasClosed.getAndSet(true)) {
            return;
        }
        if (this.wasInterrupted.get()) {
            this.output(true, null);
        }
        try {
            this.xml.writeEndDocument();
            this.xml.close();
        }
        catch (XMLStreamException e) {
            LOG.log(Level.SEVERE, "Unable to close xml output", e);
        }
    }

    static class LazyFileWriter
    extends Writer {
        private final Path path;
        private BufferedWriter delegate;
        private boolean isCreated = false;

        public LazyFileWriter(Path path) {
            this.path = path;
        }

        private void createWriterIfNeeded() throws IOException {
            if (!this.isCreated) {
                this.delegate = Files.newBufferedWriter(this.path, StandardCharsets.UTF_8, new OpenOption[0]);
                this.isCreated = true;
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.createWriterIfNeeded();
            this.delegate.write(cbuf, off, len);
        }

        @Override
        public void flush() throws IOException {
            if (this.isCreated) {
                this.delegate.flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.isCreated) {
                this.delegate.close();
            }
        }
    }
}

