/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vcs.changes.ignore.cache.PatternCache;
import com.intellij.openapi.vcs.changes.ignore.util.RegexUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\b\u0001\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b\f\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\b\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/cache/IgnorePatternsMatchedFilesCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "projectFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "dispose", "", "getFilesForPattern", "pattern", "Ljava/util/regex/Pattern;", "runSearchRequest", "key", "doSearch", "", "Companion", "intellij.platform.vcs.impl"})
public final class IgnorePatternsMatchedFilesCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ProjectFileIndex projectFileIndex;
    @NotNull
    private final Cache<String, Collection<VirtualFile>> cache;
    @NotNull
    private final MergingUpdateQueue updateQueue;

    public IgnorePatternsMatchedFilesCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        this.projectFileIndex = projectFileIndex;
        Cache cache = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
        this.updateQueue = new MergingUpdateQueue("IgnorePatternsMatchedFilesCacheUpdateQueue", 500, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD, null, 128, null);
        MessageBusConnection messageBusConnection2 = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection2.subscribe(topic, (Object)new BulkFileListener(){

            public void after(List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                if (cache.estimatedSize() == 0L) {
                    return;
                }
                for (VFileEvent vFileEvent : events) {
                    if (vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFileDeleteEvent || vFileEvent instanceof VFileCopyEvent) {
                        String string = vFileEvent.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        this.cleanupCache(string);
                        continue;
                    }
                    if (vFileEvent instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)vFileEvent).isRename()) {
                        String string = ((VFilePropertyChangeEvent)vFileEvent).getOldPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOldPath(...)");
                        this.cleanupCache(string);
                        String string2 = ((VFilePropertyChangeEvent)vFileEvent).getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                        this.cleanupCache(string2);
                        continue;
                    }
                    if (!(vFileEvent instanceof VFileMoveEvent)) continue;
                    String string = ((VFileMoveEvent)vFileEvent).getOldPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOldPath(...)");
                    this.cleanupCache(string);
                    String string3 = ((VFileMoveEvent)vFileEvent).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                    this.cleanupCache(string3);
                }
            }

            private final void cleanupCache(String path) {
                ConcurrentMap concurrentMap = cache.asMap();
                Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"asMap(...)");
                ConcurrentMap cacheMap = concurrentMap;
                PatternCache globCache = PatternCache.getInstance(project);
                for (String key : cacheMap.keySet()) {
                    String[] parts;
                    Pattern pattern;
                    if (globCache.getPattern(key) == null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)RegexUtil.getParts(pattern), (String)"getParts(...)");
                    if (!RegexUtil.matchAnyPart(parts, path)) continue;
                    cacheMap.remove(key);
                }
            }
        });
    }

    public void dispose() {
        this.cache.invalidateAll();
        this.updateQueue.cancelAllUpdates();
    }

    @NotNull
    public final Collection<VirtualFile> getFilesForPattern(@NotNull Pattern pattern) {
        Collection files;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String string = pattern.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String key = string;
        Collection collection = (Collection)this.cache.getIfPresent((Object)key);
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        if ((files = collection).isEmpty()) {
            this.runSearchRequest(key, pattern);
        }
        return files;
    }

    private final void runSearchRequest(String key, Pattern pattern) {
        Project project = this.project;
        this.updateQueue.queue((Update)new DisposableUpdate(key, this, pattern, project){
            final /* synthetic */ String $key;
            final /* synthetic */ IgnorePatternsMatchedFilesCache this$0;
            final /* synthetic */ Pattern $pattern;
            {
                this.$key = $key;
                this.this$0 = $receiver;
                this.$pattern = $pattern;
                super((Disposable)$super_call_param$1, (Object)$key);
            }

            public boolean canEat(Update update2) {
                Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
                return true;
            }

            protected void doRun() {
                IgnorePatternsMatchedFilesCache.access$getCache$p(this.this$0).put((Object)this.$key, (Object)IgnorePatternsMatchedFilesCache.access$doSearch(this.this$0, this.$pattern));
            }
        });
    }

    private final Set<VirtualFile> doSearch(Pattern pattern) {
        HashSet files = new HashSet(1000);
        String[] stringArray = RegexUtil.getParts(pattern);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getParts(...)");
        String[] parts = stringArray;
        if (parts.length == 0) {
            return files;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        GlobalSearchScope projectScope = globalSearchScope;
        this.projectFileIndex.iterateContent(arg_0 -> IgnorePatternsMatchedFilesCache.doSearch$lambda$0(parts, files, projectScope, arg_0));
        return files;
    }

    private static final boolean doSearch$lambda$0(String[] $parts, HashSet $files, GlobalSearchScope $projectScope, VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        ProgressManager.checkCanceled();
        String string = fileOrDir.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        if (RegexUtil.matchAnyPart($parts, name)) {
            for (VirtualFile file : (Collection)ActionsKt.runReadAction(() -> IgnorePatternsMatchedFilesCache.doSearch$lambda$0$0(name, $projectScope))) {
                if (!file.isValid() || !RegexUtil.matchAllParts($parts, file.getPath())) continue;
                $files.add(file);
            }
        }
        return true;
    }

    private static final Collection doSearch$lambda$0$0(String $name, GlobalSearchScope $projectScope) {
        return FilenameIndex.getVirtualFilesByName((String)$name, (GlobalSearchScope)$projectScope);
    }

    @JvmStatic
    @NotNull
    public static final IgnorePatternsMatchedFilesCache getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Set access$doSearch(IgnorePatternsMatchedFilesCache $this, Pattern pattern) {
        return $this.doSearch(pattern);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/cache/IgnorePatternsMatchedFilesCache$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/vcs/changes/ignore/cache/IgnorePatternsMatchedFilesCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IgnorePatternsMatchedFilesCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(IgnorePatternsMatchedFilesCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (IgnorePatternsMatchedFilesCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

