/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserConflictsNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLocallyDeletedNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLockedFoldersNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLogicallyLockedFile;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserSpecificFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserStringNode;
import com.intellij.openapi.vcs.changes.ui.ModifiedWithoutEditingNode;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.merge.MergeConflictManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.vcs.impl.shared.changes.ChangesViewModelBuilderService;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.tree.MutableTreeNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J<\u0010\u0006\u001a\u00020\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u0010\u0012\u0006\b\u0001\u0012\u00020\u0010\u0018\u00010\u000fH\u0016J\f\u0010\u0011\u001a\u00020\u0007*\u00020\bH\u0016J\u0018\u0010\u0012\u001a\u00020\b*\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u001e\u0010\u0016\u001a\u00020\b*\u00020\b2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00150\u0018J\u0018\u0010\u001a\u001a\u00020\b*\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\nJ \u0010\u001d\u001a\u00020\b*\u00020\b2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u001fJ\u0018\u0010 \u001a\u00020\b*\u00020\b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u001e\u0010\"\u001a\u00020\b*\u00020\b2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020$0\u001fJ.\u0010%\u001a\u00020\u0007*\u00020\b2\u0006\u0010&\u001a\u00020\u000b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00142\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/BackendChangesViewModelBuilderService;", "Lcom/intellij/platform/vcs/impl/shared/changes/ChangesViewModelBuilderService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "setChangeList", "", "Lcom/intellij/openapi/vcs/changes/ui/TreeModelBuilder;", "changeLists", "", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "skipSingleDefaultChangeList", "", "changeDecoratorProvider", "Ljava/util/function/Function;", "Lcom/intellij/openapi/vcs/changes/ui/ChangeNodeDecorator;", "createNodes", "setModifiedWithoutEditing", "modifiedWithoutEditing", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "setSwitchedFiles", "switchedFiles", "Lcom/intellij/util/containers/MultiMap;", "", "setLocallyDeletedPaths", "locallyDeletedChanges", "Lcom/intellij/openapi/vcs/changes/LocallyDeletedChange;", "setSwitchedRoots", "switchedRoots", "", "setLockedFolders", "lockedFolders", "setLogicallyLockedFiles", "logicallyLockedFiles", "Lcom/intellij/openapi/vcs/changes/LogicalLock;", "insertResolvedUnchangedNodes", "list", "resolvedUnchangedFilePaths", "Lcom/intellij/openapi/vcs/FilePath;", "changesParent", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nBackendChangesViewModelBuilderService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendChangesViewModelBuilderService.kt\ncom/intellij/openapi/vcs/changes/ui/BackendChangesViewModelBuilderService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1878#2,3:160\n*S KotlinDebug\n*F\n+ 1 BackendChangesViewModelBuilderService.kt\ncom/intellij/openapi/vcs/changes/ui/BackendChangesViewModelBuilderService\n*L\n40#1:160,3\n*E\n"})
public final class BackendChangesViewModelBuilderService
implements ChangesViewModelBuilderService {
    @NotNull
    private final Project project;

    public BackendChangesViewModelBuilderService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    public void setChangeList(@NotNull TreeModelBuilder $this$setChangeList, @NotNull Collection<? extends ChangeList> changeLists2, boolean skipSingleDefaultChangeList, @Nullable Function<? super ChangeNodeDecorator, ? extends ChangeNodeDecorator> changeDecoratorProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$setChangeList, (String)"<this>");
        Intrinsics.checkNotNullParameter(changeLists2, (String)"changeLists");
        List resolvedUnchangedFiles = CollectionsKt.toMutableList((Collection)MergeConflictManager.Companion.getInstance(this.project).getResolvedConflictPaths());
        RemoteRevisionsCache revisionsCache = RemoteRevisionsCache.getInstance(this.project);
        boolean skipChangeListNode = skipSingleDefaultChangeList && TreeModelBuilder.isSingleBlankChangeList(changeLists2);
        ChangesBrowserConflictsNode conflictsRoot = null;
        for (ChangeList changeList : changeLists2) {
            ChangesBrowserNode changesBrowserNode;
            Collection collection = changeList.getChanges();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChanges(...)");
            Iterable iterable = collection;
            Comparator comparator = TreeModelBuilder.CHANGE_COMPARATOR;
            Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"CHANGE_COMPARATOR");
            List changes = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
            ChangeListRemoteState listRemoteState = new ChangeListRemoteState();
            if (skipChangeListNode) {
                ChangesBrowserNode changesBrowserNode2 = $this$setChangeList.myRoot;
                changesBrowserNode = changesBrowserNode2;
                Intrinsics.checkNotNullExpressionValue((Object)changesBrowserNode2, (String)"myRoot");
            } else {
                ChangesBrowserChangeListNode changesBrowserChangeListNode;
                ChangesBrowserChangeListNode listNode = changesBrowserChangeListNode = new ChangesBrowserChangeListNode(this.project, changeList, listRemoteState);
                boolean bl = false;
                listNode.markAsHelperNode();
                $this$setChangeList.insertSubtreeRoot((ChangesBrowserNode)listNode);
                changesBrowserNode = changesBrowserChangeListNode;
            }
            ChangesBrowserNode changesParent = changesBrowserNode;
            Iterable $this$forEachIndexed$iv = changes;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                FilePath path;
                void change;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Change change2 = (Change)item$iv;
                int i = n;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)revisionsCache);
                RemoteStatusChangeNodeDecorator baseDecorator = new RemoteStatusChangeNodeDecorator(revisionsCache, listRemoteState, i);
                ChangeNodeDecorator changeNodeDecorator = changeDecoratorProvider;
                if (changeNodeDecorator == null || (changeNodeDecorator = (ChangeNodeDecorator)changeNodeDecorator.apply(baseDecorator)) == null) {
                    changeNodeDecorator = baseDecorator;
                }
                ChangeNodeDecorator decorator = changeNodeDecorator;
                Intrinsics.checkNotNullExpressionValue((Object)ChangesUtil.getFilePath((Change)change), (String)"getFilePath(...)");
                if (MergeConflictManager.Companion.getInstance(this.project).isResolvedConflict(path)) {
                    resolvedUnchangedFiles.remove(path);
                    $this$setChangeList.insertChangeNode((Change)change, changesParent, $this$setChangeList.createChangeNode((Change)change, decorator));
                    continue;
                }
                FileStatus fileStatus = change.getFileStatus();
                Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getFileStatus(...)");
                if (MergeConflictManager.Companion.isMergeConflict(fileStatus)) {
                    if (conflictsRoot == null) {
                        conflictsRoot = new ChangesBrowserConflictsNode(this.project);
                        conflictsRoot.markAsHelperNode();
                        $this$setChangeList.myModel.insertNodeInto((MutableTreeNode)conflictsRoot, (MutableTreeNode)$this$setChangeList.myRoot, $this$setChangeList.myModel.getChildCount($this$setChangeList.myRoot));
                    }
                    $this$setChangeList.insertChangeNode((Change)change, (ChangesBrowserNode)conflictsRoot, $this$setChangeList.createChangeNode((Change)change, decorator));
                    continue;
                }
                $this$setChangeList.insertChangeNode((Change)change, changesParent, $this$setChangeList.createChangeNode((Change)change, decorator));
            }
            this.insertResolvedUnchangedNodes($this$setChangeList, changeList, resolvedUnchangedFiles, changesParent);
        }
    }

    public void createNodes(@NotNull TreeModelBuilder $this$createNodes) {
        Intrinsics.checkNotNullParameter((Object)$this$createNodes, (String)"<this>");
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.project);
        List<LocallyDeletedChange> list = changeListManager.getDeletedFiles();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDeletedFiles(...)");
        TreeModelBuilder treeModelBuilder = this.setLocallyDeletedPaths($this$createNodes, (Collection<? extends LocallyDeletedChange>)list);
        List<VirtualFile> list2 = changeListManager.getModifiedWithoutEditing();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getModifiedWithoutEditing(...)");
        TreeModelBuilder treeModelBuilder2 = this.setModifiedWithoutEditing(treeModelBuilder, list2);
        MultiMap<String, VirtualFile> multiMap = changeListManager.getSwitchedFilesMap();
        Intrinsics.checkNotNullExpressionValue(multiMap, (String)"getSwitchedFilesMap(...)");
        TreeModelBuilder treeModelBuilder3 = this.setSwitchedRoots(this.setSwitchedFiles(treeModelBuilder2, multiMap), changeListManager.getSwitchedRoots());
        List<VirtualFile> list3 = changeListManager.getLockedFolders();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getLockedFolders(...)");
        TreeModelBuilder treeModelBuilder4 = this.setLockedFolders(treeModelBuilder3, list3);
        Map<VirtualFile, LogicalLock> map = changeListManager.getLogicallyLockedFolders();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getLogicallyLockedFolders(...)");
        this.setLogicallyLockedFiles(treeModelBuilder4, map);
    }

    @NotNull
    public final TreeModelBuilder setModifiedWithoutEditing(@NotNull TreeModelBuilder $this$setModifiedWithoutEditing, @NotNull List<? extends VirtualFile> modifiedWithoutEditing) {
        Intrinsics.checkNotNullParameter((Object)$this$setModifiedWithoutEditing, (String)"<this>");
        Intrinsics.checkNotNullParameter(modifiedWithoutEditing, (String)"modifiedWithoutEditing");
        if (ContainerUtil.isEmpty((Collection)modifiedWithoutEditing)) {
            return $this$setModifiedWithoutEditing;
        }
        ModifiedWithoutEditingNode node = new ModifiedWithoutEditingNode(this.project, modifiedWithoutEditing);
        TreeModelBuilder treeModelBuilder = $this$setModifiedWithoutEditing.insertSpecificFileNodeToModel(modifiedWithoutEditing, (ChangesBrowserSpecificFilesNode)node);
        Intrinsics.checkNotNullExpressionValue((Object)treeModelBuilder, (String)"insertSpecificFileNodeToModel(...)");
        return treeModelBuilder;
    }

    @NotNull
    public final TreeModelBuilder setSwitchedFiles(@NotNull TreeModelBuilder $this$setSwitchedFiles, @NotNull MultiMap<String, VirtualFile> switchedFiles) {
        Intrinsics.checkNotNullParameter((Object)$this$setSwitchedFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter(switchedFiles, (String)"switchedFiles");
        if (switchedFiles.isEmpty()) {
            return $this$setSwitchedFiles;
        }
        ChangesBrowserNode changesBrowserNode = $this$setSwitchedFiles.createTagNode(ChangesBrowserNode.SWITCHED_FILES_TAG);
        Intrinsics.checkNotNullExpressionValue((Object)changesBrowserNode, (String)"createTagNode(...)");
        ChangesBrowserNode subtreeRoot = changesBrowserNode;
        for (String branchName : switchedFiles.keySet()) {
            Collection collection = switchedFiles.get((Object)branchName);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            Iterable iterable = collection;
            Comparator comparator = TreeModelBuilder.FILE_COMPARATOR;
            Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"FILE_COMPARATOR");
            List switchedFileList = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
            if (switchedFileList.isEmpty()) continue;
            ChangesBrowserStringNode branchNode = new ChangesBrowserStringNode(branchName);
            branchNode.markAsHelperNode();
            $this$setSwitchedFiles.insertSubtreeRoot((ChangesBrowserNode)branchNode, subtreeRoot);
            for (VirtualFile file : switchedFileList) {
                $this$setSwitchedFiles.insertChangeNode(file, (ChangesBrowserNode)branchNode, ChangesBrowserNode.createFile((Project)this.project, (VirtualFile)file));
            }
        }
        return $this$setSwitchedFiles;
    }

    @NotNull
    public final TreeModelBuilder setLocallyDeletedPaths(@NotNull TreeModelBuilder $this$setLocallyDeletedPaths, @NotNull Collection<? extends LocallyDeletedChange> locallyDeletedChanges) {
        Intrinsics.checkNotNullParameter((Object)$this$setLocallyDeletedPaths, (String)"<this>");
        Intrinsics.checkNotNullParameter(locallyDeletedChanges, (String)"locallyDeletedChanges");
        if (locallyDeletedChanges.isEmpty()) {
            return $this$setLocallyDeletedPaths;
        }
        ChangesBrowserNode changesBrowserNode = $this$setLocallyDeletedPaths.createTagNode(ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG);
        Intrinsics.checkNotNullExpressionValue((Object)changesBrowserNode, (String)"createTagNode(...)");
        ChangesBrowserNode subtreeRoot = changesBrowserNode;
        Iterable iterable = locallyDeletedChanges;
        Comparator comparator = TreeModelBuilder.PATH_COMPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"PATH_COMPARATOR");
        Comparator comparator2 = comparator;
        for (LocallyDeletedChange change : CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(comparator2){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                LocallyDeletedChange locallyDeletedChange = (LocallyDeletedChange)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                LocallyDeletedChange it = (LocallyDeletedChange)b;
                FilePath filePath = it.getPath();
                bl = false;
                FilePath filePath2 = it.getPath();
                return comparator.compare(filePath, filePath2);
            }
        })) {
            $this$setLocallyDeletedPaths.insertChangeNode(change.getPath(), subtreeRoot, (ChangesBrowserNode)new ChangesBrowserLocallyDeletedNode(change));
        }
        return $this$setLocallyDeletedPaths;
    }

    @NotNull
    public final TreeModelBuilder setSwitchedRoots(@NotNull TreeModelBuilder $this$setSwitchedRoots, @Nullable Map<VirtualFile, String> switchedRoots) {
        Intrinsics.checkNotNullParameter((Object)$this$setSwitchedRoots, (String)"<this>");
        if (switchedRoots == null || switchedRoots.isEmpty()) {
            return $this$setSwitchedRoots;
        }
        ChangesBrowserNode changesBrowserNode = $this$setSwitchedRoots.createTagNode(ChangesBrowserNode.SWITCHED_ROOTS_TAG, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES, true);
        Intrinsics.checkNotNullExpressionValue((Object)changesBrowserNode, (String)"createTagNode(...)");
        ChangesBrowserNode rootsHeadNode = changesBrowserNode;
        Comparator comparator = TreeModelBuilder.FILE_COMPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"FILE_COMPARATOR");
        for (Map.Entry entry : ((Map)MapsKt.toSortedMap(switchedRoots, (Comparator)comparator)).entrySet()) {
            VirtualFile vf = (VirtualFile)entry.getKey();
            String branchName = (String)entry.getValue();
            CurrentContentRevision cr = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)vf));
            Change change = new Change((ContentRevision)cr, (ContentRevision)cr, FileStatus.NOT_CHANGED);
            $this$setSwitchedRoots.insertChangeNode(vf, rootsHeadNode, $this$setSwitchedRoots.createChangeNode(change, new ChangeNodeDecorator(branchName){
                final /* synthetic */ String $branchName;
                {
                    this.$branchName = $branchName;
                }

                public void decorate(Change change1, SimpleColoredComponent component, boolean isShowFlatten) {
                    Intrinsics.checkNotNullParameter((Object)change1, (String)"change1");
                    Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                }

                public void preDecorate(Change change1, ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
                    Intrinsics.checkNotNullParameter((Object)change1, (String)"change1");
                    Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
                    renderer.append("[" + this.$branchName + "] ", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                }
            }));
        }
        return $this$setSwitchedRoots;
    }

    @NotNull
    public final TreeModelBuilder setLockedFolders(@NotNull TreeModelBuilder $this$setLockedFolders, @NotNull List<? extends VirtualFile> lockedFolders) {
        Intrinsics.checkNotNullParameter((Object)$this$setLockedFolders, (String)"<this>");
        Intrinsics.checkNotNullParameter(lockedFolders, (String)"lockedFolders");
        if (lockedFolders.isEmpty()) {
            return $this$setLockedFolders;
        }
        $this$setLockedFolders.insertFilesIntoNode((Collection)lockedFolders, (ChangesBrowserNode)new ChangesBrowserLockedFoldersNode(this.project));
        return $this$setLockedFolders;
    }

    @NotNull
    public final TreeModelBuilder setLogicallyLockedFiles(@NotNull TreeModelBuilder $this$setLogicallyLockedFiles, @NotNull Map<VirtualFile, LogicalLock> logicallyLockedFiles) {
        Intrinsics.checkNotNullParameter((Object)$this$setLogicallyLockedFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter(logicallyLockedFiles, (String)"logicallyLockedFiles");
        if (logicallyLockedFiles.isEmpty()) {
            return $this$setLogicallyLockedFiles;
        }
        ChangesBrowserNode changesBrowserNode = $this$setLogicallyLockedFiles.createTagNode(ChangesBrowserNode.LOGICALLY_LOCKED_TAG);
        Intrinsics.checkNotNullExpressionValue((Object)changesBrowserNode, (String)"createTagNode(...)");
        ChangesBrowserNode subtreeRoot = changesBrowserNode;
        Comparator comparator = TreeModelBuilder.FILE_COMPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"FILE_COMPARATOR");
        for (Map.Entry entry : ((Map)MapsKt.toSortedMap(logicallyLockedFiles, (Comparator)comparator)).entrySet()) {
            VirtualFile file = (VirtualFile)entry.getKey();
            LogicalLock lock = (LogicalLock)entry.getValue();
            $this$setLogicallyLockedFiles.insertChangeNode(file, subtreeRoot, (ChangesBrowserNode)new ChangesBrowserLogicallyLockedFile(this.project, file, lock));
        }
        return $this$setLogicallyLockedFiles;
    }

    private final void insertResolvedUnchangedNodes(TreeModelBuilder $this$insertResolvedUnchangedNodes, ChangeList list, List<? extends FilePath> resolvedUnchangedFilePaths, ChangesBrowserNode<?> changesParent) {
        if (resolvedUnchangedFilePaths.isEmpty()) {
            return;
        }
        if (list instanceof LocalChangeList && ((LocalChangeList)list).isDefault()) {
            for (FilePath filePath : resolvedUnchangedFilePaths) {
                $this$insertResolvedUnchangedNodes.insertChangeNode(filePath, changesParent, ChangesBrowserNode.createFilePath((FilePath)filePath, (FileStatus)FileStatus.MERGE));
            }
        }
    }
}

