/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListDataKt;
import com.intellij.openapi.vcs.changes.ChangeListDecorator;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.platform.vcs.changes.ChangeListManagerState;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserChangeListNode
extends ChangesBrowserNode<ChangeList> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ChangeListManagerEx myClManager;
    @NotNull
    private final ChangeListRemoteState myChangeListRemoteState;

    public ChangesBrowserChangeListNode(@NotNull Project project, @NotNull ChangeList userObject, @NotNull ChangeListRemoteState changeListRemoteState) {
        if (project == null) {
            ChangesBrowserChangeListNode.$$$reportNull$$$0(0);
        }
        if (userObject == null) {
            ChangesBrowserChangeListNode.$$$reportNull$$$0(1);
        }
        if (changeListRemoteState == null) {
            ChangesBrowserChangeListNode.$$$reportNull$$$0(2);
        }
        super((Object)userObject);
        this.myProject = project;
        this.myChangeListRemoteState = changeListRemoteState;
        this.myClManager = ChangeListManagerEx.getInstanceEx(project);
    }

    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Object object;
        if (renderer == null) {
            ChangesBrowserChangeListNode.$$$reportNull$$$0(3);
        }
        if ((object = this.userObject) instanceof LocalChangeList) {
            LocalChangeList list = (LocalChangeList)object;
            String listName = list.getName();
            if (StringUtil.isEmptyOrSpaces((String)listName)) {
                listName = VcsBundle.message((String)"changes.nodetitle.empty.changelist.name", (Object[])new Object[0]);
            }
            renderer.appendTextWithIssueLinks(listName, list.isDefault() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
            if (ChangeListDataKt.getChangeListData((LocalChangeList)list) != null) {
                renderer.append(" (i)", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                renderer.setToolTipText(this.getTooltipText());
            }
            this.appendCount((ColoredTreeCellRenderer)renderer);
            for (ChangeListDecorator decorator : ChangeListDecorator.getDecorators((Project)this.myProject)) {
                decorator.decorateChangeList(list, (ColoredTreeCellRenderer)renderer, selected, expanded, hasFocus);
            }
            ChangeListManagerState clManagerState = this.myClManager.getChangeListManagerState();
            if (clManagerState instanceof ChangeListManagerState.Frozen) {
                ChangeListManagerState.Frozen frozen = (ChangeListManagerState.Frozen)clManagerState;
                renderer.append(FontUtil.spaceAndThinSpace() + frozen.getReason(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else if (clManagerState instanceof ChangeListManagerState.Updating) {
                this.appendUpdatingState(renderer);
            }
            if (!this.myChangeListRemoteState.allUpToDate()) {
                renderer.append(FontUtil.spaceAndThinSpace());
                renderer.append(VcsBundle.message((String)"changes.nodetitle.have.outdated.files", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        } else {
            renderer.append(((ChangeList)this.getUserObject()).getName(), SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
            this.appendCount((ColoredTreeCellRenderer)renderer);
        }
    }

    @NlsContexts.Tooltip
    @Nullable
    private String getTooltipText() {
        if (!(this.userObject instanceof LocalChangeList)) {
            return null;
        }
        ChangeListData data = ChangeListDataKt.getChangeListData((LocalChangeList)((LocalChangeList)this.userObject));
        if (data == null) {
            return null;
        }
        String dataInfo = data.getPresentation();
        String message = ChangesBrowserChangeListNode.cropMessageIfNeeded(((LocalChangeList)this.userObject).getComment());
        @Nls StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmpty((String)dataInfo)) {
            sb.append(dataInfo);
        }
        if (!StringUtil.isEmpty((String)message)) {
            if (!sb.isEmpty()) {
                sb.append("<br/>").append("<br/>");
            }
            sb.append(message);
        }
        return StringUtil.nullize((String)sb.toString());
    }

    @Nullable
    private static String cropMessageIfNeeded(@Nullable String comment) {
        if (comment == null) {
            return null;
        }
        Object[] lines = StringUtil.splitByLines((String)XmlStringUtil.escapeString((String)comment), (boolean)false);
        String croppedMessage = ((StreamEx)StreamEx.of((Object[])lines).limit(5L)).joining((CharSequence)"<br/>");
        return lines.length > 5 ? croppedMessage + "..." : croppedMessage;
    }

    public String getTextPresentation() {
        return ((ChangeList)this.getUserObject()).getName().trim();
    }

    @ApiStatus.Internal
    public boolean canAcceptDrop(ChangeListDragBean dragBean) {
        List changes = dragBean.getChanges();
        for (Change change : ((ChangeList)this.getUserObject()).getChanges()) {
            for (Change incomingChange : changes) {
                if (change != incomingChange) continue;
                return false;
            }
        }
        return true;
    }

    @ApiStatus.Internal
    public void acceptDrop(ChangeListOwner dragOwner, ChangeListDragBean dragBean) {
        if (!(this.userObject instanceof LocalChangeList)) {
            return;
        }
        LocalChangeList dropList = (LocalChangeList)this.getUserObject();
        dragOwner.moveChangesTo(dropList, dragBean.getChanges());
        ArrayList toUpdate = new ArrayList();
        ChangesBrowserChangeListNode.addIfNotNull(toUpdate, dragBean.getUnversionedFiles());
        ChangesBrowserChangeListNode.addIfNotNull(toUpdate, dragBean.getIgnoredFiles());
        if (!toUpdate.isEmpty()) {
            dragOwner.addUnversionedFiles(dropList, ContainerUtil.mapNotNull(toUpdate, FilePath::getVirtualFile));
        }
    }

    private static void addIfNotNull(List<? super FilePath> unversionedFiles, List<? extends FilePath> ignoredFiles) {
        if (ignoredFiles != null) {
            unversionedFiles.addAll(ignoredFiles);
        }
    }

    public int getSortWeight() {
        if (this.userObject instanceof LocalChangeList && ((LocalChangeList)this.userObject).isDefault()) {
            return 1;
        }
        return 2;
    }

    public int compareUserObjects(ChangeList o2) {
        return ChangesBrowserChangeListNode.compareFileNames((String)((ChangeList)this.getUserObject()).getName(), (String)o2.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListRemoteState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserChangeListNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

