/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.dnd.DnDAware;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.VcsCurrentRevisionProxy;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserResolvedConflictsNodeKt;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vcs.merge.MergeConflictManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.commit.EditedCommitNode;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangesListView
extends ChangesTree
implements DnDAware {
    private static final Logger LOG = Logger.getInstance(ChangesListView.class);
    @NonNls
    public static final String HELP_ID = "ideaInterface.changes";
    @NonNls
    public static final DataKey<ChangesListView> DATA_KEY = DataKey.create((String)"ChangeListView");
    @NonNls
    public static final DataKey<Iterable<FilePath>> UNVERSIONED_FILE_PATHS_DATA_KEY = DataKey.create((String)"ChangeListView.UnversionedFiles");
    @NonNls
    public static final DataKey<Iterable<VirtualFile>> EXACTLY_SELECTED_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.ExactlySelectedFiles");
    @NonNls
    public static final DataKey<Iterable<FilePath>> IGNORED_FILE_PATHS_DATA_KEY = DataKey.create((String)"ChangeListView.IgnoredFiles");
    @NonNls
    public static final DataKey<Iterable<VirtualFile>> MODIFIED_WITHOUT_EDITING_DATA_KEY = DataKey.create((String)"ChangeListView.ModifiedWithoutEditing");
    @NonNls
    public static final DataKey<List<FilePath>> MISSING_FILES_DATA_KEY = DataKey.create((String)"ChangeListView.MissingFiles");
    @NonNls
    public static final DataKey<List<LocallyDeletedChange>> LOCALLY_DELETED_CHANGES = DataKey.create((String)"ChangeListView.LocallyDeletedChanges");
    private boolean myBusy;

    public ChangesListView(@NotNull Project project, boolean showCheckboxes) {
        if (project == null) {
            ChangesListView.$$$reportNull$$$0(0);
        }
        super(project, showCheckboxes, true, true, true);
        this.myBusy = false;
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.setDragEnabled(true);
        }
    }

    public int getToggleClickCount() {
        return 2;
    }

    public void setPaintBusy(boolean paintBusy) {
        this.myBusy = paintBusy;
        super.setPaintBusy(paintBusy);
    }

    protected boolean isEmptyTextVisible() {
        return super.isEmptyTextVisible() && !this.myBusy;
    }

    protected boolean isInclusionVisible(@NotNull ChangesBrowserNode<?> node) {
        ChangesBrowserNode<?> subtreeRoot;
        Object subtreeRootObject;
        if (node == null) {
            ChangesListView.$$$reportNull$$$0(1);
        }
        Object object = subtreeRootObject = (subtreeRoot = ChangesListView.getSubtreeRoot(node)) != null ? subtreeRoot.getUserObject() : null;
        if (subtreeRootObject instanceof LocalChangeList) {
            LocalChangeList localChangeList = (LocalChangeList)subtreeRootObject;
            return !localChangeList.getChanges().isEmpty();
        }
        return subtreeRootObject == ChangesBrowserNode.UNVERSIONED_FILES_TAG && subtreeRoot.getChildCount() > 0;
    }

    protected boolean isInclusionEnabled(@NotNull ChangesBrowserNode<?> node) {
        if (node == null) {
            ChangesListView.$$$reportNull$$$0(2);
        }
        if (MergeConflictManager.isForceIncludeResolvedConflicts() && ChangesListView.isUnderResolvedConflicts(node)) {
            return false;
        }
        return super.isInclusionEnabled(node);
    }

    protected boolean isIncludable(@NotNull ChangesBrowserNode<?> node) {
        if (node == null) {
            ChangesListView.$$$reportNull$$$0(3);
        }
        if (ChangesListView.isUnderResolvedConflicts(node)) {
            return true;
        }
        return super.isIncludable(node);
    }

    private static boolean isUnderResolvedConflicts(@NotNull ChangesBrowserNode<?> node) {
        if (node == null) {
            ChangesListView.$$$reportNull$$$0(4);
        }
        ChangesBrowserNode curNode = node;
        while (curNode != null && !(node.getUserObject() instanceof LocalChangeList) && curNode.getUserObject() != ChangesBrowserResolvedConflictsNodeKt.RESOLVED_CONFLICTS_NODE_TAG) {
            if ((curNode = curNode.getParent()) == null || curNode.getUserObject() != ChangesBrowserResolvedConflictsNodeKt.RESOLVED_CONFLICTS_NODE_TAG) continue;
            return true;
        }
        if (curNode == null) {
            return false;
        }
        return curNode.getUserObject() == ChangesBrowserResolvedConflictsNodeKt.RESOLVED_CONFLICTS_NODE_TAG;
    }

    @Nullable
    private static ChangesBrowserNode<?> getSubtreeRoot(@NotNull ChangesBrowserNode<?> node) {
        TreeNode[] path;
        if (node == null) {
            ChangesListView.$$$reportNull$$$0(5);
        }
        if ((path = node.getPath()).length < 2) {
            return null;
        }
        return (ChangesBrowserNode)path[1];
    }

    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    public void rebuildTree() {
        LOG.warn("rebuildTree() not implemented in " + String.valueOf((Object)this), new Throwable());
    }

    @ApiStatus.Internal
    public void updateTreeModel(@NotNull DefaultTreeModel model, @NotNull ChangesTree.TreeStateStrategy treeStateStrategy) {
        if (model == null) {
            ChangesListView.$$$reportNull$$$0(6);
        }
        if (treeStateStrategy == null) {
            ChangesListView.$$$reportNull$$$0(7);
        }
        super.updateTreeModel(model, treeStateStrategy);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            ChangesListView.$$$reportNull$$$0(8);
        }
        super.uiDataSnapshot(sink);
        sink.set(DATA_KEY, (Object)this);
        sink.set(VcsDataKeys.CHANGES, (Object)((Change[])this.getSelectedChanges().toArray((Object[])Change.EMPTY_CHANGE_ARRAY)));
        sink.set(VcsDataKeys.CHANGE_LEAD_SELECTION, (Object)((Change[])VcsTreeModelData.exactlySelected((JTree)((Object)this)).iterateUserObjects(Change.class).toArray((Object[])Change.EMPTY_CHANGE_ARRAY)));
        sink.set(VcsDataKeys.CHANGE_LISTS, (Object)((ChangeList[])VcsTreeModelData.exactlySelected((JTree)((Object)this)).iterateRawUserObjects(ChangeList.class).toList().toArray(ChangeList[]::new)));
        sink.set(VcsDataKeys.FILE_PATHS, (Object)VcsTreeModelData.mapToFilePath((VcsTreeModelData)VcsTreeModelData.selected((JTree)((Object)this))));
        sink.set(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)(VcsTreeModelData.exactlySelected((JTree)((Object)this)).iterateRawUserObjects().filter(userObject -> !(userObject instanceof ChangeList)).isNotEmpty() ? new VirtualFileDeleteProvider() : null));
        sink.set(UNVERSIONED_FILE_PATHS_DATA_KEY, this.getSelectedUnversionedFiles());
        sink.set(IGNORED_FILE_PATHS_DATA_KEY, this.getSelectedIgnoredFiles());
        sink.set(MODIFIED_WITHOUT_EDITING_DATA_KEY, this.getSelectedModifiedWithoutEditing());
        sink.set(LOCALLY_DELETED_CHANGES, (Object)this.getSelectedLocallyDeletedChanges().toList());
        sink.set(MISSING_FILES_DATA_KEY, (Object)this.getSelectedLocallyDeletedChanges().map(LocallyDeletedChange::getPath).toList());
        sink.set(PlatformCoreDataKeys.HELP_ID, (Object)HELP_ID);
        VcsTreeModelData treeSelection = VcsTreeModelData.selected((JTree)((Object)this));
        VcsTreeModelData exactSelection = VcsTreeModelData.exactlySelected((JTree)((Object)this));
        sink.lazy(SelectInContext.DATA_KEY, () -> {
            VirtualFile file = (VirtualFile)VcsTreeModelData.mapObjectToVirtualFile((JBIterable)exactSelection.iterateRawUserObjects()).first();
            if (file == null) {
                return null;
            }
            return new FileSelectInContext(this.myProject, file, null);
        });
        sink.lazy(CommonDataKeys.VIRTUAL_FILE, () -> VcsTreeModelData.findSelectedVirtualFile((JTree)((Object)this)));
        sink.lazy(CommonDataKeys.VIRTUAL_FILE_ARRAY, () -> (VirtualFile[])VcsTreeModelData.mapToVirtualFile((VcsTreeModelData)treeSelection).toArray((Object[])VirtualFile.EMPTY_ARRAY));
        sink.lazy(VcsDataKeys.VIRTUAL_FILES, () -> VcsTreeModelData.mapToVirtualFile((VcsTreeModelData)treeSelection));
        sink.lazy(CommonDataKeys.NAVIGATABLE, () -> {
            VirtualFile file = (VirtualFile)VcsTreeModelData.mapToNavigatableFile((VcsTreeModelData)treeSelection).single();
            return file != null && !file.isDirectory() ? PsiNavigationSupport.getInstance().createNavigatable(this.myProject, file, 0) : null;
        });
        sink.lazy(CommonDataKeys.NAVIGATABLE_ARRAY, () -> ChangesUtil.getNavigatableArray((Project)this.myProject, (Iterable)VcsTreeModelData.mapToNavigatableFile((VcsTreeModelData)treeSelection)));
        sink.lazy(EXACTLY_SELECTED_FILES_DATA_KEY, () -> VcsTreeModelData.mapToExactVirtualFile((VcsTreeModelData)exactSelection));
    }

    @NotNull
    public JBIterable<FilePath> getUnversionedFiles() {
        JBIterable jBIterable = VcsTreeModelData.allUnderTag((JTree)((Object)this), (Object)ChangesBrowserNode.UNVERSIONED_FILES_TAG).iterateUserObjects(FilePath.class);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<FilePath> getSelectedUnversionedFiles() {
        JBIterable jBIterable = VcsTreeModelData.selectedUnderTag((JTree)((Object)this), (Object)ChangesBrowserNode.UNVERSIONED_FILES_TAG).iterateUserObjects(FilePath.class);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<FilePath> getSelectedIgnoredFiles() {
        JBIterable jBIterable = VcsTreeModelData.selectedUnderTag((JTree)((Object)this), (Object)ChangesBrowserNode.IGNORED_FILES_TAG).iterateUserObjects(FilePath.class);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<VirtualFile> getSelectedModifiedWithoutEditing() {
        JBIterable jBIterable = VcsTreeModelData.selectedUnderTag((JTree)((Object)this), (Object)ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG).iterateUserObjects(VirtualFile.class).filter(VirtualFile::isValid);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<Change> getSelectedChanges() {
        JBIterable changes = VcsTreeModelData.selected((JTree)((Object)this)).iterateUserObjects(Change.class);
        JBIterable hijackedChanges = this.getSelectedModifiedWithoutEditing().map(file -> ChangesListView.toHijackedChange(this.myProject, file)).filterNotNull();
        JBIterable jBIterable = changes.append((Iterable)hijackedChanges);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    @Nullable
    public static Change toHijackedChange(@NotNull Project project, @NotNull VirtualFile file) {
        VcsCurrentRevisionProxy before;
        if (project == null) {
            ChangesListView.$$$reportNull$$$0(14);
        }
        if (file == null) {
            ChangesListView.$$$reportNull$$$0(15);
        }
        if ((before = VcsCurrentRevisionProxy.create(file, project)) != null) {
            CurrentContentRevision afterRevision = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)file));
            return new Change((ContentRevision)before, (ContentRevision)afterRevision, FileStatus.HIJACKED);
        }
        return null;
    }

    @NotNull
    private JBIterable<LocallyDeletedChange> getSelectedLocallyDeletedChanges() {
        JBIterable jBIterable = VcsTreeModelData.selectedUnderTag((JTree)((Object)this), (Object)ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG).iterateUserObjects(LocallyDeletedChange.class);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    @Nullable
    public List<Change> getAllChangesFromSameChangelist(@NotNull Change change) {
        ChangesBrowserNode<?> node;
        if (change == null) {
            ChangesListView.$$$reportNull$$$0(17);
        }
        if ((node = this.findNodeInTree(change)) == null) {
            return null;
        }
        ChangesBrowserNode<?> parent = Registry.is((String)"vcs.skip.single.default.changelist") || !ChangeListManager.getInstance((Project)this.myProject).areChangeListsEnabled() ? this.getRoot() : ChangesListView.findParentOfType(node, ChangesBrowserChangeListNode.class);
        if (parent == null) {
            return null;
        }
        return parent.traverseObjectsUnder().filter(Change.class).toList();
    }

    @Nullable
    public List<Change> getAllChangesFromSameAmendNode(@NotNull Change change) {
        ChangesBrowserNode<?> node;
        if (change == null) {
            ChangesListView.$$$reportNull$$$0(18);
        }
        if ((node = this.findNodeInTree(change)) == null) {
            return null;
        }
        ChangesBrowserNode<?> parent = ChangesListView.findParentOfType(node, EditedCommitNode.class);
        if (parent == null) {
            return null;
        }
        return parent.traverseObjectsUnder().filter(Change.class).toList();
    }

    @Nullable
    private static ChangesBrowserNode<?> findParentOfType(@NotNull ChangesBrowserNode<?> node, @NotNull Class<? extends ChangesBrowserNode<?>> clazz) {
        if (node == null) {
            ChangesListView.$$$reportNull$$$0(19);
        }
        if (clazz == null) {
            ChangesListView.$$$reportNull$$$0(20);
        }
        for (ChangesBrowserNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!clazz.isInstance(parent)) continue;
            return parent;
        }
        return null;
    }

    @NotNull
    public JBIterable<ChangesBrowserChangeNode> getChangesNodes() {
        JBIterable jBIterable = VcsTreeModelData.all((JTree)((Object)this)).iterateNodes().filter(ChangesBrowserChangeNode.class);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(21);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<ChangesBrowserNode<?>> getSelectedChangesNodes() {
        JBIterable jBIterable = VcsTreeModelData.selected((JTree)((Object)this)).iterateNodes();
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(22);
        }
        return jBIterable;
    }

    public void installPopupHandler(@NotNull ActionGroup group) {
        if (group == null) {
            ChangesListView.$$$reportNull$$$0(23);
        }
        PopupHandler.installPopupMenu((JComponent)((Object)this), (ActionGroup)group, (String)"ChangesViewPopup");
    }

    @NotNull
    public JComponent getComponent() {
        ChangesListView changesListView = this;
        if (changesListView == null) {
            ChangesListView.$$$reportNull$$$0(24);
        }
        return changesListView;
    }

    public void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
    }

    public boolean isOverSelection(Point point) {
        return TreeUtil.isOverSelection((JTree)((Object)this), (Point)point);
    }

    public void dropSelectionButUnderPoint(Point point) {
        TreeUtil.dropSelectionButUnderPoint((JTree)((Object)this), (Point)point);
    }

    @Nullable
    public ChangesBrowserNode<?> findNodeInTree(@Nullable Object userObject) {
        return this.findNodeInTree(userObject, null);
    }

    @Nullable
    public ChangesBrowserNode<?> findNodeInTree(@Nullable Object userObject, @Nullable Object tag) {
        ChangesBrowserNode fromNode;
        if (userObject instanceof LocalChangeList) {
            return (ChangesBrowserNode)this.getRoot().iterateNodeChildren().find(node -> userObject.equals(node.getUserObject()));
        }
        ChangesBrowserNode changesBrowserNode = fromNode = tag != null ? VcsTreeModelData.findTagNode((JTree)((Object)this), (Object)tag) : this.getRoot();
        if (fromNode == null) {
            return null;
        }
        if (userObject instanceof ChangeListChange) {
            return (ChangesBrowserNode)VcsTreeModelData.allUnder((ChangesBrowserNode)fromNode).iterateNodes().find(node -> ChangeListChange.HASHING_STRATEGY.equals(node.getUserObject(), userObject));
        }
        return (ChangesBrowserNode)VcsTreeModelData.allUnder((ChangesBrowserNode)fromNode).iterateNodes().find(node -> Objects.equals(node.getUserObject(), userObject));
    }

    @Nullable
    public TreePath findNodePathInTree(@Nullable Object userObject) {
        return this.findNodePathInTree(userObject, null);
    }

    @Nullable
    public TreePath findNodePathInTree(@Nullable Object userObject, @Nullable Object tag) {
        ChangesBrowserNode<?> node = this.findNodeInTree(userObject, tag);
        return node != null ? TreeUtil.getPathFromRoot(node) : null;
    }

    public void expandSafe(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            ChangesListView.$$$reportNull$$$0(25);
        }
        if (node.getChildCount() <= 10000) {
            this.expandPath(TreeUtil.getPathFromRoot((TreeNode)node));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 12, 13, 16, 21, 22, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeStateStrategy";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesListView";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesListView";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedUnversionedFiles";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedIgnoredFiles";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModifiedWithoutEditing";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLocallyDeletedChanges";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesNodes";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChangesNodes";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInclusionVisible";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInclusionEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIncludable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUnderResolvedConflicts";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSubtreeRoot";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateTreeModel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 21: 
            case 22: 
            case 24: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "toHijackedChange";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAllChangesFromSameChangelist";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAllChangesFromSameAmendNode";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findParentOfType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "expandSafe";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 12, 13, 16, 21, 22, 24 -> new IllegalStateException(string);
        };
    }
}

