/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.ide.errorTreeView.SimpleErrorData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.TransactionProvider;
import com.intellij.openapi.vcs.TransactionRunnable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.committed.ChangesBrowserDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTableModel;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationCommittedChangesPanel;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.vcs.changes.ui.LoadingCommittedChangeListPanel;
import com.intellij.openapi.vcs.changes.ui.SelectFilePathsDialog;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vcs.history.FileHistoryRefresher;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vcs.impl.VcsErrorViewPanel;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.merge.MultipleFileMergeDialog;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.AppIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManagerUtil;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.BufferedListConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ConfirmationDialog;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class AbstractVcsHelperImpl
extends AbstractVcsHelper {
    private static final Logger LOG = Logger.getInstance(AbstractVcsHelperImpl.class);
    private Consumer<VcsException> myCustomHandler;

    protected AbstractVcsHelperImpl(@NotNull Project project) {
        if (project == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(0);
        }
        super(project);
        this.myCustomHandler = null;
    }

    @ApiStatus.Internal
    public void openMessagesView(VcsErrorViewPanel errorTreeView, @NlsContexts.TabTitle @NotNull String tabDisplayName) {
        if (tabDisplayName == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(1);
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, () -> {
            MessageView messageView = MessageView.getInstance((Project)this.myProject);
            messageView.runWhenInitialized(() -> {
                Content content = ContentFactory.getInstance().createContent((JComponent)((Object)errorTreeView), tabDisplayName, true);
                messageView.getContentManager().addContent(content);
                Disposer.register((Disposable)content, (Disposable)errorTreeView);
                messageView.getContentManager().setSelectedContent(content);
                ContentManagerUtil.cleanupContents((Content)content, (Project)this.myProject, (String)tabDisplayName);
                ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Messages").activate(null);
            });
        }, VcsBundle.message((String)"command.name.open.error.message.view", (Object[])new Object[0]), null);
    }

    public void showFileHistory(@NotNull VcsHistoryProvider historyProvider, @NotNull FilePath path, @NotNull AbstractVcs vcs) {
        if (historyProvider == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(2);
        }
        if (path == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(3);
        }
        if (vcs == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(4);
        }
        this.showFileHistory(historyProvider, vcs.getAnnotationProvider(), path, vcs);
    }

    public void showFileHistory(@NotNull VcsHistoryProvider historyProvider, @Nullable AnnotationProvider annotationProvider, @NotNull FilePath path, @NotNull AbstractVcs vcs) {
        if (historyProvider == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(5);
        }
        if (path == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(6);
        }
        if (vcs == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(7);
        }
        FileHistoryRefresherI refresher = FileHistoryRefresher.findOrCreate(historyProvider, path, vcs);
        refresher.selectContent();
        refresher.refresh(true);
    }

    public void showFileHistory(@NotNull VcsHistoryProviderEx historyProvider, @NotNull FilePath path, @NotNull AbstractVcs vcs, @Nullable VcsRevisionNumber startingRevisionNumber) {
        if (historyProvider == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(8);
        }
        if (path == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(9);
        }
        if (vcs == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(10);
        }
        FileHistoryRefresherI refresher = FileHistoryRefresher.findOrCreate(historyProvider, path, vcs, startingRevisionNumber);
        refresher.selectContent();
        refresher.refresh(true);
    }

    @Nullable
    public Collection<VirtualFile> selectFilesToProcess(List<? extends VirtualFile> files, String title, @Nullable String prompt, @Nullable String singleFileTitle, @Nullable String singleFilePromptTemplate, @NotNull VcsShowConfirmationOption confirmationOption) {
        if (confirmationOption == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(11);
        }
        if (files == null || files.isEmpty()) {
            return null;
        }
        String okActionName = CommonBundle.getAddButtonText();
        String cancelActionName = CommonBundle.getCancelButtonText();
        if (files.size() == 1 && singleFileTitle != null && singleFilePromptTemplate != null) {
            String filePrompt = MessageFormat.format(singleFilePromptTemplate, FileUtil.getLocationRelativeToUserHome((String)files.get(0).getPresentableUrl()));
            if (ConfirmationDialog.requestForConfirmation((VcsShowConfirmationOption)confirmationOption, (Project)this.myProject, (String)filePrompt, (String)singleFileTitle, (Icon)Messages.getQuestionIcon(), (String)okActionName, (String)cancelActionName)) {
                return new ArrayList<VirtualFile>(files);
            }
            return null;
        }
        SelectFilesDialog dlg = SelectFilesDialog.init(this.myProject, files, prompt, confirmationOption, true, false, okActionName, cancelActionName);
        dlg.setTitle(title);
        if (dlg.showAndGet()) {
            Collection<VirtualFile> selection = dlg.getSelectedFiles();
            ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
            for (VirtualFile virtualFile : files) {
                if (!selection.contains(virtualFile)) continue;
                result2.add(virtualFile);
            }
            return result2;
        }
        return null;
    }

    @Nullable
    public Collection<FilePath> selectFilePathsToProcess(@NotNull List<? extends FilePath> files, String title, @Nullable String prompt, @Nullable String singleFileTitle, @Nullable String singleFilePromptTemplate, @NotNull VcsShowConfirmationOption confirmationOption, @Nullable String okActionName, @Nullable String cancelActionName) {
        if (files == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(12);
        }
        if (confirmationOption == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(13);
        }
        if (files.size() == 1 && singleFileTitle != null && singleFilePromptTemplate != null) {
            String filePrompt = MessageFormat.format(singleFilePromptTemplate, files.get(0).getPresentableUrl());
            if (ConfirmationDialog.requestForConfirmation((VcsShowConfirmationOption)confirmationOption, (Project)this.myProject, (String)filePrompt, (String)singleFileTitle, (Icon)Messages.getQuestionIcon(), (String)okActionName, (String)cancelActionName)) {
                return new ArrayList<FilePath>(files);
            }
            return null;
        }
        SelectFilePathsDialog dlg = new SelectFilePathsDialog(this.myProject, files, prompt, confirmationOption, okActionName, cancelActionName, true);
        dlg.setTitle(title);
        return dlg.showAndGet() ? dlg.getSelectedFiles() : null;
    }

    @Nullable
    public Collection<FilePath> selectFilePathsToProcess(@NotNull List<? extends FilePath> files, String title, @Nullable String prompt, @Nullable String singleFileTitle, @Nullable String singleFilePromptTemplate, @NotNull VcsShowConfirmationOption confirmationOption) {
        if (files == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(14);
        }
        if (confirmationOption == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(15);
        }
        return this.selectFilePathsToProcess(files, title, prompt, singleFileTitle, singleFilePromptTemplate, confirmationOption, null, null);
    }

    public void showErrors(List<? extends VcsException> abstractVcsExceptions, @NotNull String tabDisplayName) {
        if (tabDisplayName == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(16);
        }
        this.showErrorsImpl(abstractVcsExceptions.isEmpty(), () -> (VcsException)((Object)((Object)abstractVcsExceptions.get(0))), tabDisplayName, (Consumer<? super VcsErrorViewPanel>)((Consumer)vcsErrorViewPanel -> AbstractVcsHelperImpl.addDirectMessages(vcsErrorViewPanel, abstractVcsExceptions)));
    }

    public boolean commitChanges(@NotNull Collection<? extends Change> changes, @NotNull LocalChangeList initialChangeList, @NotNull String commitMessage, @Nullable CommitResultHandler customResultHandler) {
        if (changes == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(17);
        }
        if (initialChangeList == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(18);
        }
        if (commitMessage == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(19);
        }
        return CommitChangeListDialog.commitVcsChanges(this.myProject, changes, initialChangeList, commitMessage, customResultHandler);
    }

    private static void addDirectMessages(VcsErrorViewPanel vcsErrorViewPanel, List<? extends VcsException> abstractVcsExceptions) {
        for (VcsException vcsException : abstractVcsExceptions) {
            String[] messages = AbstractVcsHelperImpl.getExceptionMessages(vcsException);
            vcsErrorViewPanel.addMessage(AbstractVcsHelperImpl.getErrorCategory(vcsException), messages, vcsException.getVirtualFile(), -1, -1, null);
        }
    }

    private static String[] getExceptionMessages(@NotNull VcsException exception) {
        String[] messages;
        if (exception == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(20);
        }
        if ((messages = exception.getMessages()).length == 0) {
            messages = new String[]{VcsBundle.message((String)"exception.text.unknown.error", (Object[])new Object[0])};
        }
        ArrayList list = new ArrayList();
        for (String message : messages) {
            list.addAll(StringUtil.split((String)StringUtil.convertLineSeparators((String)message), (String)"\n"));
        }
        return ArrayUtilRt.toStringArray(list);
    }

    private void showErrorsImpl(boolean isEmpty, Supplier<? extends VcsException> firstGetter, @NlsContexts.TabTitle @NotNull String tabDisplayName, Consumer<? super VcsErrorViewPanel> viewFiller) {
        if (tabDisplayName == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(21);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            VcsException exception;
            if (!isEmpty && !this.handleCustom(exception = firstGetter.get())) {
                throw new RuntimeException(exception);
            }
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (isEmpty) {
                ContentManagerUtil.cleanupContents(null, (Project)this.myProject, (String)tabDisplayName);
                return;
            }
            VcsErrorViewPanel errorTreeView = new VcsErrorViewPanel(this.myProject);
            this.openMessagesView(errorTreeView, tabDisplayName);
            viewFiller.consume((Object)errorTreeView);
        });
    }

    public boolean handleCustom(VcsException exception) {
        if (this.myCustomHandler != null) {
            this.myCustomHandler.consume((Object)exception);
            return true;
        }
        return false;
    }

    public void showErrors(Map<HotfixData, List<VcsException>> exceptionGroups, @NotNull String tabDisplayName) {
        if (tabDisplayName == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(22);
        }
        this.showErrorsImpl(exceptionGroups.isEmpty(), () -> {
            List exceptionList = (List)exceptionGroups.values().iterator().next();
            return exceptionList == null ? null : (exceptionList.isEmpty() ? null : (VcsException)((Object)((Object)exceptionList.get(0))));
        }, tabDisplayName, (Consumer<? super VcsErrorViewPanel>)((Consumer)vcsErrorViewPanel -> {
            for (Map.Entry entry : exceptionGroups.entrySet()) {
                if (entry.getKey() == null) {
                    AbstractVcsHelperImpl.addDirectMessages(vcsErrorViewPanel, (List)entry.getValue());
                    continue;
                }
                List exceptionList = (List)entry.getValue();
                ArrayList<SimpleErrorData> list = new ArrayList<SimpleErrorData>(exceptionList.size());
                for (VcsException exception : exceptionList) {
                    String[] messages = AbstractVcsHelperImpl.getExceptionMessages(exception);
                    list.add(new SimpleErrorData(ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)AbstractVcsHelperImpl.getErrorCategory(exception)), messages, exception.getVirtualFile()));
                }
                vcsErrorViewPanel.addHotfixGroup((HotfixData)entry.getKey(), list);
            }
        }));
    }

    private static int getErrorCategory(VcsException exception) {
        if (exception.isWarning()) {
            return 5;
        }
        return 4;
    }

    public List<VcsException> runTransactionRunnable(AbstractVcs vcs, TransactionRunnable runnable, Object vcsParameters) {
        boolean transactionSupported;
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        TransactionProvider transactionProvider = vcs.getTransactionProvider();
        boolean bl = transactionSupported = transactionProvider != null;
        if (transactionSupported) {
            transactionProvider.startTransaction(vcsParameters);
        }
        runnable.run(exceptions);
        if (transactionSupported) {
            if (exceptions.isEmpty()) {
                try {
                    transactionProvider.commitTransaction(vcsParameters);
                }
                catch (VcsException e) {
                    exceptions.add(e);
                    transactionProvider.rollbackTransaction(vcsParameters);
                }
            } else {
                transactionProvider.rollbackTransaction(vcsParameters);
            }
        }
        return exceptions;
    }

    public void showAnnotation(FileAnnotation annotation, VirtualFile file, AbstractVcs vcs) {
        this.showAnnotation(annotation, file, vcs, 0);
    }

    public void showAnnotation(FileAnnotation annotation, VirtualFile file, AbstractVcs vcs, int line) {
        Editor editor;
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(file);
        TextEditor textFileEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : (TextEditor)ContainerUtil.findInstance((Iterable)FileEditorManager.getInstance((Project)this.myProject).getEditorList(file), TextEditor.class);
        if (textFileEditor != null) {
            editor = textFileEditor.getEditor();
        } else {
            OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(this.myProject, file, line, 0);
            editor = FileEditorManager.getInstance((Project)this.myProject).openTextEditor(openFileDescriptor, true);
        }
        if (editor == null) {
            Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.open.editor", (Object[])new Object[]{file.getPresentableUrl()}), (String)VcsBundle.message((String)"message.title.cannot.open.editor", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
            return;
        }
        AnnotateToggleAction.doAnnotate(editor, this.myProject, annotation, vcs);
    }

    private ChangesBrowserDialog createChangesBrowserDialog(CommittedChangesTableModel changelists, @NlsContexts.DialogTitle @Nullable String title, @Nullable Component parent, Consumer<? super ChangesBrowserDialog> initRunnable) {
        ChangesBrowserDialog dlg;
        ChangesBrowserDialog.Mode mode = ChangesBrowserDialog.Mode.Browse;
        ChangesBrowserDialog changesBrowserDialog = dlg = parent != null ? new ChangesBrowserDialog(this.myProject, parent, changelists, mode, initRunnable) : new ChangesBrowserDialog(this.myProject, changelists, mode, initRunnable);
        if (title != null) {
            dlg.setTitle(title);
        }
        return dlg;
    }

    public void showChangesListBrowser(@NotNull CommittedChangeList changelist, @Nullable String title) {
        if (changelist == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(23);
        }
        LoadingCommittedChangeListPanel panel = new LoadingCommittedChangeListPanel(this.myProject);
        panel.setChangeList(changelist, null);
        ChangeListViewerDialog.show(this.myProject, title, panel);
    }

    public void showWhatDiffersBrowser(@NotNull Collection<Change> changes, @Nullable String title) {
        if (changes == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(24);
        }
        LoadingCommittedChangeListPanel panel = new LoadingCommittedChangeListPanel(this.myProject);
        panel.setChanges(changes, null);
        ChangeListViewerDialog.show(this.myProject, title, panel);
    }

    @NotNull
    public List<VirtualFile> showMergeDialog(@NotNull List<? extends VirtualFile> files, @NotNull MergeProvider provider, @NotNull MergeDialogCustomizer mergeDialogCustomizer) {
        if (files == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(25);
        }
        if (provider == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(26);
        }
        if (mergeDialogCustomizer == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(27);
        }
        if (files.isEmpty()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                AbstractVcsHelperImpl.$$$reportNull$$$0(28);
            }
            return list;
        }
        RefreshVFsSynchronously.refreshVirtualFiles(files);
        MultipleFileMergeDialog fileMergeDialog = new MultipleFileMergeDialog(this.myProject, files, provider, mergeDialogCustomizer);
        AppIcon.getInstance().requestAttention(this.myProject, true);
        fileMergeDialog.show();
        List<VirtualFile> list = fileMergeDialog.getProcessedFiles();
        if (list == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(29);
        }
        return list;
    }

    public void showCommittedChangesBrowser(@NotNull CommittedChangesProvider provider, @NotNull RepositoryLocation location, @Nullable String title, @Nullable Component parent) {
        ChangesBrowserSettingsEditor filterUI;
        CommittedChangesFilterDialog filterDialog;
        if (provider == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(30);
        }
        if (location == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(31);
        }
        if ((filterDialog = new CommittedChangesFilterDialog(this.myProject, filterUI = provider.createFilterUI(true), provider.createDefaultSettings())).showAndGet()) {
            ChangeBrowserSettings settings = filterDialog.getSettings();
            if (this.myProject.isDefault() || ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss().length == 0 || !ModalityState.nonModal().equals(ModalityState.current())) {
                ArrayList<CommittedChangeList> versions = new ArrayList<CommittedChangeList>();
                if (parent == null || !parent.isValid()) {
                    parent = WindowManager.getInstance().suggestParentWindow(this.myProject);
                }
                CommittedChangesTableModel model = new CommittedChangesTableModel(versions, true);
                AsynchronousListsLoader[] task2 = new AsynchronousListsLoader[1];
                ChangesBrowserDialog dlg = this.createChangesBrowserDialog(model, title, parent, (Consumer<? super ChangesBrowserDialog>)((Consumer)changesBrowserDialog -> {
                    task2[0] = new AsynchronousListsLoader(this.myProject, provider, location, settings, (ChangesBrowserDialog)((Object)changesBrowserDialog));
                    ProgressManager.getInstance().run((Task)task2[0]);
                }));
                dlg.startLoading();
                dlg.show();
                if (task2[0] != null) {
                    task2[0].cancel();
                    List<VcsException> exceptions = task2[0].getExceptions();
                    if (!exceptions.isEmpty()) {
                        Messages.showErrorDialog((Project)this.myProject, (String)VcsBundle.message((String)"browse.changes.error.message", (Object[])new Object[]{exceptions.get(0).getMessage()}), (String)VcsBundle.message((String)"browse.changes.error.title", (Object[])new Object[0]));
                        return;
                    }
                    if (!task2[0].isRevisionsReturned()) {
                        Messages.showInfoMessage((Project)this.myProject, (String)VcsBundle.message((String)"browse.changes.nothing.found", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.nothing.found.title", (Object[])new Object[0]));
                    }
                }
            } else {
                this.openCommittedChangesTab(provider, location, settings, 0, title);
            }
        }
    }

    public void openCommittedChangesTab(@NotNull CommittedChangesProvider provider, @NotNull RepositoryLocation location, @NotNull ChangeBrowserSettings settings, int maxCount, @Nullable String title) {
        if (provider == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(32);
        }
        if (location == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(33);
        }
        if (settings == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(34);
        }
        DefaultActionGroup extraActions = new DefaultActionGroup();
        RepositoryLocationCommittedChangesPanel<ChangeBrowserSettings> panel = new RepositoryLocationCommittedChangesPanel<ChangeBrowserSettings>(this.myProject, provider, location, extraActions);
        panel.setMaxCount(maxCount);
        panel.setSettings(settings);
        panel.refreshChanges();
        ContentFactory factory = ContentFactory.getInstance();
        if (title == null) {
            title = VcsBundle.message((String)"browse.changes.content.title", (Object[])new Object[]{location.toPresentableString()});
        }
        final Content content = factory.createContent(panel, title, false);
        final ChangesViewContentI contentManager = ChangesViewContentManager.getInstance(this.myProject);
        contentManager.addContent(content);
        contentManager.setSelectedContent(content);
        extraActions.add((AnAction)new CloseTabToolbarAction(this){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                contentManager.removeContent(content);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl$1", "actionPerformed"));
            }
        });
        ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Version Control");
        if (!window.isVisible()) {
            window.activate(null);
        }
    }

    public void loadAndShowCommittedChangesDetails(@NotNull Project project, @NotNull VcsRevisionNumber revision, @NotNull VirtualFile virtualFile, @NotNull VcsKey vcsKey, @Nullable RepositoryLocation location, boolean isNonLocal) {
        AbstractVcs vcs;
        if (project == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(35);
        }
        if (revision == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(36);
        }
        if (virtualFile == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(37);
        }
        if (vcsKey == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(38);
        }
        if ((vcs = ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(vcsKey.getName())) == null) {
            return;
        }
        CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
        if (provider == null) {
            return;
        }
        if (isNonLocal && provider.getForNonLocal(virtualFile) == null) {
            return;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)virtualFile);
        AbstractVcsHelperImpl.loadAndShowCommittedChangesDetails(project, revision, filePath, () -> AbstractVcsHelperImpl.getAffectedChanges(provider, virtualFile, revision, location, isNonLocal));
    }

    public static void loadAndShowCommittedChangesDetails(@NotNull Project project, @NotNull VcsRevisionNumber revision, @NotNull FilePath filePath, @NotNull CommittedChangeListProvider changelistProvider) {
        if (project == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(39);
        }
        if (revision == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(40);
        }
        if (filePath == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(41);
        }
        if (changelistProvider == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(42);
        }
        AbstractVcsHelperImpl.loadAndShowCommittedChangesDetails(project, revision, filePath, AbstractVcsHelperImpl.showCommittedChangesAsTab(), changelistProvider);
    }

    public static void loadAndShowCommittedChangesDetails(@NotNull Project project, @NotNull VcsRevisionNumber revision, @NotNull FilePath filePath, boolean showAsTab, @NotNull CommittedChangeListProvider changelistProvider) {
        if (project == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(43);
        }
        if (revision == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(44);
        }
        if (filePath == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(45);
        }
        if (changelistProvider == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(46);
        }
        String title = VcsBundle.message((String)"paths.affected.in.revision", (Object[])new Object[]{VcsUtil.getShortRevisionString((VcsRevisionNumber)revision)});
        BackgroundableActionLock lock = BackgroundableActionLock.getLock(project, new Object[]{VcsBackgroundableActions.COMMITTED_CHANGES_DETAILS, revision, filePath.getPath()});
        if (ChangeListViewerDialog.tryFocusExistingDialog(lock)) {
            return;
        }
        LoadingCommittedChangeListPanel loadingPanel = new LoadingCommittedChangeListPanel(project);
        loadingPanel.loadChangesInBackground((ThrowableComputable<? extends LoadingCommittedChangeListPanel.ChangelistData, ? extends VcsException>)((ThrowableComputable)() -> AbstractVcsHelperImpl.loadCommittedChanges(revision, filePath, changelistProvider)));
        ChangeListViewerDialog.show(project, title, loadingPanel, lock, showAsTab);
    }

    public static boolean showCommittedChangesAsTab() {
        return Registry.is((String)"vcs.show.affected.files.as.tab") && ModalityState.current() == ModalityState.nonModal();
    }

    @NotNull
    private static LoadingCommittedChangeListPanel.ChangelistData loadCommittedChanges(@NotNull VcsRevisionNumber revision, @NotNull FilePath filePath, @NotNull CommittedChangeListProvider changelistProvider) throws VcsException {
        if (revision == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(47);
        }
        if (filePath == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(48);
        }
        if (changelistProvider == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(49);
        }
        try {
            Pair<? extends CommittedChangeList, FilePath> pair = changelistProvider.loadChangelist();
            if (pair.getFirst() == null) {
                throw new VcsException(AbstractVcsHelperImpl.failedText(filePath, revision));
            }
            CommittedChangeList changeList = (CommittedChangeList)pair.getFirst();
            FilePath targetPath = (FilePath)pair.getSecond();
            FilePath navigateToPath = (FilePath)ObjectUtils.notNull((Object)targetPath, (Object)filePath);
            return new LoadingCommittedChangeListPanel.ChangelistData(changeList, navigateToPath);
        }
        catch (VcsException e) {
            throw new VcsException(AbstractVcsHelperImpl.failedText(filePath, revision), (Throwable)e);
        }
    }

    @NotNull
    private static Pair<CommittedChangeList, FilePath> getAffectedChanges(@NotNull CommittedChangesProvider provider, @NotNull VirtualFile virtualFile, @NotNull VcsRevisionNumber revision, @Nullable RepositoryLocation location, boolean isNonLocal) throws VcsException {
        if (provider == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(50);
        }
        if (virtualFile == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(51);
        }
        if (revision == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(52);
        }
        if (!isNonLocal) {
            Pair pair = provider.getOneList(virtualFile, revision);
            if (pair != null) {
                Pair pair2 = pair;
                if (pair2 == null) {
                    AbstractVcsHelperImpl.$$$reportNull$$$0(53);
                }
                return pair2;
            }
            throw new VcsException(VcsBundle.message((String)"error.cant.load.affected.files", (Object[])new Object[]{virtualFile.getPath(), revision.asString()}));
        }
        if (location != null) {
            ChangeBrowserSettings settings = provider.createDefaultSettings();
            settings.USE_CHANGE_BEFORE_FILTER = true;
            settings.CHANGE_BEFORE = revision.asString();
            List changes = provider.getCommittedChanges(settings, location, 1);
            if (changes.size() == 1) {
                Pair pair = Pair.create((Object)((CommittedChangeList)changes.get(0)), null);
                if (pair == null) {
                    AbstractVcsHelperImpl.$$$reportNull$$$0(54);
                }
                return pair;
            }
            throw new VcsException(VcsBundle.message((String)"error.cant.load.affected.files", (Object[])new Object[]{virtualFile.getPath(), revision.asString()}));
        }
        CommittedChangeList list = AbstractVcsHelperImpl.getRemoteList(provider, revision, virtualFile);
        Pair pair = Pair.create((Object)list, null);
        if (pair == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(55);
        }
        return pair;
    }

    @NotNull
    public static CommittedChangeList getRemoteList(@NotNull CommittedChangesProvider provider, @NotNull VcsRevisionNumber revision, @NotNull VirtualFile nonLocal) throws VcsException {
        RepositoryLocation location;
        if (provider == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(56);
        }
        if (revision == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(57);
        }
        if (nonLocal == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(58);
        }
        if ((location = provider.getForNonLocal(nonLocal)) == null) {
            throw new VcsException(VcsBundle.message((String)"error.cant.get.local.file.for.non.local", (Object[])new Object[]{nonLocal}));
        }
        String number = revision.asString();
        ChangeBrowserSettings settings = provider.createDefaultSettings();
        List changes = provider.getCommittedChanges(settings, location, provider.getUnlimitedCountValue());
        for (CommittedChangeList change : changes) {
            if (!number.equals(String.valueOf(change.getNumber()))) continue;
            CommittedChangeList committedChangeList = change;
            if (committedChangeList == null) {
                AbstractVcsHelperImpl.$$$reportNull$$$0(59);
            }
            return committedChangeList;
        }
        LOG.warn(String.format("Cannot load affected files for location '%s' in revision '%s' with limit %s (found %s)", location, revision.asString(), provider.getUnlimitedCountValue(), changes.size()), new Throwable());
        throw new VcsException(VcsBundle.message((String)"error.cant.load.affected.files", (Object[])new Object[]{nonLocal.getPath(), revision.asString()}));
    }

    @NotNull
    @Nls
    private static String failedText(@NotNull FilePath filePath, @NotNull VcsRevisionNumber revision) {
        if (filePath == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(60);
        }
        if (revision == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(61);
        }
        String string = VcsBundle.message((String)"impl.show.all.affected.files.for.path.at.revision.failed", (Object[])new Object[]{filePath.getPath(), revision.asString()});
        if (string == null) {
            AbstractVcsHelperImpl.$$$reportNull$$$0(62);
        }
        return string;
    }

    @TestOnly
    public static void setCustomExceptionHandler(Project project, Consumer<VcsException> customHandler) {
        ((AbstractVcsHelperImpl)AbstractVcsHelperImpl.getInstance((Project)project)).myCustomHandler = customHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 28, 29, 53, 54, 55, 59, 62 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 16: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabDisplayName";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyProvider";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmationOption";
                break;
            }
            case 12: 
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialChangeList";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitMessage";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changelist";
                break;
            }
            case 26: 
            case 30: 
            case 32: 
            case 50: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeDialogCustomizer";
                break;
            }
            case 28: 
            case 29: 
            case 53: 
            case 54: 
            case 55: 
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 36: 
            case 40: 
            case 44: 
            case 47: 
            case 52: 
            case 57: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 37: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsKey";
                break;
            }
            case 41: 
            case 45: 
            case 48: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 42: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changelistProvider";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonLocal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "showMergeDialog";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedChanges";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteList";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "failedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "openMessagesView";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showFileHistory";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "selectFilesToProcess";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "selectFilePathsToProcess";
                break;
            }
            case 16: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "showErrors";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "commitChanges";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionMessages";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showErrorsImpl";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "showChangesListBrowser";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "showWhatDiffersBrowser";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "showMergeDialog";
                break;
            }
            case 28: 
            case 29: 
            case 53: 
            case 54: 
            case 55: 
            case 59: 
            case 62: {
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showCommittedChangesBrowser";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "openCommittedChangesTab";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "loadAndShowCommittedChangesDetails";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "loadCommittedChanges";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedChanges";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteList";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "failedText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 28, 29, 53, 54, 55, 59, 62 -> new IllegalStateException(string);
        };
    }

    private static final class AsynchronousListsLoader
    extends Task.Backgroundable {
        @NotNull
        private final CommittedChangesProvider myProvider;
        @NotNull
        private final RepositoryLocation myLocation;
        private final ChangeBrowserSettings mySettings;
        private final ChangesBrowserDialog myDlg;
        private final List<VcsException> myExceptions;
        private volatile boolean myCanceled;
        private boolean myRevisionsReturned;

        private AsynchronousListsLoader(@Nullable Project project, @NotNull CommittedChangesProvider provider, @NotNull RepositoryLocation location, @NotNull ChangeBrowserSettings settings, ChangesBrowserDialog dlg) {
            if (provider == null) {
                AsynchronousListsLoader.$$$reportNull$$$0(0);
            }
            if (location == null) {
                AsynchronousListsLoader.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                AsynchronousListsLoader.$$$reportNull$$$0(2);
            }
            super(project, VcsBundle.message((String)"browse.changes.progress.title", (Object[])new Object[0]), true);
            this.myProvider = provider;
            this.myLocation = location;
            this.mySettings = settings;
            this.myDlg = dlg;
            this.myExceptions = new ArrayList<VcsException>();
        }

        public void cancel() {
            this.myCanceled = true;
        }

        public void run(final @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                AsynchronousListsLoader.$$$reportNull$$$0(3);
            }
            final AsynchConsumer<List<CommittedChangeList>> appender = this.myDlg.getAppender();
            final BufferedListConsumer bufferedListConsumer = new BufferedListConsumer(10, appender, -1);
            final Application application = ApplicationManager.getApplication();
            try {
                this.myProvider.loadCommittedChanges(this.mySettings, this.myLocation, 0, (AsynchConsumer)new AsynchConsumer<CommittedChangeList>(){

                    public void consume(CommittedChangeList committedChangeList) {
                        myRevisionsReturned = true;
                        bufferedListConsumer.consumeOne((Object)committedChangeList);
                        if (myCanceled) {
                            indicator.cancel();
                        }
                    }

                    public void finished() {
                        bufferedListConsumer.flush();
                        appender.finished();
                        if (!myRevisionsReturned) {
                            application.invokeLater(() -> myDlg.close(-1), ModalityState.stateForComponent((Component)myDlg.getWindow()));
                        }
                    }
                });
            }
            catch (VcsException e) {
                this.myExceptions.add(e);
                application.invokeLater(() -> this.myDlg.close(-1), ModalityState.stateForComponent((Component)this.myDlg.getWindow()));
            }
        }

        public List<VcsException> getExceptions() {
            return this.myExceptions;
        }

        public boolean isRevisionsReturned() {
            return this.myRevisionsReturned;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/impl/AbstractVcsHelperImpl$AsynchronousListsLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface CommittedChangeListProvider {
        @NotNull
        public Pair<? extends CommittedChangeList, FilePath> loadChangelist() throws VcsException;
    }
}

