/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.update.AbstractCommonUpdateActionKt;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.ScopeInfo;
import com.intellij.openapi.vcs.update.VcsUpdateProcess;
import com.intellij.util.ui.OptionsDialog;
import java.util.Collection;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0007H$J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/update/AbstractCommonUpdateAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "actionInfo", "Lcom/intellij/openapi/vcs/update/ActionInfo;", "scopeInfo", "Lcom/intellij/openapi/vcs/update/ScopeInfo;", "alwaysVisible", "", "<init>", "(Lcom/intellij/openapi/vcs/update/ActionInfo;Lcom/intellij/openapi/vcs/update/ScopeInfo;Z)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "filterRootsBeforeAction", "update", "Companion", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public abstract class AbstractCommonUpdateAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActionInfo actionInfo;
    @NotNull
    private final ScopeInfo scopeInfo;
    private final boolean alwaysVisible;

    protected AbstractCommonUpdateAction(@NotNull ActionInfo actionInfo, @NotNull ScopeInfo scopeInfo, boolean alwaysVisible) {
        Intrinsics.checkNotNullParameter((Object)actionInfo, (String)"actionInfo");
        Intrinsics.checkNotNullParameter((Object)scopeInfo, (String)"scopeInfo");
        this.actionInfo = actionInfo;
        this.scopeInfo = scopeInfo;
        this.alwaysVisible = alwaysVisible;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        String string = this.getTemplatePresentation().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        VcsUpdateProcess.INSTANCE.launchUpdate(project2, this.actionInfo, this.scopeInfo, dataContext, string, OptionsDialog.shiftIsPressed((int)e.getModifiers()));
    }

    protected abstract boolean filterRootsBeforeAction();

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        Project project = e.getProject();
        if (project == null) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        boolean underVcs = vcsManager.hasActiveVcss();
        if (!underVcs) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        String scopeName = this.scopeInfo.getScopeName(e.getDataContext(), this.actionInfo);
        Object actionName = this.actionInfo.getActionName(scopeName);
        if (this.actionInfo.showOptions(project) || OptionsDialog.shiftIsPressed((int)e.getModifiers())) {
            actionName = (String)actionName + "...";
        }
        presentation2.setText((String)actionName);
        Intrinsics.checkNotNull((Object)vcsManager);
        if (AbstractCommonUpdateActionKt.access$supportingVcsesAreEmpty(vcsManager, this.actionInfo)) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        if (this.filterRootsBeforeAction()) {
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            FilePath[] roots2 = VcsUpdateProcess.getRoots(project, this.actionInfo, this.scopeInfo, dataContext, false);
            if (roots2.length == 0) {
                presentation2.setVisible(this.alwaysVisible);
                presentation2.setEnabled(false);
                return;
            }
        }
        AbstractVcs singleVcs = vcsManager.getSingleVCS();
        presentation2.setVisible(true);
        presentation2.setEnabled(!vcsManager.isBackgroundVcsOperationRunning() && (singleVcs == null || !singleVcs.isUpdateActionDisabled()));
    }

    @Deprecated(message="Use VcsUpdateProcess.checkUpdateHasCustomNotification", replaceWith=@ReplaceWith(expression="VcsUpdateProcess.checkUpdateHasCustomNotification(vcss)", imports={"com.intellij.openapi.vcs.update.VcsUpdateProcess"}))
    @JvmStatic
    public static final boolean showsCustomNotification(@NotNull Collection<? extends AbstractVcs> vcss) {
        return Companion.showsCustomNotification(vcss);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/update/AbstractCommonUpdateAction$Companion;", "", "<init>", "()V", "showsCustomNotification", "", "vcss", "", "Lcom/intellij/openapi/vcs/AbstractVcs;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Use VcsUpdateProcess.checkUpdateHasCustomNotification", replaceWith=@ReplaceWith(expression="VcsUpdateProcess.checkUpdateHasCustomNotification(vcss)", imports={"com.intellij.openapi.vcs.update.VcsUpdateProcess"}))
        @JvmStatic
        public final boolean showsCustomNotification(@NotNull Collection<? extends AbstractVcs> vcss) {
            Intrinsics.checkNotNullParameter(vcss, (String)"vcss");
            return VcsUpdateProcess.checkUpdateHasCustomNotification(vcss);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

