/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.vcs.commit.AbstractCommitWorkflow;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandler;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandlerKt;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.commit.AmendCommitAware;
import com.intellij.vcs.commit.AmendCommitHandler;
import com.intellij.vcs.commit.AmendCommitHandlerImplKt;
import com.intellij.vcs.commit.AmendCommitModeListener;
import com.intellij.vcs.commit.AmendData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001:\u00019B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020&H\u0004J\b\u0010*\u001a\u00020 H\u0016J\u0018\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020&H\u0002J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0002J\n\u00103\u001a\u0004\u0018\u000102H\u0004J\u0018\u0010/\u001a\u00020&2\u0006\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u001aH\u0004J\b\u00106\u001a\u00020&H\u0004J\u0010\u00107\u001a\u00020&2\u0006\u00108\u001a\u00020\u001aH\u0002R\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n \t*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010(\u001a\u00020 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\"\"\u0004\b)\u0010$\u00a8\u0006:"}, d2={"Lcom/intellij/vcs/commit/AmendCommitHandlerImpl;", "Lcom/intellij/vcs/commit/AmendCommitHandler;", "workflowHandler", "Lcom/intellij/vcs/commit/AbstractCommitWorkflowHandler;", "<init>", "(Lcom/intellij/vcs/commit/AbstractCommitWorkflowHandler;)V", "amendCommitEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/vcs/commit/AmendCommitModeListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "workflow", "Lcom/intellij/vcs/commit/AbstractCommitWorkflow;", "getWorkflow", "()Lcom/intellij/vcs/commit/AbstractCommitWorkflow;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "getCommitContext", "()Lcom/intellij/openapi/vcs/changes/CommitContext;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "vcsManager", "Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "initialMessage", "", "getInitialMessage", "()Ljava/lang/String;", "setInitialMessage", "(Ljava/lang/String;)V", "value", "", "isAmendCommitMode", "()Z", "setAmendCommitMode", "(Z)V", "amendCommitModeToggled", "", "fireAmendCommitModeToggled", "isAmendCommitModeTogglingEnabled", "setAmendCommitModeTogglingEnabled", "isAmendCommitModeSupported", "addAmendCommitModeListener", "listener", "parent", "Lcom/intellij/openapi/Disposable;", "setAmendMessage", "resolveAmendRoots", "", "Lcom/intellij/openapi/vcs/VcsRoot;", "getSingleRoot", "beforeAmendMessage", "amendMessage", "restoreBeforeAmendMessage", "setCommitMessageAndFocus", "message", "LoadCommitMessagesTask", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAmendCommitHandlerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmendCommitHandlerImpl.kt\ncom/intellij/vcs/commit/AmendCommitHandlerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1617#2,9:129\n1869#2:138\n1870#2:140\n1626#2:141\n808#2,11:142\n1761#2,3:153\n1617#2,9:157\n1869#2:166\n1870#2:168\n1626#2:169\n1#3:139\n1#3:156\n1#3:167\n*S KotlinDebug\n*F\n+ 1 AmendCommitHandlerImpl.kt\ncom/intellij/vcs/commit/AmendCommitHandlerImpl\n*L\n58#1:129,9\n58#1:138\n58#1:140\n58#1:141\n58#1:142,11\n58#1:153,3\n78#1:157,9\n78#1:166\n78#1:168\n78#1:169\n58#1:139\n78#1:167\n*E\n"})
public class AmendCommitHandlerImpl
implements AmendCommitHandler {
    @NotNull
    private final AbstractCommitWorkflowHandler<?, ?> workflowHandler;
    @NotNull
    private final EventDispatcher<AmendCommitModeListener> amendCommitEventDispatcher;
    private final ProjectLevelVcsManager vcsManager;
    @Nullable
    private String initialMessage;
    private boolean isAmendCommitModeTogglingEnabled;

    public AmendCommitHandlerImpl(@NotNull AbstractCommitWorkflowHandler<?, ?> workflowHandler) {
        Intrinsics.checkNotNullParameter(workflowHandler, (String)"workflowHandler");
        this.workflowHandler = workflowHandler;
        EventDispatcher eventDispatcher = EventDispatcher.create(AmendCommitModeListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.amendCommitEventDispatcher = eventDispatcher;
        this.vcsManager = ProjectLevelVcsManager.getInstance((Project)this.getProject());
        this.isAmendCommitModeTogglingEnabled = true;
    }

    private final AbstractCommitWorkflow getWorkflow() {
        return this.workflowHandler.getWorkflow();
    }

    @NotNull
    protected final CommitContext getCommitContext() {
        return this.getWorkflow().getCommitContext();
    }

    @NotNull
    protected final Project getProject() {
        return this.getWorkflow().getProject();
    }

    @Nullable
    public final String getInitialMessage() {
        return this.initialMessage;
    }

    public final void setInitialMessage(@Nullable String string) {
        this.initialMessage = string;
    }

    public boolean isAmendCommitMode() {
        return AbstractCommitWorkflowKt.isAmendCommitMode(this.getCommitContext());
    }

    public void setAmendCommitMode(boolean value) {
        if (AbstractCommitWorkflowKt.isAmendCommitMode(this.getCommitContext()) != value) {
            AbstractCommitWorkflowKt.setAmendCommitMode(this.getCommitContext(), value);
            this.amendCommitModeToggled();
        }
    }

    protected void amendCommitModeToggled() {
        this.fireAmendCommitModeToggled();
        if (this.isAmendCommitMode()) {
            this.setAmendMessage();
        } else {
            this.restoreBeforeAmendMessage();
        }
        this.workflowHandler.updateDefaultCommitActionName();
    }

    protected final void fireAmendCommitModeToggled() {
        ((AmendCommitModeListener)this.amendCommitEventDispatcher.getMulticaster()).amendCommitModeToggled();
    }

    public boolean isAmendCommitModeTogglingEnabled() {
        return this.isAmendCommitModeTogglingEnabled;
    }

    public void setAmendCommitModeTogglingEnabled(boolean bl) {
        this.isAmendCommitModeTogglingEnabled = bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAmendCommitModeSupported() {
        AmendCommitAware it;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        if (!this.getWorkflow().isDefaultCommitEnabled()) return false;
        Iterable $this$mapNotNull$iv = this.getWorkflow().getVcses();
        boolean $i$f$mapNotNull = false;
        Object object = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CheckinEnvironment it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            AbstractVcs it2 = (AbstractVcs)element$iv$iv;
            boolean bl2 = false;
            if (it2.getCheckinEnvironment() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapNotNullTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AmendCommitAware)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$any$iv = (List)destination$iv$iv;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        object = $this$any$iv.iterator();
        do {
            if (!object.hasNext()) return false;
            Object element$iv = object.next();
            it = (AmendCommitAware)element$iv;
            boolean bl = false;
        } while (!it.isAmendCommitSupported());
        return true;
    }

    public void addAmendCommitModeListener(@NotNull AmendCommitModeListener listener2, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.amendCommitEventDispatcher.addListener((EventListener)listener2, parent);
    }

    private final void setAmendMessage() {
        block2: {
            String amendMessage;
            String string;
            String beforeAmendMessage = this.workflowHandler.getCommitMessage();
            if (this.initialMessage != null && !Intrinsics.areEqual((Object)beforeAmendMessage, (Object)this.initialMessage)) break block2;
            Collection<VcsRoot> roots2 = this.resolveAmendRoots();
            List<String> list = new LoadCommitMessagesTask(this.getProject(), roots2).load();
            if (list == null) {
                return;
            }
            List<String> messages = list;
            String it = string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)messages), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            boolean bl = false;
            String string2 = amendMessage = !StringsKt.isBlank((CharSequence)it) ? string : null;
            if (string2 != null) {
                it = string2;
                boolean bl2 = false;
                this.setAmendMessage(beforeAmendMessage, it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<VcsRoot> resolveAmendRoots() {
        Collection collection;
        Collection collection2 = CollectionsKt.listOfNotNull((Object)this.getSingleRoot());
        if (collection2.isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = AbstractCommitWorkflowHandlerKt.getIncludedPaths(this.workflowHandler.getUi());
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                VcsRoot it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                FilePath it = (FilePath)element$iv$iv;
                boolean bl3 = false;
                if (this.vcsManager.getVcsRootObjectFor(it) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            collection = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            collection = collection2;
        }
        return collection;
    }

    @Nullable
    protected final VcsRoot getSingleRoot() {
        VcsRoot[] vcsRootArray = this.vcsManager.getAllVcsRoots();
        Intrinsics.checkNotNullExpressionValue((Object)vcsRootArray, (String)"getAllVcsRoots(...)");
        return (VcsRoot)ArraysKt.singleOrNull((Object[])vcsRootArray);
    }

    protected final void setAmendMessage(@NotNull String beforeAmendMessage, @NotNull String amendMessage) {
        Intrinsics.checkNotNullParameter((Object)beforeAmendMessage, (String)"beforeAmendMessage");
        Intrinsics.checkNotNullParameter((Object)amendMessage, (String)"amendMessage");
        if (!StringUtil.equalsIgnoreWhitespaces((CharSequence)beforeAmendMessage, (CharSequence)amendMessage)) {
            VcsConfiguration.getInstance((Project)this.getProject()).saveCommitMessage(beforeAmendMessage);
            this.setCommitMessageAndFocus(amendMessage);
            AmendCommitHandlerImplKt.access$setAmendData(this.getCommitContext(), new AmendData(beforeAmendMessage, amendMessage));
        }
    }

    protected final void restoreBeforeAmendMessage() {
        AmendData amendData = AmendCommitHandlerImplKt.access$getAmendData(this.getCommitContext());
        if (amendData == null) {
            return;
        }
        AmendData amendData2 = amendData;
        AmendCommitHandlerImplKt.access$setAmendData(this.getCommitContext(), null);
        if (Intrinsics.areEqual((Object)amendData2.getAmendMessage(), (Object)this.workflowHandler.getCommitMessage())) {
            this.setCommitMessageAndFocus(amendData2.getBeforeAmendMessage());
        }
    }

    private final void setCommitMessageAndFocus(String message) {
        AbstractCommitWorkflowHandler<?, ?> $this$setCommitMessageAndFocus_u24lambda_u240 = this.workflowHandler;
        boolean bl = false;
        $this$setCommitMessageAndFocus_u24lambda_u240.setCommitMessage(message);
        $this$setCommitMessageAndFocus_u24lambda_u240.getUi().getCommitMessageUi().focus();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/commit/AmendCommitHandlerImpl$LoadCommitMessagesTask;", "Lcom/intellij/openapi/progress/Task$WithResult;", "", "", "Lcom/intellij/openapi/vcs/VcsException;", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vcs/VcsRoot;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;)V", "load", "compute", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nAmendCommitHandlerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmendCommitHandlerImpl.kt\ncom/intellij/vcs/commit/AmendCommitHandlerImpl$LoadCommitMessagesTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1617#2,9:129\n1869#2:138\n1870#2:140\n1626#2:141\n1#3:139\n*S KotlinDebug\n*F\n+ 1 AmendCommitHandlerImpl.kt\ncom/intellij/vcs/commit/AmendCommitHandlerImpl$LoadCommitMessagesTask\n*L\n123#1:129,9\n123#1:138\n123#1:140\n123#1:141\n123#1:139\n*E\n"})
    private static final class LoadCommitMessagesTask
    extends Task.WithResult<List<? extends String>, VcsException> {
        @NotNull
        private final Collection<VcsRoot> roots;

        public LoadCommitMessagesTask(@NotNull Project project, @NotNull Collection<VcsRoot> roots2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(roots2, (String)"roots");
            super(project, VcsBundle.message((String)"amend.commit.load.message.task.title", (Object[])new Object[0]), true);
            this.roots = roots2;
        }

        @Nullable
        public final List<String> load() {
            List list;
            this.queue();
            try {
                list = (List)this.getResult();
            }
            catch (VcsException e) {
                Project project = this.getProject();
                String string = VcsBundle.message((String)"amend.commit.load.message.error.text", (Object[])new Object[0]);
                String string2 = e.getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-message>(...)");
                Messages.showErrorDialog((Project)project, (String)(string + "\n" + StringsKt.capitalize((String)string2)), (String)VcsBundle.message((String)"amend.commit.load.message.error.title", (Object[])new Object[0]));
                AmendCommitHandlerImplKt.access$getLOG$p().info((Throwable)e);
                list = null;
            }
            return list;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected List<String> compute(@NotNull ProgressIndicator indicator) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Iterable $this$mapNotNull$iv = this.roots;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                VcsRoot vcsRoot = (VcsRoot)element$iv$iv;
                boolean bl2 = false;
                AbstractVcs abstractVcs = vcsRoot.getVcs();
                Object object = abstractVcs != null ? abstractVcs.getCheckinEnvironment() : null;
                if ((object instanceof AmendCommitAware ? (AmendCommitAware)object : null) == null) {
                    string = null;
                } else {
                    AmendCommitAware amendAware;
                    amendAware = amendAware;
                    VirtualFile virtualFile = vcsRoot.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getPath(...)");
                    string = amendAware.getLastCommitMessage(virtualFile);
                }
                if (string == null) continue;
                String it$iv$iv = string;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
    }
}

