/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.vcs.commit.ChangeListViewCommitPanel;
import com.intellij.vcs.commit.ChangesViewCommitTabTitleUpdater;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/vcs/commit/ChangesViewCommitPanel;", "Lcom/intellij/vcs/commit/ChangeListViewCommitPanel;", "project", "Lcom/intellij/openapi/project/Project;", "changesView", "Lcom/intellij/openapi/vcs/changes/ui/ChangesListView;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/ui/ChangesListView;)V", "isHideToolWindowOnCommit", "", "isActive", "()Z", "activate", "deactivate", "", "isOnCommit", "saveToolWindowState", "clearToolWindowState", "getVcsToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "refreshChangesViewBeforeCommit", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.vcs.impl"})
public final class ChangesViewCommitPanel
extends ChangeListViewCommitPanel {
    @NotNull
    private final ChangesListView changesView;
    private boolean isHideToolWindowOnCommit;

    @ApiStatus.Internal
    public ChangesViewCommitPanel(@NotNull Project project, @NotNull ChangesListView changesView) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)changesView), (String)"changesView");
        super(project, changesView);
        this.changesView = changesView;
        new ChangesViewCommitTabTitleUpdater(this.changesView, this, (Disposable)this).start();
    }

    @Override
    public boolean isActive() {
        return this.getComponent().isVisible();
    }

    public boolean activate() {
        ToolWindow toolWindow = this.getVcsToolWindow();
        if (toolWindow == null) {
            return false;
        }
        ToolWindow toolWindow2 = toolWindow;
        ChangesViewContentI contentManager = ChangesViewContentManager.Companion.getInstance(this.getProject());
        this.saveToolWindowState();
        this.changesView.setShowCheckboxes(true);
        this.getComponent().setVisible(true);
        this.getCommitActionsPanel().setActive(true);
        this.getToolbar().updateActionsImmediately();
        contentManager.selectContent("Local Changes");
        toolWindow2.activate(() -> ChangesViewCommitPanel.activate$lambda$0(this), false);
        return true;
    }

    @Override
    public void deactivate(boolean isOnCommit) {
        if (isOnCommit && this.isHideToolWindowOnCommit) {
            ToolWindow toolWindow = this.getVcsToolWindow();
            if (toolWindow != null) {
                toolWindow.hide(null);
            }
        }
        this.clearToolWindowState();
        this.changesView.setShowCheckboxes(false);
        this.getComponent().setVisible(false);
        this.getCommitActionsPanel().setActive(false);
        this.getToolbar().updateActionsImmediately();
    }

    private final void saveToolWindowState() {
        if (!this.isActive()) {
            ToolWindow toolWindow = this.getVcsToolWindow();
            this.isHideToolWindowOnCommit = !(toolWindow != null ? toolWindow.isVisible() : false);
        }
    }

    private final void clearToolWindowState() {
        this.isHideToolWindowOnCommit = false;
    }

    private final ToolWindow getVcsToolWindow() {
        return ChangesViewContentManager.Companion.getToolWindowFor(this.getProject(), "Local Changes");
    }

    @Override
    @Nullable
    public Object refreshChangesViewBeforeCommit(@NotNull Continuation<? super Unit> $completion) {
        ModalityState modalityState = ModalityKt.contextModality((CoroutineContext)$completion.getContext());
        if (modalityState == null) {
            ModalityState modalityState2 = ModalityState.nonModal();
            modalityState = modalityState2;
            Intrinsics.checkNotNullExpressionValue((Object)modalityState2, (String)"nonModal(...)");
        }
        ModalityState modalityState3 = modalityState;
        Promise<?> promise = ChangesViewManager.getInstanceEx(this.getProject()).promiseRefresh(modalityState3);
        Intrinsics.checkNotNullExpressionValue(promise, (String)"promiseRefresh(...)");
        Object object = Promises.await(promise, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final void activate$lambda$0(ChangesViewCommitPanel this$0) {
        this$0.getCommitMessage().requestFocusInMessage();
    }
}

