/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.commit.CommitterResultHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 &2\u00020\u0001:\u0001&B\u001c\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fJ\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0004J\u001e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00190\"H\u0005J\u0018\u0010#\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020 H\u0002J\b\u0010%\u001a\u00020\u0019H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006'"}, d2={"Lcom/intellij/vcs/commit/Committer;", "", "project", "Lcom/intellij/openapi/project/Project;", "commitMessage", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCommitMessage", "()Ljava/lang/String;", "resultHandlers", "", "Lcom/intellij/vcs/commit/CommitterResultHandler;", "_exceptions", "Lcom/intellij/openapi/vcs/VcsException;", "exceptions", "", "getExceptions", "()Ljava/util/List;", "commitErrors", "getCommitErrors", "addResultHandler", "", "resultHandler", "addException", "e", "", "runCommitTask", "useCustomPostRefresh", "", "task", "Lkotlin/Function0;", "finishCommit", "canceled", "fireAfterRefresh", "Companion", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nCommitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Committer.kt\ncom/intellij/vcs/commit/Committer\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,137:1\n194#2,9:138\n194#2,9:147\n194#2,9:156\n194#2,9:165\n13#3:174\n*S KotlinDebug\n*F\n+ 1 Committer.kt\ncom/intellij/vcs/commit/Committer\n*L\n63#1:138,9\n67#1:147,9\n71#1:156,9\n80#1:165,9\n84#1:174\n*E\n"})
public abstract class Committer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String commitMessage;
    @NotNull
    private final List<CommitterResultHandler> resultHandlers;
    @NotNull
    private final List<VcsException> _exceptions;
    @NotNull
    private static final Logger LOG;

    public Committer(@NotNull Project project, @NotNull String commitMessage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        this.project = project;
        this.commitMessage = commitMessage;
        this.resultHandlers = new ArrayList();
        this._exceptions = new ArrayList();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getCommitMessage() {
        return this.commitMessage;
    }

    @NotNull
    public final List<VcsException> getExceptions() {
        return CollectionsKt.toList((Iterable)this._exceptions);
    }

    @NotNull
    public final List<VcsException> getCommitErrors() {
        return Companion.collectErrors(this._exceptions);
    }

    public final void addResultHandler(@NotNull CommitterResultHandler resultHandler) {
        Intrinsics.checkNotNullParameter((Object)resultHandler, (String)"resultHandler");
        ((Collection)this.resultHandlers).add(resultHandler);
    }

    protected final void addException(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this._exceptions.add(Companion.asVcsException(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    protected final void runCommitTask(boolean useCustomPostRefresh, @NotNull Function0<Unit> task2) {
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        Ref.BooleanRef canceled = new Ref.BooleanRef();
        try {
            ProgressManager.checkCanceled();
            task2.invoke();
        }
        catch (ProcessCanceledException e) {
            canceled.element = true;
        }
        catch (Throwable e) {
            LOG.warn(e);
            this.addException(e);
        }
        finally {
            ActionsKt.runInEdt$default(null, () -> Committer.runCommitTask$lambda$0(this, useCustomPostRefresh, canceled), (int)1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void finishCommit(boolean useCustomPostRefresh, boolean canceled) {
        List<VcsException> errors = this.getCommitErrors();
        if (canceled) {
            void $this$forEachLoggingErrors$iv;
            LOG.debug("Commit canceled");
            Collection collection = this.resultHandlers;
            Logger logger$iv = LOG;
            boolean $i$f$forEachLoggingErrors = false;
            for (Object it$iv : $this$forEachLoggingErrors$iv) {
                try {
                    CommitterResultHandler it = (CommitterResultHandler)it$iv;
                    boolean bl = false;
                    it.onCancel();
                }
                catch (Throwable e$iv) {
                    logger$iv.error(e$iv);
                }
            }
        } else if (errors.isEmpty()) {
            LOG.debug("Commit successful");
            Collection $this$forEachLoggingErrors$iv = this.resultHandlers;
            Logger logger$iv = LOG;
            boolean $i$f$forEachLoggingErrors = false;
            for (Object it$iv : $this$forEachLoggingErrors$iv) {
                try {
                    CommitterResultHandler it = (CommitterResultHandler)it$iv;
                    boolean bl = false;
                    it.onSuccess();
                }
                catch (Throwable e$iv) {
                    logger$iv.error(e$iv);
                }
            }
        } else {
            LOG.debug("Commit failed");
            Collection $this$forEachLoggingErrors$iv = this.resultHandlers;
            Logger logger$iv = LOG;
            boolean $i$f$forEachLoggingErrors = false;
            for (Object it$iv : $this$forEachLoggingErrors$iv) {
                try {
                    CommitterResultHandler it = (CommitterResultHandler)it$iv;
                    boolean bl = false;
                    it.onFailure();
                }
                catch (Throwable e$iv) {
                    logger$iv.error(e$iv);
                }
            }
        }
        if (!useCustomPostRefresh) {
            this.fireAfterRefresh();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void fireAfterRefresh() {
        void $this$forEachLoggingErrors$iv;
        Collection collection = this.resultHandlers;
        Logger logger$iv = LOG;
        boolean $i$f$forEachLoggingErrors = false;
        for (Object it$iv : $this$forEachLoggingErrors$iv) {
            try {
                CommitterResultHandler it = (CommitterResultHandler)it$iv;
                boolean bl = false;
                it.onAfterRefresh();
            }
            catch (Throwable e$iv) {
                logger$iv.error(e$iv);
            }
        }
    }

    private static final Unit runCommitTask$lambda$0(Committer this$0, boolean $useCustomPostRefresh, Ref.BooleanRef $canceled) {
        this$0.finishCommit($useCustomPostRefresh, $canceled.element);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final List<VcsException> collectErrors(@NotNull List<? extends VcsException> exceptions) {
        return Companion.collectErrors(exceptions);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Committer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\n\u0010\n\u001a\u00020\b*\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/commit/Committer$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "collectErrors", "", "Lcom/intellij/openapi/vcs/VcsException;", "exceptions", "asVcsException", "", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nCommitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Committer.kt\ncom/intellij/vcs/commit/Committer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n827#2:138\n855#2,2:139\n*S KotlinDebug\n*F\n+ 1 Committer.kt\ncom/intellij/vcs/commit/Committer$Companion\n*L\n87#1:138\n87#1:139,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<VcsException> collectErrors(@NotNull List<? extends VcsException> exceptions) {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
            Iterable $this$filterNot$iv = exceptions;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                VcsException it = (VcsException)((Object)element$iv$iv);
                boolean bl = false;
                if (it.isWarning()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final VcsException asVcsException(@NotNull Throwable $this$asVcsException) {
            Intrinsics.checkNotNullParameter((Object)$this$asVcsException, (String)"<this>");
            return $this$asVcsException instanceof VcsException ? (VcsException)$this$asVcsException : new VcsException($this$asVcsException);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

