/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionInitializationContextImpl;
import com.intellij.codeInsight.completion.CompletionInitializationUtil;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.terminal.frontend.action.TerminalFrontendDataContextUtils;
import java.awt.event.InputEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006!"}, d2={"Lcom/intellij/terminal/frontend/TerminalCommandCompletion;", "Lcom/intellij/codeInsight/completion/CodeCompletionHandlerBase;", "completionType", "Lcom/intellij/codeInsight/completion/CompletionType;", "invokedExplicitly", "", "autopopup", "synchronous", "<init>", "(Lcom/intellij/codeInsight/completion/CompletionType;ZZZ)V", "getCompletionType", "()Lcom/intellij/codeInsight/completion/CompletionType;", "getInvokedExplicitly", "()Z", "getAutopopup", "getSynchronous", "invokeCompletion", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "time", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "hasModifiers", "caret", "Lcom/intellij/openapi/editor/Caret;", "prepareCaret", "commonEditor", "outputModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "intellij.terminal.frontend"})
public final class TerminalCommandCompletion
extends CodeCompletionHandlerBase {
    @NotNull
    private final CompletionType completionType;
    private final boolean invokedExplicitly;
    private final boolean autopopup;
    private final boolean synchronous;

    public TerminalCommandCompletion(@NotNull CompletionType completionType, boolean invokedExplicitly, boolean autopopup, boolean synchronous) {
        Intrinsics.checkNotNullParameter((Object)completionType, (String)"completionType");
        super(completionType, invokedExplicitly, autopopup, synchronous);
        this.completionType = completionType;
        this.invokedExplicitly = invokedExplicitly;
        this.autopopup = autopopup;
        this.synchronous = synchronous;
    }

    @NotNull
    public final CompletionType getCompletionType() {
        return this.completionType;
    }

    public final boolean getInvokedExplicitly() {
        return this.invokedExplicitly;
    }

    public final boolean getAutopopup() {
        return this.autopopup;
    }

    public final boolean getSynchronous() {
        return this.synchronous;
    }

    public final void invokeCompletion(@NotNull AnActionEvent e, int time) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        TerminalOutputModel terminalOutputModel = TerminalFrontendDataContextUtils.INSTANCE.getTerminalOutputModel(e);
        if (terminalOutputModel == null) {
            throw new AssertionError((Object)"Output model is null during completion");
        }
        TerminalOutputModel outputModel = terminalOutputModel;
        Editor editor = TerminalDataContextUtils.INSTANCE.getTerminalEditor(e);
        if (editor == null) {
            throw new AssertionError((Object)"Common editor is null during completion");
        }
        Editor commonEditor = editor;
        Project project = commonEditor.getProject();
        if (project == null) {
            throw new AssertionError((Object)"Project is null during completion");
        }
        Project project2 = project;
        InputEvent inputEvent = e.getInputEvent();
        Caret caret = this.prepareCaret(commonEditor, outputModel);
        this.invokeCompletion(project2, commonEditor, time, inputEvent != null && inputEvent.getModifiersEx() != 0, caret);
    }

    protected void invokeCompletion(@NotNull Project project, @NotNull Editor editor, int time, boolean hasModifiers, @NotNull Caret caret) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int time2 = time;
        CompletionPhase phase = CompletionServiceImpl.Companion.getCompletionPhase();
        CompletionProgressIndicator completionProgressIndicator = phase.indicator;
        boolean repeated = completionProgressIndicator != null ? completionProgressIndicator.isRepeatedInvocation(this.completionType, editor) : false;
        int newTime = phase.newCompletionStarted(time2, repeated);
        if (this.invokedExplicitly) {
            time2 = newTime;
        }
        int invocationCount = time2;
        Class[] classArray = new Class[]{CompletionPhase.InsertedSingleItem.class};
        if (CompletionServiceImpl.Companion.isPhase(classArray)) {
            CompletionServiceImpl.Companion.setCompletionPhase(CompletionPhase.NoCompletion);
        }
        classArray = new Class[]{CompletionPhase.NoCompletion.getClass(), CompletionPhase.CommittingDocuments.class};
        CompletionServiceImpl.Companion.assertPhase(classArray);
        long startingTime = System.currentTimeMillis();
        Runnable initCmd = () -> TerminalCommandCompletion.invokeCompletion$lambda$0(startingTime, caret, project, editor, this, invocationCount, hasModifiers);
        try {
            CommandProcessor.getInstance().executeCommand(project, initCmd, null, null, editor.getDocument());
        }
        catch (IndexNotReadyException e) {
            DumbService dumbService = DumbService.Companion.getInstance(project);
            String string = CodeInsightBundle.message((String)"completion.not.available.during.indexing", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            dumbService.showDumbModeNotificationForFunctionality(string, DumbModeBlockedFunctionality.CodeCompletion);
            throw e;
        }
    }

    private final Caret prepareCaret(Editor commonEditor, TerminalOutputModel outputModel) {
        CaretModel caretModel = commonEditor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caret = caretModel;
        Caret caret2 = caret.getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret2, (String)"getPrimaryCaret(...)");
        Caret primaryCaret = caret2;
        primaryCaret.moveToOffset(((Number)outputModel.getCursorOffsetState().getValue()).intValue());
        CodeCompletionHandlerBase.clearCaretMarkers((Editor)commonEditor);
        CodeCompletionHandlerBase.markCaretAsProcessed((Caret)primaryCaret);
        return primaryCaret;
    }

    private static final void invokeCompletion$lambda$0(long $startingTime, Caret $caret, Project $project, Editor $editor, TerminalCommandCompletion this$0, int $invocationCount, boolean $hasModifiers) {
        boolean hasValidContext;
        CompletionInitializationContextImpl context = (CompletionInitializationContextImpl)ProgressIndicatorUtils.withTimeout((long)CodeCompletionHandlerBase.calcSyncTimeOut((long)$startingTime), () -> TerminalCommandCompletion.invokeCompletion$lambda$0$0($project, $editor, $caret, $invocationCount, this$0));
        boolean bl = hasValidContext = context != null;
        if (!hasValidContext) {
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Caret)$caret, (Project)$project);
            Intrinsics.checkNotNull((Object)psiFile);
            PsiFile psiFile2 = psiFile;
            context = new CompletionInitializationContextImpl($editor, $caret, psiFile2, this$0.completionType, $invocationCount);
        }
        this$0.doComplete(context, $hasModifiers, hasValidContext, $startingTime);
    }

    private static final CompletionInitializationContextImpl invokeCompletion$lambda$0$0(Project $project, Editor $editor, Caret $caret, int $invocationCount, TerminalCommandCompletion this$0) {
        return CompletionInitializationUtil.createCompletionInitializationContext((Project)$project, (Editor)$editor, (Caret)$caret, (int)$invocationCount, (CompletionType)this$0.completionType);
    }
}

