/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.frontend.TerminalSessionController;
import com.intellij.terminal.frontend.TerminalSessionControllerKt;
import com.intellij.terminal.frontend.hyperlinks.FrontendTerminalHyperlinkFacade;
import com.intellij.terminal.session.TerminalAliasesReceivedEvent;
import com.intellij.terminal.session.TerminalBeepEvent;
import com.intellij.terminal.session.TerminalCommandFinishedEvent;
import com.intellij.terminal.session.TerminalCommandStartedEvent;
import com.intellij.terminal.session.TerminalContentUpdatedEvent;
import com.intellij.terminal.session.TerminalCursorPositionChangedEvent;
import com.intellij.terminal.session.TerminalHyperlinksChangedEvent;
import com.intellij.terminal.session.TerminalHyperlinksHeartbeatEvent;
import com.intellij.terminal.session.TerminalInitialStateEvent;
import com.intellij.terminal.session.TerminalOutputEvent;
import com.intellij.terminal.session.TerminalPromptFinishedEvent;
import com.intellij.terminal.session.TerminalPromptStartedEvent;
import com.intellij.terminal.session.TerminalSession;
import com.intellij.terminal.session.TerminalSessionTerminatedEvent;
import com.intellij.terminal.session.TerminalState;
import com.intellij.terminal.session.TerminalStateChangedEvent;
import com.intellij.terminal.session.dto.TerminalBlocksModelStateDto;
import com.intellij.terminal.session.dto.TerminalBlocksModelStateDtoKt;
import com.intellij.terminal.session.dto.TerminalOutputModelStateDto;
import com.intellij.terminal.session.dto.TerminalOutputModelStateDtoKt;
import com.intellij.terminal.session.dto.TerminalStateDto;
import com.intellij.terminal.session.dto.TerminalStateDtoKt;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.DisposableWrapperList;
import java.awt.Toolkit;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.reworked.TerminalAliasesStorage;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelKt;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalShellIntegrationEventsListener;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.fus.BatchLatencyReporter;
import org.jetbrains.plugins.terminal.fus.DurationAndTextLength;
import org.jetbrains.plugins.terminal.fus.FrontendOutputActivity;
import org.jetbrains.plugins.terminal.fus.ReworkedTerminalUsageCollector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u001c\u0010(\u001a\u00020%2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0082@\u00a2\u0006\u0002\u0010,J\u0016\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020+H\u0082@\u00a2\u0006\u0002\u0010/J\u0012\u00100\u001a\u0004\u0018\u00010\t2\u0006\u0010.\u001a\u000201H\u0002J\"\u00102\u001a\u00020%2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020%04H\u0082@\u00a2\u0006\u0002\u00105J\u0018\u00106\u001a\u00020%2\u0006\u00107\u001a\u00020\u00072\u0006\u0010.\u001a\u000208H\u0003J\b\u00109\u001a\u00020\u0007H\u0002J\u001a\u0010:\u001a\u00020%2\n\u0010;\u001a\u00060\u001aj\u0002`\u001b2\u0006\u0010<\u001a\u00020=J\b\u0010>\u001a\u00020%H\u0002J\u0016\u0010?\u001a\u00020%2\u0006\u0010<\u001a\u00020=2\u0006\u0010@\u001a\u00020\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\f\u0012\b\u0012\u00060\u001aj\u0002`\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/terminal/frontend/TerminalSessionController;", "", "project", "Lcom/intellij/openapi/project/Project;", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "outputHyperlinkFacade", "Lcom/intellij/terminal/frontend/hyperlinks/FrontendTerminalHyperlinkFacade;", "alternateBufferModel", "alternateBufferHyperlinkFacade", "blocksModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModel;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "fusActivity", "Lorg/jetbrains/plugins/terminal/fus/FrontendOutputActivity;", "terminalAliasesStorage", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalAliasesStorage;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;Lcom/intellij/terminal/frontend/hyperlinks/FrontendTerminalHyperlinkFacade;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;Lcom/intellij/terminal/frontend/hyperlinks/FrontendTerminalHyperlinkFacade;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModel;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/terminal/fus/FrontendOutputActivity;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalAliasesStorage;)V", "terminationListeners", "Lcom/intellij/util/containers/DisposableWrapperList;", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "shellIntegrationEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalShellIntegrationEventsListener;", "edtContext", "Lkotlin/coroutines/CoroutineContext;", "documentUpdateLatencyReporter", "Lorg/jetbrains/plugins/terminal/fus/BatchLatencyReporter;", "Lorg/jetbrains/plugins/terminal/fus/DurationAndTextLength;", "handleEvents", "", "session", "Lcom/intellij/terminal/session/TerminalSession;", "doHandleEvents", "events", "", "Lcom/intellij/terminal/session/TerminalOutputEvent;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleEvent", "event", "(Lcom/intellij/terminal/session/TerminalOutputEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCurrentHyperlinkFacade", "Lcom/intellij/terminal/session/TerminalHyperlinksChangedEvent;", "updateOutputModel", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateOutputModelContent", "model", "Lcom/intellij/terminal/session/TerminalContentUpdatedEvent;", "getCurrentOutputModel", "addTerminationCallback", "onTerminated", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "fireSessionTerminated", "addShellIntegrationListener", "listener", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalSessionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalSessionController.kt\ncom/intellij/terminal/frontend/TerminalSessionController\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 BatchLatencyReporter.kt\norg/jetbrains/plugins/terminal/fus/BatchLatencyReporterKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n23#2:209\n23#2:210\n101#3:211\n87#3:215\n89#3:217\n90#3,2:220\n50#3:222\n52#3,20:224\n87#3:244\n89#3:246\n90#3,2:249\n1803#4,3:212\n1011#4,2:218\n1011#4,2:247\n1#5:216\n1#5:223\n1#5:245\n*S KotlinDebug\n*F\n+ 1 TerminalSessionController.kt\ncom/intellij/terminal/frontend/TerminalSessionController\n*L\n75#1:209\n197#1:210\n50#1:211\n51#1:215\n51#1:217\n51#1:220,2\n52#1:222\n52#1:224,20\n53#1:244\n53#1:246\n53#1:249,2\n50#1:212,3\n51#1:218,2\n53#1:247,2\n51#1:216\n52#1:223\n53#1:245\n*E\n"})
public final class TerminalSessionController {
    @NotNull
    private final Project project;
    @NotNull
    private final TerminalSessionModel sessionModel;
    @NotNull
    private final TerminalOutputModel outputModel;
    @Nullable
    private final FrontendTerminalHyperlinkFacade outputHyperlinkFacade;
    @NotNull
    private final TerminalOutputModel alternateBufferModel;
    @Nullable
    private final FrontendTerminalHyperlinkFacade alternateBufferHyperlinkFacade;
    @NotNull
    private final TerminalBlocksModel blocksModel;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final FrontendOutputActivity fusActivity;
    @NotNull
    private final TerminalAliasesStorage terminalAliasesStorage;
    @NotNull
    private final DisposableWrapperList<Runnable> terminationListeners;
    @NotNull
    private final EventDispatcher<TerminalShellIntegrationEventsListener> shellIntegrationEventDispatcher;
    @NotNull
    private final CoroutineContext edtContext;
    @NotNull
    private final BatchLatencyReporter<DurationAndTextLength> documentUpdateLatencyReporter;

    public TerminalSessionController(@NotNull Project project, @NotNull TerminalSessionModel sessionModel, @NotNull TerminalOutputModel outputModel, @Nullable FrontendTerminalHyperlinkFacade outputHyperlinkFacade, @NotNull TerminalOutputModel alternateBufferModel, @Nullable FrontendTerminalHyperlinkFacade alternateBufferHyperlinkFacade, @NotNull TerminalBlocksModel blocksModel, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull CoroutineScope coroutineScope, @NotNull FrontendOutputActivity fusActivity, @NotNull TerminalAliasesStorage terminalAliasesStorage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)alternateBufferModel, (String)"alternateBufferModel");
        Intrinsics.checkNotNullParameter((Object)blocksModel, (String)"blocksModel");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)fusActivity, (String)"fusActivity");
        Intrinsics.checkNotNullParameter((Object)terminalAliasesStorage, (String)"terminalAliasesStorage");
        this.project = project;
        this.sessionModel = sessionModel;
        this.outputModel = outputModel;
        this.outputHyperlinkFacade = outputHyperlinkFacade;
        this.alternateBufferModel = alternateBufferModel;
        this.alternateBufferHyperlinkFacade = alternateBufferHyperlinkFacade;
        this.blocksModel = blocksModel;
        this.settings = settings;
        this.coroutineScope = coroutineScope;
        this.fusActivity = fusActivity;
        this.terminalAliasesStorage = terminalAliasesStorage;
        this.terminationListeners = new DisposableWrapperList();
        EventDispatcher eventDispatcher2 = EventDispatcher.create(TerminalShellIntegrationEventsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher2, (String)"create(...)");
        this.shellIntegrationEventDispatcher = eventDispatcher2;
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        this.edtContext = coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState));
        this.documentUpdateLatencyReporter = new BatchLatencyReporter(100, TerminalSessionController::documentUpdateLatencyReporter$lambda$0);
    }

    public final void handleEvents(@NotNull TerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(session2, this, null){
            Object L$0;
            int label;
            final /* synthetic */ TerminalSession $session;
            final /* synthetic */ TerminalSessionController this$0;
            {
                this.$session = $session;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = this.$session.getOutputFlow((Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        outputFlow = (Flow)v0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)outputFlow);
                        this.label = 2;
                        v1 = outputFlow.collect(new FlowCollector(this.this$0){
                            final /* synthetic */ TerminalSessionController this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(List<? extends TerminalOutputEvent> events, Continuation<? super Unit> $completion) {
                                Object object = TerminalSessionController.access$doHandleEvents(this.this$0, events, $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        outputFlow = (Flow)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object doHandleEvents(List<? extends TerminalOutputEvent> events, Continuation<? super Unit> $completion) {
        if (!($completion instanceof doHandleEvents.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalSessionController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalSessionController.access$doHandleEvents(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = events.iterator();
lbl13:
                // 4 sources

                while (var3_6.hasNext()) {
                    event = (TerminalOutputEvent)var3_6.next();
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)events);
                    $continuation.L$1 = var3_6;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)event);
                    $continuation.label = 1;
                    v0 = this.handleEvent(event, (Continuation<? super Unit>)$continuation);
                    if (v0 != var10_5) continue;
                    return var10_5;
                }
                break;
            }
            case 1: {
                event = (TerminalOutputEvent)$continuation.L$2;
                var3_6 = (Iterator)$continuation.L$1;
                events = (List)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                    ** GOTO lbl13
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Throwable t) {
                    $this$thisLogger$iv = this;
                    $i$f$thisLogger = false;
                    v1 = Logger.getInstance(TerminalSessionController.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                    v1.error(t);
                    ** GOTO lbl13
                }
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleEvent(TerminalOutputEvent event, Continuation<? super Unit> $completion) {
        block25: {
            block34: {
                block33: {
                    block32: {
                        block31: {
                            block30: {
                                block29: {
                                    block28: {
                                        block27: {
                                            block26: {
                                                block24: {
                                                    block23: {
                                                        block22: {
                                                            if (!($completion instanceof handleEvent.1)) ** GOTO lbl-1000
                                                            var6_3 = $completion;
                                                            if ((var6_3.label & -2147483648) != 0) {
                                                                var6_3.label -= -2147483648;
                                                            } else lbl-1000:
                                                            // 2 sources

                                                            {
                                                                $continuation = new ContinuationImpl(this, $completion){
                                                                    Object L$0;
                                                                    /* synthetic */ Object result;
                                                                    final /* synthetic */ TerminalSessionController this$0;
                                                                    int label;
                                                                    {
                                                                        this.this$0 = this$0;
                                                                        super($completion);
                                                                    }

                                                                    @Nullable
                                                                    public final Object invokeSuspend(@NotNull Object $result) {
                                                                        this.result = $result;
                                                                        this.label |= Integer.MIN_VALUE;
                                                                        return TerminalSessionController.access$handleEvent(this.this$0, null, (Continuation)this);
                                                                    }
                                                                };
                                                            }
                                                            $result = $continuation.result;
                                                            var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                            switch ($continuation.label) {
                                                                case 0: {
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    var3_6 = event;
                                                                    if (!(var3_6 instanceof TerminalInitialStateEvent)) break;
                                                                    this.sessionModel.updateTerminalState(TerminalStateDtoKt.toTerminalState((TerminalStateDto)((TerminalInitialStateEvent)event).getSessionState()));
                                                                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)event);
                                                                    $continuation.label = 1;
                                                                    v0 = this.updateOutputModel((Function1<? super TerminalOutputModel, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, handleEvent$lambda$0(com.intellij.terminal.frontend.TerminalSessionController com.intellij.terminal.session.TerminalOutputEvent org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel ), (Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;)Lkotlin/Unit;)((TerminalSessionController)this, (TerminalOutputEvent)event), (Continuation<? super Unit>)$continuation);
                                                                    if (v0 == var7_5) {
                                                                        return var7_5;
                                                                    }
                                                                    ** GOTO lbl25
                                                                }
                                                                case 1: {
                                                                    event = (TerminalOutputEvent)$continuation.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v0 = $result;
lbl25:
                                                                    // 2 sources

                                                                    return Unit.INSTANCE;
                                                                }
                                                            }
                                                            if (!(var3_6 instanceof TerminalContentUpdatedEvent)) break block22;
                                                            this.fusActivity.eventReceived((TerminalContentUpdatedEvent)event);
                                                            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)event);
                                                            $continuation.label = 2;
                                                            v1 = this.updateOutputModel((Function1<? super TerminalOutputModel, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, handleEvent$lambda$1(com.intellij.terminal.frontend.TerminalSessionController com.intellij.terminal.session.TerminalOutputEvent org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel ), (Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;)Lkotlin/Unit;)((TerminalSessionController)this, (TerminalOutputEvent)event), (Continuation<? super Unit>)$continuation);
                                                            if (v1 == var7_5) {
                                                                return var7_5;
                                                            }
                                                            ** GOTO lbl38
                                                            {
                                                                case 2: {
                                                                    event = (TerminalOutputEvent)$continuation.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v1 = $result;
lbl38:
                                                                    // 2 sources

                                                                    return Unit.INSTANCE;
                                                                }
                                                            }
                                                        }
                                                        if (!(var3_6 instanceof TerminalCursorPositionChangedEvent)) break block23;
                                                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)event);
                                                        $continuation.label = 3;
                                                        v2 = this.updateOutputModel((Function1<? super TerminalOutputModel, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, handleEvent$lambda$2(com.intellij.terminal.session.TerminalOutputEvent org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel ), (Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;)Lkotlin/Unit;)((TerminalOutputEvent)event), (Continuation<? super Unit>)$continuation);
                                                        if (v2 == var7_5) {
                                                            return var7_5;
                                                        }
                                                        ** GOTO lbl51
                                                        {
                                                            case 3: {
                                                                event = (TerminalOutputEvent)$continuation.L$0;
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v2 = $result;
lbl51:
                                                                // 2 sources

                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                    }
                                                    if (!(var3_6 instanceof TerminalStateChangedEvent)) break block24;
                                                    state = TerminalStateDtoKt.toTerminalState((TerminalStateDto)((TerminalStateChangedEvent)event).getState());
                                                    this.sessionModel.updateTerminalState(state);
                                                    break block25;
                                                }
                                                if (!(var3_6 instanceof TerminalBeepEvent)) break block26;
                                                if (this.settings.audibleBell()) {
                                                    Toolkit.getDefaultToolkit().beep();
                                                }
                                                break block25;
                                            }
                                            if (!Intrinsics.areEqual((Object)var3_6, (Object)TerminalSessionTerminatedEvent.INSTANCE)) break block27;
                                            this.fireSessionTerminated();
                                            break block25;
                                        }
                                        if (!Intrinsics.areEqual((Object)var3_6, (Object)TerminalPromptStartedEvent.INSTANCE)) break block28;
                                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)event);
                                        $continuation.label = 4;
                                        v3 = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                                            int label;
                                            final /* synthetic */ TerminalSessionController this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        TerminalSessionController.access$getBlocksModel$p(this.this$0).promptStarted(((Number)TerminalSessionController.access$getOutputModel$p(this.this$0).getCursorOffsetState().getValue()).intValue());
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)$continuation);
                                        if (v3 == var7_5) {
                                            return var7_5;
                                        }
                                        ** GOTO lbl78
                                        {
                                            case 4: {
                                                event = (TerminalOutputEvent)$continuation.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v3 = $result;
lbl78:
                                                // 2 sources

                                                ((TerminalShellIntegrationEventsListener)this.shellIntegrationEventDispatcher.getMulticaster()).promptStarted();
                                                break block25;
                                            }
                                        }
                                    }
                                    if (!Intrinsics.areEqual((Object)var3_6, (Object)TerminalPromptFinishedEvent.INSTANCE)) break block29;
                                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)event);
                                    $continuation.label = 5;
                                    v4 = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                                        int label;
                                        final /* synthetic */ TerminalSessionController this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(2, $completion);
                                        }

                                        public final Object invokeSuspend(Object $result) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    TerminalSessionController.access$getBlocksModel$p(this.this$0).promptFinished(((Number)TerminalSessionController.access$getOutputModel$p(this.this$0).getCursorOffsetState().getValue()).intValue());
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation)$continuation);
                                    if (v4 == var7_5) {
                                        return var7_5;
                                    }
                                    ** GOTO lbl92
                                    {
                                        case 5: {
                                            event = (TerminalOutputEvent)$continuation.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v4 = $result;
lbl92:
                                            // 2 sources

                                            ((TerminalShellIntegrationEventsListener)this.shellIntegrationEventDispatcher.getMulticaster()).promptFinished();
                                            break block25;
                                        }
                                    }
                                }
                                if (!(var3_6 instanceof TerminalCommandStartedEvent)) break block30;
                                $continuation.L$0 = event;
                                $continuation.label = 6;
                                v5 = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                                    int label;
                                    final /* synthetic */ TerminalSessionController this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                TerminalSessionController.access$getBlocksModel$p(this.this$0).commandStarted(((Number)TerminalSessionController.access$getOutputModel$p(this.this$0).getCursorOffsetState().getValue()).intValue());
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)$continuation);
                                if (v5 == var7_5) {
                                    return var7_5;
                                }
                                ** GOTO lbl106
                                {
                                    case 6: {
                                        event = (TerminalOutputEvent)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v5 = $result;
lbl106:
                                        // 2 sources

                                        ((TerminalShellIntegrationEventsListener)this.shellIntegrationEventDispatcher.getMulticaster()).commandStarted(((TerminalCommandStartedEvent)event).getCommand());
                                        break block25;
                                    }
                                }
                            }
                            if (!(var3_6 instanceof TerminalCommandFinishedEvent)) break block31;
                            $continuation.L$0 = event;
                            $continuation.label = 7;
                            v6 = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
                                int label;
                                final /* synthetic */ TerminalSessionController this$0;
                                final /* synthetic */ TerminalOutputEvent $event;
                                {
                                    this.this$0 = $receiver;
                                    this.$event = $event;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            TerminalSessionController.access$getBlocksModel$p(this.this$0).commandFinished(((TerminalCommandFinishedEvent)this.$event).getExitCode());
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)$continuation);
                            if (v6 == var7_5) {
                                return var7_5;
                            }
                            ** GOTO lbl120
                            {
                                case 7: {
                                    event = (TerminalOutputEvent)$continuation.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v6 = $result;
lbl120:
                                    // 2 sources

                                    ((TerminalShellIntegrationEventsListener)this.shellIntegrationEventDispatcher.getMulticaster()).commandFinished(((TerminalCommandFinishedEvent)event).getCommand(), ((TerminalCommandFinishedEvent)event).getExitCode(), ((TerminalCommandFinishedEvent)event).getCurrentDirectory());
                                    break block25;
                                }
                            }
                        }
                        if (!(var3_6 instanceof TerminalAliasesReceivedEvent)) break block32;
                        this.terminalAliasesStorage.setAliasesInfo(((TerminalAliasesReceivedEvent)event).getAliases());
                        break block25;
                    }
                    if (!(var3_6 instanceof TerminalHyperlinksHeartbeatEvent)) break block33;
                    TerminalSessionControllerKt.access$getLOG$p().warn("TerminalHyperlinksHeartbeatEvent isn't supposed to reach the frontend");
                    break block25;
                }
                if (!(var3_6 instanceof TerminalHyperlinksChangedEvent)) break block34;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)event);
                $continuation.label = 8;
                v7 = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
                    int label;
                    final /* synthetic */ TerminalSessionController this$0;
                    final /* synthetic */ TerminalOutputEvent $event;
                    {
                        this.this$0 = $receiver;
                        this.$event = $event;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Unit unit;
                                ResultKt.throwOnFailure((Object)$result);
                                FrontendTerminalHyperlinkFacade frontendTerminalHyperlinkFacade = TerminalSessionController.access$getCurrentHyperlinkFacade(this.this$0, (TerminalHyperlinksChangedEvent)this.$event);
                                if (frontendTerminalHyperlinkFacade != null) {
                                    frontendTerminalHyperlinkFacade.updateHyperlinks((TerminalHyperlinksChangedEvent)this.$event);
                                    unit = Unit.INSTANCE;
                                } else {
                                    unit = null;
                                }
                                return unit;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v7 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl142
                {
                    case 8: {
                        event = (TerminalOutputEvent)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl142:
                        // 2 sources

                        return v7;
                    }
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final FrontendTerminalHyperlinkFacade getCurrentHyperlinkFacade(TerminalHyperlinksChangedEvent event) {
        return event.isInAlternateBuffer() ? this.alternateBufferHyperlinkFacade : this.outputHyperlinkFacade;
    }

    private final Object updateOutputModel(Function1<? super TerminalOutputModel, Unit> block, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(this, block, null){
            int label;
            final /* synthetic */ TerminalSessionController this$0;
            final /* synthetic */ Function1<TerminalOutputModel, Unit> $block;
            {
                this.this$0 = $receiver;
                this.$block = $block;
                super(2, $completion);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object;
                        ResultKt.throwOnFailure((Object)$result);
                        Runnable doUpdate = () -> updateOutputModel.2.invokeSuspend$lambda$0(this.$block, this.this$0);
                        LookupEx lookup = LookupManager.getInstance((Project)TerminalSessionController.access$getProject$p(this.this$0)).getActiveLookup();
                        if (lookup != null) {
                            Editor editor = lookup.getEditor();
                            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                            if (TerminalDataContextUtils.INSTANCE.isReworkedTerminalEditor(editor)) {
                                object = Boxing.boxBoolean((boolean)lookup.performGuardedChange(doUpdate));
                                return object;
                            }
                        }
                        doUpdate.run();
                        object = Unit.INSTANCE;
                        return object;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<Object> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(Function1 $block, TerminalSessionController this$0) {
                $block.invoke((Object)TerminalSessionController.access$getCurrentOutputModel(this$0));
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @RequiresEdt
    private final void updateOutputModelContent(TerminalOutputModel model, TerminalContentUpdatedEvent event) {
        long startTime = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        TerminalOutputModelKt.updateContent(model, event);
        DurationAndTextLength latencyData = new DurationAndTextLength(TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)startTime), event.getText().length(), null);
        this.documentUpdateLatencyReporter.update(latencyData);
    }

    private final TerminalOutputModel getCurrentOutputModel() {
        return ((TerminalState)this.sessionModel.getTerminalState().getValue()).isAlternateScreenBuffer() ? this.alternateBufferModel : this.outputModel;
    }

    public final void addTerminationCallback(@NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)onTerminated, (String)"onTerminated");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.terminationListeners.add((Object)onTerminated, parentDisposable);
    }

    private final void fireSessionTerminated() {
        Iterator iterator = this.terminationListeners.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Runnable listener2 = (Runnable)iterator2.next();
            try {
                listener2.run();
            }
            catch (Throwable t) {
                TerminalSessionController $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(TerminalSessionController.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Unhandled exception in termination listener", t);
            }
        }
    }

    public final void addShellIntegrationListener(@NotNull Disposable parentDisposable, @NotNull TerminalShellIntegrationEventsListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.shellIntegrationEventDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit documentUpdateLatencyReporter$lambda$0(List samples) {
        List $this$thirdLargestOf$iv;
        void p0;
        List $this$percentileOf$iv;
        long l;
        void $this$fold$iv$iv;
        List $this$totalDurationOf$iv;
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        List list = samples;
        ReworkedTerminalUsageCollector reworkedTerminalUsageCollector = ReworkedTerminalUsageCollector.INSTANCE;
        boolean $i$f$totalDurationOf = false;
        Iterable iterable = $this$totalDurationOf$iv;
        long initial$iv$iv = Duration.Companion.getZERO-UwyO8pc();
        boolean $i$f$fold22 = false;
        long accumulator$iv$iv = initial$iv$iv;
        Iterator iterator = $this$fold$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p02;
            void value$iv;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator.next();
            long acc$iv = accumulator$iv$iv;
            boolean bl = false;
            DurationAndTextLength durationAndTextLength = (DurationAndTextLength)value$iv;
            l = acc$iv;
            boolean bl2 = false;
            long l2 = p02.getDuration-UwyO8pc();
            accumulator$iv$iv = Duration.plus-LRDsOJo((long)l, (long)l2);
        }
        l = accumulator$iv$iv;
        $this$totalDurationOf$iv = samples;
        int n$iv = 90;
        boolean $i$f$percentileOf = false;
        void $this$sortBy$iv$iv = $this$percentileOf$iv;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DurationAndTextLength p0 = (DurationAndTextLength)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)Duration.box-impl((long)p0.getDuration-UwyO8pc());
                    p0 = (DurationAndTextLength)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)Duration.box-impl((long)p0.getDuration-UwyO8pc())));
                }
            });
        }
        int index$iv = RangesKt.coerceAtMost((int)($this$percentileOf$iv.size() * n$iv / 100), (int)($this$percentileOf$iv.size() - 1));
        DurationAndTextLength $i$f$fold22 = (DurationAndTextLength)$this$percentileOf$iv.get(index$iv);
        boolean bl = false;
        Duration duration = Duration.box-impl((long)p0.getDuration-UwyO8pc());
        $this$percentileOf$iv = samples;
        long l3 = ((Duration)((Comparable)duration)).unbox-impl();
        boolean $i$f$thirdLargestOf = false;
        if (!(!((Collection)$this$thirdLargestOf$iv).isEmpty())) {
            boolean $i$a$-check-BatchLatencyReporterKt$thirdLargestOf$1$iv22 = false;
            String $i$a$-check-BatchLatencyReporterKt$thirdLargestOf$1$iv22 = "It is expected that array is not empty";
            throw new IllegalStateException($i$a$-check-BatchLatencyReporterKt$thirdLargestOf$1$iv22.toString());
        }
        DurationAndTextLength p03 = (DurationAndTextLength)$this$thirdLargestOf$iv.get(0);
        boolean bl3 = false;
        Object max$iv = (Comparable)Duration.box-impl((long)p03.getDuration-UwyO8pc());
        Comparable secondLargest$iv = max$iv;
        Comparable thirdLargest$iv = max$iv;
        for (Object value$iv : $this$thirdLargestOf$iv) {
            DurationAndTextLength p04 = (DurationAndTextLength)value$iv;
            $i$a$-thirdLargestOf-TerminalSessionController$documentUpdateLatencyReporter$1$3 = false;
            Comparable comparableValue$iv = (Comparable)Duration.box-impl((long)p04.getDuration-UwyO8pc());
            if (comparableValue$iv.compareTo(max$iv) > 0) {
                thirdLargest$iv = secondLargest$iv;
                secondLargest$iv = max$iv;
                max$iv = comparableValue$iv;
                continue;
            }
            if (comparableValue$iv.compareTo(secondLargest$iv) > 0) {
                thirdLargest$iv = secondLargest$iv;
                secondLargest$iv = comparableValue$iv;
                continue;
            }
            if (comparableValue$iv.compareTo(thirdLargest$iv) <= 0) continue;
            thirdLargest$iv = comparableValue$iv;
        }
        Comparable comparable = thirdLargest$iv;
        long l4 = ((Duration)comparable).unbox-impl();
        $this$thirdLargestOf$iv = samples;
        n$iv = 90;
        $i$f$percentileOf = false;
        List $this$sortBy$iv$iv2 = $this$percentileOf$iv;
        $i$f$sortBy = false;
        if ($this$sortBy$iv$iv2.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DurationAndTextLength p0 = (DurationAndTextLength)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(p0.getTextLength());
                    p0 = (DurationAndTextLength)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getTextLength()));
                }
            });
        }
        index$iv = RangesKt.coerceAtMost((int)($this$percentileOf$iv.size() * n$iv / 100), (int)($this$percentileOf$iv.size() - 1));
        max$iv = (DurationAndTextLength)$this$percentileOf$iv.get(index$iv);
        long l5 = l4;
        boolean bl4 = false;
        int n = p0.getTextLength();
        reworkedTerminalUsageCollector.logFrontendDocumentUpdateLatency-2d-g_3Q(l, l3, l5, n);
        return Unit.INSTANCE;
    }

    private static final Unit handleEvent$lambda$0(TerminalSessionController this$0, TerminalOutputEvent $event, TerminalOutputModel it) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.outputModel.restoreFromState(TerminalOutputModelStateDtoKt.toState((TerminalOutputModelStateDto)((TerminalInitialStateEvent)$event).getOutputModelState()));
            this$0.alternateBufferModel.restoreFromState(TerminalOutputModelStateDtoKt.toState((TerminalOutputModelStateDto)((TerminalInitialStateEvent)$event).getAlternateBufferState()));
            this$0.blocksModel.restoreFromState(TerminalBlocksModelStateDtoKt.toState((TerminalBlocksModelStateDto)((TerminalInitialStateEvent)$event).getBlocksModelState()));
            FrontendTerminalHyperlinkFacade frontendTerminalHyperlinkFacade = this$0.outputHyperlinkFacade;
            if (frontendTerminalHyperlinkFacade != null) {
                frontendTerminalHyperlinkFacade.restoreFromState(((TerminalInitialStateEvent)$event).getOutputHyperlinksState());
            }
            FrontendTerminalHyperlinkFacade frontendTerminalHyperlinkFacade2 = this$0.alternateBufferHyperlinkFacade;
            if (frontendTerminalHyperlinkFacade2 == null) break block1;
            frontendTerminalHyperlinkFacade2.restoreFromState(((TerminalInitialStateEvent)$event).getAlternateBufferHyperlinksState());
        }
        return Unit.INSTANCE;
    }

    private static final Unit handleEvent$lambda$1(TerminalSessionController this$0, TerminalOutputEvent $event, TerminalOutputModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this$0.fusActivity.beforeModelUpdate();
        this$0.updateOutputModelContent(model, (TerminalContentUpdatedEvent)$event);
        this$0.fusActivity.afterModelUpdate();
        return Unit.INSTANCE;
    }

    private static final Unit handleEvent$lambda$2(TerminalOutputEvent $event, TerminalOutputModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        model.updateCursorPosition(((TerminalCursorPositionChangedEvent)$event).getLogicalLineIndex(), ((TerminalCursorPositionChangedEvent)$event).getColumnIndex());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$doHandleEvents(TerminalSessionController $this, List events, Continuation $completion) {
        return $this.doHandleEvents(events, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleEvent(TerminalSessionController $this, TerminalOutputEvent event, Continuation $completion) {
        return $this.handleEvent(event, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ TerminalBlocksModel access$getBlocksModel$p(TerminalSessionController $this) {
        return $this.blocksModel;
    }

    public static final /* synthetic */ TerminalOutputModel access$getOutputModel$p(TerminalSessionController $this) {
        return $this.outputModel;
    }

    public static final /* synthetic */ FrontendTerminalHyperlinkFacade access$getCurrentHyperlinkFacade(TerminalSessionController $this, TerminalHyperlinksChangedEvent event) {
        return $this.getCurrentHyperlinkFacade(event);
    }

    public static final /* synthetic */ Object access$updateOutputModel(TerminalSessionController $this, Function1 block, Continuation $completion) {
        return $this.updateOutputModel((Function1<? super TerminalOutputModel, Unit>)block, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Project access$getProject$p(TerminalSessionController $this) {
        return $this.project;
    }

    public static final /* synthetic */ TerminalOutputModel access$getCurrentOutputModel(TerminalSessionController $this) {
        return $this.getCurrentOutputModel();
    }
}

