/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.terminal.frontend.TerminalTypeAheadKt;
import com.intellij.terminal.session.TerminalOutputBlock;
import com.intellij.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/terminal/frontend/TerminalTypeAhead;", "", "outputModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "blocksModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModel;Lcom/intellij/openapi/editor/Editor;)V", "runUpdate", "", "update", "Ljava/lang/Runnable;", "stringTyped", "string", "", "backspace", "isDisabled", "", "isDisabledInRegistry", "isTypingCommand", "Companion", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalTypeAhead.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalTypeAhead.kt\ncom/intellij/terminal/frontend/TerminalTypeAhead\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,93:1\n67#2,4:94\n67#2,4:98\n13#2:102\n*S KotlinDebug\n*F\n+ 1 TerminalTypeAhead.kt\ncom/intellij/terminal/frontend/TerminalTypeAhead\n*L\n41#1:94,4\n49#1:98,4\n25#1:102\n*E\n"})
public final class TerminalTypeAhead {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalBlocksModel blocksModel;
    @NotNull
    private final Editor editor;
    @NotNull
    private static final Key<TerminalTypeAhead> KEY;
    @NotNull
    private static final Logger LOG;

    public TerminalTypeAhead(@NotNull TerminalOutputModel outputModel, @NotNull TerminalBlocksModel blocksModel, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)blocksModel, (String)"blocksModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.outputModel = outputModel;
        this.blocksModel = blocksModel;
        this.editor = editor;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void runUpdate(Runnable update) {
        LookupEx lookup = LookupManager.getActiveLookup((Editor)this.editor);
        if (lookup != null) {
            Editor editor = lookup.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            if (TerminalDataContextUtils.INSTANCE.isReworkedTerminalEditor(editor)) {
                lookup.performGuardedChange(update);
                return;
            }
        }
        update.run();
    }

    public final void stringTyped(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (this.isDisabled()) {
            return;
        }
        this.runUpdate(() -> TerminalTypeAhead.stringTyped$lambda$0(this, string));
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("String typed prediction inserted: '" + string + "'");
        }
    }

    public final void backspace() {
        Integer commandStartOffset;
        if (this.isDisabled()) {
            return;
        }
        TerminalOutputBlock terminalOutputBlock = (TerminalOutputBlock)CollectionsKt.lastOrNull(this.blocksModel.getBlocks());
        Integer n = commandStartOffset = terminalOutputBlock != null ? Integer.valueOf(terminalOutputBlock.getCommandStartOffset()) : null;
        if (commandStartOffset != null && ((Number)this.outputModel.getCursorOffsetState().getValue()).intValue() > commandStartOffset) {
            this.runUpdate(() -> TerminalTypeAhead.backspace$lambda$0(this));
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Backspace prediction applied");
            }
        }
    }

    public final boolean isDisabled() {
        return PlatformUtils.isJetBrainsClient() || this.isDisabledInRegistry() || !this.isTypingCommand();
    }

    private final boolean isDisabledInRegistry() {
        return !Registry.Companion.is("terminal.type.ahead", false);
    }

    private final boolean isTypingCommand() {
        boolean bl;
        TerminalOutputBlock terminalOutputBlock = (TerminalOutputBlock)CollectionsKt.lastOrNull(this.blocksModel.getBlocks());
        if (terminalOutputBlock != null) {
            TerminalOutputBlock lastBlock = terminalOutputBlock;
            boolean bl2 = false;
            bl = lastBlock.getCommandStartOffset() >= 0 && lastBlock.getOutputStartOffset() == -1;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final void stringTyped$lambda$0(TerminalTypeAhead this$0, String $string) {
        TerminalTypeAheadKt.access$insertAtCursor(this$0.outputModel, $string);
    }

    private static final void backspace$lambda$0(TerminalTypeAhead this$0) {
        TerminalTypeAheadKt.access$backspace(this$0.outputModel);
    }

    static {
        Key key = Key.create((String)"TerminalTypeAhead");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalTypeAhead.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/terminal/frontend/TerminalTypeAhead$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/terminal/frontend/TerminalTypeAhead;", "getKEY", "()Lcom/intellij/openapi/util/Key;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<TerminalTypeAhead> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

