/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOffset;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0011\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0007*\u00020\u0002H\u0002\u00a8\u0006\b"}, d2={"insertAtCursor", "", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "string", "", "backspace", "getRemainingLinePart", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.terminal.frontend"})
public final class TerminalTypeAheadKt {
    private static final void insertAtCursor(TerminalOutputModel $this$insertAtCursor, String string) {
        String remainingLinePart = TerminalTypeAheadKt.getRemainingLinePart($this$insertAtCursor);
        if (!StringsKt.isBlank((CharSequence)remainingLinePart)) {
            return;
        }
        $this$insertAtCursor.withTypeAhead((Function0<Unit>)((Function0)() -> TerminalTypeAheadKt.insertAtCursor$lambda$0(string, remainingLinePart, $this$insertAtCursor)));
    }

    private static final void backspace(TerminalOutputModel $this$backspace) {
        if (!StringsKt.isBlank((CharSequence)TerminalTypeAheadKt.getRemainingLinePart($this$backspace))) {
            return;
        }
        int offset = ((Number)$this$backspace.getCursorOffsetState().getValue()).intValue();
        if (offset <= 1) {
            return;
        }
        $this$backspace.replaceContent($this$backspace.relativeOffset(offset - 1), 1, " ", CollectionsKt.emptyList());
    }

    private static final String getRemainingLinePart(TerminalOutputModel $this$getRemainingLinePart) {
        int cursorOffset = ((Number)$this$getRemainingLinePart.getCursorOffsetState().getValue()).intValue();
        Document document = $this$getRemainingLinePart.getDocument();
        int line = document.getLineNumber(cursorOffset);
        int lineEnd = document.getLineEndOffset(line);
        String string = document.getText(new TextRange(cursorOffset, lineEnd));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String remainingLinePart = string;
        return remainingLinePart;
    }

    private static final Unit insertAtCursor$lambda$0(String $string, String $remainingLinePart, TerminalOutputModel $this_insertAtCursor) {
        int replaceLength = RangesKt.coerceAtMost((int)$string.length(), (int)$remainingLinePart.length());
        TerminalOffset replaceOffset = $this_insertAtCursor.relativeOffset(((Number)$this_insertAtCursor.getCursorOffsetState().getValue()).intValue());
        $this_insertAtCursor.replaceContent(replaceOffset, replaceLength, $string, CollectionsKt.emptyList());
        TerminalOffset newCursorOffset = (TerminalOffset)RangesKt.coerceAtMost((Comparable)$this_insertAtCursor.absoluteOffset(replaceOffset.toAbsolute() + (long)$string.length()), (Comparable)$this_insertAtCursor.relativeOffset($this_insertAtCursor.getDocument().getTextLength()));
        $this_insertAtCursor.updateCursorPosition(newCursorOffset);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$insertAtCursor(TerminalOutputModel $receiver, String string) {
        TerminalTypeAheadKt.insertAtCursor($receiver, string);
    }

    public static final /* synthetic */ void access$backspace(TerminalOutputModel $receiver) {
        TerminalTypeAheadKt.backspace($receiver);
    }
}

