/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.google.common.collect.Sets;
import com.intellij.frontend.FrontendApplicationInfo;
import com.intellij.frontend.FrontendType;
import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.TerminalTitleListener;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.terminal.ui.TerminalWidgetKt;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.JComponent;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.DefaultTerminalRunnerFactory;
import org.jetbrains.plugins.terminal.LocalBlockTerminalRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalDockContainer;
import org.jetbrains.plugins.terminal.TerminalEngine;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalStartupMoment;
import org.jetbrains.plugins.terminal.TerminalTabCloseListener;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalToolWindowPanel;
import org.jetbrains.plugins.terminal.TerminalWidgetProvider;
import org.jetbrains.plugins.terminal.action.MoveTerminalToolWindowTabLeftAction;
import org.jetbrains.plugins.terminal.action.MoveTerminalToolWindowTabRightAction;
import org.jetbrains.plugins.terminal.action.RenameTerminalSessionAction;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementManager;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementState;
import org.jetbrains.plugins.terminal.arrangement.TerminalCommandHistoryManager;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;
import org.jetbrains.plugins.terminal.block.reworked.FrontendTerminalTabsApi;
import org.jetbrains.plugins.terminal.block.reworked.session.TerminalSessionTab;
import org.jetbrains.plugins.terminal.fus.ReworkedTerminalUsageCollector;
import org.jetbrains.plugins.terminal.fus.TerminalFocusFusService;
import org.jetbrains.plugins.terminal.fus.TerminalOpeningWay;
import org.jetbrains.plugins.terminal.fus.TerminalStartupFusInfo;
import org.jetbrains.plugins.terminal.ui.TerminalContainer;

@Service(value={Service.Level.PROJECT})
public final class TerminalToolWindowManager
implements Disposable {
    private static final Key<TerminalWidget> TERMINAL_WIDGET_KEY = new Key("TerminalWidget");
    private static final Logger LOG = Logger.getInstance(TerminalToolWindowManager.class);
    private static final Key<AbstractTerminalRunner<?>> RUNNER_KEY = Key.create((String)"RUNNER_KEY");
    private ToolWindowEx myToolWindow;
    private final Project myProject;
    private final AbstractTerminalRunner<?> myTerminalRunner;
    private final Map<TerminalWidget, TerminalContainer> myContainerByWidgetMap;
    private final Map<TerminalWidget, Integer> myTabIdByWidgetMap;
    private CompletableFuture<Void> myTabsRestoredFuture;
    private final List<Consumer<TerminalWidget>> myTerminalSetupHandlers;

    @NotNull
    public AbstractTerminalRunner<?> getTerminalRunner() {
        AbstractTerminalRunner<?> abstractTerminalRunner = this.myTerminalRunner;
        if (abstractTerminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(0);
        }
        return abstractTerminalRunner;
    }

    public ToolWindow getToolWindow() {
        return this.myToolWindow;
    }

    public TerminalToolWindowManager(@NotNull Project project) {
        if (project == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(1);
        }
        this.myContainerByWidgetMap = new HashMap<TerminalWidget, TerminalContainer>();
        this.myTabIdByWidgetMap = new HashMap<TerminalWidget, Integer>();
        this.myTabsRestoredFuture = CompletableFuture.completedFuture(null);
        this.myTerminalSetupHandlers = new CopyOnWriteArrayList<Consumer<TerminalWidget>>();
        this.myProject = project;
        this.myTerminalRunner = DefaultTerminalRunnerFactory.getInstance().create(project);
    }

    public void dispose() {
    }

    @Deprecated
    @ApiStatus.Internal
    public @Unmodifiable Set<JBTerminalWidget> getWidgets() {
        return ContainerUtil.map2SetNotNull(this.myContainerByWidgetMap.keySet(), widget -> JBTerminalWidget.asJediTermWidget((TerminalWidget)widget));
    }

    @NotNull
    public Set<TerminalWidget> getTerminalWidgets() {
        Set<TerminalWidget> set = Collections.unmodifiableSet(this.myContainerByWidgetMap.keySet());
        if (set == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(2);
        }
        return set;
    }

    public void addNewTerminalSetupHandler(@NotNull Consumer<TerminalWidget> listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(4);
        }
        this.myTerminalSetupHandlers.add(listener2);
        if (!Disposer.tryRegister((Disposable)parentDisposable, () -> this.myTerminalSetupHandlers.remove(listener2))) {
            this.myTerminalSetupHandlers.remove(listener2);
        }
    }

    public static TerminalToolWindowManager getInstance(@NotNull Project project) {
        if (project == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(5);
        }
        return (TerminalToolWindowManager)project.getService(TerminalToolWindowManager.class);
    }

    void initToolWindow(@NotNull ToolWindowEx toolWindow) {
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(6);
        }
        if (this.myToolWindow != null) {
            LOG.error("Terminal tool window already initialized");
            return;
        }
        this.myToolWindow = toolWindow;
        toolWindow.setTabActions(new AnAction[]{ActionManager.getInstance().getAction("TerminalToolwindowActionGroup")});
        toolWindow.setTabDoubleClickActions(Collections.singletonList(new RenameTerminalSessionAction()));
        ToolWindowContentUi.setAllowTabsReordering((ToolWindow)toolWindow, (boolean)true);
        this.myProject.getMessageBus().connect(toolWindow.getDisposable()).subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void toolWindowShown(@NotNull ToolWindow toolWindow) {
                if (toolWindow == null) {
                    1.$$$reportNull$$$0(0);
                }
                TerminalStartupFusInfo startupFusInfo = new TerminalStartupFusInfo(TerminalOpeningWay.OPEN_TOOLWINDOW);
                if (TerminalToolWindowManager.isTerminalToolWindow(toolWindow) && TerminalToolWindowManager.this.myToolWindow == toolWindow && toolWindow.isVisible() && toolWindow.getContentManager().isEmpty()) {
                    if (TerminalToolWindowManager.this.myTabsRestoredFuture.isDone()) {
                        TerminalToolWindowManager.this.createNewTab(TerminalOptionsProvider.getInstance().getTerminalEngine(), startupFusInfo, null, null);
                    } else {
                        Runnable createSessionIfNeeded = () -> ApplicationManager.getApplication().invokeLater(() -> {
                            if (!TerminalToolWindowManager.this.myProject.isDisposed() && toolWindow.getContentManager().isEmpty()) {
                                TerminalToolWindowManager.this.createNewTab(TerminalOptionsProvider.getInstance().getTerminalEngine(), startupFusInfo, null, null);
                            }
                        }, ModalityState.any());
                        ((CompletableFuture)TerminalToolWindowManager.this.myTabsRestoredFuture.thenRun(createSessionIfNeeded)).orTimeout(2L, TimeUnit.SECONDS).exceptionally(t -> {
                            createSessionIfNeeded.run();
                            return null;
                        });
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "org/jetbrains/plugins/terminal/TerminalToolWindowManager$1", "toolWindowShown"));
            }
        });
        this.installDirectoryDnD((ToolWindow)toolWindow);
        TerminalDockContainer.install(this.myProject, (JComponent)toolWindow.getDecorator());
        TerminalFocusFusService focusService = TerminalFocusFusService.getInstance();
        if (focusService != null) {
            focusService.ensureInitialized();
        }
    }

    void restoreTabsLocal(@Nullable TerminalArrangementState arrangementState) {
        ContentManager contentManager = this.myToolWindow.getContentManager();
        if (arrangementState != null) {
            for (TerminalTabState tabState : arrangementState.myTabStates) {
                TerminalEngine engine = TerminalOptionsProvider.getInstance().getTerminalEngine();
                this.createNewSession(null, this.myTerminalRunner, engine, tabState, null, null, false, true);
            }
            Content content = contentManager.getContent(arrangementState.mySelectedTabIndex);
            if (content != null) {
                contentManager.setSelectedContent(content);
            }
        }
    }

    void restoreTabsFromBackend() {
        this.myTabsRestoredFuture = new CompletableFuture().orTimeout(5L, TimeUnit.SECONDS).exceptionally(t -> {
            LOG.error("Failed to restore tabs from the backend in the given timeout", t);
            return null;
        });
        FrontendTerminalTabsApi.getInstance(this.myProject).getStoredTerminalTabs().thenAccept(tabs -> ApplicationManager.getApplication().invokeLater(() -> {
            this.doRestoreTabsFromBackend((List<TerminalSessionTab>)tabs);
            TerminalArrangementManager.getInstance(this.myProject).setToolWindow((ToolWindow)this.myToolWindow);
            this.myTabsRestoredFuture.complete(null);
        }, ModalityState.any()));
    }

    private void doRestoreTabsFromBackend(List<TerminalSessionTab> tabs) {
        for (TerminalSessionTab tab : tabs) {
            TerminalTabState tabState = new TerminalTabState();
            tabState.myTabName = tab.getName();
            tabState.myIsUserDefinedTabTitle = tab.isUserDefinedName();
            tabState.myShellCommand = tab.getShellCommand();
            tabState.myWorkingDirectory = tab.getWorkingDirectory();
            this.createNewSession(null, this.myTerminalRunner, TerminalEngine.REWORKED, tabState, tab, null, false, true);
        }
        ReworkedTerminalUsageCollector.logSessionRestored(this.myProject, tabs.size());
        ContentManager contentManager = this.myToolWindow.getContentManager();
        Content firstContent = contentManager.getContent(0);
        if (firstContent != null) {
            contentManager.setSelectedContent(firstContent);
        }
    }

    @NotNull
    public TerminalWidget createNewSession() {
        return this.createNewSession(null, this.myTerminalRunner, TerminalEngine.CLASSIC, null, null, null, true, true);
    }

    public void createNewSession(@NotNull AbstractTerminalRunner<?> terminalRunner) {
        if (terminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(7);
        }
        this.createNewSession(null, terminalRunner, TerminalEngine.CLASSIC, null, null, null, true, true);
    }

    public void createNewSession(@NotNull AbstractTerminalRunner<?> terminalRunner, @Nullable TerminalTabState tabState) {
        if (terminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(8);
        }
        this.createNewSession(null, terminalRunner, TerminalEngine.CLASSIC, tabState, null, null, true, true);
    }

    @ApiStatus.Experimental
    public void createNewSession(@Nullable AbstractTerminalRunner<?> terminalRunner, @Nullable TerminalTabState tabState, @Nullable ContentManager contentManager) {
        AbstractTerminalRunner<?> runner = terminalRunner != null ? terminalRunner : this.myTerminalRunner;
        this.createNewSession(contentManager, runner, TerminalEngine.CLASSIC, tabState, null, null, true, true);
    }

    @NotNull
    public TerminalWidget createShellWidget(@Nullable String workingDirectory, @Nullable @Nls String tabName, boolean requestFocus, boolean deferSessionStartUntilUiShown) {
        TerminalWidget terminalWidget = this.createNewSession(workingDirectory, tabName, null, requestFocus, deferSessionStartUntilUiShown);
        if (terminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(9);
        }
        return terminalWidget;
    }

    @NotNull
    public Content newTab(@NotNull ToolWindow toolWindow, @Nullable TerminalWidget terminalWidget) {
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(10);
        }
        Content content = this.createNewTab(null, terminalWidget, this.myTerminalRunner, TerminalEngine.CLASSIC, null, null, null, true, true);
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(11);
        }
        return content;
    }

    public void openTerminalIn(@Nullable VirtualFile fileToOpen) {
        TerminalTabState state = new TerminalTabState();
        if (fileToOpen != null) {
            state.myWorkingDirectory = fileToOpen.getPath();
        }
        this.createNewSession(null, this.myTerminalRunner, TerminalEngine.CLASSIC, state, null, null, true, true);
    }

    @ApiStatus.Internal
    @NotNull
    public TerminalWidget createNewSession(@Nullable String workingDirectory, @Nullable @Nls String tabName, @Nullable List<String> shellCommand, boolean requestFocus, boolean deferSessionStartUntilUiShown) {
        TerminalTabState tabState = new TerminalTabState();
        tabState.myTabName = tabName;
        tabState.myWorkingDirectory = workingDirectory;
        tabState.myShellCommand = shellCommand;
        return this.createNewSession(null, this.myTerminalRunner, TerminalEngine.CLASSIC, tabState, null, null, requestFocus, deferSessionStartUntilUiShown);
    }

    @ApiStatus.Internal
    @NotNull
    public TerminalWidget createNewTab(@NotNull TerminalEngine preferredEngine, @Nullable TerminalStartupFusInfo startupFusInfo, @Nullable TerminalTabState tabState, @Nullable ContentManager contentManager) {
        if (preferredEngine == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(12);
        }
        return this.createNewSession(contentManager, this.myTerminalRunner, preferredEngine, tabState, null, startupFusInfo, true, true);
    }

    @NotNull
    private TerminalWidget createNewSession(@Nullable ContentManager contentManager, @NotNull AbstractTerminalRunner<?> terminalRunner, @NotNull TerminalEngine preferredEngine, @Nullable TerminalTabState tabState, @Nullable TerminalSessionTab sessionTab, @Nullable TerminalStartupFusInfo startupFusInfo, boolean requestFocus, boolean deferSessionStartUntilUiShown) {
        if (terminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(13);
        }
        if (preferredEngine == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(14);
        }
        Content content = this.createNewTab(contentManager, null, terminalRunner, preferredEngine, tabState, sessionTab, startupFusInfo, requestFocus, deferSessionStartUntilUiShown);
        TerminalWidget terminalWidget = Objects.requireNonNull((TerminalWidget)content.getUserData(TERMINAL_WIDGET_KEY));
        if (terminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(15);
        }
        return terminalWidget;
    }

    @NotNull
    private ToolWindow getOrInitToolWindow() {
        ToolWindowEx toolWindow = this.myToolWindow;
        if (toolWindow == null) {
            toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Terminal");
            ((ToolWindow)Objects.requireNonNull(toolWindow)).getContentManager();
            LOG.assertTrue(toolWindow == this.myToolWindow);
        }
        ToolWindowEx toolWindowEx = toolWindow;
        if (toolWindowEx == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(16);
        }
        return toolWindowEx;
    }

    @ApiStatus.Internal
    @NotNull
    Content createNewTab(@Nullable ContentManager contentManager, @Nullable TerminalWidget terminalWidget, @NotNull AbstractTerminalRunner<?> terminalRunner, @NotNull TerminalEngine preferredEngine, @Nullable TerminalTabState tabState, @Nullable TerminalSessionTab sessionTab, @Nullable TerminalStartupFusInfo startupFusInfo, boolean requestFocus, boolean deferSessionStartUntilUiShown) {
        if (terminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(17);
        }
        if (preferredEngine == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(18);
        }
        ToolWindow toolWindow = this.getOrInitToolWindow();
        TerminalStartupMoment startupMoment = requestFocus && deferSessionStartUntilUiShown ? new TerminalStartupMoment() : null;
        Content content = this.createTerminalContent(terminalRunner, preferredEngine, terminalWidget, tabState, sessionTab, startupFusInfo, deferSessionStartUntilUiShown, startupMoment);
        ContentManager manager = contentManager != null ? contentManager : toolWindow.getContentManager();
        manager.addContent(content);
        Runnable selectRunnable = () -> manager.setSelectedContent(content, requestFocus);
        if (requestFocus && !toolWindow.isActive()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Activating " + toolWindow.getId() + " tool window");
            }
            toolWindow.activate(selectRunnable, true, true);
        } else {
            selectRunnable.run();
        }
        int tabsCount = toolWindow.getContentManager().getContentsRecursively().size();
        ReworkedTerminalUsageCollector.logTabOpened(this.myProject, tabsCount);
        Content content2 = content;
        if (content2 == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(19);
        }
        return content2;
    }

    @Nls
    private static String generateUniqueName(@Nls String suggestedName, List<@Nls String> tabs) {
        HashSet names = Sets.newHashSet(tabs);
        return UniqueNameGenerator.generateUniqueName((String)suggestedName, (String)"", (String)"", (String)" (", (String)")", o -> !names.contains(o));
    }

    @ApiStatus.Internal
    @NotNull
    public Content createTerminalContent(@NotNull AbstractTerminalRunner<?> terminalRunner, @NotNull TerminalEngine preferredEngine, @Nullable TerminalWidget terminalWidget, @Nullable TerminalTabState tabState, @Nullable TerminalSessionTab sessionTab, @Nullable TerminalStartupFusInfo startupFusInfo, boolean deferSessionStartUntilUiShown, @Nullable TerminalStartupMoment startupMoment) {
        if (terminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(20);
        }
        if (preferredEngine == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(21);
        }
        ToolWindow toolWindow = this.getOrInitToolWindow();
        TerminalToolWindowPanel panel = new TerminalToolWindowPanel();
        Content content = ContentFactory.getInstance().createContent((JComponent)((Object)panel), null, false);
        TerminalWidget widget = terminalWidget;
        if (widget == null) {
            String currentWorkingDir = terminalRunner.getCurrentWorkingDir(tabState);
            NullableLazyValue commandHistoryFileLazyValue = NullableLazyValue.atomicLazyNullable(() -> TerminalCommandHistoryManager.getInstance().getOrCreateCommandHistoryFile(tabState != null ? tabState.myCommandHistoryFileName : null, this.myProject));
            ShellStartupOptions startupOptions = new ShellStartupOptions.Builder().workingDirectory(currentWorkingDir).shellCommand(tabState != null ? tabState.myShellCommand : null).commandHistoryFileProvider((Function0<? extends Path>)((Function0)() -> (Path)commandHistoryFileLazyValue.getValue())).startupMoment(startupMoment).build();
            widget = this.startShellTerminalWidget(content, terminalRunner, startupOptions, preferredEngine, sessionTab, startupFusInfo, deferSessionStartUntilUiShown, true, (Disposable)content);
            widget.getTerminalTitle().change(state -> {
                if (state.getDefaultTitle() == null) {
                    state.setDefaultTitle(terminalRunner.getDefaultTabTitle());
                }
                return Unit.INSTANCE;
            });
            TerminalWorkingDirectoryManager.setInitialWorkingDirectory(content, currentWorkingDir);
        } else {
            TerminalWidgetKt.setNewParentDisposable((TerminalWidget)terminalWidget, (Disposable)content);
        }
        if (tabState != null && tabState.myTabName != null) {
            widget.getTerminalTitle().change(state -> {
                if (tabState.myIsUserDefinedTabTitle) {
                    state.setUserDefinedTitle(tabState.myTabName);
                } else {
                    state.setDefaultTitle(tabState.myTabName);
                }
                return null;
            });
        }
        this.updateTabTitle(widget, toolWindow, content);
        this.setupTerminalWidget(toolWindow, terminalRunner, widget, content);
        content.setCloseable(true);
        content.putUserData(TERMINAL_WIDGET_KEY, (Object)widget);
        content.putUserData(RUNNER_KEY, terminalRunner);
        TerminalContainer container = new TerminalContainer(this.myProject, content, widget, this);
        panel.setContent(container.getWrapperPanel());
        panel.addFocusListener(TerminalToolWindowManager.createFocusListener(toolWindow));
        TerminalWidget finalWidget = widget;
        this.myTerminalSetupHandlers.forEach(consumer2 -> consumer2.accept(finalWidget));
        content.setPreferredFocusedComponent(() -> finalWidget.getPreferredFocusableComponent());
        new TerminalTabCloseListener(content, this.myProject, this);
        Content content2 = content;
        if (content2 == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(22);
        }
        return content2;
    }

    private void setupTerminalWidget(final @NotNull ToolWindow toolWindow, @NotNull AbstractTerminalRunner<?> runner, final @NotNull TerminalWidget widget, final @NotNull Content content) {
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(23);
        }
        if (runner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(24);
        }
        if (widget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(25);
        }
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(26);
        }
        final MoveTerminalToolWindowTabLeftAction moveTabLeftAction = new MoveTerminalToolWindowTabLeftAction();
        final MoveTerminalToolWindowTabRightAction moveTabRightAction = new MoveTerminalToolWindowTabRightAction();
        widget.getTerminalTitle().addTitleListener(new TerminalTitleListener(){

            public void onTitleChanged(@NotNull TerminalTitle terminalTitle) {
                if (terminalTitle == null) {
                    2.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> TerminalToolWindowManager.this.updateTabTitle(widget, toolWindow, content), TerminalToolWindowManager.this.myProject.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminalTitle", "org/jetbrains/plugins/terminal/TerminalToolWindowManager$2", "onTitleChanged"));
            }
        }, (Disposable)content);
        JBTerminalWidget terminalWidget = JBTerminalWidget.asJediTermWidget((TerminalWidget)widget);
        if (terminalWidget == null) {
            return;
        }
        terminalWidget.setListener(new JBTerminalWidgetListener(){

            public void onNewSession() {
                TerminalToolWindowManager.this.createNewTab(TerminalOptionsProvider.getInstance().getTerminalEngine(), null, null, content.getManager());
            }

            public void onTerminalStarted() {
            }

            public void onPreviousTabSelected() {
                ContentManager contentManager = content.getManager();
                if (contentManager != null && contentManager.getContentCount() > 1) {
                    contentManager.selectPreviousContent();
                }
            }

            public void onNextTabSelected() {
                ContentManager contentManager = content.getManager();
                if (contentManager != null && contentManager.getContentCount() > 1) {
                    contentManager.selectNextContent();
                }
            }

            public void onSessionClosed() {
                TerminalContainer container = TerminalToolWindowManager.this.getContainer(widget);
                if (container != null) {
                    container.closeAndHide();
                }
            }

            public void showTabs() {
                this.performAction("ShowContent");
            }

            public void moveTabRight() {
                moveTabRightAction.move(content, TerminalToolWindowManager.this.myProject);
            }

            public void moveTabLeft() {
                moveTabLeftAction.move(content, TerminalToolWindowManager.this.myProject);
            }

            public boolean canMoveTabRight() {
                return moveTabRightAction.isAvailable(content);
            }

            public boolean canMoveTabLeft() {
                return moveTabLeftAction.isAvailable(content);
            }

            public boolean canSplit(boolean vertically) {
                String actionId = vertically ? "TW.SplitRight" : "TW.SplitDown";
                return this.isActionEnabled(actionId);
            }

            public void split(boolean vertically) {
                String actionId = vertically ? "TW.SplitRight" : "TW.SplitDown";
                this.performAction(actionId);
            }

            public boolean isGotoNextSplitTerminalAvailable() {
                return this.isActionEnabled("TW.MoveToNextSplitter");
            }

            public void gotoNextSplitTerminal(boolean forward) {
                String actionId = forward ? "TW.MoveToNextSplitter" : "TW.MoveToPreviousSplitter";
                this.performAction(actionId);
            }

            private boolean isActionEnabled(@NotNull String actionId) {
                AnAction action;
                if (actionId == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((action = ActionManager.getInstance().getAction(actionId)) == null) {
                    return false;
                }
                AnActionEvent event = this.createActionEvent(action);
                AnActionResult result2 = ActionUtil.updateAction((AnAction)action, (AnActionEvent)event);
                if (!result2.isPerformed()) {
                    return false;
                }
                return event.getPresentation().isEnabled();
            }

            private void performAction(@NotNull String actionId) {
                AnAction action;
                if (actionId == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((action = ActionManager.getInstance().getAction(actionId)) == null) {
                    return;
                }
                AnActionEvent event = this.createActionEvent(action);
                ActionUtil.performAction((AnAction)action, (AnActionEvent)event);
            }

            @NotNull
            private AnActionEvent createActionEvent(@NotNull AnAction action) {
                if (action == null) {
                    3.$$$reportNull$$$0(2);
                }
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)widget.getComponent());
                AnActionEvent anActionEvent = AnActionEvent.createEvent((AnAction)action, (DataContext)dataContext, null, (String)"unknown", (ActionUiKind)ActionUiKind.NONE, null);
                if (anActionEvent == null) {
                    3.$$$reportNull$$$0(3);
                }
                return anActionEvent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "actionId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalToolWindowManager$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalToolWindowManager$3";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createActionEvent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isActionEnabled";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "performAction";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "createActionEvent";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        });
    }

    private void updateTabTitle(@NotNull TerminalWidget widget, @NotNull ToolWindow toolWindow, @NotNull Content content) {
        if (widget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(27);
        }
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(28);
        }
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(29);
        }
        TerminalTitle title = widget.getTerminalTitle();
        String titleString = title.buildTitle();
        List<String> tabs = toolWindow.getContentManager().getContentsRecursively().stream().filter(c -> c != content).map(c -> c.getDisplayName()).toList();
        String generatedName = TerminalToolWindowManager.generateUniqueName(titleString, tabs);
        Integer tabId = this.getTabIdByWidget(widget);
        if (tabId != null) {
            boolean isDefinedByUser = Objects.equals(generatedName, title.getUserDefinedTitle());
            FrontendTerminalTabsApi.getInstance(this.myProject).renameTerminalTab(tabId, generatedName, isDefinedByUser);
        }
        content.setDisplayName(generatedName);
        title.change(state -> {
            state.setDefaultTitle(generatedName);
            return Unit.INSTANCE;
        });
    }

    public void register(@NotNull TerminalContainer terminalContainer) {
        if (terminalContainer == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(30);
        }
        this.myContainerByWidgetMap.put(terminalContainer.getTerminalWidget(), terminalContainer);
    }

    public void unregister(@NotNull TerminalContainer terminalContainer) {
        if (terminalContainer == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(31);
        }
        this.myContainerByWidgetMap.remove(terminalContainer.getTerminalWidget());
        if (terminalContainer.getContent().getUserData(TERMINAL_WIDGET_KEY) == terminalContainer.getTerminalWidget()) {
            terminalContainer.getContent().putUserData(TERMINAL_WIDGET_KEY, (Object)this.findWidgetForContent(terminalContainer.getContent()));
        }
    }

    @Nullable
    private TerminalWidget findWidgetForContent(@NotNull Content content) {
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(32);
        }
        TerminalWidget any = null;
        for (Map.Entry<TerminalWidget, TerminalContainer> entry : this.myContainerByWidgetMap.entrySet()) {
            TerminalWidget terminalWidget;
            if (entry.getValue().getContent() != content) continue;
            any = terminalWidget = entry.getKey();
            if (!terminalWidget.hasFocus()) continue;
            return terminalWidget;
        }
        return any;
    }

    @Nullable
    public TerminalContainer getContainer(@NotNull TerminalWidget terminalWidget) {
        if (terminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(33);
        }
        return this.myContainerByWidgetMap.get(terminalWidget);
    }

    public void closeTab(@NotNull Content content) {
        ContentManager manager;
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(34);
        }
        if ((manager = content.getManager()) != null) {
            manager.removeContent(content, true, true, true);
        }
    }

    @NotNull
    private static FocusListener createFocusListener(final @NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(35);
        }
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JComponent component2 = TerminalToolWindowManager.getComponentToFocus(toolWindow);
                if (component2 != null) {
                    component2.requestFocusInWindow();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
    }

    @Nullable
    private static JComponent getComponentToFocus(@NotNull ToolWindow toolWindow) {
        Content selectedContent;
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(36);
        }
        if ((selectedContent = toolWindow.getContentManager().getSelectedContent()) != null) {
            return selectedContent.getPreferredFocusableComponent();
        }
        return toolWindow.getComponent();
    }

    @NotNull
    private TerminalWidget startShellTerminalWidget(@NotNull Content content, @NotNull AbstractTerminalRunner<?> terminalRunner, @NotNull ShellStartupOptions startupOptions, @NotNull TerminalEngine preferredEngine, @Nullable TerminalSessionTab existingTab, @Nullable TerminalStartupFusInfo startupFusInfo, boolean deferSessionStartUntilUiShown, boolean updateTabTitleOnBackend, @NotNull Disposable parentDisposable) {
        TerminalWidget widget;
        FrontendType.Remote remote;
        FrontendType frontendType;
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(37);
        }
        if (terminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(38);
        }
        if (startupOptions == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(39);
        }
        if (preferredEngine == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(40);
        }
        if (parentDisposable == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(41);
        }
        boolean isAnyRemoteDev = (frontendType = FrontendApplicationInfo.INSTANCE.getFrontendType()) instanceof FrontendType.Remote || PlatformUtils.isJetBrainsClient() || AppMode.isRemoteDevHost();
        boolean isCodeWithMe = frontendType instanceof FrontendType.Remote && (remote = (FrontendType.Remote)frontendType).isGuest();
        TerminalWidgetProvider provider = TerminalWidgetProvider.getProvider();
        if (preferredEngine == TerminalEngine.REWORKED && ExperimentalUI.isNewUI() && terminalRunner == this.myTerminalRunner && provider != null && !isCodeWithMe) {
            widget = this.startReworkedShellTerminalWidget(provider, content, startupOptions, existingTab, startupFusInfo, deferSessionStartUntilUiShown, updateTabTitleOnBackend, parentDisposable);
        } else if (preferredEngine == TerminalEngine.NEW_TERMINAL && ExperimentalUI.isNewUI() && terminalRunner == this.myTerminalRunner && !isAnyRemoteDev) {
            LocalBlockTerminalRunner runner = new LocalBlockTerminalRunner(this.myProject);
            widget = runner.startShellTerminalWidget(parentDisposable, startupOptions, deferSessionStartUntilUiShown);
        } else {
            widget = terminalRunner.startShellTerminalWidget(parentDisposable, startupOptions, deferSessionStartUntilUiShown);
        }
        TerminalWidget terminalWidget = widget;
        if (terminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(42);
        }
        return terminalWidget;
    }

    @NotNull
    private TerminalWidget startReworkedShellTerminalWidget(@NotNull TerminalWidgetProvider provider, @NotNull Content content, @NotNull ShellStartupOptions startupOptions, @Nullable TerminalSessionTab existingTab, @Nullable TerminalStartupFusInfo startupFusInfo, boolean deferSessionStartUntilUiShown, boolean updateTabTitleOnBackend, @NotNull Disposable parentDisposable) {
        if (provider == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(43);
        }
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(44);
        }
        if (startupOptions == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(45);
        }
        if (parentDisposable == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(46);
        }
        final TerminalWidget widget = provider.createTerminalWidget(this.myProject, startupFusInfo, parentDisposable);
        Disposer.register((Disposable)widget, (Disposable)new Disposable(){

            public void dispose() {
                Integer sessionTabId = TerminalToolWindowManager.this.getTabIdByWidget(widget);
                boolean isProjectClosing = TerminalToolWindowManager.this.myToolWindow.getContentManager().isDisposed();
                if (sessionTabId != null && !isProjectClosing) {
                    FrontendTerminalTabsApi.getInstance(TerminalToolWindowManager.this.myProject).closeTerminalTab(sessionTabId);
                    TerminalToolWindowManager.this.bindTabIdToWidget(widget, null);
                }
            }
        });
        Consumer<TerminalSessionTab> bindTabIdAndStartSession = tab -> {
            this.bindTabIdToWidget(widget, tab.getId());
            if (updateTabTitleOnBackend) {
                this.updateTabTitle(widget, (ToolWindow)this.myToolWindow, content);
            }
            FrontendTerminalTabsApi.getInstance(this.myProject).startTerminalSessionForWidget(widget, startupOptions, (TerminalSessionTab)tab, deferSessionStartUntilUiShown);
        };
        if (existingTab != null) {
            bindTabIdAndStartSession.accept(existingTab);
        } else {
            FrontendTerminalTabsApi.getInstance(this.myProject).createNewTerminalTab().thenAccept(tab -> ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myProject.isDisposed()) {
                    bindTabIdAndStartSession.accept((TerminalSessionTab)tab);
                }
            }, ModalityState.any()));
        }
        TerminalWidget terminalWidget = widget;
        if (terminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(47);
        }
        return terminalWidget;
    }

    @Nullable
    private Integer getTabIdByWidget(@NotNull TerminalWidget widget) {
        if (widget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(48);
        }
        return this.myTabIdByWidgetMap.get(widget);
    }

    private void bindTabIdToWidget(@NotNull TerminalWidget widget, @Nullable Integer tabId) {
        if (widget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(49);
        }
        this.myTabIdByWidgetMap.put(widget, tabId);
    }

    @Nullable
    public static JBTerminalWidget getWidgetByContent(@NotNull Content content) {
        TerminalWidget data;
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(50);
        }
        return (data = (TerminalWidget)content.getUserData(TERMINAL_WIDGET_KEY)) != null ? JBTerminalWidget.asJediTermWidget((TerminalWidget)data) : null;
    }

    @Nullable
    public static TerminalWidget findWidgetByContent(@NotNull Content content) {
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(51);
        }
        return (TerminalWidget)content.getUserData(TERMINAL_WIDGET_KEY);
    }

    @Nullable
    public static AbstractTerminalRunner<?> getRunnerByContent(@NotNull Content content) {
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(52);
        }
        return (AbstractTerminalRunner)content.getUserData(RUNNER_KEY);
    }

    public void detachWidgetAndRemoveContent(@NotNull Content content) {
        ContentManager contentManager;
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(53);
        }
        if ((contentManager = content.getManager()) == null) {
            throw new IllegalStateException("Content manager is null for " + String.valueOf(content));
        }
        TerminalTabCloseListener.Companion.executeContentOperationSilently(content, (Function0<Unit>)((Function0)() -> {
            contentManager.removeContent(content, true);
            return Unit.INSTANCE;
        }));
        content.putUserData(TERMINAL_WIDGET_KEY, null);
    }

    public static boolean isInTerminalToolWindow(@NotNull JBTerminalWidget widget) {
        if (widget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(54);
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)widget.getTerminalPanel());
        ToolWindow toolWindow = (ToolWindow)dataContext.getData(PlatformDataKeys.TOOL_WINDOW);
        return TerminalToolWindowManager.isTerminalToolWindow(toolWindow);
    }

    public static boolean isTerminalToolWindow(@Nullable ToolWindow toolWindow) {
        return toolWindow != null && "Terminal".equals(toolWindow.getId());
    }

    private void installDirectoryDnD(@NotNull ToolWindow window) {
        ToolWindowEx toolWindowEx;
        if (window == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(55);
        }
        ToolWindowEx toolWindowEx2 = toolWindowEx = window instanceof ToolWindowEx ? (ToolWindowEx)window : null;
        if (toolWindowEx == null) {
            return;
        }
        DnDDropHandler handler = new DnDDropHandler(){

            public void drop(DnDEvent event) {
                PsiDirectory dir;
                TransferableWrapper tw = (TransferableWrapper)ObjectUtils.tryCast((Object)event.getAttachedObject(), TransferableWrapper.class);
                if (tw != null && (dir = TerminalToolWindowManager.getDirectory((PsiElement)ArrayUtil.getFirstElement((Object[])tw.getPsiElements()))) != null && tw.getPsiElements().length == 1) {
                    ContentManager nearestManager = TerminalToolWindowManager.findNearestContentManager(event);
                    TerminalTabState state = new TerminalTabState();
                    state.myWorkingDirectory = dir.getVirtualFile().getPath();
                    TerminalToolWindowManager.this.createNewTab(TerminalOptionsProvider.getInstance().getTerminalEngine(), null, state, nearestManager);
                }
            }
        };
        DnDSupport.createBuilder((JComponent)toolWindowEx.getDecorator()).setDropHandler(handler).setDisposableParent((Disposable)this).disableAsSource().install();
    }

    @Nullable
    private static ContentManager findNearestContentManager(@NotNull DnDEvent event) {
        if (event == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(56);
        }
        Component handlerComponent = event.getHandlerComponent();
        Point point = event.getPoint();
        if (handlerComponent == null || point == null) {
            return null;
        }
        Component deepestComponent = UIUtil.getDeepestComponentAt((Component)handlerComponent, (int)point.x, (int)point.y);
        return TerminalToolWindowManager.findNearestContentManager(deepestComponent);
    }

    @ApiStatus.Internal
    @Nullable
    static ContentManager findNearestContentManager(@Nullable Component component2) {
        if (component2 == null) {
            return null;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext(component2);
        return (ContentManager)dataContext.getData(PlatformDataKeys.TOOL_WINDOW_CONTENT_MANAGER);
    }

    @Nullable
    private static PsiDirectory getDirectory(@Nullable PsiElement item) {
        if (item instanceof PsiFile) {
            return ((PsiFile)item).getParent();
        }
        return (PsiDirectory)ObjectUtils.tryCast((Object)item, PsiDirectory.class);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public ShellTerminalWidget createLocalShellWidget(@Nullable String workingDirectory, @Nullable @Nls String tabName) {
        ShellTerminalWidget shellTerminalWidget = ShellTerminalWidget.toShellJediTermWidgetOrThrow(this.createShellWidget(workingDirectory, tabName, true, true));
        if (shellTerminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(57);
        }
        return shellTerminalWidget;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public ShellTerminalWidget createLocalShellWidget(@Nullable String workingDirectory, @Nullable @Nls String tabName, boolean requestFocus) {
        ShellTerminalWidget shellTerminalWidget = ShellTerminalWidget.toShellJediTermWidgetOrThrow(this.createShellWidget(workingDirectory, tabName, requestFocus, true));
        if (shellTerminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(58);
        }
        return shellTerminalWidget;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public ShellTerminalWidget createLocalShellWidget(@Nullable String workingDirectory, @Nullable @Nls String tabName, boolean requestFocus, boolean deferSessionStartUntilUiShown) {
        ShellTerminalWidget shellTerminalWidget = ShellTerminalWidget.toShellJediTermWidgetOrThrow(this.createShellWidget(workingDirectory, tabName, requestFocus, deferSessionStartUntilUiShown));
        if (shellTerminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(59);
        }
        return shellTerminalWidget;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 7, 8, 10, 12, 13, 14, 17, 18, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 43, 44, 45, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalToolWindowManager";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 41: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: 
            case 10: 
            case 23: 
            case 28: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 17: 
            case 20: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalRunner";
                break;
            }
            case 12: 
            case 14: 
            case 18: 
            case 21: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredEngine";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 25: 
            case 27: 
            case 48: 
            case 49: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
            case 26: 
            case 29: 
            case 32: 
            case 34: 
            case 37: 
            case 44: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalContainer";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalWidget";
                break;
            }
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startupOptions";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalRunner";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalToolWindowManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalWidgets";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createShellWidget";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "newTab";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewSession";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrInitToolWindow";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTab";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createTerminalContent";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "startShellTerminalWidget";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "startReworkedShellTerminalWidget";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalShellWidget";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addNewTerminalSetupHandler";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "initToolWindow";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createNewSession";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "newTab";
                break;
            }
            case 12: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createNewTab";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createTerminalContent";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setupTerminalWidget";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "updateTabTitle";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findWidgetForContent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getContainer";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "closeTab";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createFocusListener";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getComponentToFocus";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "startShellTerminalWidget";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "startReworkedShellTerminalWidget";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getTabIdByWidget";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "bindTabIdToWidget";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getWidgetByContent";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findWidgetByContent";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getRunnerByContent";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "detachWidgetAndRemoveContent";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isInTerminalToolWindow";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "installDirectoryDnD";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "findNearestContentManager";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6, 7, 8, 10, 12, 13, 14, 17, 18, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 43, 44, 45, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56 -> new IllegalArgumentException(string);
        };
    }
}

