/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.completion.spec;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.terminal.completion.spec.ShellCommandResult;
import com.intellij.terminal.completion.spec.ShellRuntimeContext;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellRuntimeContextExtensionsKt;
import org.jetbrains.plugins.terminal.block.session.ShellIntegrationFunctions;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\u001a*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\nH\u0087@\u00a2\u0006\u0002\u0010\u0013\u001a\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\n*\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\"\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\b\u00a8\u0006\u0017"}, d2={"project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/terminal/completion/spec/ShellRuntimeContext;", "getProject", "(Lcom/intellij/terminal/completion/spec/ShellRuntimeContext;)Lcom/intellij/openapi/project/Project;", "PROJECT_KEY", "Lcom/intellij/openapi/util/Key;", "getPROJECT_KEY", "()Lcom/intellij/openapi/util/Key;", "isReworkedTerminal", "", "(Lcom/intellij/terminal/completion/spec/ShellRuntimeContext;)Z", "IS_REWORKED_KEY", "getIS_REWORKED_KEY", "getChildFiles", "", "", "path", "onlyDirectories", "(Lcom/intellij/terminal/completion/spec/ShellRuntimeContext;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createGetFilesCommand", "adjustedPath", "createGetFilesCommandReworked", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nShellRuntimeContextExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellRuntimeContextExtensions.kt\norg/jetbrains/plugins/terminal/block/completion/spec/ShellRuntimeContextExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,66:1\n1#2:67\n13#3:68\n*S KotlinDebug\n*F\n+ 1 ShellRuntimeContextExtensions.kt\norg/jetbrains/plugins/terminal/block/completion/spec/ShellRuntimeContextExtensionsKt\n*L\n47#1:68\n*E\n"})
public final class ShellRuntimeContextExtensionsKt {
    @ApiStatus.Internal
    @NotNull
    private static final Key<Project> PROJECT_KEY;
    @NotNull
    private static final Key<Boolean> IS_REWORKED_KEY;

    @ApiStatus.Experimental
    @NotNull
    public static final Project getProject(@NotNull ShellRuntimeContext $this$project) {
        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"<this>");
        Project project = $this$project.getUserData(PROJECT_KEY);
        if (project == null) {
            throw new IllegalStateException(("No project data in " + $this$project).toString());
        }
        return project;
    }

    @NotNull
    public static final Key<Project> getPROJECT_KEY() {
        return PROJECT_KEY;
    }

    @ApiStatus.Experimental
    public static final boolean isReworkedTerminal(@NotNull ShellRuntimeContext $this$isReworkedTerminal) {
        Intrinsics.checkNotNullParameter((Object)$this$isReworkedTerminal, (String)"<this>");
        Boolean bl = $this$isReworkedTerminal.getUserData(IS_REWORKED_KEY);
        return bl != null ? bl : false;
    }

    @NotNull
    public static final Key<Boolean> getIS_REWORKED_KEY() {
        return IS_REWORKED_KEY;
    }

    /*
     * Unable to fully structure code
     */
    @ApiStatus.Experimental
    @Nullable
    public static final Object getChildFiles(@NotNull ShellRuntimeContext $this$getChildFiles, @NotNull String path, boolean onlyDirectories, @NotNull Continuation<? super List<String>> $completion) {
        if (!($completion instanceof getChildFiles.1)) ** GOTO lbl-1000
        var10_4 = $completion;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                boolean Z$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ShellRuntimeContextExtensionsKt.getChildFiles(null, null, false, (Continuation<? super List<String>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = path;
                if (var5_7.length() == 0) {
                    $i$a$-ifEmpty-ShellRuntimeContextExtensionsKt$getChildFiles$adjustedPath$1 = false;
                    v0 = ".";
                } else {
                    v0 = var5_7;
                }
                adjustedPath = (String)v0;
                command = ShellRuntimeContextExtensionsKt.isReworkedTerminal($this$getChildFiles) != false ? ShellRuntimeContextExtensionsKt.createGetFilesCommandReworked(adjustedPath) : ShellRuntimeContextExtensionsKt.createGetFilesCommand(adjustedPath);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$getChildFiles);
                $continuation.L$1 = path;
                $continuation.L$2 = adjustedPath;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)command);
                $continuation.Z$0 = onlyDirectories;
                $continuation.label = 1;
                v1 = $this$getChildFiles.runShellCommand(command, (Continuation<? super ShellCommandResult>)$continuation);
                if (v1 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl38
            }
            case 1: {
                onlyDirectories = $continuation.Z$0;
                command = (String)$continuation.L$3;
                adjustedPath = (String)$continuation.L$2;
                path = (String)$continuation.L$1;
                $this$getChildFiles = (ShellRuntimeContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl38:
                // 2 sources

                if ((result = (ShellCommandResult)v1).getExitCode() != 0) {
                    $i$f$logger = false;
                    v2 = Logger.getInstance(ShellRuntimeContext.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                    v2.warn("Get files command for path '" + adjustedPath + "' failed with exit code " + result.getExitCode() + ", output: " + result.getOutput());
                    return CollectionsKt.emptyList();
                }
                separator = File.separatorChar;
                var8_14 = new String[]{"\n"};
                return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)StringsKt.splitToSequence$default((CharSequence)result.getOutput(), (String[])var8_14, (boolean)false, (int)0, (int)6, null), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getChildFiles$lambda$1(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Boolean;)()), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getChildFiles$lambda$2(boolean char java.lang.String ), (Ljava/lang/String;)Ljava/lang/Boolean;)((boolean)(onlyDirectories != false), (char)separator)), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getChildFiles$lambda$3(java.lang.String char java.lang.String ), (Ljava/lang/String;)Ljava/lang/Boolean;)((String)path, (char)separator)));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object getChildFiles$default(ShellRuntimeContext shellRuntimeContext, String string, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ShellRuntimeContextExtensionsKt.getChildFiles(shellRuntimeContext, string, bl, (Continuation<? super List<String>>)continuation);
    }

    private static final String createGetFilesCommand(String adjustedPath) {
        return ShellIntegrationFunctions.GET_DIRECTORY_FILES.getFunctionName() + " " + adjustedPath;
    }

    private static final String createGetFilesCommandReworked(String adjustedPath) {
        return "ls -1ap " + FileUtil.expandUserHome((String)adjustedPath);
    }

    private static final boolean getChildFiles$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.isBlank((CharSequence)it);
    }

    private static final boolean getChildFiles$lambda$2(boolean $onlyDirectories, char $separator, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$onlyDirectories || StringsKt.endsWith$default((CharSequence)it, (char)$separator, (boolean)false, (int)2, null);
    }

    private static final boolean getChildFiles$lambda$3(String $path, char $separator, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)$path).length() == 0 || !Intrinsics.areEqual((Object)it, (Object)("." + $separator)) && !Intrinsics.areEqual((Object)it, (Object)(".." + $separator));
    }

    static {
        Key key = Key.create((String)"Project");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PROJECT_KEY = key;
        Key key2 = Key.create((String)"isReworked");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        IS_REWORKED_KEY = key2;
    }
}

