/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.feedback;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.platform.feedback.impl.OnDemandFeedbackResolver;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalEngine;
import org.jetbrains.plugins.terminal.block.feedback.ReworkedTerminalFeedbackSurvey;
import org.jetbrains.plugins.terminal.fus.TerminalFeedbackMoment;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"REWORKED_TERMINAL_DISABLING", "Lcom/intellij/openapi/util/Key;", "", "askForFeedbackIfReworkedTerminalDisabled", "", "project", "Lcom/intellij/openapi/project/Project;", "oldEngine", "Lorg/jetbrains/plugins/terminal/TerminalEngine;", "newEngine", "getFeedbackMoment", "Lorg/jetbrains/plugins/terminal/fus/TerminalFeedbackMoment;", "intellij.terminal"})
public final class ReworkedTerminalFeedbackSurveyKt {
    @NotNull
    private static final Key<Boolean> REWORKED_TERMINAL_DISABLING;

    @ApiStatus.Internal
    public static final void askForFeedbackIfReworkedTerminalDisabled(@NotNull Project project, @NotNull TerminalEngine oldEngine, @NotNull TerminalEngine newEngine) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)oldEngine), (String)"oldEngine");
        Intrinsics.checkNotNullParameter((Object)((Object)newEngine), (String)"newEngine");
        ApplicationManager.getApplication().invokeLater(() -> ReworkedTerminalFeedbackSurveyKt.askForFeedbackIfReworkedTerminalDisabled$lambda$0(oldEngine, newEngine, project), ModalityState.nonModal(), project.getDisposed());
    }

    @NotNull
    public static final TerminalFeedbackMoment getFeedbackMoment(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return Intrinsics.areEqual((Object)project.getUserData(REWORKED_TERMINAL_DISABLING), (Object)true) ? TerminalFeedbackMoment.ON_DISABLING : TerminalFeedbackMoment.AFTER_USAGE;
    }

    private static final void askForFeedbackIfReworkedTerminalDisabled$lambda$0(TerminalEngine $oldEngine, TerminalEngine $newEngine, Project $project) {
        if ($oldEngine == TerminalEngine.REWORKED && $newEngine != TerminalEngine.REWORKED) {
            $project.putUserData(REWORKED_TERMINAL_DISABLING, (Object)true);
            OnDemandFeedbackResolver.Companion.getInstance().showFeedbackNotification(Reflection.getOrCreateKotlinClass(ReworkedTerminalFeedbackSurvey.class), $project, arg_0 -> ReworkedTerminalFeedbackSurveyKt.askForFeedbackIfReworkedTerminalDisabled$lambda$0$0($project, arg_0));
        }
    }

    private static final Unit askForFeedbackIfReworkedTerminalDisabled$lambda$0$0(Project $project, boolean isNotificationShown) {
        if (!isNotificationShown) {
            $project.putUserData(REWORKED_TERMINAL_DISABLING, null);
        }
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"ReworkedTerminalDisabling");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        REWORKED_TERMINAL_DISABLING = key;
    }
}

