/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.reworked.hyperlinks;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.terminal.session.TerminalFilterResultInfo;
import com.intellij.terminal.session.TerminalHyperlinkId;
import com.intellij.terminal.session.TerminalHyperlinksModelState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOffset;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.hyperlinks.LoggableRange;
import org.jetbrains.plugins.terminal.block.reworked.hyperlinks.TerminalHyperlinksModelKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\rJ\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u0013J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\tH\u0002J\u001e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\tH\u0002J&\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\tH\u0002J\u0006\u0010\u001f\u001a\u00020 J2\u0010!\u001a\u00020\u00122\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0002J\u001e\u0010%\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0002J\u0012\u0010&\u001a\u00020'*\b\u0012\u0004\u0012\u00020\n0\u0013H\u0002J\f\u0010(\u001a\u00020\u001d*\u00020\u0017H\u0002J\f\u0010)\u001a\u00020**\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/plugins/terminal/block/reworked/hyperlinks/TerminalHyperlinksModel;", "", "debugName", "", "outputModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;)V", "hyperlinks", "", "Lcom/intellij/terminal/session/TerminalFilterResultInfo;", "hyperlinksById", "Ljava/util/HashMap;", "Lcom/intellij/terminal/session/TerminalHyperlinkId;", "Lkotlin/collections/HashMap;", "getHyperlink", "hyperlinkId", "addHyperlinks", "", "", "removeHyperlinks", "", "fromAbsoluteOffset", "", "removeTrimmedHyperlinks", "removedIds", "removeHyperlinksFromOffset", "removeHyperlinksInRange", "removeFromIndex", "", "removeUntilIndex", "dumpState", "Lcom/intellij/terminal/session/TerminalHyperlinksModelState;", "logHyperlinksAdded", "previousHyperlinks", "addedHyperlinks", "modifiedHyperlinks", "logHyperlinksRemoved", "loggableRange", "Lorg/jetbrains/plugins/terminal/block/reworked/hyperlinks/LoggableRange;", "toRelative", "addRelative", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOffset;", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalHyperlinksModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalHyperlinksModel.kt\norg/jetbrains/plugins/terminal/block/reworked/hyperlinks/TerminalHyperlinksModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1056#2:140\n1#3:141\n*S KotlinDebug\n*F\n+ 1 TerminalHyperlinksModel.kt\norg/jetbrains/plugins/terminal/block/reworked/hyperlinks/TerminalHyperlinksModel\n*L\n21#1:140\n*E\n"})
public final class TerminalHyperlinksModel {
    @NotNull
    private final String debugName;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private List<TerminalFilterResultInfo> hyperlinks;
    @NotNull
    private final HashMap<TerminalHyperlinkId, TerminalFilterResultInfo> hyperlinksById;

    public TerminalHyperlinksModel(@NotNull String debugName, @NotNull TerminalOutputModel outputModel) {
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        this.debugName = debugName;
        this.outputModel = outputModel;
        this.hyperlinks = new ArrayList();
        this.hyperlinksById = new HashMap();
    }

    @Nullable
    public final TerminalFilterResultInfo getHyperlink(@NotNull TerminalHyperlinkId hyperlinkId) {
        Intrinsics.checkNotNullParameter((Object)hyperlinkId, (String)"hyperlinkId");
        return this.hyperlinksById.get(hyperlinkId);
    }

    public final void addHyperlinks(@NotNull List<? extends TerminalFilterResultInfo> hyperlinks) {
        Intrinsics.checkNotNullParameter(hyperlinks, (String)"hyperlinks");
        Iterable $this$sortedBy$iv = hyperlinks;
        boolean $i$f$sortedBy = false;
        List newHyperlinks = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TerminalFilterResultInfo it = (TerminalFilterResultInfo)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getAbsoluteEndOffset());
                it = (TerminalFilterResultInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getAbsoluteEndOffset()));
            }
        });
        List<TerminalFilterResultInfo> oldHyperlinks = this.hyperlinks;
        ArrayList allHyperlinks = new ArrayList(oldHyperlinks.size() + newHyperlinks.size());
        int i = 0;
        int j = 0;
        while (true) {
            boolean takeOld;
            if (i >= oldHyperlinks.size()) {
                if (j >= newHyperlinks.size()) break;
            }
            boolean bl = i >= oldHyperlinks.size() ? false : (j >= newHyperlinks.size() ? true : (takeOld = oldHyperlinks.get(i).getAbsoluteEndOffset() <= ((TerminalFilterResultInfo)newHyperlinks.get(j)).getAbsoluteEndOffset()));
            if (takeOld) {
                ((Collection)allHyperlinks).add(oldHyperlinks.get(i++));
                continue;
            }
            TerminalFilterResultInfo newHyperlink = (TerminalFilterResultInfo)newHyperlinks.get(j++);
            ((Collection)allHyperlinks).add(newHyperlink);
            ((Map)this.hyperlinksById).put(newHyperlink.getId(), newHyperlink);
        }
        this.logHyperlinksAdded(this.hyperlinks, newHyperlinks, allHyperlinks);
        this.hyperlinks = allHyperlinks;
    }

    @NotNull
    public final Collection<TerminalHyperlinkId> removeHyperlinks(long fromAbsoluteOffset) {
        if (this.hyperlinks.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List removedIds = new ArrayList();
        this.removeTrimmedHyperlinks(removedIds);
        this.removeHyperlinksFromOffset(fromAbsoluteOffset, removedIds);
        this.logHyperlinksRemoved(fromAbsoluteOffset, removedIds);
        return removedIds;
    }

    private final void removeTrimmedHyperlinks(List<TerminalHyperlinkId> removedIds) {
        long trimOffset = this.outputModel.relativeOffset(0).toAbsolute();
        int it = CollectionsKt.binarySearch$default(this.hyperlinks, (int)0, (int)0, arg_0 -> TerminalHyperlinksModel.removeTrimmedHyperlinks$lambda$0(trimOffset, arg_0), (int)3, null);
        boolean bl = false;
        int removeUntilIndex = it >= 0 ? it + 1 : -it - 1;
        this.removeHyperlinksInRange(0, removeUntilIndex, removedIds);
    }

    private final void removeHyperlinksFromOffset(long fromAbsoluteOffset, List<TerminalHyperlinkId> removedIds) {
        int it = CollectionsKt.binarySearch$default(this.hyperlinks, (int)0, (int)0, arg_0 -> TerminalHyperlinksModel.removeHyperlinksFromOffset$lambda$0(fromAbsoluteOffset, arg_0), (int)3, null);
        boolean bl = false;
        int removeFromIndex = it >= 0 ? it : -it - 1;
        this.removeHyperlinksInRange(removeFromIndex, this.hyperlinks.size(), removedIds);
    }

    private final void removeHyperlinksInRange(int removeFromIndex, int removeUntilIndex, List<TerminalHyperlinkId> removedIds) {
        List<TerminalFilterResultInfo> toRemove = this.hyperlinks.subList(removeFromIndex, removeUntilIndex);
        for (TerminalFilterResultInfo hyperlinkInfo : toRemove) {
            this.hyperlinksById.remove(hyperlinkInfo.getId());
            ((Collection)removedIds).add(hyperlinkInfo.getId());
        }
        toRemove.clear();
    }

    @NotNull
    public final TerminalHyperlinksModelState dumpState() {
        return new TerminalHyperlinksModelState(CollectionsKt.toList((Iterable)this.hyperlinks));
    }

    private final void logHyperlinksAdded(List<? extends TerminalFilterResultInfo> previousHyperlinks, List<? extends TerminalFilterResultInfo> addedHyperlinks, List<? extends TerminalFilterResultInfo> modifiedHyperlinks) {
        if (!TerminalHyperlinksModelKt.access$getLOG$p().isDebugEnabled()) {
            return;
        }
        TerminalHyperlinksModelKt.access$getLOG$p().debug(this.debugName + " Hyperlinks added: previously " + previousHyperlinks.size() + " links " + this.loggableRange(previousHyperlinks) + ", added " + addedHyperlinks.size() + " links " + this.loggableRange(addedHyperlinks) + ", now " + modifiedHyperlinks.size() + " links " + this.loggableRange(modifiedHyperlinks));
    }

    private final void logHyperlinksRemoved(long fromAbsoluteOffset, List<TerminalHyperlinkId> removedIds) {
        Comparable comparable;
        Object it;
        Object object;
        if (!TerminalHyperlinksModelKt.access$getLOG$p().isDebugEnabled()) {
            return;
        }
        Iterable iterable = removedIds;
        long l = this.outputModel.relativeOffset(0).toAbsolute();
        int n = this.toRelative(fromAbsoluteOffset);
        long l2 = fromAbsoluteOffset;
        String string = this.debugName;
        Logger logger = TerminalHyperlinksModelKt.access$getLOG$p();
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            object = null;
        } else {
            it = (TerminalHyperlinkId)iterator.next();
            boolean bl = false;
            it = it.getValue();
            while (iterator.hasNext()) {
                Object it2 = (TerminalHyperlinkId)iterator.next();
                $i$a$-minOfOrNull-TerminalHyperlinksModel$logHyperlinksRemoved$1 = false;
                if (it.compareTo(it2 = (Comparable)Long.valueOf(it2.getValue())) <= 0) continue;
                it = it2;
            }
            object = it;
        }
        Object object2 = object;
        iterable = removedIds;
        iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            it = (TerminalHyperlinkId)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Long.valueOf(it.getValue());
            while (iterator.hasNext()) {
                TerminalHyperlinkId it3 = (TerminalHyperlinkId)iterator.next();
                $i$a$-maxOfOrNull-TerminalHyperlinksModel$logHyperlinksRemoved$2 = false;
                Comparable comparable3 = Long.valueOf(it3.getValue());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Comparable comparable4 = comparable;
        logger.debug(string + " Hyperlinks removed from offset " + l2 + " (" + n + ") and trimmed until " + l + ": removed IDs " + (Comparable)object2 + "-" + comparable4 + ", now " + this.hyperlinks.size() + " links " + this.loggableRange(this.hyperlinks));
    }

    private final LoggableRange loggableRange(List<? extends TerminalFilterResultInfo> $this$loggableRange) {
        Comparable comparable;
        Object it;
        Long l;
        TerminalOffset terminalOffset;
        TerminalOffset terminalOffset2;
        long l2;
        TerminalFilterResultInfo terminalFilterResultInfo = (TerminalFilterResultInfo)CollectionsKt.firstOrNull($this$loggableRange);
        if (terminalFilterResultInfo != null) {
            l2 = terminalFilterResultInfo.getAbsoluteStartOffset();
            terminalOffset2 = this.addRelative(l2);
        } else {
            terminalOffset2 = null;
        }
        TerminalFilterResultInfo terminalFilterResultInfo2 = (TerminalFilterResultInfo)CollectionsKt.lastOrNull($this$loggableRange);
        if (terminalFilterResultInfo2 != null) {
            l2 = terminalFilterResultInfo2.getAbsoluteEndOffset();
            terminalOffset = this.addRelative(l2);
        } else {
            terminalOffset = null;
        }
        Iterable iterable = $this$loggableRange;
        TerminalOffset terminalOffset3 = terminalOffset;
        TerminalOffset terminalOffset4 = terminalOffset2;
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            l = null;
        } else {
            it = (TerminalFilterResultInfo)iterator.next();
            boolean bl = false;
            it = it.getId().getValue();
            while (iterator.hasNext()) {
                Object it2 = (TerminalFilterResultInfo)iterator.next();
                $i$a$-minOfOrNull-TerminalHyperlinksModel$loggableRange$1 = false;
                if (it.compareTo(it2 = (Comparable)Long.valueOf(it2.getId().getValue())) <= 0) continue;
                it = it2;
            }
            l = it;
        }
        Long l3 = l;
        iterable = $this$loggableRange;
        l3 = l3;
        iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            it = (TerminalFilterResultInfo)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Long.valueOf(it.getId().getValue());
            while (iterator.hasNext()) {
                TerminalFilterResultInfo it3 = (TerminalFilterResultInfo)iterator.next();
                $i$a$-maxOfOrNull-TerminalHyperlinksModel$loggableRange$2 = false;
                Comparable comparable3 = Long.valueOf(it3.getId().getValue());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Comparable comparable4 = comparable;
        Long l4 = (Long)comparable4;
        Long l5 = l3;
        TerminalOffset terminalOffset5 = terminalOffset3;
        TerminalOffset terminalOffset6 = terminalOffset4;
        return new LoggableRange(terminalOffset6, terminalOffset5, l5, l4);
    }

    private final int toRelative(long $this$toRelative) {
        return this.outputModel.absoluteOffset($this$toRelative).toRelative();
    }

    private final TerminalOffset addRelative(long $this$addRelative) {
        return this.outputModel.absoluteOffset($this$addRelative);
    }

    private static final int removeTrimmedHyperlinks$lambda$0(long $trimOffset, TerminalFilterResultInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.compare((long)it.getAbsoluteEndOffset(), (long)$trimOffset);
    }

    private static final int removeHyperlinksFromOffset$lambda$0(long $fromAbsoluteOffset, TerminalFilterResultInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.compare((long)it.getAbsoluteEndOffset(), (long)$fromAbsoluteOffset);
    }
}

