/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.terminal.BlockTerminalColors;
import com.intellij.ui.JBColor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"J\u0012\u0010#\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"J0\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020&2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0(H\u0002J\u0012\u0010+\u001a\u00020,*\u00020-2\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020*2\u0006\u0010!\u001a\u00020\"R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/plugins/terminal/block/ui/TerminalUi;", "", "<init>", "()V", "blockTopInset", "", "blockBottomInset", "blockLeftInset", "blockRightInset", "cornerToBlockInset", "cornerToBlockOffset", "commandToOutputInset", "blockArc", "blocksGap", "blockSeparatorRightOffset", "blockSelectionSeparatorGap", "errorLineYOffset", "errorLineRightOffset", "errorLineWidth", "errorLineArc", "exitCodeRightInset", "exitCodeTextIconGap", "promptTopInset", "promptBottomInset", "promptToCommandInset", "alternateBufferLeftInset", "searchComponentWidth", "blockTopInlayPriority", "terminalTopInlayPriority", "blockBottomInlayPriority", "terminalBottomInlayPriority", "defaultBackground", "Lcom/intellij/ui/JBColor;", "editor", "Lcom/intellij/openapi/editor/Editor;", "defaultForeground", "createColorBoundToColorKey", "colorKey", "Lcom/intellij/openapi/editor/colors/ColorKey;", "default", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "Ljava/awt/Color;", "useTerminalDefaultBackground", "", "Lcom/intellij/openapi/editor/ex/EditorEx;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "promptSeparatorColor", "intellij.terminal"})
@ApiStatus.Internal
public final class TerminalUi {
    @NotNull
    public static final TerminalUi INSTANCE = new TerminalUi();
    public static final int blockTopInset = 6;
    public static final int blockBottomInset = 6;
    public static final int blockLeftInset = 9;
    public static final int blockRightInset = 12;
    public static final int cornerToBlockInset = 10;
    public static final int cornerToBlockOffset = 7;
    public static final int commandToOutputInset = 2;
    public static final int blockArc = 8;
    public static final int blocksGap = 0;
    public static final int blockSeparatorRightOffset = 19;
    public static final int blockSelectionSeparatorGap = 1;
    public static final int errorLineYOffset = 2;
    public static final int errorLineRightOffset = 9;
    public static final int errorLineWidth = 3;
    public static final int errorLineArc = 4;
    public static final int exitCodeRightInset = 8;
    public static final int exitCodeTextIconGap = 4;
    public static final int promptTopInset = 6;
    public static final int promptBottomInset = 12;
    public static final int promptToCommandInset = 2;
    public static final int alternateBufferLeftInset = 4;
    public static final int searchComponentWidth = 500;
    public static final int blockTopInlayPriority = 300;
    public static final int terminalTopInlayPriority = 200;
    public static final int blockBottomInlayPriority = 100;
    public static final int terminalBottomInlayPriority = 0;

    private TerminalUi() {
    }

    @NotNull
    public final JBColor defaultBackground(@Nullable Editor editor) {
        JBColor jBColor = JBColor.lazy(() -> TerminalUi.defaultBackground$lambda$0(editor));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"lazy(...)");
        return jBColor;
    }

    public static /* synthetic */ JBColor defaultBackground$default(TerminalUi terminalUi, Editor editor, int n, Object object) {
        if ((n & 1) != 0) {
            editor = null;
        }
        return terminalUi.defaultBackground(editor);
    }

    @NotNull
    public final JBColor defaultForeground(@Nullable Editor editor) {
        return this.createColorBoundToColorKey(BlockTerminalColors.DEFAULT_FOREGROUND, editor, (Function1<? super EditorColorsScheme, ? extends Color>)((Function1)TerminalUi::defaultForeground$lambda$0));
    }

    public static /* synthetic */ JBColor defaultForeground$default(TerminalUi terminalUi, Editor editor, int n, Object object) {
        if ((n & 1) != 0) {
            editor = null;
        }
        return terminalUi.defaultForeground(editor);
    }

    private final JBColor createColorBoundToColorKey(ColorKey colorKey, Editor editor, Function1<? super EditorColorsScheme, ? extends Color> function1) {
        JBColor jBColor = JBColor.lazy(() -> TerminalUi.createColorBoundToColorKey$lambda$0(editor, colorKey, function1));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"lazy(...)");
        return jBColor;
    }

    static /* synthetic */ JBColor createColorBoundToColorKey$default(TerminalUi terminalUi, ColorKey colorKey, Editor editor, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            editor = null;
        }
        return terminalUi.createColorBoundToColorKey(colorKey, editor, (Function1<? super EditorColorsScheme, ? extends Color>)function1);
    }

    public final void useTerminalDefaultBackground(@NotNull EditorEx $this$useTerminalDefaultBackground, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)$this$useTerminalDefaultBackground, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        $this$useTerminalDefaultBackground.setBackgroundColor((Color)this.defaultBackground((Editor)$this$useTerminalDefaultBackground));
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(parentDisposable);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> TerminalUi.useTerminalDefaultBackground$lambda$0($this$useTerminalDefaultBackground, arg_0));
    }

    @NotNull
    public final Color promptSeparatorColor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return (Color)this.createColorBoundToColorKey(BlockTerminalColors.PROMPT_SEPARATOR_COLOR, editor, (Function1<? super EditorColorsScheme, ? extends Color>)((Function1)TerminalUi::promptSeparatorColor$lambda$0));
    }

    private static final Color defaultBackground$lambda$0(Editor $editor) {
        Editor editor = $editor;
        if (editor == null || (editor = editor.getColorsScheme()) == null) {
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
            editor = editorColorsScheme;
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        }
        Editor colorsScheme = editor;
        return colorsScheme.getDefaultBackground();
    }

    private static final Color defaultForeground$lambda$0(EditorColorsScheme it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Color color = it.getDefaultForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultForeground(...)");
        return color;
    }

    private static final Color createColorBoundToColorKey$lambda$0(Editor $editor, ColorKey $colorKey, Function1 $default) {
        Editor colorsScheme;
        Color color;
        Editor editor = $editor;
        if (editor == null || (editor = editor.getColorsScheme()) == null) {
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
            editor = editorColorsScheme;
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        }
        if ((color = (colorsScheme = editor).getColor($colorKey)) == null) {
            color = (Color)$default.invoke((Object)colorsScheme);
        }
        return color;
    }

    private static final void useTerminalDefaultBackground$lambda$0(EditorEx $this_useTerminalDefaultBackground, EditorColorsScheme it) {
        $this_useTerminalDefaultBackground.setBackgroundColor((Color)INSTANCE.defaultBackground((Editor)$this_useTerminalDefaultBackground));
    }

    private static final Color promptSeparatorColor$lambda$0(EditorColorsScheme it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Color color = JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"separatorForeground(...)");
        return color;
    }
}

