/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class LowMemoryWatcherManager {
    private static final Logger LOG = Logger.getInstance(LowMemoryWatcherManager.class);
    private static final long MIN_MEMORY_MARGIN = 0x500000L;
    private static final long WINDOW_SIZE_MS = TimeUnit.SECONDS.toMillis(60L);
    private static final long IN_WINDOW_GC_DURATION_THRESHOLD_MS = TimeUnit.SECONDS.toMillis(10L);
    private final ExecutorService watcherNotificationPool;
    private Future<?> watcherNotificationTaskSubmitted;
    private final Consumer<Boolean> watcherNotificationTask;
    private final Future<?> memoryPoolMXBeansInitializationFuture;
    private final GcTracker gcTracker;
    private final NotificationListener lowMemoryListener;

    public LowMemoryWatcherManager(@NotNull ExecutorService backendExecutorService) {
        if (backendExecutorService == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(0);
        }
        this.watcherNotificationTask = new Consumer<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(@NotNull Boolean afterGc) {
                if (afterGc == null) {
                    1.$$$reportNull$$$0(0);
                }
                Consumer consumer = LowMemoryWatcherManager.this.watcherNotificationTask;
                synchronized (consumer) {
                    LowMemoryWatcherManager.this.watcherNotificationTaskSubmitted = null;
                }
                LowMemoryWatcher.onLowMemorySignalReceived(afterGc);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterGc", "com/intellij/openapi/util/LowMemoryWatcherManager$1", "accept"));
            }
        };
        this.gcTracker = new GcTracker(LowMemoryWatcherManager.getMajorGcTime());
        this.lowMemoryListener = new NotificationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleNotification(Notification notification, Object __) {
                if (LowMemoryWatcher.notificationsSuppressed()) {
                    return;
                }
                boolean memoryThreshold = "java.management.memory.threshold.exceeded".equals(notification.getType());
                boolean memoryCollectionThreshold = "java.management.memory.collection.threshold.exceeded".equals(notification.getType());
                if (memoryThreshold || memoryCollectionThreshold) {
                    long currentGcTime = LowMemoryWatcherManager.getMajorGcTime();
                    long recentGcTime = LowMemoryWatcherManager.this.gcTracker.trackGcAndGetRecentTime(currentGcTime);
                    LOG.info("LowMemoryNotification{gcTime: " + currentGcTime + "ms, in last minute: " + recentGcTime + "ms}{threshold: " + memoryThreshold + ", collectionThreshold: " + memoryCollectionThreshold + "}");
                    Consumer consumer = LowMemoryWatcherManager.this.watcherNotificationTask;
                    synchronized (consumer) {
                        if (LowMemoryWatcherManager.this.watcherNotificationTaskSubmitted == null) {
                            boolean afterGC = recentGcTime > IN_WINDOW_GC_DURATION_THRESHOLD_MS && memoryCollectionThreshold;
                            LowMemoryWatcherManager.this.watcherNotificationTaskSubmitted = LowMemoryWatcherManager.this.watcherNotificationPool.submit(() -> LowMemoryWatcherManager.this.watcherNotificationTask.accept(afterGC));
                            if (LowMemoryWatcherManager.this.watcherNotificationTaskSubmitted.isDone()) {
                                LowMemoryWatcherManager.this.watcherNotificationTaskSubmitted = null;
                            }
                        }
                    }
                }
            }
        };
        this.watcherNotificationPool = Boolean.getBoolean("low.memory.watcher.sync") ? ConcurrencyUtil.newSameThreadExecutorService() : SequentialTaskExecutor.createSequentialApplicationPoolExecutor("LowMemoryWatcherManager", backendExecutorService);
        this.memoryPoolMXBeansInitializationFuture = this.initializeMXBeanListenersLater(backendExecutorService);
    }

    private static long getMajorGcTime() {
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!gc.getName().toLowerCase().contains("g1 old generation")) continue;
            return gc.getCollectionTime();
        }
        return 0L;
    }

    @NotNull
    private Future<?> initializeMXBeanListenersLater(@NotNull ExecutorService backendExecutorService) {
        if (backendExecutorService == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(1);
        }
        Future<?> future = backendExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
                        if (bean.getType() != MemoryType.HEAP || !bean.isCollectionUsageThresholdSupported() || !bean.isUsageThresholdSupported()) continue;
                        long maxPoolCapacity = bean.getUsage().getMax();
                        long threshold = Math.min((long)((float)maxPoolCapacity * LowMemoryWatcherManager.getOccupiedMemoryThreshold()), maxPoolCapacity - 0x500000L);
                        LOG.info("Subscribing to MemoryPool[" + bean.getName() + "]{max: " + maxPoolCapacity + ", threshold: " + threshold + "}");
                        if (threshold <= 0L) continue;
                        bean.setUsageThreshold(threshold);
                        bean.setCollectionUsageThreshold(threshold);
                    }
                    ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener(LowMemoryWatcherManager.this.lowMemoryListener, null, null);
                }
                catch (Throwable e) {
                    LOG.info("Errors initializing LowMemoryWatcher: ", e);
                }
            }

            public String toString() {
                return "initializeMXBeanListeners runnable";
            }
        });
        if (future == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(2);
        }
        return future;
    }

    private static float getOccupiedMemoryThreshold() {
        return SystemProperties.getFloatProperty("low.memory.watcher.notification.threshold", 0.95f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.memoryPoolMXBeansInitializationFuture.get();
            ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).removeNotificationListener(this.lowMemoryListener);
        }
        catch (Exception e) {
            LOG.error(e);
        }
        Consumer<Boolean> consumer = this.watcherNotificationTask;
        synchronized (consumer) {
            if (this.watcherNotificationTaskSubmitted != null) {
                this.watcherNotificationTaskSubmitted.cancel(false);
                this.watcherNotificationTaskSubmitted = null;
            }
        }
        LowMemoryWatcher.stopAll();
    }

    @TestOnly
    public void waitForInitComplete(int timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.memoryPoolMXBeansInitializationFuture.get(timeout, unit);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendExecutorService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/LowMemoryWatcherManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/LowMemoryWatcherManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeMXBeanListenersLater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initializeMXBeanListenersLater";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GcTracker {
        private long lastGcDurationMs;
        private final Queue<GcPeriod> gcDurations = new LinkedList<GcPeriod>();

        private GcTracker(long initialGcDurationMs) {
            this.lastGcDurationMs = initialGcDurationMs;
        }

        public synchronized long trackGcAndGetRecentTime(long currentGcDurationMs) {
            long nowMs = System.currentTimeMillis();
            long previousGcDurationMs = this.lastGcDurationMs;
            this.lastGcDurationMs = currentGcDurationMs;
            long gcDurationDeltaMs = currentGcDurationMs - previousGcDurationMs;
            if (gcDurationDeltaMs > 0L) {
                this.gcDurations.offer(new GcPeriod(nowMs, gcDurationDeltaMs));
            }
            while (!this.gcDurations.isEmpty() && this.gcDurations.peek().timestamp < nowMs - WINDOW_SIZE_MS) {
                this.gcDurations.poll();
            }
            return this.gcDurations.stream().mapToLong(period -> period.gcDurationMs).sum();
        }

        private static class GcPeriod {
            final long timestamp;
            final long gcDurationMs;

            GcPeriod(long timestamp, long gcDurationMs) {
                this.timestamp = timestamp;
                this.gcDurationMs = gcDurationMs;
            }
        }
    }
}

