/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContextManager;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.search.ActualCodeInsightContextInfo;
import com.intellij.psi.search.ActualContextFileInfo;
import com.intellij.psi.search.ActualContextFileInfoImpl;
import com.intellij.psi.search.CodeInsightContextAwareSearchScope;
import com.intellij.psi.search.CodeInsightContextFileInfo;
import com.intellij.psi.search.CodeInsightContextInfo;
import com.intellij.psi.search.DoesNotContainFileInfo;
import com.intellij.psi.search.DoesNotContainFileInfoImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NoContextFileInfo;
import com.intellij.psi.search.NoContextFileInfoImpl;
import com.intellij.psi.search.NoContextInformation;
import com.intellij.psi.search.NoContextInformationImpl;
import com.intellij.psi.search.SearchScope;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\b\u0010\u000f\u001a\u00020\u0010H\u0007\u001a\b\u0010\u0011\u001a\u00020\u0012H\u0007\u001a\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0007\u001a\u0016\u0010\u0016\u001a\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0007\u001a\b\u0010\u0017\u001a\u00020\u0018H\u0007\u001a(\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007\"\u0015\u0010\u000b\u001a\u00020\f*\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"contains", "", "Lcom/intellij/psi/search/SearchScope;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "context", "Lcom/intellij/codeInsight/multiverse/CodeInsightContext;", "getFileContextInfo", "Lcom/intellij/psi/search/CodeInsightContextFileInfo;", "getCorrespondingContexts", "", "codeInsightContextInfo", "Lcom/intellij/psi/search/CodeInsightContextInfo;", "getCodeInsightContextInfo", "(Lcom/intellij/psi/search/SearchScope;)Lcom/intellij/psi/search/CodeInsightContextInfo;", "NoContextInformation", "Lcom/intellij/psi/search/NoContextInformation;", "DoesNotContainFileInfo", "Lcom/intellij/psi/search/DoesNotContainFileInfo;", "ActualContextFileInfo", "Lcom/intellij/psi/search/ActualContextFileInfo;", "contexts", "createContainingContextFileInfo", "NoContextFileInfo", "Lcom/intellij/psi/search/NoContextFileInfo;", "tryCheckingFileInScope", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "globalScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.core"})
@ApiStatus.Experimental
@JvmName(name="CodeInsightContextAwareSearchScopes")
@SourceDebugExtension(value={"SMAP\nCodeInsightContextAwareSearchScopes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeInsightContextAwareSearchScopes.kt\ncom/intellij/psi/search/CodeInsightContextAwareSearchScopes\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,280:1\n57#2:281\n35#2,2:282\n*S KotlinDebug\n*F\n+ 1 CodeInsightContextAwareSearchScopes.kt\ncom/intellij/psi/search/CodeInsightContextAwareSearchScopes\n*L\n254#1:281\n254#1:282,2\n*E\n"})
public final class CodeInsightContextAwareSearchScopes {
    @ApiStatus.Experimental
    public static final boolean contains(@NotNull SearchScope $this$contains, @NotNull VirtualFile file, @NotNull CodeInsightContext context) {
        boolean bl;
        CodeInsightContextInfo info;
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(context, "context");
        CodeInsightContextInfo codeInsightContextInfo = info = CodeInsightContextAwareSearchScopes.getCodeInsightContextInfo($this$contains);
        if (codeInsightContextInfo instanceof NoContextInformation) {
            bl = $this$contains.contains(file);
        } else if (codeInsightContextInfo instanceof ActualCodeInsightContextInfo) {
            bl = ((ActualCodeInsightContextInfo)info).contains(file, context);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @ApiStatus.Experimental
    @NotNull
    public static final CodeInsightContextFileInfo getFileContextInfo(@NotNull SearchScope $this$getFileContextInfo, @NotNull VirtualFile file) {
        CodeInsightContextFileInfo codeInsightContextFileInfo;
        CodeInsightContextInfo info;
        Intrinsics.checkNotNullParameter($this$getFileContextInfo, "<this>");
        Intrinsics.checkNotNullParameter(file, "file");
        CodeInsightContextInfo codeInsightContextInfo = info = CodeInsightContextAwareSearchScopes.getCodeInsightContextInfo($this$getFileContextInfo);
        if (codeInsightContextInfo instanceof NoContextInformation) {
            codeInsightContextFileInfo = $this$getFileContextInfo.contains(file) ? (CodeInsightContextFileInfo)CodeInsightContextAwareSearchScopes.NoContextFileInfo() : (CodeInsightContextFileInfo)CodeInsightContextAwareSearchScopes.DoesNotContainFileInfo();
        } else if (codeInsightContextInfo instanceof ActualCodeInsightContextInfo) {
            codeInsightContextFileInfo = ((ActualCodeInsightContextInfo)info).getFileInfo(file);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return codeInsightContextFileInfo;
    }

    @ApiStatus.Experimental
    @NotNull
    public static final Collection<CodeInsightContext> getCorrespondingContexts(@NotNull SearchScope $this$getCorrespondingContexts, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter($this$getCorrespondingContexts, "<this>");
        Intrinsics.checkNotNullParameter(file, "file");
        CodeInsightContextFileInfo contextInfo = CodeInsightContextAwareSearchScopes.getFileContextInfo($this$getCorrespondingContexts, file);
        return contextInfo instanceof ActualContextFileInfo ? ((ActualContextFileInfo)contextInfo).getContexts() : (contextInfo instanceof NoContextFileInfo ? (Collection)CollectionsKt.listOf(CodeInsightContexts.anyContext()) : (Collection)CollectionsKt.emptyList());
    }

    @ApiStatus.Experimental
    @NotNull
    public static final CodeInsightContextInfo getCodeInsightContextInfo(@NotNull SearchScope $this$codeInsightContextInfo) {
        Intrinsics.checkNotNullParameter($this$codeInsightContextInfo, "<this>");
        return $this$codeInsightContextInfo instanceof CodeInsightContextAwareSearchScope ? ((CodeInsightContextAwareSearchScope)((Object)$this$codeInsightContextInfo)).getCodeInsightContextInfo() : (CodeInsightContextInfo)CodeInsightContextAwareSearchScopes.NoContextInformation();
    }

    @ApiStatus.Experimental
    @NotNull
    public static final NoContextInformation NoContextInformation() {
        return NoContextInformationImpl.INSTANCE;
    }

    @ApiStatus.Experimental
    @NotNull
    public static final DoesNotContainFileInfo DoesNotContainFileInfo() {
        return DoesNotContainFileInfoImpl.INSTANCE;
    }

    @ApiStatus.Experimental
    @NotNull
    public static final ActualContextFileInfo ActualContextFileInfo(@NotNull Collection<? extends CodeInsightContext> contexts2) {
        Intrinsics.checkNotNullParameter(contexts2, "contexts");
        if (contexts2.isEmpty()) {
            throw new IllegalArgumentException("Contexts cannot be empty");
        }
        return new ActualContextFileInfoImpl(contexts2);
    }

    @ApiStatus.Experimental
    @NotNull
    public static final CodeInsightContextFileInfo createContainingContextFileInfo(@NotNull Collection<? extends CodeInsightContext> contexts2) {
        Intrinsics.checkNotNullParameter(contexts2, "contexts");
        if (contexts2.isEmpty()) {
            return CodeInsightContextAwareSearchScopes.NoContextFileInfo();
        }
        return CodeInsightContextAwareSearchScopes.ActualContextFileInfo(contexts2);
    }

    @ApiStatus.Experimental
    @NotNull
    public static final NoContextFileInfo NoContextFileInfo() {
        return NoContextFileInfoImpl.INSTANCE;
    }

    @ApiStatus.Internal
    public static final boolean tryCheckingFileInScope(@NotNull VirtualFile file, @NotNull FileViewProvider viewProvider, @NotNull GlobalSearchScope globalScope, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(viewProvider, "viewProvider");
        Intrinsics.checkNotNullParameter(globalScope, "globalScope");
        Intrinsics.checkNotNullParameter(project, "project");
        CodeInsightContextManager contextManager = CodeInsightContextManager.Companion.getInstance(project);
        CodeInsightContext cachedContext = contextManager.getCodeInsightContextRaw(viewProvider);
        if (cachedContext != CodeInsightContexts.anyContext()) {
            return CodeInsightContextAwareSearchScopes.contains(globalScope, file, cachedContext);
        }
        CodeInsightContextFileInfo contextInfo = CodeInsightContextAwareSearchScopes.getFileContextInfo(globalScope, file);
        if (contextInfo instanceof ActualContextFileInfo) {
            CodeInsightContext context = (CodeInsightContext)CollectionsKt.first((Iterable)((ActualContextFileInfo)contextInfo).getContexts());
            CodeInsightContext actualCodeInsightContext = contextManager.getOrSetContext(viewProvider, context);
            if (actualCodeInsightContext == context) {
                return true;
            }
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
            logger.warn("Unexpected context " + actualCodeInsightContext + " for " + context + " for " + viewProvider, new Throwable());
            return CodeInsightContextAwareSearchScopes.contains(globalScope, file, actualCodeInsightContext);
        }
        if (contextInfo instanceof NoContextFileInfo) {
            return globalScope.contains(file);
        }
        if (contextInfo instanceof DoesNotContainFileInfo) {
            return false;
        }
        throw new NoWhenBranchMatchedException();
    }
}

