/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.grazie.dictionary;

import ai.grazie.nlp.similarity.Levenshtein;
import ai.grazie.spell.lists.WordList;
import ai.grazie.utils.TextKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.CollectionFactory;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J \u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u000ej\b\u0012\u0004\u0012\u00020\u0004`\u000f2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/spellchecker/grazie/dictionary/SimpleWordList;", "Lai/grazie/spell/lists/WordList;", "container", "", "", "<init>", "(Ljava/util/Set;)V", "invariants", "buildInvariants", "contains", "", "word", "caseSensitive", "suggest", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "Companion", "intellij.spellchecker"})
@SourceDebugExtension(value={"SMAP\nSimpleWordList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleWordList.kt\ncom/intellij/spellchecker/grazie/dictionary/SimpleWordList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n865#2,2:43\n*S KotlinDebug\n*F\n+ 1 SimpleWordList.kt\ncom/intellij/spellchecker/grazie/dictionary/SimpleWordList\n*L\n38#1:43,2\n*E\n"})
public final class SimpleWordList
implements WordList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> container;
    @NotNull
    private final Set<String> invariants;
    public static final int MAX_LEVENSHTEIN_DISTANCE = 3;

    public SimpleWordList(@NotNull Set<String> container) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        this.container = container;
        this.invariants = this.buildInvariants(this.container);
    }

    private final Set<String> buildInvariants(Set<String> container) {
        Set set = CollectionFactory.createSmallMemoryFootprintSet((int)container.size());
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createSmallMemoryFootprintSet(...)");
        Set result = set;
        for (String entry : container) {
            ProgressManager.checkCanceled();
            String string = entry.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            result.add(string);
        }
        return result;
    }

    public boolean contains(@NotNull String word, boolean caseSensitive) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (caseSensitive) {
            bl = this.contains(word);
        } else {
            String string = word.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            bl = this.invariants.contains(string);
        }
        return bl;
    }

    private final boolean contains(String word) {
        if (this.container.contains(word)) {
            return true;
        }
        if (TextKt.isUppercase((String)word)) {
            String string = word.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return this.container.contains(string);
        }
        if (Character.isUpperCase(StringsKt.first((CharSequence)word))) {
            return this.container.contains(StringUtil.decapitalize((String)word));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LinkedHashSet<String> suggest(@NotNull String word) {
        void var3_3;
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Iterable iterable = this.container;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (!(Levenshtein.distance$default((String)it, (String)word, (int)4, (boolean)false, (int)8, null) <= 3)) continue;
            destination$iv.add(element$iv);
        }
        return (LinkedHashSet)var3_3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/spellchecker/grazie/dictionary/SimpleWordList$Companion;", "", "<init>", "()V", "MAX_LEVENSHTEIN_DISTANCE", "", "intellij.spellchecker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

