/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.cli;

import com.intellij.docker.agent.cli.DockerCli;
import com.intellij.docker.cli.DirectPodmanDockerCli;
import com.intellij.docker.cli.PodmanCliExecutor;
import com.intellij.docker.cli.PodmanCliExecutorKt;
import com.intellij.docker.cli.PodmanConnectionDockerCliExecutor;
import com.intellij.docker.podman.PodmanInstanceConnection;
import com.intellij.docker.utils.LoggingKt;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\u001a\"\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0080@\u00a2\u0006\u0002\u0010\f\u001a\u0012\u0010\r\u001a\u00020\u0007*\u00020\bH\u0080@\u00a2\u0006\u0002\u0010\u000e\u001a\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0000\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0014\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "logger$delegate", "Lkotlin/Lazy;", "sshDialStdio", "Ljava/lang/Process;", "Lcom/intellij/docker/cli/PodmanCliExecutor;", "podmanMachineName", "", "podmanMachineUsername", "(Lcom/intellij/docker/cli/PodmanCliExecutor;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dialStdio", "(Lcom/intellij/docker/cli/PodmanCliExecutor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createPodmanDockerCli", "Lcom/intellij/docker/agent/cli/DockerCli;", "podmanCliExecutor", "connection", "Lcom/intellij/docker/podman/PodmanInstanceConnection;", "PODMAN_ENV_CONTAINER_CONNECTION", "podmanConnectionEnvs", "", "systemConnectionName", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nPodmanCliExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PodmanCliExecutor.kt\ncom/intellij/docker/cli/PodmanCliExecutorKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,83:1\n13#2:84\n13#2:85\n*S KotlinDebug\n*F\n+ 1 PodmanCliExecutor.kt\ncom/intellij/docker/cli/PodmanCliExecutorKt\n*L\n34#1:84\n19#1:85\n*E\n"})
public final class PodmanCliExecutorKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy(PodmanCliExecutorKt::logger_delegate$lambda$0);
    @NotNull
    private static final String PODMAN_ENV_CONTAINER_CONNECTION = "CONTAINER_CONNECTION";

    private static final Logger getLogger() {
        Lazy lazy = logger$delegate;
        return (Logger)lazy.getValue();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object sshDialStdio(@NotNull PodmanCliExecutor $this$sshDialStdio, @NotNull String podmanMachineName, @NotNull String podmanMachineUsername, @NotNull Continuation<? super Process> $completion) {
        if (!($completion instanceof sshDialStdio.1)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PodmanCliExecutorKt.sshDialStdio(null, null, null, (Continuation<? super Process>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = new String[]{$this$sshDialStdio.getExePath(), "machine", "ssh", "--username", podmanMachineUsername, podmanMachineName};
                v0 = CollectionsKt.listOf((Object[])var5_7);
                var5_7 = new String[]{"podman", "system", "dial-stdio"};
                command = CollectionsKt.plus((Collection)v0, (Iterable)CollectionsKt.listOf((Object[])var5_7));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$sshDialStdio);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)podmanMachineName);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)podmanMachineUsername);
                $continuation.L$3 = command;
                $continuation.label = 1;
                v1 = $this$sshDialStdio.createProcess(new GeneralCommandLine(command), (Continuation<? super Process>)$continuation);
                if (v1 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl32
            }
            case 1: {
                command = (List)$continuation.L$3;
                podmanMachineUsername = (String)$continuation.L$2;
                podmanMachineName = (String)$continuation.L$1;
                $this$sshDialStdio = (PodmanCliExecutor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl32:
                // 2 sources

                return LoggingKt.withLoggingStreamsOnTraceLevel((Process)v1, command, PodmanCliExecutorKt.getLogger(), "podman-ssh-dial-stdio");
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object dialStdio(@NotNull PodmanCliExecutor $this$dialStdio, @NotNull Continuation<? super Process> $completion) {
        if (!($completion instanceof dialStdio.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PodmanCliExecutorKt.dialStdio(null, (Continuation<? super Process>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!SystemInfo.isLinux) {
                    $i$f$logger = false;
                    v0 = Logger.getInstance(PodmanCliExecutor.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
                    v0.warn("Use PodmanCliExecutor.sshDialStdio() for Podman installation on Windows and macOS.");
                }
                var3_7 = new String[]{$this$dialStdio.getExePath(), "system", "dial-stdio"};
                command = CollectionsKt.listOf((Object[])var3_7);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$dialStdio);
                $continuation.L$1 = command;
                $continuation.label = 1;
                v1 = $this$dialStdio.createProcess(new GeneralCommandLine(command), (Continuation<? super Process>)$continuation);
                if (v1 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl31
            }
            case 1: {
                command = (List)$continuation.L$1;
                $this$dialStdio = (PodmanCliExecutor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl31:
                // 2 sources

                return LoggingKt.withLoggingStreamsOnTraceLevel((Process)v1, command, PodmanCliExecutorKt.getLogger(), "podman-dial-stdio");
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final DockerCli createPodmanDockerCli(@NotNull PodmanCliExecutor podmanCliExecutor, @NotNull PodmanInstanceConnection connection) {
        DockerCli dockerCli;
        Intrinsics.checkNotNullParameter((Object)((Object)podmanCliExecutor), (String)"podmanCliExecutor");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        PodmanInstanceConnection podmanInstanceConnection = connection;
        if (Intrinsics.areEqual((Object)podmanInstanceConnection, (Object)PodmanInstanceConnection.Direct.INSTANCE)) {
            dockerCli = new DirectPodmanDockerCli(podmanCliExecutor);
        } else if (podmanInstanceConnection instanceof PodmanInstanceConnection.SystemConnection) {
            dockerCli = new PodmanConnectionDockerCliExecutor(podmanCliExecutor, ((PodmanInstanceConnection.SystemConnection)connection).getConnectionName());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return dockerCli;
    }

    @NotNull
    public static final Map<String, String> podmanConnectionEnvs(@NotNull String systemConnectionName) {
        Intrinsics.checkNotNullParameter((Object)systemConnectionName, (String)"systemConnectionName");
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)PODMAN_ENV_CONTAINER_CONNECTION, (Object)systemConnectionName));
    }

    private static final Logger logger_delegate$lambda$0() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PodmanCliExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }
}

