/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.frontend.ReworkedTerminalView;
import com.intellij.terminal.session.TerminalSession;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.terminal.ui.TtyConnectorAccessor;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import java.awt.Component;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.fus.TerminalStartupFusInfo;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020\u000eH\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00160\rH\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020$H\u0016J\u0010\u0010,\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001bH\u0016J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020*H\u0016J\n\u00100\u001a\u0004\u0018\u00010\u001bH\u0016J\u0018\u00101\u001a\u00020$2\u0006\u00102\u001a\u0002032\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u00104\u001a\u00020$2\u0006\u00105\u001a\u00020'2\u0006\u00106\u001a\u00020\tH\u0016J\u0015\u00107\u001a\u00020$2\u000b\u00108\u001a\u00070\u001b\u00a2\u0006\u0002\b9H\u0016J\u0010\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020*H\u0016J\b\u0010<\u001a\u00020$H\u0016J\u0018\u0010A\u001a\u00020$2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\"\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010=\u001a\u00020>X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@\u00a8\u0006E"}, d2={"Lcom/intellij/terminal/frontend/ReworkedTerminalWidget;", "Lcom/intellij/terminal/ui/TerminalWidget;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lorg/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider;", "startupFusInfo", "Lorg/jetbrains/plugins/terminal/fus/TerminalStartupFusInfo;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider;Lorg/jetbrains/plugins/terminal/fus/TerminalStartupFusInfo;Lcom/intellij/openapi/Disposable;)V", "sessionFuture", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/terminal/session/TerminalSession;", "view", "Lcom/intellij/terminal/frontend/ReworkedTerminalView;", "terminalTitle", "Lcom/intellij/terminal/TerminalTitle;", "getTerminalTitle", "()Lcom/intellij/terminal/TerminalTitle;", "termSize", "Lcom/jediterm/core/util/TermSize;", "getTermSize", "()Lcom/jediterm/core/util/TermSize;", "shellCommand", "", "", "getShellCommand", "()Ljava/util/List;", "setShellCommand", "(Ljava/util/List;)V", "session", "getSession", "()Lcom/intellij/terminal/session/TerminalSession;", "connectToSession", "", "getTerminalSizeInitializedFuture", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusableComponent", "hasFocus", "", "requestFocus", "sendCommandToExecute", "getText", "", "isCommandRunning", "getCurrentDirectory", "addTerminationCallback", "onTerminated", "Ljava/lang/Runnable;", "addNotification", "notificationComponent", "disposable", "writePlainMessage", "message", "Lorg/jetbrains/annotations/Nls;", "setCursorVisible", "visible", "dispose", "ttyConnectorAccessor", "Lcom/intellij/terminal/ui/TtyConnectorAccessor;", "getTtyConnectorAccessor", "()Lcom/intellij/terminal/ui/TtyConnectorAccessor;", "connectToTty", "ttyConnector", "Lcom/jediterm/terminal/TtyConnector;", "initialTermSize", "intellij.terminal.frontend"})
public final class ReworkedTerminalWidget
implements TerminalWidget {
    @NotNull
    private final Project project;
    @NotNull
    private final CompletableFuture<TerminalSession> sessionFuture;
    @NotNull
    private final ReworkedTerminalView view;
    @NotNull
    private final TerminalTitle terminalTitle;
    @Nullable
    private List<String> shellCommand;
    @NotNull
    private final TtyConnectorAccessor ttyConnectorAccessor;

    public ReworkedTerminalWidget(@NotNull Project project, @NotNull JBTerminalSystemSettingsProvider settings, @Nullable TerminalStartupFusInfo startupFusInfo, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.sessionFuture = new CompletableFuture();
        this.view = new ReworkedTerminalView(this.project, settings, this.sessionFuture, startupFusInfo);
        this.terminalTitle = new TerminalTitle();
        Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)this));
        Disposer.register((Disposable)((Disposable)this), (Disposable)this.view);
        this.ttyConnectorAccessor = new TtyConnectorAccessor();
    }

    @NotNull
    public TerminalTitle getTerminalTitle() {
        return this.terminalTitle;
    }

    @Nullable
    public TermSize getTermSize() {
        return this.view.getTerminalSize();
    }

    @Nullable
    public List<String> getShellCommand() {
        return this.shellCommand;
    }

    public void setShellCommand(@Nullable List<String> list) {
        this.shellCommand = list;
    }

    @Nullable
    public TerminalSession getSession() {
        return this.sessionFuture.getNow(null);
    }

    public void connectToSession(@NotNull TerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.sessionFuture.complete(session2);
    }

    @NotNull
    public CompletableFuture<TermSize> getTerminalSizeInitializedFuture() {
        CompletionStage completionStage = this.view.getTerminalSizeInitializedFuture().thenApply(arg_0 -> ReworkedTerminalWidget.getTerminalSizeInitializedFuture$lambda$1(arg_0 -> ReworkedTerminalWidget.getTerminalSizeInitializedFuture$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @NotNull
    public JComponent getComponent() {
        return this.view.getComponent();
    }

    @NotNull
    public JComponent getPreferredFocusableComponent() {
        return this.view.getPreferredFocusableComponent();
    }

    public boolean hasFocus() {
        return this.view.isFocused();
    }

    public void requestFocus() {
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)this.getPreferredFocusableComponent(), true);
    }

    public void sendCommandToExecute(@NotNull String shellCommand) {
        Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
        this.view.sendCommandToExecute(shellCommand);
    }

    @NotNull
    public CharSequence getText() {
        return this.view.getText();
    }

    public boolean isCommandRunning() {
        TerminalSession terminalSession = this.getSession();
        if (terminalSession == null) {
            return false;
        }
        TerminalSession session2 = terminalSession;
        return (Boolean)TasksKt.runWithModalProgressBlocking((Project)this.project, (String)"", (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(session2, null){
            int label;
            final /* synthetic */ TerminalSession $session;
            {
                this.$session = $session;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$session.hasRunningCommands((Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Nullable
    public String getCurrentDirectory() {
        return this.view.getCurrentDirectory();
    }

    public void addTerminationCallback(@NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)onTerminated, (String)"onTerminated");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.view.addTerminationCallback(onTerminated, parentDisposable);
    }

    public void addNotification(@NotNull JComponent notificationComponent, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)notificationComponent, (String)"notificationComponent");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.view.setTopComponent(notificationComponent, disposable);
    }

    public void writePlainMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
    }

    public void setCursorVisible(boolean visible) {
    }

    public void dispose() {
    }

    @NotNull
    public TtyConnectorAccessor getTtyConnectorAccessor() {
        return this.ttyConnectorAccessor;
    }

    public void connectToTty(@NotNull TtyConnector ttyConnector, @NotNull TermSize initialTermSize) {
        Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
        Intrinsics.checkNotNullParameter((Object)initialTermSize, (String)"initialTermSize");
        throw new IllegalStateException("connectToTty is not supported by ReworkedTerminalWidget, use connectToSession instead".toString());
    }

    private static final TermSize getTerminalSizeInitializedFuture$lambda$0(ReworkedTerminalWidget this$0, Object it) {
        return this$0.getTermSize();
    }

    private static final TermSize getTerminalSizeInitializedFuture$lambda$1(Function1 $tmp0, Object p0) {
        return (TermSize)$tmp0.invoke(p0);
    }
}

