/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.completion;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.terminal.frontend.TerminalInput;
import com.intellij.terminal.frontend.completion.TerminalLookupManagerListenerKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.reworked.TerminalUsageLocalStorage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/terminal/frontend/completion/TerminalLookupListener;", "Lcom/intellij/codeInsight/lookup/LookupListener;", "<init>", "()V", "beforeItemSelected", "", "event", "Lcom/intellij/codeInsight/lookup/LookupEvent;", "itemSelected", "", "executeCommand", "lookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "firstElementShown", "intellij.terminal.frontend"})
final class TerminalLookupListener
implements LookupListener {
    public boolean beforeItemSelected(@NotNull LookupEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TerminalInput terminalInput = (TerminalInput)event.getLookup().getEditor().getUserData(TerminalInput.Companion.getKEY());
        if (terminalInput == null) {
            return false;
        }
        TerminalInput terminalInput2 = terminalInput;
        LookupElement item = event.getItem();
        Lookup lookup = event.getLookup();
        Intrinsics.checkNotNull((Object)lookup, (String)"null cannot be cast to non-null type com.intellij.codeInsight.lookup.impl.LookupImpl");
        LookupImpl lookup2 = (LookupImpl)lookup;
        char completionChar = event.getCompletionChar();
        if (item == null || !item.isValid() || item instanceof EmptyLookupItem) {
            return false;
        }
        int commandSize = lookup2.itemPattern(item).length();
        if (commandSize > 0) {
            int n = 0;
            byte[] byArray = new byte[commandSize];
            TerminalInput terminalInput3 = terminalInput2;
            while (n < commandSize) {
                int n2 = n++;
                byArray[n2] = 8;
            }
            terminalInput3.sendBytes(byArray);
        }
        String string = item.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
        terminalInput2.sendString(string);
        return false;
    }

    public void itemSelected(@NotNull LookupEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Lookup lookup = event.getLookup();
        LookupElement chosenItem = event.getItem();
        if (lookup == null || event.getCompletionChar() != '\n' || chosenItem == null) {
            return;
        }
        String string = lookup.itemPattern(chosenItem);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"itemPattern(...)");
        String typedString = string;
        String string2 = chosenItem.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLookupString(...)");
        if (TerminalLookupManagerListenerKt.canExecuteWithChosenItem(string2, typedString)) {
            this.executeCommand(lookup);
        } else {
            TerminalUsageLocalStorage.Companion.getInstance().recordCompletionItemChosen();
        }
    }

    private final void executeCommand(Lookup lookup) {
        TerminalInput terminalInput = (TerminalInput)lookup.getEditor().getUserData(TerminalInput.Companion.getKEY());
        if (terminalInput == null) {
            return;
        }
        TerminalInput terminalInput2 = terminalInput;
        terminalInput2.sendEnter();
    }

    public void firstElementShown() {
        TerminalUsageLocalStorage.Companion.getInstance().recordCompletionPopupShown();
    }
}

